/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.mapping;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MappingSchemaUtil;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.syndata.AbstractSynData;
import kd.isc.iscb.platform.core.syndata.SynDataUtil;
import kd.isc.iscb.platform.core.syndata.SyncBaseDataTask;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class DataMappingFormPlugin
extends AbstractFormPlugin {
    private static final String MAPPING_DATA_ENTRY = "mapping_data_entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sync_src_block", "sync_tar_block", "data_map_block", "sync_src_tag", "sync_tar_tag", "result_tag"});
        this.addClickListeners(new String[]{"src_image", "tar_image", "result_image", "tag_first", "tag_sec", "tag_thrid"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"src_image", "tar_imaged", "result_imaged", "sync_tar_pane", "result_pane"});
        Object srcMetaSchemaId = this.getView().getFormShowParameter().getCustomParam("src_id");
        if (srcMetaSchemaId == null) {
            return;
        }
        DynamicObject srcBaseSchema = BusinessDataServiceHelper.loadSingle((Object)srcMetaSchemaId, (String)"isc_base_schema");
        Object tarMetaSchemaId = this.getView().getFormShowParameter().getCustomParam("tar_id");
        if (tarMetaSchemaId == null) {
            return;
        }
        DynamicObject tarBaseSchema = BusinessDataServiceHelper.loadSingle((Object)tarMetaSchemaId, (String)"isc_base_schema");
        this.getModel().setValue("ruleid", this.getView().getFormShowParameter().getCustomParam("rule_id"));
        this.setBaseSchemaAndBasicData(srcBaseSchema, "src");
        this.setBaseSchemaAndBasicData(tarBaseSchema, "tar");
        this.setMappingDataEntry();
    }

    private void setBaseSchemaAndBasicData(DynamicObject baseSchema, String prefix) {
        this.setBaseSchema(baseSchema, prefix);
        this.setBasicDataEntry(baseSchema.get("id"), prefix);
    }

    private void setBaseSchema(DynamicObject baseSchema, String prefix) {
        this.getModel().setValue(prefix + "id", baseSchema.getPkValue());
        this.getModel().setValue(prefix + "_metadata", (Object)baseSchema.getDynamicObject("data_schema"));
        this.getModel().setValue(prefix + "_datasource", (Object)baseSchema.getDynamicObject("data_source"));
        this.getModel().setValue(prefix + "_number", (Object)baseSchema.getString("number"));
        this.getModel().setValue(prefix + "_name", (Object)baseSchema.getString("name"));
        this.getModel().setValue(prefix + "_number_field", (Object)baseSchema.getString("number_field"));
        this.getModel().setValue(prefix + "_name_field", (Object)baseSchema.getString("name_field"));
        this.getModel().setValue(prefix + "_creater", (Object)baseSchema.getDynamicObject("creator"));
    }

    private void setBasicDataEntry(Object baseSchemaId, String prefix) {
        QFilter filter = new QFilter("baseSchema", "=", baseSchemaId);
        DynamicObject[] basicDataArray = BusinessDataServiceHelper.load((String)"isc_basic_data", (String)"oid,number,name,cus_field1,cus_field2,cus_field3,baseschema,dataschema", (QFilter[])new QFilter[]{filter}, null, (int)100);
        this.getModel().deleteEntryData(prefix + "_basic_data");
        for (int i = 0; i < basicDataArray.length; ++i) {
            this.getModel().createNewEntryRow(prefix + "_basic_data");
            DynamicObject basicData = basicDataArray[i];
            this.getModel().setValue(prefix + "_data", basicData.get("oid"), i);
            this.getModel().setValue(prefix + "_data_number", basicData.get("number"), i);
            this.getModel().setValue(prefix + "_data_name", basicData.get("name"), i);
            this.getModel().setValue(prefix + "_cus_field1", basicData.get("cus_field1"), i);
            this.getModel().setValue(prefix + "_cus_field2", basicData.get("cus_field2"), i);
            this.getModel().setValue(prefix + "_cus_field3", basicData.get("cus_field3"), i);
            this.getModel().setValue(prefix + "_baseschema", basicData.get("baseschema"), i);
            this.getModel().setValue(prefix + "_dataschema", basicData.get("dataschema"), i);
        }
    }

    private void setMappingDataEntry() {
        Object ruleId = this.getModel().getValue("ruleid");
        QFilter filter = new QFilter("mapping_rule", "=", ruleId);
        DynamicObject[] mappingData = BusinessDataServiceHelper.load((String)"isc_mapping_data", (String)"id,source_id,source_number,source_name,target_id,target_number,target_name,enable,modifytime", (QFilter[])new QFilter[]{filter}, null, (int)100);
        this.getModel().deleteEntryData(MAPPING_DATA_ENTRY);
        for (int i = 0; i < mappingData.length; ++i) {
            this.getModel().createNewEntryRow(MAPPING_DATA_ENTRY);
            DynamicObject obj = mappingData[i];
            this.getModel().setValue("map_srcid", obj.get("source_id"), i);
            this.getModel().setValue("map_src_number", obj.get("source_number"), i);
            this.getModel().setValue("map_src_name", obj.get("source_name"), i);
            this.getModel().setValue("map_tarid", obj.get("target_id"), i);
            this.getModel().setValue("map_tar_number", obj.get("target_number"), i);
            this.getModel().setValue("map_tar_name", obj.get("target_name"), i);
            this.getModel().setValue("map_enable", obj.get("enable"), i);
            this.getModel().setValue("map_modifytime", obj.get("modifytime"), i);
            this.getModel().setValue("mapid", obj.get("id"), i);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operate = evt.getOperateKey();
        if ("sync_src".equals(operate)) {
            this.syncdata("src", ResManager.loadKDString((String)"\u540c\u6b65\u6e90\u6a21\u578b\u6570\u636e\uff1a", (String)"DataMappingFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "sync_src_data");
        } else if ("sync_tar".equals(operate)) {
            this.syncdata("tar", ResManager.loadKDString((String)"\u540c\u6b65\u76ee\u6807\u6a21\u578b\u6570\u636e\uff1a", (String)"DataMappingFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "sync_tar_data");
        } else if ("view_src_model".equals(operate)) {
            this.openModel("src");
        } else if ("view_tar_model".equals(operate)) {
            this.openModel("tar");
        } else if ("view_src_log".equals(operate)) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_sync_data_log", "base_schema", this.getModel().getValue("srcid"));
        } else if ("view_tar_log".equals(operate)) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_sync_data_log", "base_schema", this.getModel().getValue("tarid"));
        } else if ("auto_mapping".equals(operate)) {
            if (this.enableAutoMapping()) {
                this.autoMap();
            }
        } else if ("map_add".equals(operate)) {
            this.addMappingData();
        } else if ("map_refresh".equals(operate)) {
            this.setMappingDataEntry();
            this.getView().updateView(MAPPING_DATA_ENTRY);
        } else if ("map_modify".equals(operate)) {
            EntryGrid entry = (EntryGrid)this.getControl(MAPPING_DATA_ENTRY);
            int[] rows = entry.getSelectRows();
            if (rows.length == 1) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(MAPPING_DATA_ENTRY, rows[0]);
                DataMappingFormPlugin.openEdit(this, "isc_mapping_data", rowEntity.getLong("mapid"), "map_add_callback");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u6216\u9009\u62e9\u8d85\u8fc71\u884c!", (String)"DataMappingFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if ("map_view".equals(operate)) {
            EntryGrid entry = (EntryGrid)this.getControl(MAPPING_DATA_ENTRY);
            int[] rows = entry.getSelectRows();
            if (rows.length == 1) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(MAPPING_DATA_ENTRY, rows[0]);
                FormOpener.showView(this, "isc_mapping_data", rowEntity.getLong("mapid"));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u6216\u9009\u62e9\u8d85\u8fc71\u884c!", (String)"DataMappingFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if ("src_refresh".equals(operate)) {
            DynamicObject srcModel = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("srcid"), (String)"isc_base_schema");
            this.setBaseSchemaAndBasicData(srcModel, "src");
        } else if ("tar_refresh".equals(operate)) {
            DynamicObject tarModel = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("tarid"), (String)"isc_base_schema");
            this.setBaseSchemaAndBasicData(tarModel, "tar");
        } else if ("more_src_data".equals(operate)) {
            QFilter[] qfs = QFilterUtil.builder().put("baseschema", "=", this.getModel().getValue("srcid")).build();
            FormOpener.openBillList(this, "isc_basic_data", Arrays.asList(qfs));
        } else if ("more_tar_data".equals(operate)) {
            QFilter[] qfs = QFilterUtil.builder().put("baseschema", "=", this.getModel().getValue("tarid")).build();
            FormOpener.openBillList(this, "isc_basic_data", Arrays.asList(qfs));
        } else if ("more_map_data".equals(operate)) {
            QFilter[] qfs = QFilterUtil.builder().put("mapping_rule", "=", this.getModel().getValue("ruleid")).build();
            FormOpener.openBillList(this, "isc_mapping_data", Arrays.asList(qfs));
        } else if ("view_map_log".equals(operate)) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_sync_data_log", "mapping_rule", this.getModel().getValue("ruleid"));
        }
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if ("sync_src_block".equals(key) || "src_image".equals(key) || "sync_src_tag".equals(key) || "tag_first".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"src_imaged", "tar_image", "result_image"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"src_image", "tar_imaged", "result_imaged"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"sync_src_pane"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sync_tar_pane", "result_pane"});
        } else if ("sync_tar_block".equals(key) || "tar_image".equals(key) || "sync_tar_tag".equals(key) || "tag_sec".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"src_image", "tar_imaged", "result_image"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"src_imaged", "tar_image", "result_imaged"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"sync_tar_pane"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sync_src_pane", "result_pane"});
        } else if ("data_map_block".equals(key) || "result_image".equals(key) || "result_tag".equals(key) || "tag_thrid".equals(key)) {
            try {
                Object srcBaseSchemaId = this.getModel().getValue("srcid");
                if (this.isDataNumNotEqual(srcBaseSchemaId, ResManager.loadKDString((String)"\u6e90", (String)"DataMappingFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]))) {
                    return;
                }
                Object tarBaseSchemaId = this.getModel().getValue("tarid");
                if (this.isDataNumNotEqual(tarBaseSchemaId, ResManager.loadKDString((String)"\u76ee\u6807", (String)"DataMappingFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]))) {
                    return;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"src_image", "tar_image", "result_imaged"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"src_imaged", "tar_imaged", "result_image"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"result_pane"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"sync_tar_pane", "sync_src_pane"});
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e.getMessage(), ShowStackTraceUtil.getErrorMsg(e));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"sync_src_data")) {
            this.setBasicDataEntry(this.getModel().getValue("srcid"), "src");
            this.getView().updateView("src_basic_data");
        } else if (StringUtil.equals((String)evt.getActionId(), (String)"sync_tar_data")) {
            this.setBasicDataEntry(this.getModel().getValue("tarid"), "tar");
            this.getView().updateView("tar_basic_data");
        } else if (StringUtil.equals((String)evt.getActionId(), (String)"map_add_callback")) {
            this.setMappingDataEntry();
            this.getView().updateView(MAPPING_DATA_ENTRY);
        } else if (StringUtil.equals((String)evt.getActionId(), (String)"src_update_callback")) {
            DynamicObject srcModel = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("srcid"), (String)"isc_base_schema");
            this.setBaseSchema(srcModel, "src");
        } else if (StringUtil.equals((String)evt.getActionId(), (String)"tar_update_callback")) {
            DynamicObject tarModel = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("tarid"), (String)"isc_base_schema");
            this.setBaseSchema(tarModel, "tar");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (callBackId.equals("auto_map_confirm") && evt.getResult() == MessageBoxResult.Yes) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"src_image", "tar_image", "result_imaged"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"src_imaged", "tar_imaged", "result_image"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"result_pane"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sync_tar_pane", "sync_src_pane"});
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIds = e.getRowIndexs();
        Long[] ids = new Long[rowIds.length];
        for (int i = 0; i < rowIds.length; ++i) {
            DynamicObject row = this.getModel().getEntryRowEntity(MAPPING_DATA_ENTRY, rowIds[i]);
            ids[i] = row.getLong("mapid");
        }
        QFilter filter = new QFilter("id", "in", (Object)ids);
        ConnectorUtil.delete((String)"isc_mapping_data", (int)ids.length, (QFilter[])new QFilter[]{filter});
    }

    private boolean enableAutoMapping() {
        Object srcBaseSchemaId = this.getModel().getValue("srcid");
        if (this.stopToSyncData(srcBaseSchemaId, "src", ResManager.loadKDString((String)"\u6e90\u6a21\u578b", (String)"DataMappingFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]))) {
            return false;
        }
        Object tarBaseSchemaId = this.getModel().getValue("tarid");
        return !this.stopToSyncData(tarBaseSchemaId, "tar", ResManager.loadKDString((String)"\u76ee\u6807\u6a21\u578b", (String)"DataMappingFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void autoMap() {
        try {
            this.openMappingDataProgress(D.l((Object)this.getModel().getValue("ruleid")), ResManager.loadKDString((String)"\u6267\u884c\u81ea\u52a8\u5339\u914d", (String)"DataMappingFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "map_add_callback");
        }
        catch (Exception e) {
            this.getView().showMessage(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDataNumNotEqual(Object schemaId, String text) {
        long currentCount;
        long remoteCount;
        DynamicObject baseSchema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)"isc_base_schema");
        long dataSchemaId = baseSchema.getLong("data_schema_id");
        DynamicObject dataSchema = BusinessDataServiceHelper.loadSingle((Object)dataSchemaId, (String)"isc_metadata_schema");
        String type = dataSchema.getString("type");
        AbstractSynData synData = SynDataUtil.getSynDataWithoutLog((String)type, (DynamicObject)baseSchema);
        long dataSourceId = dataSchema.getLong("group_id");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        ConnectionManager.pushResLicense((boolean)true);
        try (ConnectionWrapper connectionWrapper = ConnectionManager.getConnection((long)((Long)dataSource.get("dblink_id")));){
            remoteCount = synData.queryCount(connectionWrapper, dataSchema);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u6a21\u578b\u6570\u636e\u6e90\u5f02\u5e38", (String)"DataMappingFormPlugin_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), text), (Throwable)e);
        }
        finally {
            ConnectionManager.popResLicense();
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[1]);
        try {
            String sql = "SELECT COUNT(*) FROM t_iscb_basic_data WHERE fbaseschema = ?";
            currentCount = DbUtil.executeCount((Connection)cn, (String)sql, Collections.singletonList(schemaId), Collections.singletonList(-5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        if (remoteCount > currentCount) {
            String tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d%1$s\u6a21\u578b\u6570\u636e\u5171%2$s\u6761\uff0c%3$s\u7cfb\u7edf\u5171%4$s\u6761\uff0c\u53ef\u80fd\u5b58\u5728\u672a\u540c\u6b65\u81f3\u96c6\u6210\u4e91\u7684\u6570\u636e\uff0c\u662f\u5426\u8fdb\u5165\u6570\u636e\u5339\u914d\u9636\u6bb5\uff1f", (String)"DataMappingFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), text, D.s((Object)currentCount), text, D.s((Object)remoteCount));
            this.getView().showConfirm(tip, MessageBoxOptions.YesNo, new ConfirmCallBackListener("auto_map_confirm"));
            return true;
        }
        return false;
    }

    private boolean stopToSyncData(Object baseSchemaId, String prefix, String text) {
        if (MappingSchemaUtil.hasLogRunning(baseSchemaId)) {
            FormOpener.showErrorMessage(this.getView(), String.format(ResManager.loadKDString((String)"%s\u57fa\u7840\u6570\u636e\u5c1a\u672a\u540c\u6b65\u5b8c\u6210", (String)"DataMappingFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), text), String.format(ResManager.loadKDString((String)"%1$s\u7f16\u7801\uff1a%2$s", (String)"DataMappingFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), text, this.getModel().getValue(prefix + "_number")));
            return true;
        }
        return false;
    }

    private void syncdata(String prefix, String title, String closeCallback) {
        if (this.validModel(prefix)) {
            return;
        }
        this.openSyncDataProgress(D.l((Object)this.getModel().getValue(prefix + "id")), D.s((Object)this.getModel().getValue(prefix + "_number")), title, closeCallback);
    }

    private boolean validModel(String prefix) {
        Object id = this.getModel().getValue(prefix + "id");
        DynamicObject baseSchema = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_base_schema", (String)"id,data_schema");
        long dataSchemaId = baseSchema.getLong("data_schema_id");
        DynamicObject dataSchema = BusinessDataServiceHelper.loadSingle((Object)dataSchemaId, (String)"isc_metadata_schema", (String)"id,type");
        String type = dataSchema.getString("type");
        if ("TABLE".equals(type) || "ENTITY".equals(type) || "ENUM".equals(type)) {
            return false;
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5b9e\u4f53\uff0c\u679a\u4e3e\uff0c\u6570\u636e\u8868\u7c7b\u578b\u7684\u96c6\u6210\u5bf9\u8c61\u8fdb\u884c\u6570\u636e\u540c\u6b65\uff01", (String)"DataMappingFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        return true;
    }

    private void openModel(String prefix) {
        DataMappingFormPlugin.openEdit(this, "isc_base_schema", this.getModel().getValue(prefix + "id"), prefix + "_update_callback");
    }

    private void addMappingData() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mapping_rule", this.getModel().getValue("ruleid"));
        FormOpener.showAddNew(this, "isc_mapping_data", params, "map_add_callback");
    }

    private static void openEdit(AbstractFormPlugin form, String entity, Object id, String closeCallback) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entity);
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("MUTEX_OBJ_ID", (Object)String.valueOf(id));
        param.setCustomParam("SCHEMA_NOT_EDITABLE", (Object)Boolean.TRUE);
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)form, closeCallback));
        form.getView().showForm((FormShowParameter)param);
    }

    private void openMappingDataProgress(long id, String title, String callBack) {
        List jobs = JobEngine.getJobsWithOwnerId((long)id);
        if (!jobs.isEmpty()) {
            FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), title, callBack);
        } else {
            Job job = SyncBaseDataTask.createMapJob((long)id);
            FormOpener.startJob(this, job, callBack);
        }
    }

    private void openSyncDataProgress(long id, String number, String title, String callBack) {
        List jobs = JobEngine.getJobsWithOwnerId((long)id);
        if (!jobs.isEmpty()) {
            FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), title, callBack);
        } else {
            Job job = SynDataUtil.createSynJob((long)id, (String)number);
            FormOpener.startJob(this, job, callBack);
        }
    }
}

