/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.mapping;

import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;

public class MappingDataFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String NUMBER = "number";
    private static final String TARGET_DATA = "target_data";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        Object mappingRule = params.get("mapping_rule");
        if (mappingRule != null) {
            this.getModel().setValue("mapping_rule", mappingRule);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (TARGET_DATA.equals(property.getName())) {
            this.doWhenTargetDataFieldChange(e);
        }
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String number;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && StringUtil.isEmpty((String)(number = (String)this.getModel().getValue(NUMBER)))) {
            this.getModel().setValue(NUMBER, (Object)Hash.mur64((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit target_data = (BasedataEdit)this.getView().getControl(TARGET_DATA);
        target_data.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforef7selectevent) {
        String fieldKey = beforef7selectevent.getProperty().getName();
        if (TARGET_DATA.equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforef7selectevent.getFormShowParameter();
            long ruleId = (Long)this.getModel().getValue("mapping_rule_id");
            if (ruleId > 0L) {
                DynamicObject converRule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"isc_value_conver_rule");
                showParameter.getListFilterParameter().setFilter(new QFilter("dataschema", "=", (Object)converRule.getLong("target_data_schema_id")));
            }
        }
    }

    private void doWhenTargetDataFieldChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0) {
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            String oid = null;
            String number = null;
            String name = null;
            if (newValue != null) {
                long target_data_id = newValue.getLong("id");
                DynamicObject targetData = BusinessDataServiceHelper.loadSingle((Object)target_data_id, (String)"isc_basic_data");
                oid = targetData.getString("oid");
                number = targetData.getString(NUMBER);
                name = targetData.getString("name");
            }
            this.getModel().getDataEntity().set("target_id", oid);
            this.getModel().getDataEntity().set("target_number", number);
            this.getModel().getDataEntity().set("target_name", name);
        }
    }
}

