/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.mapping;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.mapping.MappingSchemaListPlugin;
import kd.isc.iscb.formplugin.util.CssSetter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MappingSchemaUtil;
import kd.isc.iscb.formplugin.util.ScriptCommonUtil;
import kd.isc.iscb.formplugin.util.ShowEnableUtil;
import kd.isc.iscb.platform.core.constant.MappingType;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.syndata.MapDataUtil;
import kd.isc.iscb.platform.core.syndata.SyncBaseDataTask;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;

public class MappingSchemaFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String GROUP = "group";
    private static final String TYPE_AUTO = "auto";
    private static final String TYPE_MAPPING = "mapping";
    private static final String SOURCE_DATA_SCHEMA_ID = "source_data_schema_id";
    private static final String DATA_COPY_SCHEMA_ID = "data_copy_schema_id";
    private static final String RULE_TYPE = "rule_type";
    private static final String TARGET_DATA_SCHEMA_ID = "target_data_schema_id";
    private static final String SQL_TAG = "sql_tag";
    private static final String ISC_SCRIPT = "isc_script";
    private static final String ISC_SCRIPT_TAG = "isc_script_tag";
    private static final String REMARK = "remark";
    private static final String SQL_EDITOR = "sql_editor";
    public static final String SOURCE_DATA_SCHEMA = "source_data_schema";
    public static final String TARGET_DATA_SCHEMA = "target_data_schema";
    public static final String ISCB_DATA_COPY_MAPPING = "t_iscb_data_copy_mapping";
    public static final String ISC_VALUE_CONV_SUB_RULE = "t_isc_value_conv_sub_rule";
    public static final String ISC_SERVICE_FLOW_RES = "t_isc_service_flow_res";
    private static Map<String, String> ruleRefTables = new HashMap<String, String>();

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Control) {
            Control srcControl = (Control)src;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if ("view_sql_btn".equals(srcControl.getKey())) {
                params.put("view", Boolean.TRUE);
            }
            if ("view_script_btn".equals(srcControl.getKey())) {
                params.put(REMARK, this.getModel().getValue(ISC_SCRIPT));
                params.put("script", this.getModel().getValue(ISC_SCRIPT_TAG));
                params.put("field", ISC_SCRIPT);
                params.put("demo_file_name", "script_rule_demo.txt");
                params.put("plugin_name", this.getView().getEntityId() + "_script");
                this.setBillStatus(params);
                params.put("context_variables", Collections.singletonList("param"));
                params.put("env", "value_convert_script");
                params.put("id", this.getView().getModel().getValue("id"));
                ScriptCommonUtil.showEditor(this, ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"MappingSchemaFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_script");
            } else if (SQL_EDITOR.equals(srcControl.getKey()) || "view_sql_btn".equals(srcControl.getKey())) {
                params.put(REMARK, this.getModel().getValue("sql"));
                params.put("script", this.getModel().getValue(SQL_TAG));
                params.put("plugin_name", this.getView().getEntityId() + "_sql");
                params.put("field", "sql");
                FormOpener.showForm(this, "isc_sql_editor", ResManager.loadKDString((String)"SQL\u7f16\u8f91", (String)"MappingSchemaFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_sql");
            } else if ("value_attribute".equals(srcControl.getKey())) {
                if (this.getModel().getDataEntity().getLong(TARGET_DATA_SCHEMA_ID) == 0L) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5bf9\u8c61", (String)"MappingSchemaFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                } else {
                    params.put("id", this.getModel().getDataEntity().getLong(TARGET_DATA_SCHEMA_ID));
                    FormOpener.showForm(this, "isc_meta_property_tree", ResManager.loadKDString((String)"\u76ee\u6807\u5bf9\u8c61\u5c5e\u6027", (String)"MappingSchemaFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_tar_attribute");
                }
            }
        }
    }

    private void setBillStatus(HashMap<String, Object> params) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        params.put("billStatus", billShowParameter.getBillStatus());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue(SQL_EDITOR, this.getModel().getValue("sql"));
        this.getModel().setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map params;
        super.closedCallBack(e);
        if ("get_script".equals(e.getActionId())) {
            Map params2 = (Map)e.getReturnData();
            if (params2 != null) {
                if ("new_tab".equals(params2.get("operate"))) {
                    String caption = (String)params2.get("caption");
                    String actionId = (String)params2.get("actionId");
                    ScriptCommonUtil.showTabEditor(this, caption, params2, actionId);
                } else {
                    this.getModel().setValue(ISC_SCRIPT, params2.get(REMARK));
                    this.getModel().setValue(ISC_SCRIPT_TAG, params2.get("script"));
                    this.getView().updateView(ISC_SCRIPT);
                    this.getView().updateView(ISC_SCRIPT_TAG);
                }
            }
        } else if ("get_sql".equals(e.getActionId())) {
            Map params3 = (Map)e.getReturnData();
            if (params3 != null) {
                this.getModel().setValue("sql", params3.get(REMARK));
                this.getModel().setValue(SQL_TAG, params3.get("script"));
                this.getModel().setValue(SQL_EDITOR, params3.get(REMARK));
                this.getView().updateView("sql");
                this.getView().updateView(SQL_TAG);
                this.getView().updateView(SQL_EDITOR);
                if (params3.get("script") == null || !params3.get("script").toString().contains("as result")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8b66\u544a\uff1aSQL\u811a\u672c\u6ca1\u6709\u8bbe\u7f6e\u8fd4\u56de\u503cas result.", (String)"MappingSchemaFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("get_tar_attribute".equals(e.getActionId()) && (params = (Map)e.getReturnData()) != null) {
            this.getModel().setValue("value_attribute", params.get("full_number"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field = evt.getProperty().getName();
        if (field.equalsIgnoreCase(SOURCE_DATA_SCHEMA) || field.equalsIgnoreCase(TARGET_DATA_SCHEMA)) {
            CssSetter.setF7WindowSize(evt);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SQL_EDITOR, "value_attribute", "view_script_btn", "view_sql_btn"});
        BasedataEdit src = (BasedataEdit)this.getView().getControl(SOURCE_DATA_SCHEMA);
        BasedataEdit tar = (BasedataEdit)this.getView().getControl(TARGET_DATA_SCHEMA);
        src.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        tar.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (SOURCE_DATA_SCHEMA.equals(property.getName()) || TARGET_DATA_SCHEMA.equals(property.getName())) {
            this.doWhenSchemaFieldChange(e);
        }
        if (RULE_TYPE.equals(property.getName())) {
            this.doWhenRuleTypeChange(e);
        }
        if ("data_copy_schema".equals(property.getName())) {
            this.doWhenDataCopyChange(e);
        }
        if (SQL_EDITOR.equals(property.getName()) && D.s((Object)this.getModel().getValue(SQL_EDITOR)) == null) {
            this.getModel().setValue("sql", null);
            this.getModel().setValue(SQL_TAG, null);
            this.getView().updateView("sql");
            this.getView().updateView(SQL_TAG);
        }
    }

    private void doWhenDataCopyChange(PropertyChangedArgs e) {
        long id;
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0 && (id = this.getModel().getDataEntity().getLong(DATA_COPY_SCHEMA_ID)) > 0L) {
            DynamicObject dataCopySchema = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_data_copy");
            long source_data_schema_id = dataCopySchema.getLong("source_schema_id");
            long target_data_schema_id = dataCopySchema.getLong("target_schema_id");
            this.getModel().setValue(SOURCE_DATA_SCHEMA, (Object)source_data_schema_id);
            this.getModel().setValue(TARGET_DATA_SCHEMA, (Object)target_data_schema_id);
            this.getView().updateView(SOURCE_DATA_SCHEMA);
            this.getView().updateView(TARGET_DATA_SCHEMA);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        HashMap<String, String> ruleRefTips;
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            long source_data_schema_id = D.l((Object)this.getModel().getDataEntity().get(SOURCE_DATA_SCHEMA_ID));
            long target_data_schema_id = D.l((Object)this.getModel().getDataEntity().get(TARGET_DATA_SCHEMA_ID));
            String rule_type = this.getModel().getDataEntity().getString(RULE_TYPE);
            if ((TYPE_MAPPING.equals(rule_type) || TYPE_AUTO.equals(rule_type)) && (source_data_schema_id == 0L || target_data_schema_id == 0L)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4eba\u5de5\u548c\u5019\u9009\u952e\u6620\u5c04\u7684\u6e90\u548c\u76ee\u6807\u5bf9\u8c61\u5fc5\u586b", (String)"MappingSchemaFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (TYPE_AUTO.equals(rule_type)) {
                DynamicObject trigger;
                boolean runDataCopyOnMissed;
                long data_copy_schema_id = D.l((Object)this.getModel().getDataEntity().get(DATA_COPY_SCHEMA_ID));
                if (data_copy_schema_id == 0L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u5fc5\u586b\u3002", (String)"MappingSchemaFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if ((runDataCopyOnMissed = D.x((Object)this.getModel().getDataEntity().get("run_data_copy_on_missed"))) && (trigger = this.getModel().getDataEntity().getDynamicObject("data_copy_trigger")) == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u542f\u52a8\u65b9\u6848\u5fc5\u586b\u3002", (String)"MappingSchemaFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else {
                this.getModel().setValue("data_copy_schema", null);
            }
            if (TYPE_MAPPING.equals(rule_type)) {
                if (source_data_schema_id > 0L) {
                    MapDataUtil.createBaseSchemaIfNotExists((long)source_data_schema_id);
                }
                if (target_data_schema_id > 0L) {
                    MapDataUtil.createBaseSchemaIfNotExists((long)target_data_schema_id);
                }
            }
            if ("composite".equals(rule_type)) {
                DynamicObjectCollection sub_rules = this.getModel().getDataEntity(true).getDynamicObjectCollection("sub_rules");
                for (DynamicObject object : sub_rules) {
                    DynamicObject rule = object.getDynamicObject("sub_rule");
                    if (rule == null || !"composite".equals(D.s((Object)(rule = BusinessDataServiceHelper.loadSingle((String)"isc_value_conver_rule", (String)RULE_TYPE, (QFilter[])new QFilter[]{new QFilter("id", "=", object.getDynamicObject("sub_rule").getPkValue())})).get(RULE_TYPE)))) continue;
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u96c6\u4e0b\u4e0d\u5141\u8bb8\u5f15\u7528\u7ec4\u5408\u89c4\u5219\u7c7b\u578b\u7684\u503c\u8f6c\u6362\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MappingSchemaFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (args.getSource() instanceof AbstractOperate && "modify".equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey()) && this.getReferenceNum(ruleRefTips = new HashMap<String, String>()) > 1) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("modify_rule", (IFormPlugin)this);
            String tips = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u503c\u8f6c\u6362\u89c4\u5219\u5df2\u88ab\u5f15\u7528\uff08\u96c6\u6210\u65b9\u6848%1$s\u4e2a\uff0c\u670d\u52a1\u6d41\u7a0b%2$s\u4e2a\uff0c\u7ec4\u5408\u89c4\u5219%3$s\u4e2a\uff09\uff0c\u53ef\u4ee5\u901a\u8fc7\u5173\u8054\u67e5\u8be2\u6765\u67e5\u8be2\u88ab\u54ea\u4e9b\u8d44\u6e90\u5f15\u7528\u3002\u5982\u65e0\u6cd5\u5224\u65ad\u5f71\u54cd\u8303\u56f4\u53ef\u590d\u5236\u5f53\u524d\u89c4\u5219\u6765\u5904\u7406\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"MappingSchemaFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ruleRefTips.get(ISCB_DATA_COPY_MAPPING), ruleRefTips.get(ISC_SERVICE_FLOW_RES), ruleRefTips.get(ISC_VALUE_CONV_SUB_RULE));
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private int getReferenceNum(Map<String, String> ruleRefTips) {
        int refNum = 0;
        Object ruleId = this.getModel().getValue("id");
        if (ruleId == null) {
            return refNum;
        }
        for (Map.Entry<String, String> entry : ruleRefTables.entrySet()) {
            String table = entry.getKey();
            String field = entry.getValue();
            List<Object> ids = MappingSchemaUtil.getRelationIds(this.getModel().getValue("id"), table, field);
            ruleRefTips.put(table, D.s((Object)ids.size()));
            refNum += ids.size();
        }
        return refNum;
    }

    private void checkSourceOrTarget(long source_data_schema_id, long target_data_schema_id) {
        if (source_data_schema_id == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u672a\u6307\u5b9a\uff0c\u6211\u4eec\u5efa\u8bae\u60a8\u6307\u5b9a\u6e90\u5bf9\u8c61\u4ee5\u8868\u793a\u76f8\u5173\u503c\u7684\u4e1a\u52a1\u8bed\u4e49\uff1b\u5982\u679c\u503c\u4e0d\u662f\u57fa\u7840\u8d44\u6e90ID\u6216\u679a\u4e3e\uff0c\u8bf7\u4eba\u5de5\u521b\u5efa\"\u5143\u7d20\"\u7c7b\u522b\u7684\u96c6\u6210\u5bf9\u8c61\u6765\u8868\u793a\uff0c\u4f8b\u5982\uff1a\u7528\u6237\u59d3\u540d\u3001\u7528\u6237\u5e10\u53f7\u3002", (String)"MappingSchemaFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (target_data_schema_id == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u76ee\u6807\u5bf9\u8c61\u672a\u6307\u5b9a\uff0c\u6211\u4eec\u5efa\u8bae\u60a8\u6307\u5b9a\u76ee\u6807\u5bf9\u8c61\u4ee5\u8868\u793a\u76f8\u5173\u503c\u7684\u4e1a\u52a1\u8bed\u4e49\uff1b\u5982\u679c\u503c\u4e0d\u662f\u57fa\u7840\u8d44\u6e90ID\u6216\u679a\u4e3e\uff0c\u8bf7\u4eba\u5de5\u521b\u5efa\"\u5143\u7d20\"\u7c7b\u522b\u7684\u96c6\u6210\u5bf9\u8c61\u6765\u8868\u793a\uff0c\u4f8b\u5982\uff1a\u7528\u6237\u59d3\u540d\u3001\u7528\u6237\u5e10\u53f7\u3002", (String)"MappingSchemaFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void doWhenRuleTypeChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0) {
            String rule_type = this.getModel().getDataEntity().getString(RULE_TYPE);
            this.controlBtnVisible(rule_type);
        }
    }

    private void controlBtnVisible(String rule_type) {
        if (TYPE_MAPPING.equals(rule_type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"auto_map_bar", "view_data_bar", "bar_sync_base_data", "bar_view_log", "data_map_btn"});
            this.getModel().setValue("data_copy_schema", null);
            this.getModel().setValue("run_data_copy_on_missed", (Object)Boolean.FALSE);
            this.getView().updateView("data_copy_schema");
            this.getView().updateView("run_data_copy_on_missed");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"auto_map_bar", "view_data_bar", "bar_sync_base_data", "bar_view_log", "data_map_btn"});
        }
    }

    public void afterBindData(EventObject e) {
        String rule_type = this.getModel().getDataEntity().getString(RULE_TYPE);
        this.setViewPropertiesVisible(rule_type);
        super.afterBindData(e);
        long source_data_schema_id = this.getModel().getDataEntity().getLong(SOURCE_DATA_SCHEMA_ID);
        long target_data_schema_id = this.getModel().getDataEntity().getLong(TARGET_DATA_SCHEMA_ID);
        if (ShowEnableUtil.IsBaseSchemaExist(source_data_schema_id)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_view_src"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_view_src"});
        }
        if (ShowEnableUtil.IsBaseSchemaExist(target_data_schema_id)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_view_tar"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_view_tar"});
        }
        this.controlBtnVisible(rule_type);
    }

    private OperationStatus getViewStatus(IFormView viewPar) {
        return viewPar.getFormShowParameter().getStatus();
    }

    private void doWhenSchemaFieldChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0) {
            long source_data_schema_id = this.getModel().getDataEntity().getLong(SOURCE_DATA_SCHEMA_ID);
            long target_data_schema_id = this.getModel().getDataEntity().getLong(TARGET_DATA_SCHEMA_ID);
            DynamicObject source_data_schema = null;
            DynamicObject target_data_schema = null;
            if (source_data_schema_id > 0L) {
                source_data_schema = this.getDataSchema(source_data_schema_id);
                this.getModel().getDataEntity().set("source_data_source", (Object)source_data_schema.getDynamicObject(GROUP));
                this.getView().updateView("source_data_source");
            }
            if (target_data_schema_id > 0L) {
                target_data_schema = this.getDataSchema(target_data_schema_id);
                this.getModel().getDataEntity().set("target_data_source", (Object)target_data_schema.getDynamicObject(GROUP));
                this.getView().updateView("target_data_source");
            }
            if (source_data_schema != null && target_data_schema != null) {
                MappingType mappingType = this.generateMappingType(source_data_schema, target_data_schema);
                this.getModel().getDataEntity().set("mapping_type", (Object)mappingType.getType());
                this.getView().updateView("mapping_type");
                String name = source_data_schema.getString("name") + "-" + target_data_schema.getString("name");
                name = name + "(" + source_data_schema.getDynamicObject(GROUP).getString("name") + "-" + target_data_schema.getDynamicObject(GROUP).getString("name") + ")";
                if (name.length() > 50) {
                    name = name.substring(0, 50);
                }
                this.getModel().getDataEntity().set("number", (Object)Hash.mur32((Object[])new Object[]{name}));
                this.getModel().getDataEntity().set("name", (Object)name);
                this.getView().updateView("name");
                this.getView().updateView("number");
            }
        }
    }

    private MappingType generateMappingType(DynamicObject source_data_schema, DynamicObject target_data_schema) {
        String sourceType = source_data_schema.getString("type");
        String targetType = target_data_schema.getString("type");
        return MappingType.getType((String)(sourceType + "_" + targetType));
    }

    private DynamicObject getDataSchema(long schema_id) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_metadata_schema");
        return BusinessDataServiceHelper.loadSingle((Object)schema_id, (DynamicObjectType)entityType);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operate = args.getOperateKey();
        if ("auto_map".equals(operate)) {
            long target_data_schema_id;
            long source_data_schema_id = this.getModel().getDataEntity().getLong(SOURCE_DATA_SCHEMA_ID);
            if (this.isSyncDataTaskRunning(source_data_schema_id, target_data_schema_id = this.getModel().getDataEntity().getLong(TARGET_DATA_SCHEMA_ID))) {
                return;
            }
            try {
                this.autoMapData();
            }
            catch (Exception e) {
                this.getView().showMessage(e.getMessage());
            }
        } else {
            Object id = this.getModel().getValue("id");
            if ("view_data".equals(operate)) {
                FormOpener.showList((AbstractFormPlugin)this, "isc_mapping_data", "mapping_rule", id);
            } else if ("test".equals(operate)) {
                String src_value = D.s(this.getView().getFormShowParameter().getCustomParams().get("src_value"));
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", id);
                if (src_value != null) {
                    params.put("src_value", src_value);
                }
                FormOpener.showForm(this, "isc_val_conver_rule_test", ResManager.loadKDString((String)"\u6d4b\u8bd5", (String)"MappingSchemaFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "donothing");
            } else if ("view_log".equals(operate)) {
                FormOpener.showList((AbstractFormPlugin)this, "isc_sync_data_log", "mapping_rule", id);
            } else if ("sync_base_data".equals(operate)) {
                long selectedId = (Long)id;
                try {
                    MapDataUtil.syncBaseData((Object)selectedId);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u76ee\u524d\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u8bf7\u540c\u6b65\u5b8c\u6210\u540e\u518d\u70b9\u51fb\u6309\u94ae\u201c\u81ea\u52a8\u5339\u914d\u201d\u5b8c\u6210\u81ea\u52a8\u5339\u914d\u64cd\u4f5c\u3002", (String)"MappingSchemaFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showMessage(e.getMessage());
                }
            } else if ("view_src_model".equals(operate)) {
                long sourceDataSchemaId = (Long)this.getModel().getValue(SOURCE_DATA_SCHEMA_ID);
                this.viewBaseDataSchema(sourceDataSchemaId);
            } else if ("view_tar_model".equals(operate)) {
                long targetDataSchemaId = (Long)this.getModel().getValue(TARGET_DATA_SCHEMA_ID);
                this.viewBaseDataSchema(targetDataSchemaId);
            } else if ("cache_value".equals(operate)) {
                FormOpener.showList((AbstractFormPlugin)this, "isc_value_convert_cache", "convert_rule", id);
            } else if ("find_dc_schema".equals(operate)) {
                List<Object> ids = MappingSchemaUtil.getRelationIds(id, ISCB_DATA_COPY_MAPPING, "fvalue_conver_rule");
                this.openBill("isc_data_copy", ids);
            } else if ("find_composite_rule".equals(operate)) {
                List<Object> ids = MappingSchemaUtil.getRelationIds(id, ISC_VALUE_CONV_SUB_RULE, "fsub_rule");
                this.openBill("isc_value_conver_rule", ids);
            } else if ("find_service_flow".equals(operate)) {
                List<Object> ids = MappingSchemaUtil.getRelationIds(id, ISC_SERVICE_FLOW_RES, "fresouce");
                this.openBill("isc_service_flow", ids);
            } else if ("save".equals(operate) && args.getOperationResult().isSuccess()) {
                long source_data_schema_id = D.l((Object)this.getModel().getDataEntity().get(SOURCE_DATA_SCHEMA_ID));
                long target_data_schema_id = D.l((Object)this.getModel().getDataEntity().get(TARGET_DATA_SCHEMA_ID));
                this.checkSourceOrTarget(source_data_schema_id, target_data_schema_id);
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().cacheFormShowParameter();
                this.setViewPropertiesVisible(D.s((Object)this.getModel().getValue(RULE_TYPE)));
            } else if ("data_map".equals(operate) && args.getOperationResult().isSuccess()) {
                MappingSchemaListPlugin.openDataMapView(id, this);
            }
        }
    }

    private void openBill(String entity, List<Object> ids) {
        QFilter qf = new QFilter("id", "in", ids);
        ArrayList<QFilter> qfs = new ArrayList<QFilter>();
        qfs.add(qf);
        FormOpener.openBillList(this, entity, qfs);
    }

    private boolean isSyncDataTaskRunning(long source_data_schema_id, long target_data_schema_id) {
        if (MappingSchemaUtil.isSyncDataRunning(source_data_schema_id)) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u6e90\u96c6\u6210\u57fa\u7840\u6570\u636e\u5c1a\u672a\u540c\u6b65\u5b8c\u6210", (String)"MappingSchemaFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u96c6\u6210\u57fa\u7840\u6570\u636e\u7f16\u7801\uff1a%s", (String)"MappingSchemaFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MappingSchemaUtil.getBaseSchemaNumber(source_data_schema_id)));
            return true;
        }
        if (MappingSchemaUtil.isSyncDataRunning(target_data_schema_id)) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u57fa\u7840\u6570\u636e\u5c1a\u672a\u540c\u6b65\u5b8c\u6210", (String)"MappingSchemaFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u57fa\u7840\u6570\u636e\u7f16\u7801\uff1a%s", (String)"MappingSchemaFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MappingSchemaUtil.getBaseSchemaNumber(target_data_schema_id)));
            return true;
        }
        return false;
    }

    private void viewBaseDataSchema(long dataSchemaId) {
        if (dataSchemaId > 0L) {
            QFilter qFilter = new QFilter("data_schema", "=", (Object)dataSchemaId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"isc_base_schema", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObject == null) {
                dynamicObject = MapDataUtil.createBaseSchemaIfNotExists((long)dataSchemaId);
            }
            BillShowParameter param = new BillShowParameter();
            param.setFormId("isc_base_schema");
            param.setPkId(dynamicObject.get("id"));
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void autoMapData() throws SQLException {
        List jobs;
        long ruleId = (Long)this.getModel().getValue("id");
        if (ruleId == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u8bb0\u5f55\u518d\u64cd\u4f5c\u540c\u6b65\u4efb\u52a1", (String)"MappingSchemaFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if (!(jobs = JobEngine.getJobsWithOwnerId((long)ruleId)).isEmpty()) {
            String title = String.format(ResManager.loadKDString((String)"\u6267\u884c\u81ea\u52a8\u6620\u5c04\uff1a\u503c\u8f6c\u6362\u89c4\u5219(%s)", (String)"MappingSchemaFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getModel().getValue("number"));
            FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), title, null);
            return;
        }
        Job job = SyncBaseDataTask.createMapJob((long)ruleId);
        FormOpener.startJob(this, job, null);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        try {
            String callback = evt.getCallBackId();
            if ("modify_rule".equals(callback)) {
                if (evt.getResult() == MessageBoxResult.Yes) {
                    this.getView().setStatus(OperationStatus.EDIT);
                } else if (evt.getResult() == MessageBoxResult.No) {
                    this.getView().setStatus(OperationStatus.VIEW);
                }
                this.getView().cacheFormShowParameter();
                String rule_type = this.getModel().getDataEntity().getString(RULE_TYPE);
                this.setViewPropertiesVisible(rule_type);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void setViewPropertiesVisible(String rule_type) {
        IFormView view = this.getView();
        boolean btnVisible = this.getViewStatus(view) == OperationStatus.VIEW;
        this.getView().setVisible(Boolean.valueOf(btnVisible && "sql".equals(rule_type)), new String[]{"view_sql_btn"});
        this.getView().setVisible(Boolean.valueOf(btnVisible), new String[]{"bar_modify"});
        this.getView().setVisible(Boolean.valueOf(!btnVisible), new String[]{"bar_save"});
    }

    static {
        ruleRefTables.put(ISCB_DATA_COPY_MAPPING, "fvalue_conver_rule");
        ruleRefTables.put(ISC_VALUE_CONV_SUB_RULE, "fsub_rule");
        ruleRefTables.put(ISC_SERVICE_FLOW_RES, "fresouce");
    }
}

