/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MappingSchemaUtil;
import kd.isc.iscb.formplugin.util.ShowEnableUtil;
import kd.isc.iscb.platform.core.cache.DynamicObjectCacheProxy;
import kd.isc.iscb.platform.core.syndata.MapDataUtil;
import kd.isc.iscb.platform.core.syndata.SyncBaseDataTask;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class MappingSchemaListPlugin
extends AbstractTreeListPlugin {
    private static final String TARGET_DATA_SCHEMA_ID = "target_data_schema_id";
    private static final String SOURCE_DATA_SCHEMA_ID = "source_data_schema_id";
    private static final String ISC_VALUE_CONVER_RULE = "isc_value_conver_rule";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"data_map_btn"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        if ("auto_map".equals(operateKey)) {
            Object selectedId = this.getObject(args);
            if (selectedId == null) {
                return;
            }
            this.invokeAutoMapping(selectedId);
        } else if ("view_data".equals(operateKey)) {
            Object selectedId = this.getObject(args);
            if (selectedId == null) {
                return;
            }
            FormOpener.showList((AbstractFormPlugin)this, "isc_mapping_data", "mapping_rule", selectedId);
        } else if ("test".equals(operateKey)) {
            Object selectedId = this.getObject(args);
            if (selectedId == null) {
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", selectedId);
            FormOpener.showForm((AbstractFormPlugin)this, "isc_val_conver_rule_test", ResManager.loadKDString((String)"\u6d4b\u8bd5", (String)"MappingSchemaListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "donothing");
        } else if ("view_log".equals(operateKey)) {
            Object selectedId = this.getObject(args);
            if (selectedId == null) {
                return;
            }
            FormOpener.showList((AbstractFormPlugin)this, "isc_sync_data_log", "mapping_rule", selectedId);
        } else if ("sync_base_data".equals(operateKey)) {
            Object selectedId = this.getObject(args);
            if (selectedId == null) {
                return;
            }
            this.invokeSyncBaseData(selectedId);
        } else if ("export_rule".equals(operateKey)) {
            List pkIds = args.getOperationResult().getSuccessPkIds();
            ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, ISC_VALUE_CONVER_RULE);
        } else if ("exportzip".equals(operateKey)) {
            ExportUtil.exportZip((AbstractFormPlugin)this, args, ISC_VALUE_CONVER_RULE);
        } else if ("import_rule".equals(operateKey)) {
            FormOpener.openImportForm((IFormPlugin)this, this.getView(), ISC_VALUE_CONVER_RULE);
        } else if ("view_src_model".equals(args.getOperateKey())) {
            Object selectedId = this.getObject(args);
            if (selectedId == null) {
                return;
            }
            this.showBaseDataSchemaForm(selectedId, SOURCE_DATA_SCHEMA_ID);
        } else if ("view_tar_model".equals(args.getOperateKey())) {
            Object selectedId = this.getObject(args);
            if (selectedId == null) {
                return;
            }
            this.showBaseDataSchemaForm(selectedId, TARGET_DATA_SCHEMA_ID);
        } else if ("find_dc_schema".equals(args.getOperateKey())) {
            Object selectedId = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
            if (selectedId == null) {
                return;
            }
            List<Object> ids = MappingSchemaUtil.getRelationIds(selectedId, "t_iscb_data_copy_mapping", "fvalue_conver_rule");
            this.openBill("isc_data_copy", ids);
        } else if ("find_composite_rule".equals(args.getOperateKey())) {
            Object selectedId = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
            if (selectedId == null) {
                return;
            }
            List<Object> ids = MappingSchemaUtil.getRelationIds(selectedId, "t_isc_value_conv_sub_rule", "fsub_rule");
            this.openBill(ISC_VALUE_CONVER_RULE, ids);
        } else if ("find_service_flow".equals(args.getOperateKey())) {
            Object selectedId = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
            if (selectedId == null) {
                return;
            }
            List<Object> ids = MappingSchemaUtil.getRelationIds(selectedId, "t_isc_service_flow_res", "fresouce");
            this.openBill("isc_service_flow", ids);
        } else if ("data_map".equals(operateKey)) {
            Object selectedId = this.getObject(args);
            if (selectedId == null) {
                return;
            }
            MappingSchemaListPlugin.openDataMapView(selectedId, (AbstractFormPlugin)this);
        } else if ("view_rule_imp".equals(operateKey)) {
            QFilter filter = new QFilter("res_type", "like", (Object)"%(isc_value_conver_rule)");
            FormOpener.openBillList((AbstractFormPlugin)this, "isc_dts_imp", Collections.singletonList(filter), ResManager.loadKDString((String)"\u8d44\u6e90\u5bfc\u5165\u8bb0\u5f55", (String)"DataCopyListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public static void openDataMapView(Object selectedId, AbstractFormPlugin form) {
        DynamicObject rule = DynamicObjectCacheProxy.getById((Object)selectedId, (String)ISC_VALUE_CONVER_RULE);
        if (!"mapping".equals(rule.get("rule_type"))) {
            form.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5339\u914d\u53ea\u652f\u6301\u4eba\u5de5\u6620\u5c04\u7c7b\u578b\u7684\u503c\u8f6c\u6362\u89c4\u5219\uff01", (String)"MappingSchemaListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        long source_data_schema_id = rule.getLong(SOURCE_DATA_SCHEMA_ID);
        DynamicObject srcBaseSchema = MapDataUtil.createBaseSchemaIfNotExists((long)source_data_schema_id);
        long target_data_schema_id = rule.getLong(TARGET_DATA_SCHEMA_ID);
        DynamicObject tarBaseSchema = MapDataUtil.createBaseSchemaIfNotExists((long)target_data_schema_id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("src_id", srcBaseSchema.getPkValue());
        params.put("tar_id", tarBaseSchema.getPkValue());
        params.put("rule_id", selectedId);
        FormOpener.showTabForm(form, "isc_data_mapping", ResManager.loadKDString((String)"\u6570\u636e\u5339\u914d", (String)"MappingSchemaListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    private void openBill(String entity, List<Object> ids) {
        QFilter qf = new QFilter("id", "in", ids);
        ArrayList<QFilter> qfs = new ArrayList<QFilter>();
        qfs.add(qf);
        FormOpener.openBillList((AbstractFormPlugin)this, entity, qfs);
    }

    private void invokeAutoMapping(Object ruleId) {
        DynamicObject converRule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)ISC_VALUE_CONVER_RULE);
        String rule_type = D.s((Object)converRule.get("rule_type"));
        if ("mapping".equals(rule_type)) {
            long target_data_schema_id;
            long source_data_schema_id = converRule.getLong(SOURCE_DATA_SCHEMA_ID);
            if (this.isSyncDataTaskRunning(source_data_schema_id, target_data_schema_id = converRule.getLong(TARGET_DATA_SCHEMA_ID))) {
                return;
            }
            try {
                SyncBaseDataTask.autoMapData((long)((Long)ruleId));
                this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u89e6\u53d1\u81ea\u52a8\u5339\u914d\uff0c\u8bf7\u7a0d\u540e\u70b9\u51fb\u6309\u94ae\u201c\u5339\u914d\u7ed3\u679c\u201d\u67e5\u770b\u81ea\u52a8\u5339\u914d\u7684\u7ed3\u679c\u3002", (String)"MappingSchemaListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.getView().showMessage(e.getMessage());
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u4eba\u5de5\u6620\u5c04\u7c7b\u578b\u7684\u503c\u8f6c\u6362\u89c4\u5219\u624d\u80fd\u89e6\u53d1\u81ea\u52a8\u5339\u914d", (String)"MappingSchemaListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void invokeSyncBaseData(Object ruleId) {
        DynamicObject converRule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)ISC_VALUE_CONVER_RULE);
        String rule_type = D.s((Object)converRule.get("rule_type"));
        if ("mapping".equals(rule_type)) {
            try {
                MapDataUtil.syncBaseData((Object)ruleId);
                this.getView().showMessage(ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u76ee\u524d\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u8bf7\u540c\u6b65\u5b8c\u6210\u540e\u518d\u70b9\u51fb\u6309\u94ae\u201c\u81ea\u52a8\u5339\u914d\u201d\u5b8c\u6210\u81ea\u52a8\u5339\u914d\u64cd\u4f5c\u3002", (String)"MappingSchemaListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.getView().showMessage(e.getMessage());
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u4eba\u5de5\u6620\u5c04\u7c7b\u578b\u7684\u503c\u8f6c\u6362\u89c4\u5219\u624d\u80fd\u89e6\u53d1\u540c\u6b65\u6570\u636e", (String)"MappingSchemaListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void exportZip(List<Object> ruleIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", StringUtil.join(ruleIds, (String)","));
        params.put("entity", ISC_VALUE_CONVER_RULE);
        FormOpener.showForm((AbstractFormPlugin)this, "isc_export_progress", ResManager.loadKDString((String)"\u5bfc\u51fazip\u5305", (String)"MappingSchemaListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    private void export(List<Object> ruleIds) {
        DynamicObject[] dObjects = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ISC_VALUE_CONVER_RULE));
        ExportAndImportFormUtil.export((IFormView)this.getView(), (DynamicObject[])dObjects);
    }

    private void showBaseDataSchemaForm(Object ruleId, String metaName) {
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)ISC_VALUE_CONVER_RULE, (String)metaName);
        long dataSchemaId = rule.getLong(metaName);
        if (dataSchemaId == 0L) {
            return;
        }
        QFilter qFilter = new QFilter("data_schema", "=", (Object)dataSchemaId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"isc_base_schema", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            FormOpener.showView((AbstractFormPlugin)this, "isc_base_schema", dynamicObject.getPkValue());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u7684\u6a21\u578b\u4e0d\u5b58\u5728!", (String)"MappingSchemaListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private Object getObject(AfterDoOperationEventArgs args) {
        Object selectedId = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (selectedId == null) {
            return null;
        }
        return selectedId;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"importschema")) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
    }

    private boolean isSyncDataTaskRunning(long source_data_schema_id, long target_data_schema_id) {
        if (MappingSchemaUtil.isSyncDataRunning(source_data_schema_id)) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u6e90\u96c6\u6210\u57fa\u7840\u6570\u636e\u5c1a\u672a\u540c\u6b65\u5b8c\u6210", (String)"MappingSchemaListPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u96c6\u6210\u57fa\u7840\u6570\u636e\u7f16\u7801\uff1a%s", (String)"MappingSchemaListPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MappingSchemaUtil.getBaseSchemaNumber(source_data_schema_id)));
            return true;
        }
        if (MappingSchemaUtil.isSyncDataRunning(target_data_schema_id)) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u57fa\u7840\u6570\u636e\u5c1a\u672a\u540c\u6b65\u5b8c\u6210", (String)"MappingSchemaListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u57fa\u7840\u6570\u636e\u7f16\u7801\uff1a%s", (String)"MappingSchemaListPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MappingSchemaUtil.getBaseSchemaNumber(target_data_schema_id)));
            return true;
        }
        return false;
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        if (evt.getCurrentListSelectedRow() == null || evt.getListSelectedRowCollection().size() != 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_view_src"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_view_tar"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_map_btn"});
        } else {
            Object primaryKeyValue = evt.getCurrentListSelectedRow().getPrimaryKeyValue();
            evt.getCurrentListSelectedRow().getNumber();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)ISC_VALUE_CONVER_RULE, (String)"source_data_schema_id,target_data_schema_id,rule_type");
            long source_id = object.getLong(SOURCE_DATA_SCHEMA_ID);
            long target_id = object.getLong(TARGET_DATA_SCHEMA_ID);
            this.getView().setEnable(Boolean.valueOf(ShowEnableUtil.IsBaseSchemaExist(source_id)), new String[]{"btn_view_src"});
            this.getView().setEnable(Boolean.valueOf(ShowEnableUtil.IsBaseSchemaExist(target_id)), new String[]{"btn_view_tar"});
            this.getView().setVisible(Boolean.valueOf("mapping".equals(object.getString("rule_type"))), new String[]{"data_map_btn"});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        FormOpener.showView((AbstractFormPlugin)this, ISC_VALUE_CONVER_RULE, selectedId);
    }
}

