/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.meta;

import java.text.NumberFormat;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.isc.iscb.util.misc.StringUtil;

public abstract class AbstractProgressBarFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log logger = LogFactory.getLog(AbstractProgressBarFormPlugin.class);
    public static final String KEY_BTNSTART = "btnok";
    public static final String KEY_BTNSTOP = "btnstop";
    public static final String KEY_BTNEXIT = "btnexit";
    public static final String KEY_PROGRESSBAR = "progressbarap";

    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressBar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{KEY_BTNSTART, KEY_BTNSTOP, KEY_BTNEXIT});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_BTNSTART, (CharSequence)source.getKey())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTNSTART});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BTNSTOP});
            this.start();
        } else if (StringUtils.equals((CharSequence)KEY_BTNSTOP, (CharSequence)source.getKey())) {
            this.stop();
        } else if (StringUtils.equals((CharSequence)KEY_BTNEXIT, (CharSequence)source.getKey())) {
            this.getView().invokeOperation("close");
        }
    }

    public void stop() {
        this.getPageCache().put("startprogress", "false");
    }

    protected void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.setPercent(0, ResManager.loadKDString((String)" \u5f00\u59cb\u6267\u884c ...", (String)"AbstractProgressBarFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("startprogress", "true");
        this.getPageCache().put("progress", "0");
        this.doTask(this.getView().getPageId());
    }

    protected abstract void doTask(String var1);

    public void execute(String pageId) {
        final PageCache pageCache = pageId == null ? null : new PageCache(pageId);
        final NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        if (pageCache != null && pageCache.get("startprogress") != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 100; ++i) {
                        float value = Math.min(100.0f, (float)(i + 1) * 100.0f / 100.0f);
                        String progress = numberFormat.format(value);
                        pageCache.put("progress", progress);
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            logger.warn((Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }).start();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String startProgress = this.getPageCache().get("startprogress");
        if (StringUtils.isBlank((CharSequence)startProgress)) {
            progressEvent.setProgress(0);
            progressEvent.setText(ResManager.loadKDString((String)" \u672a\u5f00\u59cb ", (String)"AbstractProgressBarFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        int progress = 0;
        String text = ResManager.loadKDString((String)" \u8fdb\u884c\u4e2d ...", (String)"AbstractProgressBarFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        String cacheProgress = this.getPageCache().get("progress");
        if (StringUtils.isNotBlank((CharSequence)cacheProgress)) {
            progress = Double.valueOf(cacheProgress).intValue();
            text = cacheProgress + "%";
        }
        if (progress >= 100) {
            progress = 100;
            text = ResManager.loadKDString((String)" \u5b8c\u6210 ", (String)"AbstractProgressBarFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("false".equals(startProgress)) {
            text = ResManager.loadKDString((String)" \u5df2\u53d6\u6d88\u6267\u884c ", (String)"AbstractProgressBarFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if (!StringUtil.isEmpty((String)this.getPageCache().get("text"))) {
            text = this.getPageCache().get("text");
        }
        progressEvent.setProgress(progress);
        progressEvent.setText(text);
    }
}

