/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.meta;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.View;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.CustomFunctionUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ScriptCommonUtil;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.meta.doc.ExportMetaXML;
import kd.isc.iscb.platform.core.connector.meta.doc.TypeHandlers;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class MetadataSchemaFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String RESULT_JST_TAG = "result_jst_tag";
    private static final String PARAM_JST_TAG = "param_jst_tag";
    private static final String VIEW_SQL_TAG = "view_sql_tag";
    private static final String GET_SCRIPT = "get_script";
    private static final String PARAM_JST = "param_jst";
    private static final String FIELD = "field";
    private static final String SCRIPT = "script";
    private static final String RESULT_JST = "result_jst";
    private static final String REMARK = "remark";
    private static final String BTN_TEST = "btn_test";
    private static final String SYNC_META_SCHEMA = "sync_meta_schema";
    private static final String REFRESH = "refresh";
    private static final String DB_LINK = "dblink";
    private static final String ISC_DATA_SOURCE = "isc_data_source";
    private static final String FULL_NAME = "full_name";
    private static final String TABLE_NAME = "table_name";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String NUMBER = "number";
    private static final String ISC_SCHEMA_ENCRYPT_LOG = "isc_schema_encrypt_log";
    private static final String STATE = "state";
    private static final String GROUP_ID = "group_id";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String VIEW_SQL = "view_sql";
    private static final String FUNCTION_ENTRY = "function_entryentity";
    private static final String FUNCTION_NUMBER = "function_number";
    private static final String CUSTOM_FUNCTION = "custom_function";
    private static final String FUNCTION_DESCRIPTION = "function_description";
    private static final String QUERY_INDEX = "query_index";
    private static final Set<String> REFTYPE_LIST = new HashSet<String>(4);

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("view_sql_editor", this.getModel().getValue(VIEW_SQL));
        this.setButtonState();
    }

    public void afterBindData(EventObject e) {
        this.setPropEntry();
        this.setDefaultTypeWhenIscHub();
        this.showTipsWhenEvtRscType();
        this.setDataSource();
    }

    private void setDataSource() {
        long datasource = D.l(this.getView().getFormShowParameter().getCustomParams().get("guide_datasource"));
        if (datasource != 0L) {
            this.getView().getModel().setValue("group", (Object)datasource);
        }
    }

    private void showTipsWhenEvtRscType() {
        if ("EVT_RSC".equals(this.getModel().getValue("type"))) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u6e90\u96c6\u6210\u5bf9\u8c61\u5168\u540d\u683c\u5f0f\u4e3a\uff1a%s", (String)"MetadataSchemaFormPlugin_53", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MetadataSchemaFormPlugin.getEvtSrcTypeFullNameFormat())));
            ((TextEdit)this.getControl(FULL_NAME)).addTips(tips);
        } else if ("SERVICE".equals(this.getModel().getValue("type"))) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString("\u4f1a\u8ba1\u4e8b\u4ef6\u5168\u540d\u683c\u5f0f\u4e3a\uff1aaccount_event://[\u4f1a\u8ba1\u4e8b\u4ef6\u7c7b\u578b\u7f16\u7801]\u3002\u5fae\u670d\u52a1\u5168\u540d\u683c\u5f0f\u4e3a\uff1amservice://[appId.serviceName.methodName\u6216cloudId.appId.serviceName.methodName]\u3002"));
            ((TextEdit)this.getControl(FULL_NAME)).addTips(tips);
        } else {
            ((TextEdit)this.getControl(FULL_NAME)).hideTips();
        }
    }

    private void setDefaultTypeWhenIscHub() {
        long dataSourceId = D.l((Object)this.getModel().getValue(GROUP_ID));
        if (dataSourceId > 0L) {
            DynamicObject dataSource = BusinessDataServiceHelper.loadSingleFromCache((Object)dataSourceId, (String)ISC_DATA_SOURCE);
            long id = D.l((Object)this.getModel().getValue("id"));
            if (id <= 0L && "isc_hub".equals(dataSource.get("connection_type"))) {
                this.getModel().setValue("type", (Object)"EVT_RSC");
            }
        }
    }

    private void setPropEntry() {
        DynamicObjectCollection prop_entryentity = this.getModel().getEntryEntity(PROP_ENTRYENTITY);
        int size = prop_entryentity.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)prop_entryentity.get(i);
            String data_type = null;
            if (dynamicObject != null) {
                data_type = dynamicObject.getString("data_type");
            }
            if (!REFTYPE_LIST.contains(data_type)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"is_encrypt"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            this.beforeSave(e);
        } else if (e.getSource() instanceof View) {
            this.getModel().setDataChanged(false);
        } else if (e.getSource() instanceof Refresh) {
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        String type = this.getModel().getValue("type").toString();
        long dataSourceId = (Long)this.getModel().getValue(GROUP_ID);
        this.changeIllegalFields();
        String name = this.getName(type);
        if (D.l((Object)this.getModel().getValue("id")) == 0L && !this.isValid(type, dataSourceId, name)) {
            e.setCancel(true);
        } else if (D.l((Object)this.getModel().getValue("id")) == 0L && !this.isFullNameLegal(D.s((Object)this.getModel().getValue(FULL_NAME)))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u975e\u7279\u5b9a\u573a\u666f\u4e0b\u4e0d\u5efa\u8bae\u4f7f\u7528\u6c49\u5b57\u4f5c\u4e3a\u96c6\u6210\u5bf9\u8c61\u5168\u540d\u3002", (String)"MetadataSchemaFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (CustomFunctionUtil.isEntryDuplicate("event_entryentity", "event_number", this.getModel(), this.getView())) {
            e.setCancel(true);
        } else if (CustomFunctionUtil.isEntryDuplicate("param_entryentity", "param_number", this.getModel(), this.getView())) {
            e.setCancel(true);
        } else if (CustomFunctionUtil.isEntryDuplicate(PROP_ENTRYENTITY, "prop_name", this.getModel(), this.getView())) {
            e.setCancel(true);
        } else if (CustomFunctionUtil.isEntryDuplicate("op_entryentity", "op_number", this.getModel(), this.getView())) {
            e.setCancel(true);
        } else if (CustomFunctionUtil.isEntryDuplicate(FUNCTION_ENTRY, FUNCTION_NUMBER, this.getModel(), this.getView())) {
            e.setCancel(true);
        } else if (CustomFunctionUtil.isEntryDuplicate(FUNCTION_ENTRY, CUSTOM_FUNCTION, this.getModel(), this.getView(), ResManager.loadKDString((String)"\u4f9d\u8d56\u51fd\u6570\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MetadataSchemaFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]))) {
            e.setCancel(true);
        } else if (CustomFunctionUtil.isEntryDuplicate(PROP_ENTRYENTITY, "prop_name", this.getModel(), this.getView())) {
            e.setCancel(true);
        } else if (this.hasDatabaseLink(dataSourceId)) {
            long id = D.l((Object)this.getModel().getValue("id"));
            if (id <= 0L) {
                id = MetaSchemaUtil.getHashId((MetaType)this.getType(type), (long)dataSourceId, (String)name);
                this.getModel().setValue("id", (Object)id);
                this.getView().setStatus(OperationStatus.EDIT);
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
            }
            this.getModel().setValue("status", (Object)"A");
            if (this.isEnableSync()) {
                this.getModel().setValue("is_init", (Object)Boolean.FALSE);
                this.getModel().setValue(STATE, (Object)"W");
            } else {
                this.getModel().setValue("is_init", (Object)Boolean.TRUE);
                this.getModel().setValue(STATE, (Object)"Z");
            }
            this.saveEncryptedFieldsInfo(id);
        } else {
            e.setCancel(true);
        }
    }

    private boolean isFullNameLegal(String fullName) {
        if (fullName == null) {
            return true;
        }
        int length = fullName.length();
        for (int i = 0; i < length; ++i) {
            char c = fullName.charAt(i);
            if (MetadataSchemaFormPlugin.isValid(c)) continue;
            return false;
        }
        return length > 0;
    }

    private static boolean isValid(char c) {
        return c >= '!' && c <= '\u007f';
    }

    private void saveEncryptedFieldsInfo(long metaDataId) {
        Map<String, Object> encryptedFieldsFromView = this.getEncryptedFieldsFromView();
        Map<String, Object> encryptedFieldsFromDB = this.getEncryptedFieldsFromDB(metaDataId);
        LinkedHashMap<String, Object> operationKey = new LinkedHashMap<String, Object>(12);
        if (encryptedFieldsFromDB == null) {
            this.newAndSave(encryptedFieldsFromView, operationKey);
        } else {
            this.modifyAndSave(encryptedFieldsFromView, encryptedFieldsFromDB, operationKey);
        }
        this.doSave(operationKey);
    }

    private void doSave(Map<String, Object> operationKey) {
        if (operationKey.size() < 1) {
            return;
        }
        IDataModel model = this.getView().getModel();
        String s = Json.toString(operationKey, (boolean)true);
        DynamicObject encryptLog = BusinessDataServiceHelper.newDynamicObject((String)ISC_SCHEMA_ENCRYPT_LOG);
        encryptLog.set(NUMBER, model.getValue(NUMBER));
        encryptLog.set("name", model.getValue("name"));
        encryptLog.set("schema", model.getDataEntity().getPkValue());
        encryptLog.set("type", (Object)ResManager.loadKDString((String)"\u6570\u636e\u8131\u654f", (String)"MetadataSchemaFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        encryptLog.set("log", (Object)StringUtil.trim((String)s, (int)30));
        encryptLog.set("log_tag", (Object)s);
        encryptLog.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        encryptLog.set("creator", (Object)RequestContext.get().getUserId());
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)ISC_SCHEMA_ENCRYPT_LOG, (DynamicObject[])new DynamicObject[]{encryptLog}, (OperateOption)OperateOption.create()));
    }

    private void modifyAndSave(Map<String, Object> viewFields, Map<String, Object> oldFields, Map<String, Object> operationKey) {
        for (Map.Entry<String, Object> v : viewFields.entrySet()) {
            boolean oldIsEncrypt;
            String viewKey = v.getKey();
            boolean viewIsEncrypt = D.x((Object)v.getValue());
            if (viewIsEncrypt == (oldIsEncrypt = D.x((Object)oldFields.get(viewKey)))) continue;
            operationKey.put(viewKey, this.getIsEncrypt(viewIsEncrypt));
        }
    }

    private void newAndSave(Map<String, Object> viewFields, Map<String, Object> operationKey) {
        for (Map.Entry<String, Object> e : viewFields.entrySet()) {
            boolean b = D.x((Object)e.getValue());
            if (!b) continue;
            operationKey.put(e.getKey(), this.getIsEncrypt(b));
        }
    }

    private String getIsEncrypt(boolean viewIsEncrypt) {
        if (viewIsEncrypt) {
            return ResManager.loadKDString((String)"\u5f00\u542f", (String)"MetadataSchemaFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5173\u95ed", (String)"MetadataSchemaFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private Map<String, Object> getEncryptedFieldsFromDB(long id) {
        if (QueryServiceHelper.exists((String)ISC_METADATA_SCHEMA, (Object)id)) {
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
            DynamicObjectCollection prop = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
            return this.getMetaDataFields(prop);
        }
        return null;
    }

    private Map<String, Object> getEncryptedFieldsFromView() {
        DynamicObjectCollection prop = this.getModel().getEntryEntity(PROP_ENTRYENTITY);
        return this.getMetaDataFields(prop);
    }

    private Map<String, Object> getMetaDataFields(DynamicObjectCollection prop) {
        LinkedHashMap<String, Object> encryptedFields = new LinkedHashMap<String, Object>(prop.size());
        for (DynamicObject en : prop) {
            String param_number = en.getString("prop_name");
            boolean is_encrypt = en.getBoolean("is_encrypt");
            encryptedFields.put(param_number, is_encrypt);
        }
        return encryptedFields;
    }

    private String getName(String type) {
        if (StringUtil.isEmpty((String)type)) {
            return null;
        }
        if ("TABLE".equals(type)) {
            return this.getModel().getValue(TABLE_NAME).toString().toLowerCase();
        }
        return this.getModel().getValue(FULL_NAME).toString();
    }

    private boolean isValid(String type, long dataSourceId, String name) {
        if (StringUtil.isEmpty((String)type) || dataSourceId == 0L || StringUtil.isEmpty((String)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u4fe1\u606f\u586b\u5199\u5b8c\u6574\uff0c\u81f3\u5c11\u5305\u542b\u7c7b\u578b\u3001\u6570\u636e\u6e90\u3001\u5168\u540d\u6216\u6570\u636e\u8868\u540d\u3002", (String)"MetadataSchemaFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        MetaType metaType = this.getType(type);
        if (metaType == MetaType.EVT_RSC && !this.isNameValid(name)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u6e90\u96c6\u6210\u5bf9\u8c61\u5168\u540d\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5e94\u8be5\u4e3a\uff1a%1$s\uff0c\u800c\u5f53\u524d\u5168\u540d\u4e3a\uff1a%2$s", (String)"MetadataSchemaFormPlugin_54", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MetadataSchemaFormPlugin.getEvtSrcTypeFullNameFormat(), name));
            return false;
        }
        Long hashId = MetaSchemaUtil.getHashId((MetaType)metaType, (long)dataSourceId, (String)name);
        if (QueryServiceHelper.exists((String)ISC_METADATA_SCHEMA, (Object)hashId)) {
            String tip = metaType == MetaType.TABLE ? ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d", (String)"MetadataSchemaFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5168\u540d", (String)"MetadataSchemaFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u53ca%s\u7684\u5143\u6570\u636e\u3002", (String)"MetadataSchemaFormPlugin_55", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tip), Integer.valueOf(2000));
            return false;
        }
        if (MetaType.ELEMENT.name().equals(type) && D.s((Object)this.getModel().getValue("element_type")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u4e3a\u201c\u5143\u7d20\u201d\u7c7b\u578b\uff0c\u8bf7\u586b\u5199\u5143\u7d20\u6240\u5bf9\u5e94\u7684\u6570\u636e\u7c7b\u578b\u3002", (String)"MetadataSchemaFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return this.hasDatabaseLink(dataSourceId);
    }

    private boolean isNameValid(String name) {
        return name.startsWith("isc_data_source/") || name.startsWith("isc_data_copy_trigger/") || name.startsWith("isc_service_flow/") || name.startsWith("isc_user_defined_event/");
    }

    private boolean hasDatabaseLink(long dataSourceId) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)ISC_DATA_SOURCE);
        if (dataSource.get(DB_LINK) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u7ba1\u7406\u7684\u7cfb\u7edf\u8fde\u63a5\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u8fde\u63a5\u7ba1\u7406-\u6570\u636e\u6e90\u7ba1\u7406\uff0c\u4e3a\u6570\u636e\u6e90\u914d\u7f6e\u8fde\u63a5\u7cfb\u7edf\u3002", (String)"MetadataSchemaFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private MetaType getType(String type) {
        if (StringUtil.isEmpty((String)type)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u7c7b\u578b!", (String)"MetadataSchemaFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return MetaType.valueOf((String)type);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if ("syncmetaschema".equals(operationKey)) {
            this.syncMetadata(evt);
        } else if ("test".equals(operationKey)) {
            this.test();
        } else if (operationKey.equals("save")) {
            this.setButtonState();
        } else if (operationKey.equals("modify") && evt.getOperationResult().isSuccess()) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else if (operationKey.equals("relation_query")) {
            this.relationQuery();
        } else if (operationKey.equals("encryptlog")) {
            this.showEncryptlogList();
        } else if ("view_evt_src".equals(operationKey)) {
            this.showEvtSrcSchema();
        } else if (QUERY_INDEX.equals(operationKey)) {
            this.showIndex();
        } else if ("exportword".equals(operationKey)) {
            try {
                Object id = this.getModel().getValue("id");
                DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
                new ExportMetaXML(meta, TypeHandlers.buildInfo((DynamicObject)meta)).export(this.getView());
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        } else if ("show_sql".equals(operationKey)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(REMARK, this.getModel().getValue(VIEW_SQL));
            params.put(SCRIPT, this.getModel().getValue(VIEW_SQL_TAG));
            params.put(FIELD, VIEW_SQL);
            FormOpener.showStatusForm(this, "isc_sql_editor", ResManager.loadKDString((String)"SQL\u67e5\u770b", (String)"MetadataSchemaFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, OperationStatus.VIEW, ShowType.Modal);
        }
    }

    private void showIndex() {
        Object obj_table = this.getView().getModel().getValue(TABLE_NAME);
        if (obj_table == null || "".equals(obj_table)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u5bf9\u8c61\u7684\u6570\u636e\u8868\u4e3a\u7a7a\u3002", (String)"MetadataSchemaFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.queryIndex(obj_table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryIndex(Object table) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue(GROUP_ID), (String)ISC_DATA_SOURCE);
        ConnectionManager.pushResLicense((boolean)true);
        try (ConnectionWrapper connectionWrapper = ConnectionManager.getConnection((long)D.l((Object)dataSource.get("dblink_id")));){
            ConnectionFactory cf = connectionWrapper.getFactory();
            if (cf instanceof JdbcConnectionFactory) {
                String table_name;
                JdbcConnectionFactory factory = (JdbcConnectionFactory)connectionWrapper.getFactory();
                Map indexMap = factory.getIndexInfo((JdbcConnectionWrapper)connectionWrapper, table_name = StringUtil.toLowerCase((String)table.toString()));
                if (indexMap.isEmpty()) {
                    indexMap = factory.getIndexInfo((JdbcConnectionWrapper)connectionWrapper, StringUtil.toUpperCase((String)table_name));
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("content", this.getTableIndex(indexMap));
                FormOpener.showForm(this, "isc_text_content_dialog", table.toString(), params, null);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u5bf9\u8c61\u7684\u8fde\u63a5\u7c7b\u578b\u4e0d\u652f\u6301\u83b7\u53d6\u6570\u636e\u8868\u7684\u7d22\u5f15\u3002", (String)"MetadataSchemaFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private String getTableIndex(Map<String, Index> map) {
        StringBuilder sbuilder = new StringBuilder();
        for (Map.Entry<String, Index> indexEntry : map.entrySet()) {
            Index index = indexEntry.getValue();
            List list = index.getColumns();
            String unique = index.isUnique() ? ResManager.loadKDString((String)"\u552f\u4e00\u7d22\u5f15\uff1a", (String)"MetadataSchemaFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7d22\u5f15\uff1a", (String)"MetadataSchemaFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            sbuilder.append(unique).append(index.getIndexName()).append('\n');
            sbuilder.append(ResManager.loadKDString((String)"\u5217\u540d\uff1a", (String)"MetadataSchemaFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            for (Pair p : list) {
                sbuilder.append('\n').append('\t').append((String)p.getKey());
            }
            sbuilder.append('\n').append('\n');
        }
        return sbuilder.toString();
    }

    private void showEvtSrcSchema() {
        try {
            String fullname = D.s((Object)this.getModel().getValue(FULL_NAME));
            if (fullname == null || !fullname.contains("/")) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u6e90\u5168\u540d\u4e0d\u5408\u6cd5,\u6b63\u786e\u683c\u5f0f\u5e94\u8be5\u4e3a\u3010\u5143\u6570\u636e\u7f16\u7801/\u6570\u636e\u7f16\u7801\u3011,\u800c\u5f53\u524d\u5168\u540d\u4e3a\uff1a%s", (String)"MetadataSchemaFormPlugin_56", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), fullname));
            }
            String[] split = fullname.split("/");
            String entity = split[0];
            String number = fullname.substring(entity.length() + 1);
            long srcSchemaId = MetadataSchemaFormPlugin.getSrcSchemaId(number, EntityMetadataCache.getDataEntityType((String)entity));
            if (entity.equals(ISC_DATA_SOURCE)) {
                FormOpener.showView(this, entity, srcSchemaId);
            } else {
                FormOpener.showTabView((AbstractFormPlugin)this, entity, srcSchemaId);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public static long getSrcSchemaId(String number, MainEntityType entityType) {
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{qFilter};
        if (QueryServiceHelper.exists((String)entityType.getName(), (QFilter[])qFilters)) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entityType.getName(), (String)"id", (QFilter[])qFilters);
            return obj.getLong("id");
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"%1$s\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%2$s\u7684\u6570\u636e", (String)"MetadataSchemaFormPlugin_57", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entityType.getDisplayName(), number));
    }

    private void syncMetadata(AfterDoOperationEventArgs evt) {
        if (this.isIllegalFields(this.getModelFields())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u4e0d\u652f\u6301\u540c\u6b65\uff0c\u539f\u56e0\uff1a\u8d4b\u503c\u4e0d\u5408\u6cd5\uff0c\u542b\u6709\u7a7a\u5b57\u7b26\u5f00\u5934\u6216\u7ed3\u5c3e\u3002\u89e3\u51b3\u529e\u6cd5\uff1a\u70b9\u51fb\u4fdd\u5b58\uff0c\u7cfb\u7edf\u4f1a\u4e3a\u81ea\u52a8\u66f4\u6b63\u76f8\u5e94\u5b57\u6bb5", (String)"MetadataSchemaFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isDataSourceExists()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u7ba1\u7406\u7684\u7cfb\u7edf\u8fde\u63a5\u5df2\u4e0d\u5b58\u5728", (String)"MetadataSchemaFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("syncmetaschema", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u8986\u76d6\u5f53\u524d\u5143\u6570\u636e\u4fe1\u606f\uff0c\u5e76\u540c\u6b65\u65b0\u589e\uff08\u4f46\u4e0d\u8986\u76d6\uff09\u6240\u5f15\u7528\u7684\u6570\u636e\u6a21\u578b\uff0c\u53ef\u80fd\u5f71\u54cd\u5230\u6b63\u5728\u8fd0\u884c\u7684\u65b9\u6848\uff0c\u6b63\u5f0f\u73af\u5883\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\u540c\u6b65\uff1f", (String)"MetadataSchemaFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (StringUtils.equals((CharSequence)"syncmetaschema", (CharSequence)e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            Object id = this.getModel().getValue("id");
            try {
                MetaSchemaUtil.syncMetaSchema((Object)id);
                MetadataSchemaFormPlugin.saveHistories(BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)ISC_METADATA_SCHEMA));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5143\u6570\u636e\u6a21\u578b\u6210\u529f\u3002", (String)"MetadataSchemaFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().cacheFormShowParameter();
                this.getView().invokeOperation(REFRESH);
            }
            catch (Throwable err) {
                FormOpener.showErrorMessage(this.getView(), String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u96c6\u6210\u5bf9\u8c61\u4fe1\u606f\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"MetadataSchemaFormPlugin_58", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), err.getMessage()), ShowStackTraceUtil.getErrorMsg(err));
            }
        }
    }

    private void test() {
        Object type = this.getModel().getValue("type");
        String paramStr = null;
        if (!"STRUCT".equals(type)) {
            Object id = this.getModel().getValue("id");
            if ("SERVICE".equals(type) || "QUERY".equals(type)) {
                if (D.l((Object)id) <= 0L) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61id\u4e3a\uff1a%s\uff0c\u8be5\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"MetadataSchemaFormPlugin_59", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
                    return;
                }
                DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
                DynamicObjectCollection paramEntryentity = meta.getDynamicObjectCollection("param_entryentity");
                LinkedHashMap<String, Object> inputs = new LinkedHashMap<String, Object>(paramEntryentity.size());
                for (DynamicObject paramEntry : paramEntryentity) {
                    String paramType = paramEntry.getString("param_type").toLowerCase();
                    String paramNumber = paramEntry.getString("param_number");
                    inputs.put(paramNumber, this.getDefaultValue(paramType));
                }
                paramStr = JSON.toJSONString(inputs, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", id);
            params.put("inputs", paramStr);
            FormOpener.showForm(this, "isc_metadata_test", ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u6d4b\u8bd5", (String)"MetadataSchemaFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u5bf9\u8c61\u4e0d\u652f\u6301\u6d4b\u8bd5\u3002", (String)"MetadataSchemaFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public static void saveHistories(DynamicObject obj) {
        String json = Json.toString((Object)DynamicObjectUtil.object2Map((DynamicObject)obj), (boolean)true);
        DynamicObject histories = BusinessDataServiceHelper.newDynamicObject((String)"isc_res_history");
        histories.set("res_type", (Object)obj.getDataEntityType().getName());
        histories.set("operate_key", (Object)"syncmetaschema");
        histories.set("res_number", obj.get(NUMBER));
        histories.set("res_name", (Object)obj.getString("name"));
        histories.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        histories.set("operator", (Object)D.l((Object)RequestContext.get().getUserId()));
        histories.set("res_content", (Object)"...");
        histories.set("res_content_tag", (Object)json);
        histories.set("resid", obj.getPkValue());
        histories.set("version", MetadataSchemaFormPlugin.getVersion(obj.getPkValue()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{histories});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getVersion(Object pkValue) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "SELECT MAX(fversion) FROM t_iscb_res_history WHERE fres_id=?";
            int version = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(pkValue), Collections.singletonList(-5)));
            Integer n = version + 1;
            return n;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void showEncryptlogList() {
        String pkValue = D.s((Object)this.getView().getModel().getDataEntity().getPkValue());
        FormOpener.showList(this, ISC_SCHEMA_ENCRYPT_LOG, new QFilter("schema", "=", (Object)pkValue));
    }

    private Object getDefaultValue(String dataType) {
        switch (dataType) {
            case "string": 
            case "ml_string": {
                return "";
            }
            case "boolean": {
                return Boolean.FALSE;
            }
            case "bigdecimal": {
                return BigDecimal.ZERO;
            }
            case "integer": 
            case "int": 
            case "long": {
                return 0;
            }
            case "boid": {
                return null;
            }
            case "datetime": {
                return new Date();
            }
            case "map": 
            case "java.util.map": 
            case "java.util.hashmap": {
                return Collections.emptyMap();
            }
            case "list": 
            case "java.util.list": {
                return Collections.emptyList();
            }
            case "set": 
            case "java.util.set": {
                return Collections.emptySet();
            }
        }
        return null;
    }

    private void relationQuery() {
        long dataSourceId = D.l((Object)this.getModel().getValue(GROUP_ID));
        String dataSchema = D.s((Object)this.getModel().getValue(NUMBER));
        if (dataSourceId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e3a\u7a7a\u3002", (String)"MetadataSchemaFormPlugin_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)dataSchema)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"MetadataSchemaFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("group", "=", (Object)dataSourceId).and(new QFilter("prop_entryentity.data_schema", "=", (Object)dataSchema));
        FormOpener.openBillList(this, ISC_METADATA_SCHEMA, "isc_related_metadata", ResManager.loadKDString((String)"\u5173\u8054\u96c6\u6210\u5bf9\u8c61", (String)"MetadataSchemaFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Collections.singletonList(qFilter));
    }

    private boolean isDataSourceExists() {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)ISC_METADATA_SCHEMA);
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)meta.get(GROUP_ID), (String)ISC_DATA_SOURCE, (String)DB_LINK);
        return dataSource.get(DB_LINK) == null;
    }

    private void changeIllegalFields() {
        Map<String, String> modelFields = this.getModelFields();
        if (this.isIllegalFields(modelFields)) {
            this.getModel().setValue(NUMBER, (Object)D.s((Object)modelFields.get(NUMBER)));
            this.getModel().setValue(FULL_NAME, (Object)D.s((Object)modelFields.get(FULL_NAME)));
            if (modelFields.size() > 2) {
                this.getModel().setValue(TABLE_NAME, (Object)D.s((Object)modelFields.get(TABLE_NAME)));
            }
        }
    }

    private Map<String, String> getModelFields() {
        String number = this.getView().getModel().getValue(NUMBER).toString();
        String full_name = this.getView().getModel().getValue(FULL_NAME).toString();
        HashMap<String, String> checkFields = new HashMap<String, String>();
        checkFields.put(NUMBER, number);
        checkFields.put(FULL_NAME, full_name);
        if ("TABLE".equals(this.getView().getModel().getValue("type"))) {
            String table_name = this.getView().getModel().getValue(TABLE_NAME).toString();
            checkFields.put(TABLE_NAME, table_name);
        }
        return checkFields;
    }

    private boolean isIllegalFields(Map<String, String> checkFields) {
        for (String checkFieldValue : checkFields.values()) {
            if (!checkFieldValue.startsWith(" ") && !checkFieldValue.endsWith(" ")) continue;
            return true;
        }
        return false;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PROP_ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"btn_param_script", "btn_result_script", "view_sql_editor"});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("data_schema".equals(evt.getFieldName()) && evt.getRowIndex() >= 0) {
            Object dataSourceId = this.getModel().getValue(GROUP_ID);
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(PROP_ENTRYENTITY);
            DynamicObject entry = (DynamicObject)collection.get(evt.getRowIndex());
            String dataType = entry.getString("data_type");
            String dataSchema = entry.getString("data_schema");
            MetadataSchemaFormPlugin.openRefMeta(this, dataSourceId, dataSchema, dataType);
        }
    }

    public static void openRefMeta(AbstractFormPlugin form, Object dataSourceId, String dataSchema, String dataType) {
        if (dataType.contains("meta")) {
            if (QueryServiceHelper.exists((String)ISC_METADATA_SCHEMA, (Object)D.l((Object)dataSchema))) {
                FormOpener.showTabView(form, ISC_METADATA_SCHEMA, D.l((Object)dataSchema));
            } else {
                form.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230id\u4e3a[%s]\u7684\u96c6\u6210\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u540c\u6b65\u5f53\u524d\u5bf9\u8c61", (String)"MetadataSchemaFormPlugin_60", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataSchema));
            }
        } else {
            QFilter qFilter = new QFilter("group", "=", (Object)D.l((Object)dataSourceId)).and(NUMBER, "=", (Object)dataSchema);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ISC_METADATA_SCHEMA, (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (obj != null) {
                FormOpener.showTabView(form, ISC_METADATA_SCHEMA, obj.getPkValue());
            } else {
                DataSource dataSource = DataSource.get((long)D.l((Object)dataSourceId));
                form.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90[%1$s]\u4e2d\u627e\u4e0d\u5230number\u4e3a[%2$s]\u7684\u5143\u6570\u636e", (String)"MetadataSchemaFormPlugin_61", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataSource.getNumber(), dataSchema));
            }
        }
    }

    private void setButtonState() {
        if (D.l((Object)this.getView().getModel().getValue("id")) != 0L) {
            this.getView().setEnable(Boolean.TRUE, new String[]{SYNC_META_SCHEMA});
            this.getView().setEnable(Boolean.TRUE, new String[]{REFRESH});
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_TEST});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{SYNC_META_SCHEMA});
            this.getView().setEnable(Boolean.FALSE, new String[]{REFRESH});
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_TEST});
        }
        this.getView().setVisible(Boolean.valueOf(!"Z".equals(this.getModel().getValue(STATE))), new String[]{SYNC_META_SCHEMA});
        if (this.getView().getFormShowParameter() != null && !OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"exportword"});
            this.getView().setVisible(Boolean.valueOf("TABLE".equals(this.getModel().getValue("type")) || "ENTITY".equals(this.getModel().getValue("type"))), new String[]{QUERY_INDEX});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isEnableSync() {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue(GROUP_ID), (String)ISC_DATA_SOURCE);
        ConnectionManager.pushResLicense((boolean)true);
        try {
            boolean bl;
            Throwable throwable;
            ConnectionWrapper connectionWrapper;
            block17: {
                block18: {
                    connectionWrapper = ConnectionManager.getConnection((long)D.l((Object)dataSource.get("dblink_id")));
                    throwable = null;
                    ConnectionFactory factory = connectionWrapper.getFactory();
                    bl = factory.hasMetaData(D.s((Object)this.getModel().getValue(FULL_NAME)), D.s((Object)this.getModel().getValue("type")), connectionWrapper);
                    if (connectionWrapper == null) break block17;
                    if (throwable == null) break block18;
                    try {
                        connectionWrapper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block17;
                }
                connectionWrapper.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (connectionWrapper != null) {
                            if (throwable != null) {
                                try {
                                    connectionWrapper.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                connectionWrapper.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                }
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
        return false;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object src = evt.getSource();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (src instanceof Button) {
            String key2 = ((Button)src).getKey();
            if ("btn_result_script".equals(key2)) {
                params.put(REMARK, this.getModel().getValue(RESULT_JST));
                params.put(SCRIPT, this.getModel().getValue(RESULT_JST_TAG));
                params.put(FIELD, RESULT_JST);
                this.setBillStatus(params);
                Pair<List<String>, List<Map<String, Object>>> innervarPair = this.getEntryOfInnerVar("result_entryentity", "result_number", "result_remark");
                List<String> heightLightkeys = this.resultScriptHeightLightKeys();
                heightLightkeys.addAll((Collection)innervarPair.getA());
                params.put("context_variables", heightLightkeys);
                params.put("dynamic_tips", innervarPair.getB());
                params.put("env", "meta_service_result");
                params.put("id", this.getView().getModel().getValue("id"));
                ScriptCommonUtil.showEditor(this, ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"MetadataSchemaFormPlugin_43", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, GET_SCRIPT);
            } else if ("btn_param_script".equals(key2)) {
                params.put(REMARK, this.getModel().getValue(PARAM_JST));
                params.put(SCRIPT, this.getModel().getValue(PARAM_JST_TAG));
                params.put(FIELD, PARAM_JST);
                this.setBillStatus(params);
                Pair<List<String>, List<Map<String, Object>>> innervarPair = this.getEntryOfInnerVar("param_entryentity", "param_number", "param_remark");
                params.put("context_variables", innervarPair.getA());
                params.put("dynamic_tips", innervarPair.getB());
                params.put("env", "meta_service_param");
                params.put("id", this.getView().getModel().getValue("id"));
                ScriptCommonUtil.showEditor(this, ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"MetadataSchemaFormPlugin_43", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, GET_SCRIPT);
            }
        } else if (src instanceof FieldEdit && "view_sql_editor".equals(key = ((FieldEdit)src).getKey())) {
            params.put(REMARK, this.getModel().getValue(VIEW_SQL));
            params.put(SCRIPT, this.getModel().getValue(VIEW_SQL_TAG));
            params.put(FIELD, VIEW_SQL);
            FormOpener.showForm(this, "isc_sql_editor", ResManager.loadKDString((String)"SQL\u7f16\u8f91", (String)"MetadataSchemaFormPlugin_44", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_sql");
        }
    }

    private List<String> resultScriptHeightLightKeys() {
        ArrayList<String> keys = new ArrayList<String>(5);
        keys.add("$data");
        keys.add("$service");
        keys.add("$params");
        keys.add("$result");
        keys.add("$invokeMicroService2");
        return keys;
    }

    private Pair<List<String>, List<Map<String, Object>>> getEntryOfInnerVar(String entryName, String fieldName, String fieldDescName) {
        int entrySize = this.getView().getModel().getEntryRowCount(entryName);
        ArrayList<String> innerVars = new ArrayList<String>(entrySize);
        ArrayList tips = new ArrayList(entrySize);
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject entry = this.getView().getModel().getEntryRowEntity(entryName, i);
            String field = entry.getString(fieldName);
            String fieldDesc = entry.getString(fieldDescName);
            innerVars.add(field);
            HashMap<String, String> tip = new HashMap<String, String>();
            String descMark = "";
            descMark = "param_entryentity".equals(entryName) ? ResManager.loadKDString((String)"\u53c2\u6570", (String)"MetadataSchemaFormPlugin_45", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ed3\u679c", (String)"MetadataSchemaFormPlugin_46", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            tip.put("title", field + " // " + descMark + (StringUtils.isNotBlank((CharSequence)fieldDesc) ? " - " + fieldDesc : ""));
            tip.put("text", field);
            tips.add(tip);
        }
        return new Pair(innerVars, tips);
    }

    private void setBillStatus(HashMap<String, Object> params) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        params.put("billStatus", billShowParameter.getBillStatus());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map params;
        super.closedCallBack(e);
        String action = e.getActionId();
        if (GET_SCRIPT.equals(action)) {
            this.setScript(e);
        } else if ("get_sql".equals(action) && (params = (Map)e.getReturnData()) != null) {
            this.getModel().setValue(VIEW_SQL, params.get(REMARK));
            this.getModel().setValue(VIEW_SQL_TAG, params.get(SCRIPT));
            this.getModel().setValue("view_sql_editor", params.get(REMARK));
            this.getView().updateView();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getRowDataEntities().length <= 0) {
            return;
        }
        int index = e.getRowDataEntities()[0].getRowIndex();
        if (e.getEntryProp().getName().equals(PROP_ENTRYENTITY)) {
            this.getModel().setValue("prop_customize", (Object)Boolean.TRUE, index);
        } else if (e.getEntryProp().getName().equals("event_entryentity")) {
            this.getModel().setValue("event_customize", (Object)Boolean.TRUE, index);
        }
    }

    private void setScript(ClosedCallBackEvent evt) {
        Map params = (Map)evt.getReturnData();
        if (params != null) {
            if ("new_tab".equals(params.get("operate"))) {
                String caption = (String)params.get("caption");
                String actionId = (String)params.get("actionId");
                ScriptCommonUtil.showTabEditor(this, caption, params, actionId);
            } else if (PARAM_JST.equals(params.get(FIELD))) {
                this.getModel().setValue(PARAM_JST, params.get(REMARK));
                this.getModel().setValue(PARAM_JST_TAG, params.get(SCRIPT));
                this.getView().updateView();
            } else if (RESULT_JST.equals(params.get(FIELD))) {
                this.getModel().setValue(RESULT_JST, params.get(REMARK));
                this.getModel().setValue(RESULT_JST_TAG, params.get(SCRIPT));
                this.getView().updateView();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject dynamicObject;
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("S".equals(this.getModel().getValue(STATE)) && changeSet.length == 1 && ("prop_name".equals(proName) || "is_primary_key".equals(proName) || "required".equals(proName)) && !D.x((Object)(dynamicObject = changeSet[0].getDataEntity()).get("prop_customize"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u5206\u5f55\u7b2c %1$s \u884c\u7f16\u7801\u4e3a\uff1a %2$s \u7684\u6570\u636e\u5c5e\u6027\u503c [ %3$s ] \u5df2\u88ab\u4fee\u6539\uff0c\u4f46\u672a\u52fe\u9009\u201c\u81ea\u5b9a\u4e49\u201d\u6807\u8bc6\uff1b\u5982\u9700\u786e\u4fdd\u518d\u6b21\u540c\u6b65\u5143\u6570\u636e\u65f6\u4e0d\u4f1a\u8986\u76d6\u672c\u6b21\u4fee\u6539\uff0c\u8bf7\u5728\u4fdd\u5b58\u524d\u52fe\u9009\u5bf9\u5e94\u5206\u5f55\u884c\u5c5e\u6027\u7684\u201c\u81ea\u5b9a\u4e49\u201d\u6807\u8bc6\u3002", (String)"MetadataSchemaFormPlugin_62", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), changeSet[0].getRowIndex() + 1, dynamicObject.get("prop_name"), e.getProperty().getDisplayName()));
        }
        if (CUSTOM_FUNCTION.equals(proName) && changeSet.length == 1 && changeSet[0].getNewValue() != null) {
            DynamicObject row = this.getModel().getEntryRowEntity(FUNCTION_ENTRY, changeSet[0].getRowIndex());
            DynamicObject function = (DynamicObject)changeSet[0].getNewValue();
            row.set(FUNCTION_NUMBER, (Object)function.getString(NUMBER));
            this.getView().updateView();
        }
        if (CUSTOM_FUNCTION.equals(proName) || FUNCTION_NUMBER.equals(proName) || FUNCTION_DESCRIPTION.equals(proName)) {
            CustomFunctionUtil.checkFunctionNoNull(e, this.getView());
        }
        if ("group".equals(proName)) {
            this.setDefaultTypeWhenIscHub();
        }
        if ("type".equals(proName)) {
            this.showTipsWhenEvtRscType();
        }
    }

    private static String getEvtSrcTypeFullNameFormat() {
        return ResManager.loadKDString((String)"isc_data_source/[\u6570\u636e\u6e90\u7f16\u7801]\uff1bisc_data_copy_trigger/[\u542f\u52a8\u65b9\u6848\u7f16\u7801]\uff1bisc_service_flow/[\u670d\u52a1\u6d41\u7a0b\u7f16\u7801]\uff1bisc_user_defined_event/[\u81ea\u5b9a\u4e49\u7f16\u7801]", (String)"MetadataSchemaFormPlugin_52", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    static {
        REFTYPE_LIST.add("REF");
        REFTYPE_LIST.add("SubHeadEntity");
        REFTYPE_LIST.add("ENTRIES");
    }
}

