/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.oauth;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.isc.iscb.formplugin.dc.oauth.GetOauthReturnDataUtil;
import kd.isc.iscb.formplugin.dc.oauth.OauthUtil;
import kd.isc.iscb.platform.core.ShowStackTraceUtil;

public class OauthIframeFormPlugin
extends AbstractMobFormPlugin {
    private static final String ACTION_URL = "url";
    private static final String OAUTH_LINK_IFRAME_FORMID = "oauthiframe";
    private static final String TXDOC_LINK_FORMID = "isc_database_link_txdoc";
    private static final String WPS_LINK_FORMID = "isc_database_link_wps";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CustomControl oauthIframe = (CustomControl)this.getView().getControl(OAUTH_LINK_IFRAME_FORMID);
        HashMap paramsMap = new HashMap();
        Map authInfo = this.getView().getFormShowParameter().getCustomParams();
        paramsMap.put(ACTION_URL, authInfo.get("oauth_url"));
        oauthIframe.setData(paramsMap);
    }

    public void customEvent(CustomEventArgs e) {
        if ("code".equals(e.getEventName())) {
            try {
                Map authInfo = this.getView().getFormShowParameter().getCustomParams();
                String url = OauthUtil.getDeDomainContextUrl(e.getEventArgs());
                String code = OauthUtil.getSubstringUrl("code=", url);
                Map<Object, Object> returnOauthInfo = new HashMap();
                Object conn_type = authInfo.get("conn_type");
                if (code == null) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u57df\u540d\u672a\u6388\u6743\uff0c\u62a5\u9519\u5730\u5740\u4fe1\u606f\uff1a%s", (String)"OauthIframeFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), url));
                    return;
                }
                if (TXDOC_LINK_FORMID.equals(conn_type)) {
                    returnOauthInfo = GetOauthReturnDataUtil.getTxdocAuthInfo(authInfo, code);
                } else if (WPS_LINK_FORMID.equals(conn_type)) {
                    returnOauthInfo = GetOauthReturnDataUtil.getWpsAuthInfo(authInfo, code);
                }
                this.getView().returnDataToParent(returnOauthInfo);
                this.getView().close();
            }
            catch (Exception exception) {
                this.getView().showMessage(ShowStackTraceUtil.getErrorMsg((Throwable)exception));
            }
        }
    }
}

