/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.oauth;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.isc.iscb.formplugin.dc.oauth.OauthUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class TxDocDatabaseLinkFormPlugin
extends AbstractMobFormPlugin {
    private static final String OAUTH_CALLBACK = "oauth";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if (OAUTH_CALLBACK.equals(operationKey)) {
            IDataModel model = this.getModel();
            String ip = D.s((Object)model.getValue("server_ip"));
            String tenant = D.s((Object)model.getValue("tenant"));
            String appSecret = D.s((Object)model.getValue("appsecret_new"));
            if (D.s((Object)ip) == null || D.s((Object)tenant) == null || D.s((Object)appSecret) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u817e\u8baf\u6587\u6863\u57df\u540d\u3001\u5e94\u7528\u5bc6\u94a5\u3001\u5e94\u7528ID\u3002", (String)"TxDocDatabaseLinkFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if (OAUTH_CALLBACK.equals(operationKey)) {
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                IDataModel model = this.getModel();
                String http = D.s((Object)model.getValue("http_protocal"));
                String ip = D.s((Object)model.getValue("server_ip"));
                String tenant = D.s((Object)model.getValue("tenant"));
                String appSecret = D.s((Object)model.getValue("appsecret_new"));
                String oauth_url = http + "://" + ip + "/oauth/v2/authorize?client_id=" + tenant + "&redirect_uri=" + OauthUtil.getEnDomainContextUrl() + "&response_type=code&scope=all&state=DD0870D15224AAD950500EB124E7C14F";
                params.put("http", http);
                params.put("ip", ip);
                params.put("tenant", tenant);
                params.put("appSecret", appSecret);
                params.put("conn_type", this.getView().getFormShowParameter().getFormId());
                params.put("oauth_url", oauth_url);
                FormOpener.showForm((AbstractFormPlugin)this, "isc_connection_oauth", TxDocDatabaseLinkFormPlugin.getOauthWindowTitle(), params, OAUTH_CALLBACK);
            }
            catch (Exception e) {
                this.getView().showMessage(e.getMessage());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (OAUTH_CALLBACK.equals(closedCallBackEvent.getActionId())) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            String errorMessage = D.s(returnData.get("errorMessage"));
            if (errorMessage != null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u5931\u8d25,\u8bf7\u68c0\u67e5\u4fe1\u606f\u662f\u5426\u586b\u5199\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f:%s", (String)"TxDocDatabaseLinkFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), errorMessage));
            } else {
                String userId = D.s(returnData.get("user_id"));
                String refreshToken = D.s(returnData.get("refresh_token"));
                if (userId != null && D.s((Object)this.getModel().getValue("newpwd")) == null) {
                    this.getModel().setValue("newpwd", (Object)userId);
                }
                if (refreshToken != null) {
                    this.getModel().setValue("attr9", (Object)refreshToken);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u817e\u8baf\u6587\u6863\u8ba4\u8bc1\u6210\u529f\uff0c\u8bf7\u4fdd\u5b58\u3002", (String)"TxDocDatabaseLinkFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private static String getOauthWindowTitle() {
        return ResManager.loadKDString((String)"\u626b\u7801\u8ba4\u8bc1\u6388\u6743", (String)"TxDocDatabaseLinkFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }
}

