/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.dc.meta.MetadataSchemaFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.MetaDataSchemaType;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class MetaPropertyTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String REMARK = "remark";
    private static final String DATA_TYPE = "data_type";
    private static final String PROP_LABEL = "prop_label";
    private static final String DATA_SCHEMA = "data_schema";
    private static final String PROP_NAME = "prop_name";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String DATA_TABLE_ID = "data_table_id";
    private static final String NAME_SUFFIX = "@TABLE";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String RELATION_MAPPING = "relation_mapping";
    private static final String PARAM_ROW = "$row";
    private static final String PARAM_TYPE = "$type";
    private static final String NUMBER = "number";
    private static final String FULL_NUMBER = "full_number";
    private static final String KEY_TREE = "treeviewap";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_BTN_OK = "btn_ok";
    private static final String KEY_BTN_CANCEL = "btn_cancel";
    private static final String KEY_BTN_SYNC = "btn_sync";
    private static final Set<String> META_TYPES = new HashSet<String>(Arrays.asList("TABLE", "VIEW", "ENTITY", "STRUCT", "meta"));
    private static final Set<String> NODE_TYPES = new HashSet<String>(Arrays.asList("ENTRIES", "STRUCT", "REF", "SubHeadEntity", "ml_string", "ml_string_k3c", "meta", "list<meta>"));
    private static final String ROOT = "rootId";
    private static final String DATA_SOURCE = "data_source";
    private static final String OPERATION = "operation";
    private final Map<String, Object> aliasCache = new HashMap<String, Object>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL, KEY_BTN_SYNC, KEY_ENTRY_ENTITY});
        EntryGrid entry = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.getView().updateView(KEY_ENTRY_ENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        String text = searchEnterEvent.getText();
        if (entryEntity.size() == 0 || StringUtil.isEmpty((String)text)) {
            return;
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject o = (DynamicObject)entryEntity.get(i);
            if (!o.getString(FULL_NUMBER).contains(text) && !o.getString("name").contains(text)) continue;
            indexs.add(i);
        }
        if (indexs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e!", (String)"MetaPropertyTreePlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] rows = indexs.stream().mapToInt(Integer::valueOf).toArray();
        grid.setRowBackcolor("#eff3fd", rows);
        grid.focusCell(rows[0], NUMBER);
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params == null || !params.containsKey("id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u5143\u6570\u636eid\uff0c\u65e0\u6cd5\u83b7\u53d6\u5143\u6570\u636e\u5c5e\u6027!", (String)"MetaPropertyTreePlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        String type = D.s(params.get(PARAM_TYPE));
        if (type != null) {
            this.getPageCache().put(PARAM_ROW, D.s(params.get(PARAM_ROW)));
            this.getPageCache().put(PARAM_TYPE, type);
            this.getPageCache().put(RELATION_MAPPING, Json.toString(params.get(RELATION_MAPPING)));
        }
        String id = D.s(params.get("id"));
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
        this.getPageCache().put(ROOT, params.get("id").toString());
        this.getPageCache().put(DATA_SOURCE, meta.getString("group_id"));
        String operation = D.s(params.get(OPERATION));
        if (operation != null) {
            this.getPageCache().put(OPERATION, operation);
        }
        this.initTree(id, meta.getString("name"));
    }

    private void initTree(String id, String text) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        TreeNode root = new TreeNode("", id + "@REF", text);
        root.setExpend(true);
        root.setType("REF");
        root.setChildren(new ArrayList());
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand(id + "@REF");
        treeView.focusNode(root);
        this.initRootEntry();
    }

    private void initRootEntry() {
        String rootId = this.getPageCache().get(ROOT);
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)rootId, (String)ISC_METADATA_SCHEMA);
        this.showCollection(rootId + "@REF", "", meta);
    }

    private void initTableEntry(String nodeId) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)ISC_METADATA_SCHEMA);
        this.showCollection(nodeId + NAME_SUFFIX, meta.getString("name"), meta);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        String rootId = this.getPageCache().get(ROOT);
        try {
            if (StringUtils.equals((CharSequence)"syncmetaschema", (CharSequence)callBackId) && event.getResult() == MessageBoxResult.Yes) {
                DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)rootId, (String)ISC_METADATA_SCHEMA);
                if (this.isSyncEnabled(meta)) {
                    MetaSchemaUtil.syncMetaSchema((Object)rootId);
                    this.initTree(rootId, meta.getString("name"));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5143\u6570\u636e\u6210\u529f!", (String)"MetaPropertyTreePlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                } else {
                    StringBuilder sb = new StringBuilder();
                    String type = MetaDataSchemaType.valueOf((String)meta.getString("type")).getDesc();
                    String number = meta.getString(NUMBER);
                    sb.append(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u4e0d\u652f\u6301\u540c\u6b65\uff0c\u7c7b\u578b\uff1a[%1$s], \u7f16\u7801\uff1a[%2$s];\n", (String)"MetaPropertyTreePlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type, number));
                    this.getView().showTipNotification(sb.toString(), Integer.valueOf(3000));
                }
            }
        }
        catch (Exception e) {
            this.getView().showMessage(ShowStackTraceUtil.getErrorMsg((Throwable)e));
        }
    }

    /*
     * Loose catch block
     */
    private boolean isSyncEnabled(DynamicObject metaObj) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)metaObj.get("group_id"), (String)"isc_data_source");
        ConnectionManager.checkConnection((DynamicObject)dataSource);
        ConnectionManager.pushResLicense((boolean)true);
        try {
            try (ConnectionWrapper connectionWrapper = ConnectionManager.getConnection((long)D.l((Object)dataSource.get("dblink_id")));){
                ConnectionFactory factory = connectionWrapper.getFactory();
                boolean bl = factory.hasMetaData(D.s((Object)metaObj.get("full_name")), D.s((Object)metaObj.get("type")), connectionWrapper);
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_ok": {
                EntryGrid entry = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
                int[] rows = entry.getSelectRows();
                String operation = this.getPageCache().get(OPERATION);
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c!", (String)"MetaPropertyTreePlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    break;
                }
                if ("batch_add".equals(operation)) {
                    this.getView().returnDataToParent(this.getBatchSelectedRowData(rows));
                    this.getView().close();
                    break;
                }
                this.getView().returnDataToParent(this.getSelectedRowData(rows[0]));
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            case "btn_sync": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("syncmetaschema", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u8986\u76d6\u9009\u5b9a\u7684\u5143\u6570\u636e\u4fe1\u606f\uff0c\u5e76\u540c\u6b65\u65b0\u589e\uff08\u4f46\u4e0d\u8986\u76d6\uff09\u6240\u5f15\u7528\u7684\u6570\u636e\u6a21\u578b\uff0c\u53ef\u80fd\u5f71\u54cd\u5230\u6b63\u5728\u8fd0\u884c\u7684\u65b9\u6848\uff0c\u6b63\u5f0f\u73af\u5883\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\u540c\u6b65\uff1f", (String)"MetaPropertyTreePlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
                break;
            }
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_ENTRY_ENTITY, row);
        Map map = DynamicObjectUtil.object2Map((DynamicObject)rowEntity);
        map.put(PARAM_ROW, this.getPageCache().get(PARAM_ROW));
        map.put(PARAM_TYPE, this.getPageCache().get(PARAM_TYPE));
        return map;
    }

    private List<Map<String, Object>> getBatchSelectedRowData(int[] row) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(row.length);
        for (int r : row) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_ENTRY_ENTITY, r);
            Map map = DynamicObjectUtil.object2Map((DynamicObject)rowEntity);
            map.put(PARAM_ROW, this.getPageCache().get(PARAM_ROW));
            map.put(PARAM_TYPE, this.getPageCache().get(PARAM_TYPE));
            list.add(map);
        }
        return list;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        try {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
            String pNodeId = evt.getNodeId().toString();
            DynamicObject meta = pNodeId.contains(NAME_SUFFIX) ? BusinessDataServiceHelper.loadSingle((Object)pNodeId.replace(NAME_SUFFIX, ""), (String)ISC_METADATA_SCHEMA) : BusinessDataServiceHelper.loadSingle((Object)this.getPageCache().get(ROOT), (String)ISC_METADATA_SCHEMA);
            int index = pNodeId.indexOf(46);
            if (index > 0) {
                String number = pNodeId.substring(index + 1).replace("@REF", "");
                StringBuilder sb = new StringBuilder();
                DynamicObject childMeta = this.getChildMeta(meta, number, sb.append(meta.getString("name")));
                this.addTreeNodes(treeView, pNodeId, childMeta);
            } else {
                this.addTreeNodes(treeView, pNodeId, meta);
            }
            this.addEntryNode(treeView);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private boolean notExpandMultiLangNode() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        return D.x(params.get("notExpandMultiLangNode"));
    }

    public void addEntryNode(TreeView view) {
        String relationMapping = this.getPageCache().get(RELATION_MAPPING);
        if (StringUtil.isEmpty((String)relationMapping)) {
            return;
        }
        Object mappings = Json.toObject((String)relationMapping);
        if (mappings instanceof List) {
            List relationMappings = (List)mappings;
            for (Map map : relationMappings) {
                String masterTableId = D.s(map.get("master_table_id"));
                if (!masterTableId.equals(this.getPageCache().get(ROOT))) continue;
                String text = D.s(map.get("relation_alias"));
                String remark = D.s(map.get("relation_remark"));
                if (StringUtil.isEmpty((String)text)) {
                    DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)D.s(map.get(DATA_TABLE_ID)), (String)ISC_METADATA_SCHEMA, (String)"id, table_name");
                    text = meta.getString("table_name");
                }
                TreeNode node = new TreeNode(this.getPageCache().get(ROOT) + "@REF", D.s(map.get(DATA_TABLE_ID)) + NAME_SUFFIX, remark == null ? text : remark);
                node.addChildren(new ArrayList());
                view.addNode(node);
            }
        }
    }

    public DynamicObject getChildMeta(DynamicObject parent, String number, StringBuilder title) {
        int index;
        String propName;
        int lastSpotIndex;
        if (number.contains("ml_string") && (lastSpotIndex = (propName = number.substring(0, index = number.indexOf("@ml_string"))).lastIndexOf(46)) < 0) {
            this.buildTitleByPropEntryEntity(parent, title, propName);
            return this.getMlStringMeta(number);
        }
        index = number.indexOf(46);
        if (index < 0) {
            boolean isMeta = number.endsWith("@meta");
            if (isMeta) {
                number = number.replace("@meta", "");
            }
            return this.getMetaPropertyEntry(parent, number, title, isMeta);
        }
        String childNumber = number.substring(0, index);
        boolean isMeta = childNumber.contains("@meta");
        if (isMeta) {
            childNumber = childNumber.replace("@meta", "");
        }
        DynamicObjectCollection properties = parent.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject property : properties) {
            if (!property.getString(PROP_NAME).equals(childNumber)) continue;
            String dataSchema = property.getString(DATA_SCHEMA);
            DynamicObject childMeta = this.getMetaBySchema(dataSchema, isMeta, parent.getLong("group_id"));
            if (title.length() > 0) {
                title.append('.');
            }
            title.append(property.getString(PROP_LABEL));
            return this.getChildMeta(childMeta, number.substring(index + 1), title);
        }
        return null;
    }

    private void buildTitleByPropEntryEntity(DynamicObject parent, StringBuilder title, String propName) {
        DynamicObjectCollection collection = parent.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject c : collection) {
            if (!propName.equals(c.getString(PROP_NAME))) continue;
            if (title.length() > 0) {
                title.append('.');
            }
            title.append(c.getString(PROP_LABEL));
            break;
        }
    }

    private DynamicObject getMetaPropertyEntry(DynamicObject parent, String number, StringBuilder title, boolean isMeta) {
        DynamicObjectCollection properties = parent.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject property : properties) {
            String propName = property.getString(PROP_NAME);
            if (!propName.equals(number)) continue;
            String schema = property.getString(DATA_SCHEMA);
            String type = property.getString(DATA_TYPE);
            if (NODE_TYPES.contains(type)) {
                if ("ml_string".equals(type) && this.notExpandMultiLangNode()) {
                    return property;
                }
                DynamicObject meta = this.getMetaBySchema(schema, isMeta, parent.getLong("group_id"));
                meta.set(REMARK, (Object)type);
                String label = property.getString(PROP_LABEL);
                if (title.length() > 0) {
                    title.append('.');
                }
                title.append(StringUtil.isEmpty((String)label) ? propName : label);
                return meta;
            }
            return property;
        }
        return null;
    }

    public DynamicObject getMetaBySchema(String dataSchema, boolean isMeta, long dataSourceId) {
        if (isMeta) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)D.l((Object)dataSchema), (String)ISC_METADATA_SCHEMA);
            return obj;
        }
        QFilter filter = new QFilter(NUMBER, "=", (Object)dataSchema).and("group", "=", (Object)dataSourceId);
        DynamicObject meta = BusinessDataServiceHelper.loadSingleFromCache((String)ISC_METADATA_SCHEMA, (QFilter[])new QFilter[]{filter});
        if (meta != null) {
            return meta;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff08%s\uff09\u7684\u96c6\u6210\u5bf9\u8c61\u672a\u627e\u5230\uff0c\u8bf7\u540c\u6b65\u5168\u90e8\u5143\u6570\u636e\u6216\u4eba\u5de5\u6dfb\u52a0\u8be5\u96c6\u6210\u5bf9\u8c61\uff01", (String)"MetaPropertyTreePlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataSchema));
    }

    private boolean isRoot(String id) {
        return id.equals(this.getPageCache().get(ROOT) + "@REF");
    }

    private boolean isRelatedTable(String id) {
        return id.contains(NAME_SUFFIX);
    }

    private void addTreeNodes(TreeView treeView, String pNodeId, DynamicObject childMeta) {
        String type = childMeta.getString("type");
        if (this.isRoot(pNodeId) || childMeta.getString(REMARK).equals("ENTRIES") || META_TYPES.contains(type) || pNodeId.contains("@ml_string") || pNodeId.contains("@meta")) {
            treeView.addNodes(this.getMetaNodes(pNodeId, childMeta));
        }
    }

    private DynamicObject getMlStringMeta(String number) {
        long id = MetaSchemaUtil.getHashId((MetaType)MetaType.ENUM, (long)0L, (String)"ml_string");
        boolean exist = QueryServiceHelper.exists((String)ISC_METADATA_SCHEMA, (Object)id);
        if (!exist) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)ISC_METADATA_SCHEMA);
            object.set("id", (Object)id);
            DynamicObjectCollection properties = object.getDynamicObjectCollection(PROP_ENTRYENTITY);
            DynamicObject p1 = properties.addNew();
            p1.set(PROP_NAME, (Object)"zh_CN");
            p1.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"MetaPropertyTreePlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            p1.set(DATA_TYPE, (Object)"string");
            DynamicObject p2 = properties.addNew();
            p2.set(PROP_NAME, (Object)"zh_TW");
            p2.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"MetaPropertyTreePlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            p2.set(DATA_TYPE, (Object)"string");
            DynamicObject p3 = properties.addNew();
            p3.set(PROP_NAME, (Object)"en_US");
            p3.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u82f1\u6587", (String)"MetaPropertyTreePlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            p3.set(DATA_TYPE, (Object)"string");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            return object;
        }
        if (number.contains("@ml_string.")) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
            DynamicObjectCollection properties = object.getDynamicObjectCollection(PROP_ENTRYENTITY);
            properties.clear();
            DynamicObject p = properties.addNew();
            if (number.contains("zh_TW")) {
                p.set(PROP_NAME, (Object)"zh_TW");
                p.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"MetaPropertyTreePlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                p.set(DATA_TYPE, (Object)"string");
            } else if (number.contains("zh_CN")) {
                p.set(PROP_NAME, (Object)"zh_CN");
                p.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"MetaPropertyTreePlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                p.set(DATA_TYPE, (Object)"string");
            } else if (number.contains("en_US")) {
                p.set(PROP_NAME, (Object)"en_US");
                p.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u82f1\u6587", (String)"MetaPropertyTreePlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                p.set(DATA_TYPE, (Object)"string");
            }
            return object;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
    }

    private List<TreeNode> getMetaNodes(String pNodeId, DynamicObject schema) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection properties = schema.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject o : properties) {
            String text;
            TreeNode childNode = new TreeNode();
            String type = o.getString(DATA_TYPE);
            String name = o.getString(PROP_NAME);
            if (NODE_TYPES.contains(type)) {
                if (type.startsWith("ml_string")) {
                    if (!this.notExpandMultiLangNode()) {
                        childNode.setId(pNodeId.replace("@REF", "") + "." + name + "@ml_string");
                        childNode.setChildren(new ArrayList());
                    } else {
                        childNode.setId(pNodeId.replace("@REF", "") + "." + name);
                    }
                } else if (type.contains("meta")) {
                    String metaId = pNodeId.replace("@REF", "");
                    childNode.setId(metaId + "." + name + "@meta");
                    this.getPageCache().put(name, o.getString(DATA_SCHEMA));
                    childNode.setChildren(new ArrayList());
                } else {
                    childNode.setId(pNodeId.replace("@REF", "") + "." + name + "@REF");
                    childNode.setChildren(new ArrayList());
                }
            } else {
                childNode.setId(pNodeId.replace("@REF", "") + "." + name);
            }
            childNode.setType(type);
            childNode.setParentid(pNodeId);
            String label = o.getString(PROP_LABEL);
            String string = text = StringUtil.isEmpty((String)label) ? name : label;
            if (!StringUtil.isEmpty((String)type) && ("ENTRIES".equals(type) || type.contains("list"))) {
                text = text + " [ ]";
            }
            childNode.setText(text);
            childNodes.add(childNode);
        }
        return childNodes;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        try {
            String nodeId = evt.getNodeId().toString();
            String parentNode = evt.getParentNodeId().toString();
            if (this.isRoot(nodeId)) {
                this.initRootEntry();
            } else if (!nodeId.contains(".") && this.isRoot(parentNode)) {
                this.initTableEntry(nodeId.replace(NAME_SUFFIX, ""));
            } else {
                StringBuilder sb;
                String number = nodeId.substring(nodeId.indexOf(46) + 1).replace("@REF", "");
                String metaId = nodeId.substring(0, nodeId.indexOf(46)).replace("@REF", "").replace("@meta", "").replace(NAME_SUFFIX, "");
                DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)ISC_METADATA_SCHEMA);
                DynamicObject childMeta = this.getChildMeta(parent, number, sb = new StringBuilder());
                if (childMeta == null) {
                    return;
                }
                String entryType = childMeta.getDynamicObjectType().getName();
                if (entryType.equals(PROP_ENTRYENTITY)) {
                    this.showOne(parentNode, sb.toString(), childMeta);
                } else {
                    this.showCollection(nodeId, sb.toString(), childMeta);
                }
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void showOne(String parentNode, String parentName, DynamicObject meta) {
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        DynamicObject row = entry.addNew();
        if (meta.getDynamicObjectType().getName().equals(PROP_ENTRYENTITY)) {
            this.copyProperty2Entry(parentNode, parentName, meta, row);
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void showCollection(String currentNode, String currentName, DynamicObject meta) {
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject p : properties) {
            DynamicObject row = entry.addNew();
            this.copyProperty2Entry(currentNode, currentName, p, row);
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void copyProperty2Entry(String parentNode, String parentName, DynamicObject p, DynamicObject row) {
        row.set(NUMBER, (Object)p.getString(PROP_NAME));
        row.set("name", (Object)p.getString(PROP_LABEL));
        row.set(DATA_TYPE, (Object)p.getString(DATA_TYPE));
        row.set(DATA_SCHEMA, (Object)p.getString(DATA_SCHEMA));
        row.set("is_primary_key", p.get("is_primary_key"));
        row.set("required", p.get("required"));
        row.set(REMARK, p.get("prop_remark"));
        row.set("full_name", (Object)((StringUtil.isEmpty((String)parentName) ? "" : parentName + ".") + p.getString(PROP_LABEL)));
        String rootId = this.getPageCache().get(ROOT);
        if (this.isRoot(parentNode)) {
            row.set(FULL_NUMBER, (Object)p.getString(PROP_NAME));
        } else if (this.isRelatedTable(parentNode)) {
            String tableAlias = this.getTableAlias(parentNode);
            String full_number = (tableAlias == null ? parentName : tableAlias) + "." + p.getString(PROP_NAME);
            row.set(FULL_NUMBER, (Object)full_number);
            row.set("full_name", (Object)p.getString(PROP_LABEL));
        } else if (parentNode.contains("@REF")) {
            row.set(FULL_NUMBER, (Object)(parentNode.replace(rootId + ".", "").replace("@REF", "").replace("@meta", "") + "." + p.getString(PROP_NAME)));
        } else if (parentNode.contains("@ml_string")) {
            if (parentNode.endsWith("@ml_string")) {
                row.set(FULL_NUMBER, (Object)(parentNode.replace(rootId + ".", "").replace("@ml_string", "") + "." + p.getString(PROP_NAME)));
            } else {
                row.set(FULL_NUMBER, (Object)parentNode.replace(rootId + ".", "").replace("@ml_string", ""));
            }
        } else if (parentNode.contains("@meta")) {
            int index = parentNode.indexOf(46);
            row.set(FULL_NUMBER, (Object)(parentNode.substring(index + 1).replace("@meta", "") + "." + p.getString(PROP_NAME)));
        }
    }

    private String getTableAlias(String parentNode) {
        Object o = this.aliasCache.get(parentNode);
        if (o != null) {
            return D.s((Object)o);
        }
        String relationMapping = this.getPageCache().get(RELATION_MAPPING);
        if (StringUtil.isEmpty((String)relationMapping)) {
            return null;
        }
        String parentNodeId = parentNode.replace(NAME_SUFFIX, "");
        Object mappings = Json.toObject((String)relationMapping);
        if (mappings instanceof List) {
            List list = (List)mappings;
            for (Map map : list) {
                if (!D.s(map.get(DATA_TABLE_ID)).equals(parentNodeId)) continue;
                String alias = D.s(map.get("relation_alias"));
                this.aliasCache.put(parentNode, alias);
                return alias;
            }
        }
        return null;
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        String operation = this.getPageCache().get(OPERATION);
        if ("batch_add".equals(operation)) {
            this.getView().returnDataToParent(this.getBatchSelectedRowData(new int[]{evt.getRow()}));
            this.getView().close();
        } else {
            Map<String, Object> data = this.getSelectedRowData(evt.getRow());
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (DATA_SCHEMA.equals(evt.getFieldName()) && evt.getRowIndex() >= 0) {
            Object dataSourceId;
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
            DynamicObject entry = (DynamicObject)collection.get(evt.getRowIndex());
            String dataSchema = entry.getString(DATA_SCHEMA);
            String dataType = entry.getString(DATA_TYPE);
            String fullNumber = entry.getString(FULL_NUMBER);
            int index = fullNumber.indexOf(46);
            String parentNumber = index > 0 ? fullNumber.substring(0, index) : fullNumber;
            long metaId = D.l((Object)this.getPageCache().get(parentNumber));
            if (metaId > 0L) {
                DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)ISC_METADATA_SCHEMA);
                dataSourceId = parent.getLong("group_id");
            } else {
                dataSourceId = this.getPageCache().get(DATA_SOURCE);
            }
            MetadataSchemaFormPlugin.openRefMeta(this, dataSourceId, dataSchema, dataType);
        }
    }
}

