/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.trigger;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.dc.file.CommonPluginUtil;
import kd.isc.iscb.formplugin.dc.trigger.DataCopyTriggerListPlugin;
import kd.isc.iscb.formplugin.dc.trigger.TriggerPluginUtil;
import kd.isc.iscb.formplugin.hub.HubTriggerEventChecker;
import kd.isc.iscb.formplugin.util.ArtificialF7Util;
import kd.isc.iscb.formplugin.util.CustomFunctionUtil;
import kd.isc.iscb.formplugin.util.EntryFilterUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.SetFilterUtil;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ischub.triggerInfo.TriggerUtil;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.TimerJobUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;

public class DataCopyTriggerFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String TRIGGER_TYPE = "trigger_type";
    private static final String ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String SOURCE_SCHEMA_ID = "source_schema_id";
    private static final String ISC_DATA_COPY_TRIGGER = "isc_data_copy_trigger";
    private static final String NEXT_TASKS = "next_tasks";
    private static final String NUMBER = "number";
    private static final String TIMESTAMP_FIELD = "timestamp_field";
    private static final String DATA_COPY = "data_copy";
    private static final String PARAMS_VALUE = "params_value";
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final String DATA_COPY_PARAM_ENTRIES = "param_entries";
    private static final String FILTER_ENTRIES = "filter_entries";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FILTER_LABEL = "filter_label";
    private static final String DATA_COPY_ID = "data_copy_id";
    private static final String ISC_DATA_COPY = "isc_data_copy";
    private static final String IS_CUSTOM = "iscustom";
    private static final String PARAMS_NAME = "params_name";
    private static final String PARAMS_LABEL = "params_label";
    private static final String PARAMS_DATA_TYPE = "params_data_type";
    private static final String PARAMS_REMARK = "params_remark";
    private static final String GET_TIMESTAMP = "get_timestamp";
    private static final String INTERVAL = "interval";
    private static final String EXE_JOB_USER = "exe_job_user";
    private static final String BOS_USER = "bos_user";
    private static final String USER_SELECT = "user_select";
    private static final String SCHEDULE = "schedule";
    private static final String CONTAINS_DYNAMIC_FILTER = "contains_dynamic_filter";

    public void afterBindData(EventObject e) {
        Object dcId;
        super.afterBindData(e);
        this.loadEvents();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (billShowParameter.getBillStatus().equals((Object)BillOperationStatus.EDIT) && (dcId = this.getModel().getValue(DATA_COPY_ID)) != null && D.i((Object)dcId) != 0) {
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)dcId, (String)ISC_DATA_COPY);
            DynamicObjectCollection schemaEntries = schema.getDynamicObjectCollection(DATA_COPY_PARAM_ENTRIES);
            DynamicObjectCollection paramEntries = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
            Map<String, Object> lastValue = this.getLastValue(schemaEntries, paramEntries);
            ArrayList<Map<String, Object>> paramsData = new ArrayList<Map<String, Object>>();
            for (DynamicObject paramEntry : paramEntries) {
                if (!Boolean.TRUE.equals(paramEntry.get(IS_CUSTOM)) || this.isExists(schemaEntries, paramEntry)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put(PARAMS_NAME, paramEntry.getString(PARAMS_NAME));
                map.put(PARAMS_LABEL, paramEntry.getString(PARAMS_LABEL));
                map.put(PARAMS_DATA_TYPE, paramEntry.getString(PARAMS_DATA_TYPE));
                map.put(PARAMS_REMARK, paramEntry.getString(PARAMS_REMARK));
                map.put(PARAMS_VALUE, paramEntry.getString(PARAMS_VALUE));
                map.put(IS_CUSTOM, Boolean.TRUE);
                paramsData.add(map);
            }
            this.resetParams(paramsData, paramEntries, schemaEntries, lastValue);
        }
        this.initFilterColumn(this.getModel().getEntryEntity(PARAMS_ENTRYENTITY));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object dataCopyId = params.get(DATA_COPY_ID);
        if (dataCopyId != null) {
            this.getModel().setValue(DATA_COPY, dataCopyId);
        }
        this.showParamsEntryentity();
    }

    private void showParamsEntryentity() {
        DynamicObjectCollection params_entryentity = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
        boolean hasParamsEntries = params_entryentity.size() > 0;
        this.getModel().setValue(CONTAINS_DYNAMIC_FILTER, (Object)hasParamsEntries);
    }

    private void initCron() {
        if (this.getModel().getValue(TRIGGER_TYPE).toString().equals("auto")) {
            String interval = D.s((Object)this.getModel().getValue(INTERVAL));
            String schedule = D.s((Object)this.getModel().getValue(SCHEDULE));
            if (interval != null && schedule == null) {
                this.resetCronVal(interval);
            }
        }
    }

    private boolean isExists(DynamicObjectCollection schemaEntries, DynamicObject paramEntry) {
        boolean isExist = false;
        for (DynamicObject schemaEntry : schemaEntries) {
            if (!paramEntry.get(PARAMS_NAME).equals(schemaEntry.get(PARAMS_NAME))) continue;
            isExist = true;
        }
        return isExist;
    }

    private Map<String, Object> getLastValue(DynamicObjectCollection schemaEntries, DynamicObjectCollection paramEntries) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DynamicObject paramEntry : paramEntries) {
            for (DynamicObject schemaEntry : schemaEntries) {
                if (!paramEntry.get(PARAMS_NAME).equals(schemaEntry.get(PARAMS_NAME))) continue;
                map.put(D.s((Object)paramEntry.get(PARAMS_NAME)), paramEntry.getString(PARAMS_VALUE));
            }
        }
        return map;
    }

    private void resetParams(List<Map<String, Object>> paramsData, DynamicObjectCollection paramEntries, DynamicObjectCollection schemaEntries, Map<String, Object> lastValue) {
        this.getModel().getDataEntity(true);
        paramEntries.clear();
        for (DynamicObject schemaParam : schemaEntries) {
            DynamicObject rowObj = paramEntries.addNew();
            rowObj.set(PARAMS_NAME, (Object)schemaParam.getString(PARAMS_NAME));
            rowObj.set(PARAMS_LABEL, (Object)schemaParam.getString(PARAMS_LABEL));
            rowObj.set(PARAMS_DATA_TYPE, (Object)schemaParam.getString(PARAMS_DATA_TYPE));
            rowObj.set(PARAMS_REMARK, (Object)schemaParam.getString(PARAMS_REMARK));
            Object value = lastValue.get(schemaParam.getString(PARAMS_NAME));
            rowObj.set(PARAMS_VALUE, value == null ? "" : value);
            rowObj.set(IS_CUSTOM, (Object)Boolean.FALSE);
        }
        if (!paramsData.isEmpty()) {
            for (Map<String, Object> paramData : paramsData) {
                DynamicObject item = paramEntries.addNew();
                item.set(PARAMS_NAME, paramData.get(PARAMS_NAME));
                item.set(PARAMS_LABEL, paramData.get(PARAMS_LABEL));
                item.set(PARAMS_DATA_TYPE, paramData.get(PARAMS_DATA_TYPE));
                item.set(PARAMS_REMARK, paramData.get(PARAMS_REMARK));
                item.set(PARAMS_VALUE, paramData.get(PARAMS_VALUE));
                item.set(IS_CUSTOM, paramData.get(IS_CUSTOM));
            }
        }
        this.getView().updateView(PARAMS_ENTRYENTITY);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl(FILTER_ENTRIES);
        filterEntries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{TIMESTAMP_FIELD, EXE_JOB_USER, SCHEDULE});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(DATA_COPY)) {
            this.generateDefaultTrigger();
            this.loadParams();
            this.showParamsEntryentity();
            this.loadEvents();
            this.setDefaultTriggerType();
        } else if (name.equals(TRIGGER_TYPE)) {
            this.loadEvents();
            this.initCron();
        } else if (name.equals(PARAMS_NAME)) {
            this.initFilterColumn(this.getModel().getEntryEntity(PARAMS_ENTRYENTITY));
        } else if (name.equals("next_task")) {
            Object newNumber = this.getModel().getValue(NUMBER);
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                Object number = ((DynamicObject)newValue).get(NUMBER);
                if (String.valueOf(newNumber).equals(String.valueOf(number))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u8ddf\u5f53\u524d\u65b9\u6848\u76f8\u540c\u7684\u540e\u7f6e\u65b9\u6848\uff01", (String)"DataCopyTriggerFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(NEXT_TASKS);
                    int rowIndex = e.getChangeSet()[0].getRowIndex();
                    collection.remove(rowIndex);
                    this.getView().updateView(NEXT_TASKS);
                }
            }
        } else if (INTERVAL.equals(name)) {
            String interval = D.s((Object)e.getChangeSet()[0].getNewValue());
            this.resetCronVal(interval);
        } else if (TIMESTAMP_FIELD.equals(name)) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().updateView(TIMESTAMP_FIELD);
        } else if (CONTAINS_DYNAMIC_FILTER.equals(name)) {
            this.checkParamsEntries();
        }
    }

    private void checkParamsEntries() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
        if (!D.x((Object)this.getModel().getValue(CONTAINS_DYNAMIC_FILTER))) {
            for (DynamicObject o : entryEntity) {
                if (!Boolean.FALSE.equals(o.get(IS_CUSTOM))) continue;
                this.getModel().setValue(CONTAINS_DYNAMIC_FILTER, (Object)Boolean.TRUE);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ece\u96c6\u6210\u65b9\u6848\u7ee7\u627f\u4e86\u8fc7\u6ee4\u6761\u4ef6\u53c2\u6570\u9879\uff0c\u4e0d\u80fd\u5173\u95ed", (String)"DataCopyTriggerFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void setDefaultTriggerType() {
        DynamicObject srcSchema = this.getSrcSchema();
        if (srcSchema != null && TriggerUtil.isEventSrcType((DynamicObject)srcSchema)) {
            if (!"event".equals(D.s((Object)this.getModel().getValue(TRIGGER_TYPE)))) {
                this.getModel().setValue(TRIGGER_TYPE, (Object)"event");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u542f\u52a8\u7c7b\u578b\u4ec5\u652f\u6301\u4e8b\u4ef6\u89e6\u53d1", (String)"DataCopyTriggerFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{TRIGGER_TYPE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{TRIGGER_TYPE});
        }
    }

    private DynamicObject getSrcSchema() {
        long schemaId = D.l((Object)this.getModel().getValue(DATA_COPY_ID));
        if (schemaId > 0L) {
            DynamicObject schema = DataCopySchema.get((long)schemaId);
            return MetaDataSchema.get((long)schema.getLong(SOURCE_SCHEMA_ID));
        }
        return null;
    }

    private void resetCronVal(String interval) {
        if (interval == null) {
            this.getModel().setValue(SCHEDULE, null);
        } else if (!"0".equals(interval)) {
            TimeSpan timeSpan = this.getTimeSpan();
            this.getModel().setValue(SCHEDULE, (Object)DataCopyTaskUtil.buildCron((String)interval, (TimeSpan)timeSpan));
        }
    }

    private TimeSpan getTimeSpan() {
        Date start = (Date)this.getModel().getValue("validated_time");
        if (start == null) {
            start = new Timestamp(System.currentTimeMillis() - 86400000L);
        }
        return DataCopyTaskUtil.getTimeSpan((long)start.getTime());
    }

    private void generateDefaultTrigger() {
        Object schemaId = this.getModel().getValue(DATA_COPY_ID);
        if (schemaId != null && Long.parseLong(schemaId.toString()) != 0L) {
            int count;
            DynamicObject schema = BusinessDataServiceHelper.loadSingleFromCache((Object)schemaId, (String)ISC_DATA_COPY);
            String name = schema.getString("name");
            String number = schema.getString(NUMBER);
            String categoryName = schema.getString("schema_category.name");
            DynamicObject[] triggers = BusinessDataServiceHelper.load((String)ISC_DATA_COPY_TRIGGER, (String)"id", (QFilter[])new QFilter[]{new QFilter(DATA_COPY, "=", schemaId)});
            int n = count = triggers != null ? triggers.length : 0;
            if (count > 0) {
                name = name + "_" + (count + 1);
                number = number + "_" + (count + 1);
            }
            this.getModel().setValue("name", (Object)name);
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().setValue("schema_category", (Object)categoryName);
        }
    }

    private void loadEvents() {
        long dataCopy;
        if (this.getModel().getValue(TRIGGER_TYPE).toString().equals("event") && (dataCopy = ((Long)this.getModel().getValue(DATA_COPY_ID)).longValue()) != 0L) {
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)dataCopy, (String)ISC_DATA_COPY);
            long tarId = trigger.getLong(SOURCE_SCHEMA_ID);
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)tarId, (String)"isc_metadata_schema");
            DynamicObjectCollection events = meta.getDynamicObjectCollection("event_entryentity");
            this.addEventComboItems(events);
        }
    }

    private void addEventComboItems(DynamicObjectCollection events) {
        if (CollectionUtils.isEmpty((Collection)events)) {
            return;
        }
        ComboEdit combo = (ComboEdit)this.getView().getControl("events");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(events.size());
        for (DynamicObject e : events) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(e.getString("event_label") + '(' + e.getString("event_number") + ')'));
            item.setValue(e.getString("event_number"));
            items.add(item);
        }
        combo.setComboItems(items);
    }

    private void loadParams() {
        Object schemaId = this.getModel().getValue(DATA_COPY_ID);
        if (schemaId != null && Long.parseLong(schemaId.toString()) != 0L) {
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)ISC_DATA_COPY);
            this.initParams(schema);
            this.getView().updateView(PARAMS_ENTRYENTITY);
        }
    }

    private void initParams(DynamicObject schema) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection schemaParams = (DynamicObjectCollection)schema.get(DATA_COPY_PARAM_ENTRIES);
        DynamicObjectCollection paramEntries = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
        Set<String> paramCols = this.arrayToSet(paramEntries);
        for (DynamicObject schemaParam : schemaParams) {
            if (paramCols.contains(schemaParam.getString(PARAMS_NAME))) continue;
            DynamicObject rowObj = paramEntries.addNew();
            rowObj.set(PARAMS_NAME, (Object)schemaParam.getString(PARAMS_NAME));
            rowObj.set(PARAMS_LABEL, (Object)schemaParam.getString(PARAMS_LABEL));
            rowObj.set(PARAMS_DATA_TYPE, (Object)schemaParam.getString(PARAMS_DATA_TYPE));
            rowObj.set(PARAMS_REMARK, (Object)schemaParam.getString(PARAMS_REMARK));
            rowObj.set(IS_CUSTOM, (Object)Boolean.FALSE);
        }
        Set<String> schemaCols = this.arrayToSet(schemaParams);
        for (DynamicObject paramEntry : paramEntries) {
            if (paramEntry.getBoolean(IS_CUSTOM) || schemaCols.contains(paramEntry.getString(PARAMS_NAME))) continue;
            paramEntry.set(IS_CUSTOM, (Object)Boolean.TRUE);
        }
        this.initFilterColumn(paramEntries);
    }

    private Set<String> arrayToSet(DynamicObjectCollection collection) {
        HashSet<String> paramCols = new HashSet<String>();
        for (DynamicObject dynamicObject : collection) {
            paramCols.add(dynamicObject.getString(PARAMS_NAME));
        }
        return paramCols;
    }

    private void initFilterColumn(DynamicObjectCollection paramEntries) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        Iterator iterator = paramEntries.iterator();
        while (iterator.hasNext()) {
            String params_name = ((DynamicObject)iterator.next()).getString(PARAMS_NAME);
            if (null == params_name || StringUtil.isEmpty((String)params_name)) continue;
            items.add(new ComboItem(new LocaleString(params_name), params_name));
        }
        ((ComboEdit)this.getView().getControl("filter_value_var")).setComboItems(items);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        DynamicObjectCollection params_entryentity;
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (operationKey.equals("refreshparams")) {
            this.loadParams();
            this.showParamsEntryentity();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f!", (String)"DataCopyTriggerFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("show_logs".equals(operationKey)) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_data_copy_exec_log", "data_copy_trigger", evt);
        } else if ("show_executions".equals(operationKey)) {
            FormOpener.showList((AbstractFormPlugin)this, ISC_DATA_COPY_EXECUTION, "data_copy_trigger", evt);
        } else if (operationKey.equals("relation_query")) {
            TriggerPluginUtil.showUpstreamTrigger(this, FormOpener.getSelectedId(this, evt));
        } else if (operationKey.equals("show_next_scheduled_time")) {
            long triggerId = D.l((Object)FormOpener.getSelectedId(this, evt));
            if (triggerId > 0L) {
                DynamicObject trigger = DataCopyTrigger.get((long)triggerId);
                if (!trigger.getBoolean(ENABLE)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7981\u7528\u7684\u542f\u52a8\u65b9\u6848\u4e0d\u652f\u6301\u67e5\u770b\u4e0b\u6b21\u6267\u884c\u8ba1\u5212", (String)"DataCopyTriggerFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                List jobInfos = JobEngine.getCreatedJobsWithOwnerId((long)triggerId);
                if (jobInfos.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u3010\u5df2\u5230\u8fbe\u8fc7\u671f\u65f6\u95f4\uff0c\u65e0\u4e0b\u6b21\u6267\u884c\u8ba1\u5212\u3011\u6216\u3010\u73af\u5883\u672a\u4f7f\u7528\u96c6\u6210\u4e91\u8c03\u5ea6\u5f15\u64ce\uff0c\u4e0d\u652f\u6301\u67e5\u770b\u3011", (String)"DataCopyTriggerFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                } else {
                    FormOpener.showTabView((AbstractFormPlugin)this, "isc_job_inst", ((JobInfo)jobInfos.get(0)).getId());
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848\u540e\u518d\u542f\u7528\u67e5\u770b\u4e0b\u6b21\u6267\u884c\u8ba1\u5212\u3002", (String)"DataCopyTriggerFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if (operationKey.equals("show_scheduled_time")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("cron_expr", D.s((Object)this.getModel().getValue(SCHEDULE)));
            params.put("end_time", D.t((Object)this.getModel().getValue("expired_time")));
            params.put("start_time", D.t((Object)this.getModel().getValue("validated_time")));
            FormOpener.showStatusForm(this, "isc_cron_expression", "", params, OperationStatus.VIEW, ShowType.Modal);
        } else if ("deleteentry".equals(operationKey) && (params_entryentity = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY)).size() == 0) {
            this.getModel().setValue(CONTAINS_DYNAMIC_FILTER, (Object)false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            if (CommonPluginUtil.checkFilterEntries(this.getView(), this.getModel())) {
                evt.setCancel(true);
                return;
            }
            if (CustomFunctionUtil.isEntryDuplicate(PARAMS_ENTRYENTITY, PARAMS_NAME, this.getModel(), this.getView())) {
                evt.setCancel(true);
            }
            try {
                this.checkCronWhenAutoType();
                this.checkEnable(evt);
                this.checkTimeIsValid(evt);
                this.checkContainsDelete(evt);
                this.checkActionWhenEventType(evt);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
                evt.setCancel(true);
            }
            this.clearNextTaskEntriesIfTypeIsEventOrMSG();
            this.checkBatchSize(evt);
        } else if ("deleteentry".equals(operationKey)) {
            int currentRow = this.getModel().getEntryCurrentRowIndex(PARAMS_ENTRYENTITY);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
            if (Boolean.FALSE.equals(((DynamicObject)entryEntity.get(currentRow)).get(IS_CUSTOM))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ece\u96c6\u6210\u65b9\u6848\u7ee7\u627f\u7684\u53c2\u6570\u9879\u4e0d\u80fd\u5220\u9664\uff01", (String)"DataCopyTriggerFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (ENABLE.equals(operationKey) || DISABLE.equals(operationKey)) {
            Object id = this.getModel().getValue("id");
            if (D.l((Object)id) == 0L) {
                return;
            }
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY_TRIGGER);
            if (trigger == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u672c\u542f\u52a8\u65b9\u6848.", (String)"DataCopyTriggerFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            boolean success = this.updateTriggerStatus(trigger, operationKey);
            if (!success) {
                evt.setCancel(true);
            }
            if ("message".equals(trigger.getString(TRIGGER_TYPE)) && ENABLE.equals(operationKey)) {
                TriggerPluginUtil.enableSubscriberQueue(this, new DynamicObject[]{trigger});
            }
        } else if ("modify".equals(operationKey)) {
            this.checkEnable(evt);
        }
    }

    private void checkBatchSize(BeforeDoOperationEventArgs evt) {
        long batch_size = D.l((Object)this.getModel().getValue("batch_size"));
        if (batch_size > 3000L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3a\u907f\u514d\u5f71\u54cd\u7cfb\u7edf\u6027\u80fd\uff0c\u76ee\u6807\u5355\u6279\u91cf\u5927\u5c0f\u4e0d\u5141\u8bb8\u8d85\u8fc73000\uff0c\u5efa\u8bae1000\u5de6\u53f3\u6027\u80fd\u8f83\u9ad8\uff0c\u8bf7\u914c\u60c5\u4fee\u6539\u3002", (String)"DataCopyTriggerFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void clearNextTaskEntriesIfTypeIsEventOrMSG() {
        DynamicObjectCollection nextTaskEntries;
        String triggerType = D.s((Object)this.getModel().getValue(TRIGGER_TYPE));
        if (("event".equals(triggerType) || "message".equals(triggerType)) && !(nextTaskEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(NEXT_TASKS)).isEmpty()) {
            nextTaskEntries.clear();
        }
    }

    private void checkActionWhenEventType(BeforeDoOperationEventArgs evt) {
        DynamicObject srcSchema;
        if ("event".equals(this.getModel().getValue(TRIGGER_TYPE)) && (srcSchema = this.getSrcSchema()) != null) {
            HubTriggerEventChecker.checkActions(this.getView(), evt, srcSchema.getLong("id"), this.getModel().getValue("events"));
        }
    }

    private void checkCronWhenAutoType() {
        if ("auto".equals(this.getModel().getValue(TRIGGER_TYPE))) {
            String interval = D.s((Object)this.getModel().getValue(INTERVAL));
            if (interval == null) {
                throw new IscBizException(ResManager.loadKDString((String)"\u5b9a\u65f6\u542f\u52a8\u7c7b\u578b\u7684\u542f\u52a8\u65b9\u6848\uff0c\u6267\u884c\u9891\u7387\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String)"DataCopyTriggerFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if ("0".equals(interval)) {
                DataCopyTaskUtil.checkCron((String)D.s((Object)this.getModel().getValue(SCHEDULE)));
            }
        }
    }

    private boolean updateTriggerStatus(DynamicObject trigger, String operationKey) {
        try {
            if (ENABLE.equals(operationKey)) {
                DataCopyTriggerListPlugin.submit(new DynamicObject[]{trigger});
            } else if (DISABLE.equals(operationKey)) {
                DataCopyTriggerListPlugin.cancel(new DynamicObject[]{trigger});
            }
            return true;
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
            return false;
        }
    }

    private void checkTimeIsValid(BeforeDoOperationEventArgs evt) {
        Timestamp validated_time = D.t((Object)this.getModel().getValue("validated_time"));
        Timestamp expired_time = D.t((Object)this.getModel().getValue("expired_time"));
        if (validated_time != null && expired_time != null && validated_time.after(expired_time)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u65f6\u95f4\u5fc5\u987b\u5728\u8fc7\u671f\u65f6\u95f4\u4e4b\u540e\uff0c\u8bf7\u4fee\u6539\u8be5\u5185\u5bb9\uff01", (String)"DataCopyTriggerFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void checkContainsDelete(BeforeDoOperationEventArgs evt) {
        String s = D.s((Object)this.getModel().getValue("events"));
        if (s != null) {
            String[] events = s.split(",");
            ArrayList<String> notNullEvents = new ArrayList<String>();
            boolean hasDelete = false;
            for (String event : events) {
                if (StringUtil.isEmpty((String)event)) continue;
                notNullEvents.add(event);
                if (!event.equals("delete")) continue;
                hasDelete = true;
            }
            if (hasDelete && notNullEvents.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u89e6\u53d1\u4e8b\u4ef6\u9009\u62e9\u4e86\u5220\u9664\u4e8b\u4ef6\uff0c\u4e0d\u80fd\u518d\u9009\u62e9\u5176\u4ed6\u4e8b\u4ef6", (String)"DataCopyTriggerFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void checkEnable(BeforeDoOperationEventArgs evt) {
        DynamicObject schema;
        Object schemaId = this.getModel().getValue("id");
        if (schemaId != null && Long.parseLong(schemaId.toString()) != 0L && (schema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)ISC_DATA_COPY_TRIGGER, (String)ENABLE)).getInt(ENABLE) == 1) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_trigger", (IFormPlugin)this);
            String tips = OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus()) ? ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataCopyTriggerFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataCopyTriggerFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callback = evt.getCallBackId();
        if ("disable_trigger".equals(callback)) {
            Object id = this.getModel().getValue("id");
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY_TRIGGER);
            if (this.updateTriggerStatus(trigger, DISABLE)) {
                trigger.set(ENABLE, (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trigger});
                if (this.getView().getFormShowParameter() != null && OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                    this.getView().setStatus(OperationStatus.EDIT);
                    this.getView().updateView();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"DataCopyTriggerFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u5df2\u7981\u7528\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u4fdd\u5b58!", (String)"DataCopyTriggerFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("enable_subscriber_queue".equals(callback)) {
            TriggerPluginUtil.confirmEnableQueue(this);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        Object dataCopyId = this.getModel().getValue(DATA_COPY_ID);
        if (fieldKey.equals(FILTER_COLUMN) && D.l((Object)dataCopyId) != 0L) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)dataCopyId, (String)ISC_DATA_COPY, (String)"source_schema");
            long srcId = dataCopy.getLong(SOURCE_SCHEMA_ID);
            param.put("id", srcId);
            param.put("$row", cellClickEvent.getRow());
            param.put("notExpandMultiLangNode", true);
            EntryFilterUtil.showFormByConnType(this, srcId, param, FILTER_COLUMN);
        } else if (fieldKey.equals("filter_value_fixed")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("$row", cellClickEvent.getRow());
            params.put("isTrigger", Boolean.TRUE);
            FormOpener.showForm(this, "fixed_value_selector", ResManager.loadKDString((String)"\u9009\u62e9\u8868\u8fbe\u5f0f", (String)"DataCopyTriggerFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_iscenv_var");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if (action.equals(FILTER_COLUMN) && data instanceof Map) {
            Map map = (Map)data;
            Object rowValue = map.get("$row");
            if (rowValue != null) {
                int index = Integer.parseInt(rowValue.toString());
                DynamicObject row = this.getModel().getEntryRowEntity(FILTER_ENTRIES, index);
                row.set(FILTER_COLUMN, EntryFilterUtil.getFilterColumn(map));
                row.set(FILTER_LABEL, map.get("name"));
                this.getView().updateView(FILTER_ENTRIES);
            }
        } else if (action.equals(GET_TIMESTAMP) && data instanceof Map) {
            Map map = (Map)data;
            this.getModel().setValue(TIMESTAMP_FIELD, map.get(NUMBER));
            this.getView().updateView();
        } else if (action.equals(USER_SELECT)) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)evt.getReturnData();
            ArtificialF7Util.setValue(this.getView(), lsrc, EXE_JOB_USER);
        } else if ("get_iscenv_var".equals(action)) {
            SetFilterUtil.setIscVariable(evt, this.getView());
        } else if (SCHEDULE.equals(action)) {
            if (data == null) {
                return;
            }
            this.getModel().setValue(SCHEDULE, ((Map)data).get("cron_expr"));
        }
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (src instanceof TextEdit) {
            TextEdit edit = (TextEdit)src;
            if (TIMESTAMP_FIELD.equals(edit.getKey())) {
                if (D.l((Object)this.getModel().getValue(DATA_COPY_ID)) == 0L) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u65b9\u6848\u3002", (String)"DataCopyTriggerFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dcObj = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue(DATA_COPY_ID), (String)ISC_DATA_COPY, (String)"source_schema");
                long srcId = dcObj.getLong(SOURCE_SCHEMA_ID);
                if (srcId == 0L) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u4e2d\u4e0d\u542b\u6e90\u5bf9\u8c61\u3002", (String)"DataCopyTriggerFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", srcId);
                FormOpener.showForm(this, "isc_meta_property_tree", ResManager.loadKDString((String)"\u9009\u62e9\u65f6\u95f4\u6233\u5c5e\u6027", (String)"DataCopyTriggerFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, GET_TIMESTAMP);
            } else if (EXE_JOB_USER.equals(edit.getKey())) {
                this.showPersonForm();
            } else if (SCHEDULE.equals(edit.getKey())) {
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put("cron_expr", D.s((Object)this.getModel().getValue(SCHEDULE)));
                params.put("end_time", D.t((Object)this.getModel().getValue("expired_time")));
                params.put("start_time", D.t((Object)this.getModel().getValue("validated_time")));
                FormOpener.showForm(this, "isc_cron_expression", "", params, SCHEDULE);
            }
        }
    }

    private void showPersonForm() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BOS_USER, (boolean)false, (int)0);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, USER_SELECT));
        String user = (String)this.getModel().getValue(EXE_JOB_USER);
        parameter.setSelectedRow((Object)TimerJobUtil.getUserIdByNumber((String)user));
        this.getView().showForm((FormShowParameter)parameter);
    }
}

