/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.trigger;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.trace.TraceTask;

public class EventTriggerParamFormPlugin
extends AbstractFormPlugin {
    private static final String FILTER_LINK = "filter_link";
    private static final String FILTER_RIGHT_BRACKET = "filter_right_bracket";
    private static final String FILTER_VALUE = "filter_value";
    private static final String FILTER_LEFT_BRACKET = "filter_left_bracket";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FILTER_COMPARE = "filter_compare";
    private static final String CANDIDATE_KEY = "candidate_key";
    private static final String FILTER_TAG = "$is_filter";
    private static final String FILTER_ITEMS = "$filter_items";
    private static final String VALUE = "value";
    private static final String FILTER_ENTRY = "filter_entry";
    private static final int MAX_SIZE = 50;

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("filter_button".equals(name)) {
            Object triggerId;
            String newValue = D.s((Object)e.getChangeSet()[0].getNewValue());
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map params = parameter.getCustomParams();
            if (params != null && (triggerId = params.get("triggerId")) != null) {
                IDataModel model = this.getModel();
                DynamicObject trigger = BusinessDataServiceHelper.loadSingle(triggerId, (String)"isc_data_copy_trigger");
                DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)trigger.getLong("data_copy_id"), (String)"isc_data_copy");
                newValue = "candidate".equals(newValue) ? CANDIDATE_KEY : "id";
                DynamicObjectCollection filterEntry = this.constructFilterEntry(schema, newValue);
                model.getDataEntity(true).set(FILTER_ENTRY, (Object)filterEntry);
                this.getView().updateView(FILTER_ENTRY);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        Object triggerId;
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = parameter.getCustomParams();
        if (params != null && (triggerId = params.get("triggerId")) != null) {
            IDataModel model = this.getModel();
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle(triggerId, (String)"isc_data_copy_trigger");
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)trigger.getLong("data_copy_id"), (String)"isc_data_copy");
            model.setValue("trigger", trigger.getPkValue());
            model.setValue("schema", schema.getPkValue());
            DynamicObjectCollection filterEntry = this.constructFilterEntry(schema, CANDIDATE_KEY);
            model.setValue(FILTER_ENTRY, (Object)filterEntry);
            this.getModel().updateCache();
        }
    }

    private DynamicObjectCollection constructFilterEntry(DynamicObject schema, String filterField) {
        DynamicObjectCollection filterEntry = this.getModel().getDataEntity().getDynamicObjectCollection(FILTER_ENTRY);
        filterEntry.clear();
        if (CANDIDATE_KEY.equals(filterField)) {
            this.handleProp(filterEntry, schema);
        } else {
            this.handlePropNew(filterEntry, schema);
        }
        return filterEntry;
    }

    private void handleProp(DynamicObjectCollection filterEntry, DynamicObject schema) {
        DynamicObjectCollection mapping_collection = (DynamicObjectCollection)schema.get("mapping_entries");
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject obj : mapping_collection) {
            String srcColumn;
            if (!obj.getBoolean(CANDIDATE_KEY) || (srcColumn = D.s((Object)obj.get("mapping_src_column"))) == null || srcColumn.indexOf(46) >= 0 || !set.add(srcColumn)) continue;
            DynamicObject rowObj = filterEntry.addNew();
            rowObj.set("name", (Object)srcColumn);
            String src_desc = obj.getString("src_desc");
            rowObj.set("title", (Object)(src_desc.length() > 50 ? src_desc.substring(0, 50) : src_desc));
            rowObj.set("type", (Object)"string");
            rowObj.set(VALUE, null);
        }
    }

    private void handlePropNew(DynamicObjectCollection filterEntry, DynamicObject schema) {
        DynamicObject source_schema = (DynamicObject)schema.get("source_schema");
        Object schemaId = source_schema.get("id");
        source_schema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)"isc_metadata_schema");
        DynamicObjectCollection prop_entryentity = source_schema.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject obj : prop_entryentity) {
            String srcColumn;
            if (!obj.getBoolean("is_primary_key") || (srcColumn = D.s((Object)obj.get("prop_name"))) == null || srcColumn.indexOf(46) >= 0) continue;
            DynamicObject rowObj = filterEntry.addNew();
            rowObj.set("name", (Object)srcColumn);
            String src_desc = obj.getString("prop_label");
            rowObj.set("title", (Object)(src_desc.length() > 50 ? src_desc.substring(0, 50) : src_desc));
            rowObj.set("type", (Object)"string");
            rowObj.set(VALUE, null);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operationKey = eventArgs.getOperateKey();
        if ("execute".equals(operationKey)) {
            RequestContext current = RequestContext.get();
            RequestContext new_rc = null;
            try {
                long exe_job_user_id = D.l((Object)this.getModel().getValue("exe_job_user_id"));
                String proxyUser = exe_job_user_id == 0L ? null : D.s((Object)exe_job_user_id);
                new_rc = ContextUtil.restoreAndGetContext((RequestContext)current, (String)proxyUser);
                this.execute();
            }
            finally {
                if (new_rc != null) {
                    RequestContextCreator.restoreForMQ((RequestContext)current);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        try {
            DataCopyDebugger.setDebug((boolean)D.x((Object)this.getView().getFormShowParameter().getCustomParam("#DEBUG")));
            final HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(FILTER_TAG, Boolean.TRUE);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            List<Map<String, Object>> filterItems = this.constructFilterItems(dataEntity);
            params.put(FILTER_ITEMS, filterItems);
            final long tid = dataEntity.getLong("trigger_id");
            TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

                public void run() {
                    DynamicObject execution = DataCopyTask.create((long)tid, (Object)params);
                    DataCopyTask.start((DynamicObject)execution);
                    EventTriggerParamFormPlugin.this.openExecFormAndCloseCurrent(execution);
                }
            });
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
        finally {
            DataCopyDebugger.unsetDebug();
        }
    }

    private List<Map<String, Object>> constructFilterItems(DynamicObject dataEntity) {
        DynamicObjectCollection filtersEntry = dataEntity.getDynamicObjectCollection(FILTER_ENTRY);
        ArrayList<Map<String, Object>> filterItems = new ArrayList<Map<String, Object>>(filtersEntry.size());
        if (filtersEntry.size() == 1) {
            this.handleOneJudgeKey(filtersEntry, filterItems);
        } else if (filtersEntry.size() > 1) {
            this.handleMultiJudgeKey(filtersEntry, filterItems);
        } else {
            throw new IscBizException(ResManager.loadKDString((String)"\u8be5\u96c6\u6210\u65b9\u6848\u627e\u4e0d\u5230\u6e90\u5355\u5019\u9009\u952e\u5b57\u6bb5", (String)"EventTriggerParamFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return filterItems;
    }

    private void handleMultiJudgeKey(DynamicObjectCollection filtersEntry, List<Map<String, Object>> filterItems) {
        for (int i = 0; i < filtersEntry.size(); ++i) {
            DynamicObject o = (DynamicObject)filtersEntry.get(i);
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(FILTER_LEFT_BRACKET, Character.valueOf('('));
            item.put(FILTER_COLUMN, o.getString("name"));
            item.put(FILTER_COMPARE, "=");
            String propVal = D.s((Object)o.get(VALUE));
            if (propVal == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e[%s]\u7684\u503c\u672a\u586b\u5199", (String)"EventTriggerParamFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), o.getString("name")));
            }
            item.put(FILTER_VALUE, propVal);
            item.put(FILTER_RIGHT_BRACKET, Character.valueOf(')'));
            if (i > 0) {
                item.put(FILTER_LINK, "AND");
            }
            filterItems.add(item);
        }
    }

    private void handleOneJudgeKey(DynamicObjectCollection filtersEntry, List<Map<String, Object>> filterItems) {
        DynamicObject o = (DynamicObject)filtersEntry.get(0);
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(FILTER_LEFT_BRACKET, Character.valueOf('('));
        item.put(FILTER_COLUMN, o.getString("name"));
        String idStr = D.s((Object)o.get(VALUE));
        if (idStr == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e[%s]\u7684\u503c\u672a\u586b\u5199", (String)"EventTriggerParamFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), o.getString("name")));
        }
        if (idStr.startsWith("[") && idStr.endsWith("]")) {
            item.put(FILTER_COMPARE, "in");
        } else {
            item.put(FILTER_COMPARE, "=");
        }
        item.put(FILTER_VALUE, idStr);
        item.put(FILTER_RIGHT_BRACKET, Character.valueOf(')'));
        filterItems.add(item);
    }

    private void openExecFormAndCloseCurrent(DynamicObject execution) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(1);
        returnData.put("id", execution.getPkValue());
        returnData.put("#DEBUG", this.getView().getFormShowParameter().getCustomParam("#DEBUG"));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

