/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.export;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.export.FileDownload;
import kd.isc.iscb.formplugin.log.SchemaEncryptDataUtil;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

abstract class AbstractExecLogDownload
implements FileDownload {
    private static Log logger = LogFactory.getLog(AbstractExecLogDownload.class);

    AbstractExecLogDownload() {
    }

    Object getEncryptData(boolean isSrc, DynamicObject exec_log) {
        DynamicObject meta;
        long pk = exec_log.getLong("data_copy_schema_id");
        DynamicObject dc = DataCopySchema.get((long)pk);
        DynamicObject dynamicObject = meta = isSrc ? dc.getDynamicObject("source_schema") : dc.getDynamicObject("target_schema");
        if (meta == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u7684\u96c6\u6210\u65b9\u6848\u5173\u8054\u96c6\u6210\u5bf9\u8c61\u7f3a\u5931\u3002", (String)"AbstractExecLogDownload_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dc.getString("number")));
        }
        String data = isSrc ? exec_log.getString("source_data_tag") : exec_log.getString("target_data_tag");
        try {
            return SchemaEncryptDataUtil.getData(D.l((Object)meta.getPkValue()), data);
        }
        catch (Exception e) {
            logger.warn("\u4e0b\u8f7d\u65e5\u5fd7\u52a0\u5bc6\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
            return data;
        }
    }

    protected Map<String, Object> buildLog(Object id) {
        LinkedHashMap<String, Object> log = new LinkedHashMap<String, Object>();
        DynamicObject exec_log = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_data_copy_exec_log");
        try {
            log.put("log_id", id);
            log.put("data_src", this.getEncryptData(true, exec_log));
            log.put("data_tar", this.getEncryptData(false, exec_log));
            log.put("src_jf", exec_log.get("judgefields"));
            log.put("exec_state", DcLogState.valueOf(exec_log.getString("state")).getDesc());
            log.put("trigger_number", exec_log.get("data_copy_trigger.number"));
            log.put("execution_number", exec_log.get("data_copy_execution.number"));
            log.put("log", exec_log.getString("message_tag"));
        }
        catch (Exception e) {
            log.put("log", StringUtil.getCascadeMessage((Throwable)e));
        }
        return log;
    }

    static enum DcLogState {
        S(new MultiLangEnumBridge("\u6210\u529f", "AbstractExecLogDownload_2", "isc-iscb-platform-formplugin")),
        F(new MultiLangEnumBridge("\u5931\u8d25", "AbstractExecLogDownload_3", "isc-iscb-platform-formplugin")),
        G(new MultiLangEnumBridge("\u5931\u6548", "AbstractExecLogDownload_4", "isc-iscb-platform-formplugin")),
        N(new MultiLangEnumBridge("\u5ffd\u7565", "AbstractExecLogDownload_5", "isc-iscb-platform-formplugin")),
        I(new MultiLangEnumBridge("\u624b\u52a8\u5931\u6548", "AbstractExecLogDownload_6", "isc-iscb-platform-formplugin"));

        private final MultiLangEnumBridge desc;

        private DcLogState(MultiLangEnumBridge desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }
    }
}

