/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.ext;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.ext.InterfaceCenterUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ExternalCnConfigListPlugin
extends AbstractListPlugin {
    private static final String DATABASE_TYPE = "database_type";
    private static final String ISC_CN_CONFIG = "isc_cn_config";
    private static final String ISC_CONNECTION_TYPE_X = "isc_connection_type_x";
    private static final String TBLNEW = "tblnew";
    private static final String TBLDEL = "tbldel";
    private static final String CONNECTION_TYPE = "connection_type";

    public void initialize() {
        super.initialize();
        if ("admin".equals(System.getProperty("interface_center.user.type"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TBLNEW, TBLDEL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TBLNEW, TBLDEL});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("number".equals(args.getFieldName())) {
            args.setCancel(true);
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow current = billList.getCurrentSelectedRowInfo();
            Object selectedId = current.getPrimaryKeyValue();
            DynamicObject cnConfig = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)ISC_CN_CONFIG, (String)DATABASE_TYPE);
            try {
                FormOpener.showView((AbstractFormPlugin)this, this.getCnTypeFormId(cnConfig), selectedId);
            }
            catch (Exception e) {
                this.getView().showMessage(D.s((Object)e));
            }
        }
    }

    private String getCnTypeFormId(DynamicObject cnConfig) {
        DynamicObject type = cnConfig.getDynamicObject(DATABASE_TYPE);
        Object typeId = type.getPkValue();
        DynamicObject cnType = BusinessDataServiceHelper.loadSingle((Object)typeId, (String)ISC_CONNECTION_TYPE_X, (String)"config_form");
        if (cnType == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6\uff1aid = (%1$s),\u67e5\u8be2\u5355\u636e\uff1a%2$s\u4e3a\u7a7a\u3002", (String)"ExternalCnConfigListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), typeId, ISC_CONNECTION_TYPE_X));
        }
        return cnType.getString("config_form");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            if ("test".equals(operateKey)) {
                this.test(args);
            } else if ("delete".equals(operateKey)) {
                IscLicenseUtil.refreshCache();
            } else if (CONNECTION_TYPE.equals(operateKey)) {
                this.openConnectionTypeList();
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void openConnectionTypeList() {
        FormOpener.showList((AbstractFormPlugin)this, ISC_CONNECTION_TYPE_X, new QFilter("id", "!=", (Object)"-1"));
    }

    private boolean cnConfigIsEnabled(DynamicObject dataEntity) {
        return dataEntity.getBoolean("enable");
    }

    private void test(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (null != id) {
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_CN_CONFIG);
            if (!this.cnConfigIsEnabled(dataEntity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u5916\u90e8\u7cfb\u7edf\u914d\u7f6e\uff0c\u518d\u6267\u884c\u6d4b\u8bd5\u3002", (String)"ExternalCnConfigListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!InterfaceCenterUtil.connectionTypeIsEnabled((DynamicObject)dataEntity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5f00\u653e\u5e73\u53f0->\u7b2c\u4e09\u65b9\u63a5\u53e3->\u5916\u90e8\u7cfb\u7edf->\u7cfb\u7edf\u7c7b\u578b\uff0c\u6267\u884c\u542f\u7528/\u7981\u7528\u64cd\u4f5c\uff0c\u5c06\u8fde\u63a5\u7c7b\u578b\u53d1\u5e03\u5230\u96c6\u6210\u7ba1\u7406\uff0c\u518d\u6267\u884c\u6d4b\u8bd5\u3002", (String)"ExternalCnConfigListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                ConnectionManager.test((long)D.l((Object)id));
                dataEntity.set("state", (Object)"S");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f.", (String)"ExternalCnConfigListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                dataEntity.set("state", (Object)"F");
                FormOpener.showErrorMessage(this.getView(), e);
            }
            SaveServiceHelper.update((DynamicObject)dataEntity);
        }
    }
}

