/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.guide.tasks;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.webapi.VarItem;
import kd.isc.iscb.formplugin.guide.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class VarSelectGuideFormPlugin
extends AbstractFormPlugin
implements CellClickListener,
Const {
    private static final String ROW = "row";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String webRespBodyStr = (String)params.get("webRespBodyStr");
        Map resp = (Map)Json.toObject((String)webRespBodyStr);
        this.getModel().setValue(ROW, params.get("$row"));
        ArrayList<VarItem> list = new ArrayList<VarItem>(10);
        this.buildRespList(resp, list, "$session.");
        if (D.s(params.get("conn_id")) != null) {
            this.buildConnVarList(D.s(params.get("conn_id")), list, this.getConnPrefix(params));
        }
        this.initVarEntries(list);
    }

    private String getConnPrefix(Map<String, Object> params) {
        String taskType = D.s((Object)params.get("guideTask"));
        if ("is_create_webapi".equals(taskType)) {
            return "$connection.";
        }
        return "this.";
    }

    private void buildConnVarList(String conn_id, List<VarItem> list, String prefix) {
        DynamicObject conn = BusinessDataServiceHelper.loadSingle((Object)conn_id, (String)"isc_connection_type");
        DynamicObjectCollection collection = conn.getDynamicObjectCollection("entryentity");
        for (DynamicObject col : collection) {
            list.add(new VarItem(prefix + col.getString("params_number"), col.getString("default_value"), "", col.getString("desc")));
        }
    }

    public void buildRespList(Map<String, Object> resp, List<VarItem> list, String prefix) {
        for (Map.Entry<String, Object> entry : resp.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                list.add(new VarItem(prefix + entry.getKey(), (String)value, "", null));
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.buildRespList((Map)value, list, prefix + entry.getKey() + ".");
        }
    }

    private void initVarEntries(List<VarItem> varList) {
        this.getModel().deleteEntryData("var_list");
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("var_list");
        for (VarItem var : varList) {
            DynamicObject obj = entries.addNew();
            obj.set("var_name", (Object)var.getName());
            obj.set("var_value", (Object)var.getDesc());
        }
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        int[] rowNum;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("select".equals(operateKey) && (rowNum = ((EntryGrid)this.getView().getControl("var_list")).getSelectRows()).length == 1) {
            Map<String, Object> selectedRowData = this.getSelectedRowData(rowNum[0]);
            this.getView().returnDataToParent(selectedRowData);
            this.getView().close();
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("var_list", row);
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        String varName = rowEntity.getString("var_name");
        String varDesc = rowEntity.getString("var_value");
        data.put("$row", this.getModel().getValue(ROW));
        data.put("var_name", varName);
        data.put("var_value", varDesc);
        return data;
    }
}

