/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.help;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Html;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.script.misc.StringUtil;

public class IscOnlineHelperPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String TREEVIEW = "topic_tree";

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.initTree(params);
    }

    private void initTree(Map<String, Object> params) {
        List<TreeNode> categories = this.loadCategories();
        Map<String, Pair> counter = this.prepareCategoryCounter(categories);
        List<TreeNode> items = this.loadItems();
        this.statLeafCategoryCount(items, counter);
        this.statBranchCategoryCount(categories, counter);
        List<TreeNode> nodes = this.filterNotEmtpyCategories(categories, items, counter);
        nodes.addAll(items);
        this.appendTreeNodes(nodes);
    }

    private void appendTreeNodes(List<TreeNode> nodes) {
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        for (TreeNode node : nodes) {
            tree.addNode(node);
        }
    }

    private List<TreeNode> filterNotEmtpyCategories(List<TreeNode> categories, List<TreeNode> items, Map<String, Pair> counter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(items.size() + categories.size());
        for (TreeNode node : categories) {
            if (counter.get(node.getId()).childCount <= 0) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private void statBranchCategoryCount(List<TreeNode> categories, Map<String, Pair> counter) {
        for (int i = categories.size() - 1; i >= 0; --i) {
            String key;
            TreeNode node = categories.get(i);
            if (counter.get(node.getId()).childCount <= 0 || (key = node.getParentid()).length() <= 0) continue;
            Pair p = counter.get(key);
            p.childCount++;
        }
    }

    private void statLeafCategoryCount(List<TreeNode> items, Map<String, Pair> counter) {
        for (TreeNode node : items) {
            String key = node.getParentid();
            Pair p = counter.get(key);
            p.childCount++;
        }
    }

    private Map<String, Pair> prepareCategoryCounter(List<TreeNode> categories) {
        LinkedHashMap<String, Pair> counter = new LinkedHashMap<String, Pair>(categories.size());
        for (TreeNode node : categories) {
            counter.put(node.getId(), new Pair(node));
        }
        return counter;
    }

    private List<TreeNode> loadItems() {
        QFilter[] filters = this.prepareItemsFilter();
        DynamicObjectCollection items = QueryServiceHelper.query((String)"isc_help_item", (String)"id,group,number,name", (QFilter[])filters, (String)"number");
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(items.size());
        HashMap<String, String> cache = new HashMap<String, String>();
        for (DynamicObject item : items) {
            long pid = item.getLong("group");
            String parent = String.valueOf(pid);
            String id = String.valueOf(item.get("id"));
            String title = item.getString("name");
            String number = item.getString("number");
            cache.put(id, title + ":" + number);
            nodes.add(new TreeNode(parent, id, title));
        }
        this.getPageCache().put("cache", Json.toString(cache));
        return nodes;
    }

    private QFilter[] prepareItemsFilter() {
        Object scene;
        QFilter[] filters = new QFilter[]{};
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && (scene = params.get("scene")) != null) {
            QFilter filter = new QFilter("target_scens", "=", (Object)",ALL,");
            filter = filter.or(new QFilter("target_scens", "like", (Object)("%," + scene + ",%")));
            filters = new QFilter[]{filter};
        }
        return filters;
    }

    private List<TreeNode> loadCategories() {
        DynamicObjectCollection categories = QueryServiceHelper.query((String)"isc_help_category", (String)"id,parent,name", (QFilter[])new QFilter[0], (String)"longnumber");
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(categories.size());
        for (DynamicObject category : categories) {
            long pid = category.getLong("parent");
            String parent = pid <= 0L ? "" : String.valueOf(pid);
            String id = String.valueOf(category.get("id"));
            String title = category.getString("name");
            TreeNode node = new TreeNode(parent, id, title);
            nodes.add(node);
        }
        return nodes;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        QFilter filter = new QFilter("id", "in", (Object)Long.parseLong(nodeId));
        DynamicObject item = QueryServiceHelper.queryOne((String)"isc_help_item", (String)"target_scens,help_text", (QFilter[])new QFilter[]{filter});
        if (item != null) {
            Map<String, String> consts = this.getTargetSceneConsts();
            List<String> target_scens = this.getTargetScenes(item, consts);
            String text = this.generateHTML(item, target_scens);
            Html html = (Html)this.getControl("content");
            html.setConent(text);
        }
    }

    private String generateHTML(DynamicObject item, List<String> target_scens) {
        String help_text = item.getString("help_text");
        if (target_scens.isEmpty()) {
            return "<pre>" + help_text + "</pre>";
        }
        return String.format("<pre>%1$s%2$s</pre><pre>%3$s</pre>", ResManager.loadKDString((String)"\u9002\u7528\u573a\u666f\uff1a", (String)"IscOnlineHelperPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.join(target_scens, (String)", "), help_text);
    }

    private List<String> getTargetScenes(DynamicObject item, Map<String, String> consts) {
        ArrayList<String> target_scens = new ArrayList<String>(8);
        String s = D.s((Object)item.get("target_scens"));
        if (s != null) {
            for (String key : s.split(",")) {
                String name = consts.get(key);
                if (name == null) continue;
                target_scens.add(name);
            }
        }
        return target_scens;
    }

    private Map<String, String> getTargetSceneConsts() {
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)"isc_help_item");
        ComboProp property = (ComboProp)entity.getProperties().get((Object)"target_scens");
        List vItems = property.getComboItems();
        HashMap<String, String> consts = new HashMap<String, String>(vItems.size());
        for (ValueMapItem e : vItems) {
            consts.put(e.getValue(), e.getName().toString());
        }
        return consts;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent args) {
        String priorKeys;
        Iterator<Map.Entry<String, String>> it;
        boolean found;
        String s;
        Map cache;
        String text = D.s((Object)args.getText());
        if (text != null && (cache = (Map)Json.toObject((String)(s = this.getPageCache().get("cache")))) != null && !(found = this.searchKeywords(text, it = this.getEntryIterator(text, cache, priorKeys = this.getPageCache().get("prior_keys")))) && !text.equals(priorKeys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5e2e\u52a9\u4fe1\u606f\u3002", (String)"IscOnlineHelperPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean searchKeywords(String text, Iterator<Map.Entry<String, String>> it) {
        String nodeId = this.searchAndShowEntry(it, text);
        this.getPageCache().put("prior_keys", text);
        this.getPageCache().put("prior_hits", nodeId);
        return !"".equals(nodeId);
    }

    private String searchAndShowEntry(Iterator<Map.Entry<String, String>> it, String text) {
        String[] keywords = text.split("\\s+");
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            if (!this.containsAll(e.getValue(), keywords)) continue;
            String nodeId = e.getKey();
            this.showEntry(nodeId);
            return nodeId;
        }
        return "";
    }

    private void showEntry(String nodeId) {
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        tree.showNode(nodeId);
        tree.focusNode(new TreeNode("", nodeId, ""));
    }

    private Iterator<Map.Entry<String, String>> getEntryIterator(String text, Map<String, String> cache, String priorKeys) {
        if (!text.equals(priorKeys)) {
            return cache.entrySet().iterator();
        }
        String priorHits = this.getPageCache().get("prior_hits");
        return this.skipSearchedEntries(cache, priorKeys, priorHits);
    }

    private Iterator<Map.Entry<String, String>> skipSearchedEntries(Map<String, String> cache, String priorKeys, String priorHits) {
        if ("".equals(priorKeys)) {
            return cache.entrySet().iterator();
        }
        Iterator<Map.Entry<String, String>> it = cache.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getKey().equals(priorHits)) continue;
            return it;
        }
        return cache.entrySet().iterator();
    }

    private boolean containsAll(String topic, String[] keywords) {
        for (String key : keywords) {
            if (topic.contains(key)) continue;
            return false;
        }
        return true;
    }

    static class Pair {
        private TreeNode node;
        private int childCount;

        public Pair(TreeNode node) {
            this.node = node;
            this.childCount = 0;
        }

        public String toString() {
            return this.childCount + ":" + this.node.getParentid();
        }
    }
}

