/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.hub;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class EventLogFormPlugin
extends AbstractFormPlugin {
    private static final String ACTION = "action";
    private static final String EVT_SCHEMA_TYPE = "evt_schema_type";
    private static final String EVT_SCHEMA_ID = "evt_schema_id";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("isc_user_defined_event".equals(this.getModel().getValue(EVT_SCHEMA_TYPE))) {
            try {
                ComboEdit combo = (ComboEdit)this.getView().getControl(ACTION);
                combo.setComboItems(this.reInitComboList());
                this.getView().updateView(ACTION);
            }
            catch (Throwable ex) {
                FormOpener.showErrorMessage(this.getView(), ex);
            }
        }
    }

    private List<ComboItem> reInitComboList() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue(EVT_SCHEMA_ID), (String)"isc_user_defined_event");
        DynamicObjectCollection eventEntries = obj.getDynamicObjectCollection("event_entryentity");
        for (DynamicObject eventEntry : eventEntries) {
            ComboItem comboItem = new ComboItem(new LocaleString(eventEntry.getString("event_label")), eventEntry.getString("event_number"));
            items.add(comboItem);
        }
        return items;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("view_job".equals(args.getOperateKey())) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_job_inst", "job_owner", D.l((Object)this.getModel().getValue("id")));
        }
    }
}

