/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.log;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.log.ClearLogUtil;
import kd.isc.iscb.platform.core.log.LogEnum;
import kd.isc.iscb.platform.core.log.job.DeleteLogJob;
import kd.isc.iscb.platform.core.log.job.QueryLogJob;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class ClearLogFormPlugin
extends AbstractFormPlugin {
    private static final String RADIO_GROUP_FIELD = "radiogroupfield";
    private static final String LOG_QUERY = "log_query";
    private static final String LOG_DEL = "log_del";
    private static final String LOG_RECORD = "log_record";
    private static final String RESET = "reset";
    private static final String DATE_RANGE = "daterange";
    private static final long ONEDAY = 86400000L;
    private static final String RADIO_GROUP_STATE = "radiogroupstate";
    private static final String JOB_QUERY_LOG = "QUERY_LOG";
    private static final String JOB_DELETE_LOG = "DELETE_LOG";
    private static final String REFRESH = "refresh";
    private static final List<String> KEYS = Arrays.asList("copy_execution", "exec_log", "copy_taskstage", "evt_que", "log_relation", "apic_log", "ts_log", "attach_log", "attachment", "data_received", "data_published", "job_inst", "biz_execution", "biz_trace", "sf_proc_inst", "sf_proc_log", "dbc_table_copy_log");
    private static final List<LogEnum> LOGENUMS = Arrays.asList(LogEnum.COPYEXECUTION, LogEnum.COPYEXECLOG, LogEnum.COPYTASKSTAGE, LogEnum.CONEVTQUE, LogEnum.BILLLOGRELATION, LogEnum.APICLOG, LogEnum.DATATSLOG, LogEnum.ATTACHLOG, LogEnum.ATTACHMENT, LogEnum.MQRECEIVED, LogEnum.MQPUBLISHED, LogEnum.JOBINST, LogEnum.BIZEXECUTION, LogEnum.BIZTRACE, LogEnum.SFPROCINST, LogEnum.SFPROCLOG, LogEnum.TABLECOPYLOG);
    private List<JobInfo> jobs = null;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindLastRecord();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"checkboxall", "definerange", "sevenbefore", "threebefore", "todaybefore", DATE_RANGE, "success", "all_state"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (LOG_RECORD.equals(args.getOperateKey())) {
            FormOpener.openExistedBillList(this, "isc_clear_record", null);
        } else if (RESET.equals(args.getOperateKey())) {
            for (int i = 0; i < KEYS.size(); ++i) {
                this.getPageCache().remove(LOGENUMS.get(i).getMasterTable());
                Label logtypeLabel = (Label)this.getView().getControl(LOGENUMS.get(i).getMasterTable());
                logtypeLabel.setText(null);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{DATE_RANGE});
        } else if (LOG_DEL.equals(args.getOperateKey())) {
            UserPermissionUtil.checkUserPermission();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(LOG_DEL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u7406\u540e\u7684\u65e5\u5fd7\u5c06\u4e0d\u53ef\u6062\u590d\uff0c\u786e\u5b9a\u8981\u6e05\u7406\u65e5\u5fd7\u5417\uff1f", (String)"ClearLogFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else if (LOG_QUERY.equals(args.getOperateKey())) {
            this.queryLog();
        } else if (REFRESH.equals(args.getOperateKey())) {
            if (this.deleteLogJobIsExist()) {
                FormOpener.reopenJob(this, this.jobs.get(0).getId(), this.jobs.get(0).getTitle(), JOB_DELETE_LOG);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u540e\u53f0\u65e0\u6e05\u7406\u65e5\u5fd7\u4efb\u52a1\u3002", (String)"ClearLogFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult() == MessageBoxResult.Yes && LOG_DEL.equals(event.getCallBackId())) {
            this.deleteLog();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (JOB_QUERY_LOG.equals(event.getActionId())) {
            this.refreshLable(true);
        } else if (JOB_DELETE_LOG.equals(event.getActionId())) {
            this.refreshLable(false);
        }
    }

    private void refreshLable(boolean log_query) {
        Label logtypeLabel = null;
        for (LogEnum e : LogEnum.values()) {
            String text;
            logtypeLabel = (Label)this.getView().getControl(e.getMasterTable());
            String string = text = log_query ? ResManager.loadKDString((String)"\u65e5\u5fd7\u6570 ", (String)"ClearLogFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u6e05\u7406 ", (String)"ClearLogFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            if (this.getPageCache().get(e.getMasterTable()) != null) {
                logtypeLabel.setText(text + D.s((Object)this.getPageCache().get(e.getMasterTable())));
                continue;
            }
            logtypeLabel.setText(null);
        }
    }

    private void deleteLog() {
        this.getPageCache().put("totalNum", "0");
        DeleteLogJob job = (DeleteLogJob)this.createJob(true);
        this.jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
        if (this.jobs.isEmpty()) {
            FormOpener.startJob(this, (Job)job, JOB_DELETE_LOG);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e05\u7406\u65e5\u5fd7\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\uff0c\u5982\u9700\u53d1\u8d77\u65b0\u4efb\u52a1\u8bf7\u5148\u64a4\u9500\u6b63\u5728\u8fd0\u884c\u7684\u4efb\u52a1\u3002", (String)"ClearLogFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            FormOpener.reopenJob(this, this.jobs.get(0).getId(), this.jobs.get(0).getTitle(), JOB_DELETE_LOG);
        }
    }

    private void queryLog() {
        QueryLogJob job = (QueryLogJob)this.createJob(false);
        this.jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
        if (this.jobs.isEmpty()) {
            FormOpener.startJob(this, (Job)job, JOB_QUERY_LOG);
        } else {
            FormOpener.reopenJob(this, this.jobs.get(0).getId(), job.getTitle(), JOB_QUERY_LOG);
        }
    }

    private String getCurrentUserName() {
        DynamicObject user = UserServiceHelper.getCurrentUser((String)"name");
        if (user.getLocaleString("name") != null) {
            return user.getLocaleString("name").getLocaleValue();
        }
        return null;
    }

    private Job createJob(boolean isDelete) {
        Map<String, Object> map = this.getClearLogMap();
        if (isDelete) {
            return new DeleteLogJob(Json.toString(map), String.format(ResManager.loadKDString((String)"\u6e05\u7406\u65e5\u5fd7_%1$s_%2$s", (String)"ClearLogFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getCurrentUserName(), System.currentTimeMillis()), this.getPageCache());
        }
        return new QueryLogJob(Json.toString(map), String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u65e5\u5fd7_%1$s_%2$s", (String)"ClearLogFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getCurrentUserName(), System.currentTimeMillis()), this.getPageCache());
    }

    private boolean deleteLogJobIsExist() {
        DeleteLogJob job = (DeleteLogJob)this.createJob(true);
        this.jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
        return !this.jobs.isEmpty();
    }

    private Map<String, Object> getClearLogMap() {
        List<Object> range = this.checkChoose();
        Map<String, LogEnum> fieldParams = this.getCheckField();
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("range", range);
        map.put("params", fieldParams);
        map.put("isAllState", this.checkState());
        return map;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if (LOG_QUERY.equals(operationKey) || LOG_DEL.equals(operationKey)) {
            int select = D.i((Object)this.getModel().getValue(RADIO_GROUP_FIELD));
            switch (select) {
                case 0: {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u65e5\u671f\u8303\u56f4\u6ca1\u6709\u9009\u62e9\uff01", (String)"ClearLogFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                    args.setCancel(true);
                    break;
                }
                case 4: {
                    Timestamp startdate = D.t((Object)this.getModel().getValue("daterange_startdate"));
                    Timestamp enddate = D.t((Object)this.getModel().getValue("daterange_enddate"));
                    if (startdate != null && enddate != null) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7684\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\u6ca1\u6709\u9009\u62e9\uff01", (String)"ClearLogFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                    args.setCancel(true);
                    break;
                }
            }
            if (this.isChooseLogType()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u7c7b\u578b\u6ca1\u6709\u9009\u62e9\uff01", (String)"ClearLogFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                args.setCancel(true);
            }
        } else if (RESET.equals(operationKey) && this.deleteLogJobIsExist()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e05\u7406\u65e5\u5fd7\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\uff0c\u8bf7\u5148\u64a4\u9500\u6b63\u5728\u8fd0\u884c\u7684\u4efb\u52a1\u518d\u8fdb\u884c\u5237\u65b0\u3002", (String)"ClearLogFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            args.setCancel(true);
        }
    }

    private boolean isChooseLogType() {
        for (String key : KEYS) {
            if (!D.x((Object)this.getModel().getValue(key))) continue;
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if ("checkboxall".equals(prop)) {
            boolean checkboxall = D.x((Object)this.getModel().getValue("checkboxall"));
            this.setValue(checkboxall);
        }
        if (RADIO_GROUP_FIELD.equals(prop)) {
            int s = D.i((Object)this.getModel().getValue(RADIO_GROUP_FIELD));
            this.getView().setVisible(Boolean.valueOf(s == 4), new String[]{DATE_RANGE});
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"btn_del"});
    }

    private void setValue(boolean isCheck) {
        for (String key : KEYS) {
            this.getModel().setValue(key, (Object)isCheck);
        }
    }

    private boolean checkState() {
        return D.i((Object)this.getModel().getValue(RADIO_GROUP_STATE)) == 2;
    }

    private List<Object> checkChoose() {
        ArrayList<Timestamp> daterange = null;
        int rgroup = D.i((Object)this.getModel().getValue(RADIO_GROUP_FIELD));
        switch (rgroup) {
            case 1: {
                daterange = new ArrayList<Timestamp>(1);
                daterange.add(this.getBeforeDay(6));
                break;
            }
            case 2: {
                daterange = new ArrayList(1);
                daterange.add(this.getBeforeDay(2));
                break;
            }
            case 3: {
                daterange = new ArrayList(1);
                daterange.add(this.getBeforeDay(0));
                break;
            }
            case 4: {
                daterange = new ArrayList(2);
                Timestamp fromDate = D.t((Object)this.getModel().getValue("daterange_startdate"));
                Timestamp toDate = D.t((Object)this.getModel().getValue("daterange_enddate"));
                daterange.add(fromDate);
                daterange.add(toDate);
                break;
            }
        }
        return daterange;
    }

    private Map<String, LogEnum> getCheckField() {
        HashMap<String, LogEnum> params = new HashMap<String, LogEnum>(14);
        HashMap<String, String> caches = new HashMap<String, String>(14);
        for (int i = 0; i < KEYS.size(); ++i) {
            if (D.x((Object)this.getModel().getValue(KEYS.get(i)))) {
                params.put(KEYS.get(i), LOGENUMS.get(i));
                caches.put(LOGENUMS.get(i).getMasterTable(), "0");
                continue;
            }
            this.getPageCache().remove(LOGENUMS.get(i).getMasterTable());
        }
        this.getPageCache().put(caches);
        return params;
    }

    private Timestamp getBeforeDay(int before) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date curDate = calendar.getTime();
        Timestamp beforeTime = D.t((Object)(D.l((Object)curDate) - (long)before * 86400000L));
        return beforeTime;
    }

    private void bindLastRecord() {
        DataRow dr = ClearLogUtil.getRecord();
        long userId = UserServiceHelper.getCurrentUserId();
        Label startTime = (Label)this.getView().getControl("start_time");
        Label operator = (Label)this.getView().getControl("operator");
        if (dr != null && startTime != null && operator != null) {
            startTime.setText(D.s((Object)dr.get((Object)"fstart_time")));
            if (dr.get((Object)"foperator_id") != null) {
                userId = D.l((Object)dr.get((Object)"foperator_id"));
            }
            DynamicObject dObject = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
            String operName = D.s((Object)dObject.get("name"));
            operator.setText(operName);
        }
    }
}

