/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.cache.data.type.EntryType;
import kd.isc.iscb.platform.core.cache.data.type.RefType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class SchemaEncryptDataUtil {
    public static Object getEncryptData(long metaDataId, Object dataTag) {
        try {
            Object encryptData = SchemaEncryptDataUtil.getData(metaDataId, dataTag);
            return encryptData == null ? dataTag : Json.toString((Object)encryptData, (boolean)true);
        }
        catch (Exception e) {
            return dataTag;
        }
    }

    public static Object getData(long metaDataId, Object dataTag) {
        MetaDataSchema schema = MetaDataSchema.getSchema((long)metaDataId);
        Map<String, Object> encryptData = null;
        String data = null;
        if (dataTag == null) {
            return null;
        }
        if (dataTag instanceof List) {
            encryptData = SchemaEncryptDataUtil.getEncryptDataFromList(metaDataId, (List)dataTag);
        } else if (dataTag instanceof Map) {
            encryptData = SchemaEncryptDataUtil.getEncryptDataFromMap(schema, metaDataId, (Map)dataTag);
        } else {
            data = D.s((Object)dataTag);
            if (data.startsWith("{") && data.endsWith("}")) {
                encryptData = SchemaEncryptDataUtil.getEncryptDataFromMap(schema, metaDataId, (Map)JSON.parseObject((String)data, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField}));
            } else if (data.startsWith("[") && data.endsWith("]")) {
                List value = (List)JSON.parseObject((String)data, List.class);
                encryptData = SchemaEncryptDataUtil.getEncryptDataFromList(metaDataId, value);
            } else if (data.startsWith("(") && data.endsWith(")")) {
                encryptData = SchemaEncryptDataUtil.getData(metaDataId, Json.toObject((String)data));
            } else {
                return dataTag;
            }
        }
        return encryptData;
    }

    private static Object getEncryptDataFromList(long metaDataId, List<Object> dataTag) {
        for (Object obj : dataTag) {
            SchemaEncryptDataUtil.getData(metaDataId, obj);
        }
        return dataTag;
    }

    private static Map<String, Object> getEncryptDataFromMap(MetaDataSchema source_schema, long metaDataId, Map<String, Object> dataTag) {
        for (Map.Entry<String, Object> m : dataTag.entrySet()) {
            SchemaEncryptDataUtil.encryptField(source_schema, dataTag, m, metaDataId);
        }
        return dataTag;
    }

    private static void encryptField(MetaDataSchema source_schema, Map<String, Object> dataTag, Map.Entry<String, Object> m, long metaDataId) {
        String field = m.getKey();
        if (null == field) {
            return;
        }
        boolean isEncrypt = source_schema.getIsEncrypt(field);
        DataType dataType = source_schema.getDataType(field);
        if (dataType instanceof RefType) {
            SchemaEncryptDataUtil.fromRefType(metaDataId, source_schema, dataTag, field, isEncrypt);
        } else if (dataType instanceof EntryType) {
            SchemaEncryptDataUtil.fromEntryType(metaDataId, source_schema, dataTag, field);
        } else if (field.contains("$K3CloudBizData")) {
            SchemaEncryptDataUtil.fromK3Model(metaDataId, m.getValue());
        } else {
            SchemaEncryptDataUtil.encrypt(dataTag, field, isEncrypt);
        }
    }

    private static void fromK3Model(long metaDataId, Object value) {
        if (value instanceof List) {
            List bizData = (List)value;
            Map md = (Map)bizData.get(1);
            SchemaEncryptDataUtil.getEncryptData(metaDataId, md.get("Model"));
        }
    }

    private static void fromEntryType(long metaDataId, MetaDataSchema source_schema, Map<String, Object> dataTag, String field) {
        block3: {
            Object dt;
            MetaDataSchema metaDataScheme;
            block2: {
                metaDataScheme = SchemaEncryptDataUtil.getMetaDataScheme(source_schema, field);
                dt = dataTag.get(field);
                if (!(dt instanceof List)) break block2;
                List entryList = (List)dt;
                for (Map map : entryList) {
                    SchemaEncryptDataUtil.getEncryptDataFromMap(metaDataScheme, metaDataId, map);
                }
                break block3;
            }
            if (!(dt instanceof Map)) break block3;
            Map entryMap = (Map)dt;
            for (Map.Entry<String, Object> entry : entryMap.entrySet()) {
                SchemaEncryptDataUtil.encryptField(metaDataScheme, entryMap, entry, metaDataId);
            }
        }
    }

    private static void fromRefType(long metaDataId, MetaDataSchema source_schema, Map<String, Object> dataTag, String field, boolean isEncryp) {
        MetaDataSchema metaDataScheme = SchemaEncryptDataUtil.getMetaDataScheme(source_schema, field);
        Object dt = dataTag.get(field);
        if (dt instanceof Map) {
            Map ref = (Map)dataTag.get(field);
            SchemaEncryptDataUtil.getEncryptDataFromMap(metaDataScheme, metaDataId, ref);
        } else {
            SchemaEncryptDataUtil.encrypt(dataTag, field, isEncryp);
        }
    }

    private static void encrypt(Map<String, Object> dataTag, String field, boolean isEncrypt) {
        if (isEncrypt) {
            dataTag.put(field, "******");
        }
    }

    private static MetaDataSchema getMetaDataScheme(MetaDataSchema source_schema, String field) {
        String dataSchema = source_schema.getDataSchema(field);
        QFilter qFilter = new QFilter("number", "=", (Object)dataSchema);
        return MetaDataSchema.getOneSchemaByFilter((QFilter)qFilter);
    }

    public static void setEncryptData2Model(IDataModel model, Object data_tag, DynamicObject isc_mq_data) {
        DynamicObject data_structure = isc_mq_data.getDynamicObject("data_structure");
        if (null != data_structure) {
            long pkValue = D.l((Object)data_structure.getPkValue());
            Object encryptData = SchemaEncryptDataUtil.getEncryptData(pkValue, data_tag);
            model.setValue("data", (Object)StringUtil.trim((Object)encryptData, (int)50));
            model.setValue("data_tag", encryptData);
        }
    }

    public static Object getVarTag(String encryptData) {
        try {
            Object data = null;
            if (encryptData == null) {
                data = null;
            } else if (encryptData.startsWith("{")) {
                data = JSONObject.parseObject((String)encryptData, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
            } else if (encryptData.startsWith("[")) {
                data = JSONObject.parseArray((String)encryptData);
            } else {
                return encryptData;
            }
            return JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        }
        catch (Exception e) {
            return encryptData;
        }
    }
}

