/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.log.es;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.log.es.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.log.es.EsLogUtil;
import kd.isc.iscb.util.dt.D;

public class EsLogFormPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String billtype = D.s((Object)this.getModel().getValue("billtype"));
        this.getView().setVisible(Boolean.valueOf(Util.canBeReverted(billtype)), new String[]{"btn_revert"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            String billType = D.s((Object)this.getModel().getValue("billtype"));
            long billId = D.l((Object)this.getModel().getValue("billId"));
            if ("preview".equals(args.getOperateKey())) {
                Util.showPreView(this.getView(), billType, billId);
            } else if ("revert".equals(args.getOperateKey())) {
                if (QueryServiceHelper.exists((String)billType, (Object)billId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8fd8\u539f\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\u3002", (String)"EsLogFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                } else {
                    this.showConfirm(billId);
                }
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void showConfirm(long billId) {
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("innerRevert", (IFormPlugin)this);
        DynamicObject esLog = EsLogUtil.queryIDAndType((Object)billId);
        String billtype = esLog.getString("billtype");
        String tips = ResManager.loadKDString((String)"\u5373\u5c06\u8fd8\u539f\u9009\u5b9a\u7684\u5386\u53f2\u65e5\u5fd7\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"EsLogFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        if ("isc_data_copy_exec_log".equals(billtype)) {
            tips = ResManager.loadKDString((String)"\u8fd8\u539f\u3010\u6267\u884c\u65e5\u5fd7\u3011\u4f1a\u5c06\u4f9d\u8d56\u7684\u3010\u6267\u884c\u7ed3\u679c\u3011\u4e5f\u4e00\u5e76\u8fd8\u539f\uff0c\u662f\u5426\u8fd8\u539f?", (String)"EsLogFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        this.getView().showConfirm(tips, MessageBoxOptions.YesNo, callBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"innerRevert", (CharSequence)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            String billtype = D.s((Object)this.getModel().getValue("billtype"));
            long id = D.l((Object)this.getModel().getValue("billId"));
            Util.revert(this.getView(), billtype, id);
        }
    }
}

