/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.log.es;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.log.es.EsLogUtil;

public class Util {
    private static final Set<String> canBeRevertedTypes = new HashSet<String>(Arrays.asList("isc_data_copy_execution", "isc_data_copy_exec_log", "isc_mq_data_published", "isc_mq_data_received", "isc_sf_proc_inst"));

    public static boolean canBeReverted(String billtype) {
        return canBeRevertedTypes.contains(billtype);
    }

    public static void showPreView(IFormView view, String billType, long billId) {
        HashMap<String, Long> params = new HashMap<String, Long>(8);
        params.put("preview_id", billId);
        Object p = Util.isBaseDataType(billType) ? new BaseShowParameter() : new FormShowParameter();
        p.setFormId(billType);
        p.setCustomParams(params);
        p.setStatus(OperationStatus.VIEW);
        p.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm((FormShowParameter)p);
    }

    public static void revert(IFormView view, String billType, long billId) {
        try {
            if (QueryServiceHelper.exists((String)billType, (Object)billId)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8fd8\u539f\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\u3002", (String)"Util_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                EsLogUtil.revertObjAndSave((String)billType, (long)billId);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u8fd8\u539f\u6210\u529f\u3002", (String)"Util_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(view, e);
        }
    }

    private static boolean isBaseDataType(String billtype) {
        return "isc_data_copy_execution".equals(billtype) || "isc_data_copy_taskstage".equals(billtype);
    }
}

