/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.log.op;

import java.util.Arrays;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class IscOperationLogListPlugin
extends AbstractListPlugin {
    public static final String SCHEMAID = "schemaid";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if ("view".equals(operationKey)) {
            Object selectedId = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
            if (selectedId == null) {
                return;
            }
            DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"isc_operation_log");
            String entity = log.getString("type.number");
            if ("isc_connection_type".equals(entity)) {
                if (this.objIsNotDeleted(entity, D.s((Object)log.get("number")))) {
                    FormOpener.showTabView((AbstractFormPlugin)this, entity, log.get("desc"));
                }
            } else if ("isc_service_flow_editor".equals(entity)) {
                if (D.x((Object)log.get("desc"))) {
                    if (this.objIsNotDeleted("isc_service_flow", log.get(SCHEMAID))) {
                        FormOpener.showFlowDiagramEditor((AbstractFormPlugin)this, log.getLong(SCHEMAID));
                    }
                } else if (this.objIsNotDeleted("isc_sf_proc_inst", log.get(SCHEMAID))) {
                    Util.openProcessDiagram((AbstractFormPlugin)this, log.getLong(SCHEMAID), "");
                }
            } else if ("isc_database_link".equals(entity)) {
                if (this.objIsNotDeleted(entity, log.get(SCHEMAID))) {
                    FormOpener.showDatabaseLinkForm((AbstractFormPlugin)this, log.getLong(SCHEMAID));
                }
            } else if ("isc_sf_event_param".equals(entity)) {
                if (this.objIsNotDeleted("isc_service_flow", log.get(SCHEMAID))) {
                    FormOpener.showTabViewIfNotExist((AbstractFormPlugin)this, "isc_service_flow", log.getLong(SCHEMAID));
                }
            } else if ("isc_event_trigger_param".equals(entity)) {
                FormOpener.showTabViewIfNotExist((AbstractFormPlugin)this, "isc_data_copy_trigger", log.getLong(SCHEMAID));
            } else if ("isc_app_params".equals(entity)) {
                FormOpener.showForm((AbstractFormPlugin)this, "isc_app_params", null);
            } else if ("isc_white_list".equals(entity)) {
                if (this.objIsNotDeleted(entity, log.get(SCHEMAID))) {
                    FormOpener.showView((AbstractFormPlugin)this, entity, log.get(SCHEMAID));
                }
            } else if (this.objIsNotDeleted(entity, log.get(SCHEMAID))) {
                BillShowParameter param = new BillShowParameter();
                param.setFormId(entity);
                param.setPkId(log.get(SCHEMAID));
                param.getOpenStyle().setShowType(this.getShowType(entity));
                param.setCustomParam("MUTEX_OBJ_ID", (Object)String.valueOf(log.get(SCHEMAID)));
                param.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    private ShowType getShowType(String entity) {
        List<String> list = Arrays.asList("isc_data_source", "isc_dataset_schema", "isc_apic_caller", "isc_value_conver_rule", "isc_env_variable");
        if (list.contains(entity)) {
            return ShowType.Modal;
        }
        return ShowType.MainNewTabPage;
    }

    private boolean objIsNotDeleted(String type, Object id) {
        QFilter qFilter = new QFilter("id", "=", id);
        DynamicObject obj = QueryServiceHelper.queryOne((String)type, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (obj == null) {
            String displayName = EntityMetadataCache.getDataEntityType((String)type).getDisplayName().toString();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e[%s]\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"IscOperationLogListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), displayName), Integer.valueOf(1500));
        }
        return obj != null;
    }

    private boolean objIsNotDeleted(String type, String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject obj = QueryServiceHelper.queryOne((String)type, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (obj == null) {
            String displayName = EntityMetadataCache.getDataEntityType((String)type).getDisplayName().toString();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e[%s]\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"IscOperationLogListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), displayName), Integer.valueOf(1500));
        }
        return obj != null;
    }
}

