/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.mq;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.mq.AbstractMqFormPlugin;
import kd.isc.iscb.formplugin.util.BatchSelectorsUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;

public class AbstractBillDataFormPlugin
extends AbstractMqFormPlugin
implements ClickListener,
CellClickListener {
    private static final String NUMBER = "number";
    private static final String DATA_TYPE = "data_type";
    private static final String OP_AUTO_FILL = "auto_fill";
    private static final String FIELD = "field";
    public static final String FIELDS_ENTRY = "fields";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELD});
        EntryGrid selectors = (EntryGrid)this.getView().getControl(FIELDS_ENTRY);
        selectors.addCellClickListener((CellClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_AUTO_FILL.equals(operateKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OP_AUTO_FILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u81ea\u52a8\u586b\u5145\u5c06\u8986\u76d6\u5df2\u9009\u62e9\u5b57\u6bb5\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"AbstractBillDataFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes == result && OP_AUTO_FILL.equals(messageBoxClosedEvent.getCallBackId())) {
            long metaId = D.l((Object)this.getModel().getValue("meta_data_id"));
            if (metaId != 0L) {
                this.autoFillFields(metaId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61!", (String)"AbstractBillDataFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void autoFillFields(long metaId) {
        DynamicObjectCollection fieldEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(FIELDS_ENTRY);
        fieldEntries.clear();
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)"isc_metadata_schema");
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject item : properties) {
            String data_type = item.getString(DATA_TYPE);
            if ("ENTRIES".equals(data_type)) continue;
            DynamicObject entry = fieldEntries.addNew();
            entry.set(FIELD, (Object)item.getString("prop_name"));
            entry.set(DATA_TYPE, (Object)data_type);
            entry.set("description", (Object)item.getString("prop_label"));
        }
        this.getView().updateView(FIELDS_ENTRY);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Map returnData = (Map)evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("get_property".equals(action)) {
            BatchSelectorsUtil.setReturnListValues(this.getView(), returnData, FIELDS_ENTRY, FIELD, "description", DATA_TYPE);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("message_queue") && e.getChangeSet().length == 1 && e.getChangeSet()[0].getNewValue() != null) {
            String formId = ((DynamicObject)e.getChangeSet()[0].getNewValue()).getDataEntityType().getName();
            this.generateDefaultValue(formId);
        }
    }

    private void generateDefaultValue(String formId) {
        Object messageQueueId = this.getModel().getValue("message_queue_id");
        if (messageQueueId != null && Long.parseLong(messageQueueId.toString()) != 0L) {
            DynamicObject messageQueue = BusinessDataServiceHelper.loadSingleFromCache((Object)messageQueueId, (String)formId);
            String name = messageQueue.getString("name");
            String number = messageQueue.getString(NUMBER);
            String randVarName = this.getAndCheckVarName(number);
            number = number + "_" + randVarName;
            name = name + "_" + randVarName;
            this.getModel().setValue("name", (Object)name);
            this.getModel().setValue(NUMBER, (Object)number);
        }
    }

    private String getAndCheckVarName(String number) {
        String randVarName = this.getRandVarName();
        String tmpNumber = number + "_" + randVarName;
        while (QueryServiceHelper.exists((String)this.getModel().getDataEntityType().getName(), (QFilter[])QFilterUtil.builder().put(NUMBER, "=", (Object)tmpNumber).build())) {
            randVarName = this.getRandVarName();
            tmpNumber = number + randVarName;
        }
        return randVarName;
    }

    private String getRandVarName() {
        String name = Hash.mur16((Object[])new Object[]{UUID.randomUUID()});
        char c = name.charAt(0);
        if (c < 'A') {
            name = (char)(c + 23) + name.substring(1);
        }
        return name;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        long metaId = this.getModel().getDataEntity().getLong("meta_data_id");
        if (metaId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61", (String)"AbstractBillDataFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        String fieldKey = evt.getFieldKey();
        if (FIELD.equals(fieldKey)) {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("id", metaId);
            param.put("$type", fieldKey);
            param.put("$row", evt.getRow());
            FormOpener.showForm(this, "isc_sf_field_slected", ResManager.loadKDString((String)"\u9009\u62e9\u5bf9\u8c61\u5c5e\u6027", (String)"AbstractBillDataFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_property");
        }
    }
}

