/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.mq;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.hub.HubTriggerEventChecker;
import kd.isc.iscb.formplugin.mq.AbstractBillDataFormPlugin;
import kd.isc.iscb.formplugin.mq.BillDataPublishListPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class BillDataPublishFormPlugin
extends AbstractBillDataFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operationKey = operate.getOperateKey();
        long id = D.l((Object)this.getModel().getValue("id"));
        try {
            if ("save".equals(operationKey)) {
                this.checkEnable("isc_mq_bill_data_pub", evt);
                HubTriggerEventChecker.checkActions(this.getView(), evt, D.l((Object)this.getModel().getValue("meta_data_id")), this.getModel().getValue("events"));
            } else if ("enable".equalsIgnoreCase(operationKey)) {
                if (id != 0L) {
                    DynamicObject listener = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_mq_bill_data_pub");
                    BillDataPublishListPlugin.submit(new DynamicObject[]{listener});
                }
            } else if ("disable".equalsIgnoreCase(operationKey)) {
                if (id != 0L) {
                    DynamicObject listener = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_mq_bill_data_pub");
                    this.disableStatus(listener);
                    this.getView().setStatus(OperationStatus.EDIT);
                }
            } else if ("modify".equals(operationKey)) {
                this.checkEnable("isc_mq_bill_data_pub", evt);
            }
        }
        catch (Exception e) {
            evt.setCancel(true);
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    @Override
    protected void disableStatus(DynamicObject listener) {
        BillDataPublishListPlugin.cancel(new DynamicObject[]{listener});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadEvents();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("meta_data")) {
            DynamicObject meta = (DynamicObject)this.getModel().getValue("meta_data");
            this.getModel().setValue("group", meta != null ? meta.get("group_id") : null);
            this.loadEvents();
        }
    }

    private void loadEvents() {
        long metaId = (Long)this.getModel().getValue("meta_data_id");
        if (metaId != 0L) {
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)"isc_metadata_schema");
            DynamicObjectCollection events = meta.getDynamicObjectCollection("event_entryentity");
            this.addEventComboItems(events);
        }
    }

    private void addEventComboItems(DynamicObjectCollection events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        ComboEdit combo = (ComboEdit)this.getView().getControl("events");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(events.size());
        for (DynamicObject e : events) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(e.getString("event_label")));
            item.setValue(e.getString("event_number"));
            items.add(item);
        }
        combo.setComboItems(items);
    }
}

