/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.mq;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.mq.support.QueueManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.mq.AbstractMqFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServerFactory;
import kd.isc.iscb.platform.core.factory.FactoryManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class MessagePublisherFormPlugin
extends AbstractMqFormPlugin {
    private static final String TYPE = "type";
    private static final String DATA_STRUCTURE = "data_structure";
    private static final String DATA_STRUCTURE_ID = "data_structure_id";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCustomParam();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"custom_config"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("custom_config".equals(c.getKey())) {
            Map<String, Object> config = this.getConfig();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("configuration", Json.toString(config, (boolean)true));
            param.put("edit", Boolean.TRUE);
            String caption = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u914d\u7f6e", (String)"MessageSubscriberFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            FormOpener.showForm(this, "isc_param_custom_config", caption, param, "getCustomParam");
        }
    }

    private Map<String, Object> getConfig() {
        String configValue = D.s((Object)this.getModel().getValue("custom_config"));
        Map<String, Object> defaultConfig = this.getDefaultConfig();
        if (StringUtil.isEmpty((String)configValue)) {
            return defaultConfig;
        }
        Map configItems = (Map)Json.toObject((String)configValue);
        for (Map.Entry<String, Object> item : defaultConfig.entrySet()) {
            item.setValue(configItems.get(item.getKey()));
        }
        return configItems;
    }

    private Map<String, Object> getDefaultConfig() {
        DynamicObject server = this.getModel().getDataEntity(true).getDynamicObject("group");
        Object factory = FactoryManager.get((String)server.getString(TYPE));
        if (factory instanceof MessageQueueServerFactory) {
            MessageQueueServerFactory mqFactory = (MessageQueueServerFactory)factory;
            return mqFactory.getDefaultConfig();
        }
        return Collections.emptyMap();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnMap;
        super.closedCallBack(evt);
        if ("getCustomParam".equals(evt.getActionId()) && evt.getReturnData() != null && (returnMap = (Map)Json.toObject((String)evt.getReturnData().toString())) != null && !returnMap.isEmpty()) {
            this.getModel().setValue("custom_config", evt.getReturnData());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            if (this.checkEnable("isc_mq_publisher", e)) {
                return;
            }
            Object serverId = this.getModel().getValue("group_id");
            String number = D.s((Object)this.getModel().getValue("number"));
            if (MessagePublisherFormPlugin.checkInnerRabbitNumber(this.getView(), e, serverId, number)) {
                return;
            }
            long dataStructureId = D.l((Object)this.getModel().getValue(DATA_STRUCTURE_ID));
            if (dataStructureId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7ed3\u6784\u672a\u9009\u62e9!", (String)"MessagePublisherFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            }
        }
    }

    public static boolean checkInnerRabbitNumber(IFormView view, BeforeDoOperationEventArgs e, Object serverId, String number) {
        DynamicObject server = BusinessDataServiceHelper.loadSingle((Object)serverId, (String)"isc_mq_server", (String)TYPE);
        if ("InternalRabbit".equals(server.getString(TYPE))) {
            if (!number.contains(".")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u683c\u5f0f\u4e3a\uff1aregion.queue !", (String)"MessagePublisherFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                e.setCancel(true);
                return true;
            }
            String[] topics = number.split("\\.", 2);
            if (QueueManager.get((String)topics[0], (String)topics[1]) == null) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s \u6d88\u606f\u961f\u5217\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u5185\u90e8\u961f\u5217\uff0c\u961f\u5217\u4fe1\u606f\u3001\u6570\u636e\u683c\u5f0f\u53ca\u6ce8\u610f\u4e8b\u9879\u8bf7\u8054\u7cfb\u76ee\u6807\u5355\u6240\u5728\u90e8\u95e8\uff0c\u6216\u4e8c\u6b21\u5f00\u53d1\u63d0\u4f9b\uff08\u901a\u5e38\u5e94\u8be5\u662f\u7531\u9879\u76ee\u7684\u4e8c\u6b21\u5f00\u53d1\u5b9e\u73b0\u6d88\u606f\u7684\u6d88\u8d39\u8005\uff0c\u5e76\u5b8c\u6210\u6d88\u606f\u961f\u5217\u5728\u5e73\u53f0\u4e2d\u7684\u6ce8\u518c\uff09\u3002", (String)"MessagePublisherFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number), Integer.valueOf(3000));
                e.setCancel(true);
                return true;
            }
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (DATA_STRUCTURE.equals(property)) {
            DynamicObject datasource = (DynamicObject)this.getModel().getValue(DATA_STRUCTURE);
            if (datasource == null) {
                this.getModel().setValue("data_source", null);
                return;
            }
            Object dsId = datasource.get("group_id");
            this.getModel().setValue("data_source", dsId);
        } else if ("group".equals(property)) {
            this.setCustomParam();
        }
    }

    private void setCustomParam() {
        DynamicObject server = this.getModel().getDataEntity(true).getDynamicObject("group");
        if (server == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"custom_config"});
            this.getModel().setValue("custom_config", null);
        } else {
            Object factory = FactoryManager.get((String)server.getString(TYPE));
            if (factory instanceof MessageQueueServerFactory) {
                MessageQueueServerFactory mqFactory = (MessageQueueServerFactory)factory;
                this.getView().setEnable(Boolean.valueOf(mqFactory.supportCustomParam()), new String[]{"custom_config"});
                if (!mqFactory.supportCustomParam()) {
                    this.getModel().setValue("custom_config", null);
                }
            }
        }
    }
}

