/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.mq;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.isc.iscb.formplugin.mq.AbstractMqFormPlugin;
import kd.isc.iscb.formplugin.mq.MessagePublisherFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueInitiator;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServerFactory;
import kd.isc.iscb.platform.core.factory.FactoryManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class MessageSubscriberFormPlugin
extends AbstractMqFormPlugin {
    private static final String DATA_STRUCTURE = "data_structure";
    private static final String DATA_STRUCTURE_ID = "data_structure_id";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCustomParam();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"custom_config"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("custom_config".equals(c.getKey())) {
            Map<String, Object> config = this.getConfig();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("configuration", Json.toString(config, (boolean)true));
            param.put("edit", Boolean.TRUE);
            String caption = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u914d\u7f6e", (String)"MessageSubscriberFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            FormOpener.showForm(this, "isc_param_custom_config", caption, param, "getCustomParam");
        }
    }

    private Map<String, Object> getConfig() {
        String configValue = D.s((Object)this.getModel().getValue("custom_config"));
        Map<String, Object> defaultConfig = this.getDefaultConfig();
        if (StringUtil.isEmpty((String)configValue)) {
            return defaultConfig;
        }
        Map configItems = (Map)Json.toObject((String)configValue);
        for (Map.Entry<String, Object> item : defaultConfig.entrySet()) {
            item.setValue(configItems.get(item.getKey()));
        }
        return configItems;
    }

    private Map<String, Object> getDefaultConfig() {
        DynamicObject server = this.getModel().getDataEntity(true).getDynamicObject("group");
        Object factory = FactoryManager.get((String)server.getString("type"));
        if (factory instanceof MessageQueueServerFactory) {
            MessageQueueServerFactory mqFactory = (MessageQueueServerFactory)factory;
            return mqFactory.getDefaultConfig();
        }
        return Collections.emptyMap();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnMap;
        super.closedCallBack(evt);
        if ("getCustomParam".equals(evt.getActionId()) && evt.getReturnData() != null && (returnMap = (Map)Json.toObject((String)evt.getReturnData().toString())) != null && !returnMap.isEmpty()) {
            this.getModel().setValue("custom_config", evt.getReturnData());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (e.getSource() instanceof Save) {
            if (this.checkEnable("isc_mq_subscriber", e)) {
                return;
            }
            Object serverId = this.getModel().getValue("group_id");
            String number = D.s((Object)this.getModel().getValue("number"));
            if (MessagePublisherFormPlugin.checkInnerRabbitNumber(this.getView(), e, serverId, number)) {
                return;
            }
            long dataStructureId = D.l((Object)this.getModel().getValue(DATA_STRUCTURE_ID));
            if (dataStructureId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7ed3\u6784\u672a\u9009\u62e9!", (String)"MessageSubscriberFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("enable".equalsIgnoreCase(key) || "disable".equalsIgnoreCase(key)) {
            this.disableStatus(null);
        }
    }

    @Override
    protected void disableStatus(DynamicObject entity) {
        long id = D.l((Object)this.getModel().getValue("id"));
        if (id != 0L) {
            try {
                MessageQueueInitiator.resetListeners(Collections.singletonList(id));
            }
            catch (Exception exception) {
                this.getView().showMessage(ShowStackTraceUtil.getErrorMsg(exception));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (DATA_STRUCTURE.equals(property)) {
            DynamicObject datasource = (DynamicObject)this.getModel().getValue(DATA_STRUCTURE);
            if (datasource == null) {
                this.getModel().setValue("data_source", null);
                return;
            }
            Object dsId = datasource.get("group_id");
            this.getModel().setValue("data_source", dsId);
        } else if ("group".equals(property)) {
            this.setCustomParam();
        }
    }

    private void setCustomParam() {
        DynamicObject server = this.getModel().getDataEntity(true).getDynamicObject("group");
        if (server == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"custom_config"});
            this.getModel().setValue("custom_config", null);
        } else {
            Object factory = FactoryManager.get((String)server.getString("type"));
            if (factory instanceof MessageQueueServerFactory) {
                MessageQueueServerFactory mqFactory = (MessageQueueServerFactory)factory;
                this.getView().setEnable(Boolean.valueOf(mqFactory.supportCustomParam()), new String[]{"custom_config"});
                if (!mqFactory.supportCustomParam()) {
                    this.getModel().setValue("custom_config", null);
                }
            }
        }
    }
}

