/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.mq;

import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueInitiator;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;

public class MqServerListPlugin
extends AbstractListPlugin {
    private static final String ISC_MQ_SERVER = "isc_mq_server";
    private static final String ENABLE = "enable";
    private static final String LICENSE_SN = "license_sn";
    private static final String LICENSE_INFO = "license_info";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if (ENABLE.equals(operateKey)) {
            this.establishConnection(e);
        } else if ("disable".equals(operateKey)) {
            this.disableListeners(e);
        } else if ("reconnect".equals(operateKey)) {
            this.reConnect(e);
        } else if ("modify".equals(operateKey)) {
            this.modify(e);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
        String taskId = "RefreshConnectionLicenseInfo1";
        if (!TaskManager.exists((String)taskId)) {
            this.asyncRefreshLicenseInfo(taskId);
        }
    }

    private void asyncRefreshLicenseInfo(final String taskId) {
        TaskManager.submit((Task)new Task(){

            public String getId() {
                return taskId;
            }

            public void run() {
                DynamicObject[] links = BusinessDataServiceHelper.load((String)MqServerListPlugin.ISC_MQ_SERVER, (String)"type, license_info,license_sn", null);
                MqServerListPlugin.this.setLicenseInfo(Arrays.asList(links));
                SaveServiceHelper.save((DynamicObject[])links);
            }
        });
    }

    private void setLicenseInfo(Collection<DynamicObject> links) {
        if (links.isEmpty()) {
            return;
        }
        AccountInfo account = LicenseCache.getTenant().getCurrentAccount();
        if (account == null) {
            account = LicenseCache.refreshTenant().getCurrentAccount();
        }
        for (DynamicObject link : links) {
            long id = link.getLong("id");
            ConnectionInfo cn = account.getMqConnection(id);
            if (cn == null) {
                account = LicenseCache.refreshTenant().getCurrentAccount();
                cn = account.getMqConnection(id);
            }
            if (cn == null) continue;
            link.set(LICENSE_INFO, (Object)cn.getStateString());
            link.set(LICENSE_SN, (Object)cn.getLicenseSN());
        }
    }

    private void modify(BeforeDoOperationEventArgs evt) {
        ListSelectedRow pk;
        DynamicObject trigger;
        ListSelectedRowCollection selectedData = evt.getListSelectedData();
        if (selectedData.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e.", (String)"MqServerListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if ((trigger = BusinessDataServiceHelper.loadSingleFromCache((Object)D.l((Object)(pk = selectedData.get(0))), (String)ISC_MQ_SERVER, (String)"id,enable")).getString(ENABLE).equalsIgnoreCase("1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u542f\u7528\u4e2d\uff0c\u8bf7\u5148\u7981\u7528\u540e\u4fee\u6539\u3002", (String)"MqServerListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void reConnect(BeforeDoOperationEventArgs evt) {
        long id = this.getSelectedRowId(evt);
        if (id == 0L) {
            return;
        }
        try {
            DynamicObject mqServer = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_MQ_SERVER, (String)ENABLE);
            if (!"1".equals(mqServer.getString(ENABLE))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u672a\u542f\u7528\uff0c\u7981\u6b62\u91cd\u8fde\u64cd\u4f5c", (String)"MqServerListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            MessageQueueManager.reset((long)id);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u8fde\u6210\u529f!", (String)"MqServerListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void establishConnection(BeforeDoOperationEventArgs evt) {
        long id = this.getSelectedRowId(evt);
        if (id == 0L) {
            return;
        }
        try {
            MessageQueueManager.get((long)id);
        }
        catch (Exception e2) {
            evt.setCancel(true);
            FormOpener.showErrorMessage(this.getView(), e2);
        }
    }

    private void disableListeners(BeforeDoOperationEventArgs evt) {
        long id = this.getSelectedRowId(evt);
        if (id == 0L) {
            return;
        }
        try {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_MQ_SERVER, (String)ENABLE);
            if (D.x((Object)object.get(ENABLE))) {
                MessageQueueInitiator.disableAllListeners((long)id);
                MessageQueueManager.remove((long)id);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private long getSelectedRowId(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection selectedData = evt.getListSelectedData();
        if (CollectionUtils.isEmpty((Collection)selectedData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u3002", (String)"MqServerListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return 0L;
        }
        if (selectedData.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"MqServerListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return 0L;
        }
        return D.l((Object)selectedData.get(0));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)ISC_MQ_SERVER, (String)"type");
        String type = D.s((Object)cfg.get("type"));
        try {
            FormOpener.showView((AbstractFormPlugin)this, DatabaseType.getForm((String)type), selectedId);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6d88\u606f\u961f\u5217\u670d\u52a1\u5de5\u5382\u7c7b\u8def\u5f84\u672a\u627e\u5230\u8be5\u7c7b\u3002\uff1a%s\u5982\u9700\u4f7f\u7528\u8be5\u5de5\u5382\u7c7b\uff0c\u9700\u8054\u7cfb\u96c6\u6210\u4e91\u90e8\u95e8\u4eba\u5458\u63d0\u4f9b\u5bf9\u5e94\u90e8\u7f72\u5305\u3002", (String)"MqServerListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)MqServerListPlugin.LICENSE_INFO)) {
                return rows;
            }
            MqServerListPlugin.this.setLicenseInfo((Collection)rows);
            return rows;
        }
    }
}

