/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.msg;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MsgUtil;
import kd.isc.iscb.platform.core.connector.notice.LinkPropertyEnum;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.DblinkMessageUtil;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class DblinkMessageFormPlugin
extends AbstractFormPlugin {
    private static final String OUTSIDEPERSON = "outsideperson";
    private static final String MSGCONTENT = "msg_content";
    private static final String ISC_BASE_NOTICE = "isc_base_notice";
    private static final String ISC_MSG_PERSONPHONE = "isc_msg_phonenumber";
    private static final String MSGCONTENT_SELECT = "msgcontent_select";
    private static final String PERSONPHONE_SELECT = "personphone_select";
    private static final String PERSON = "person";
    private static final Pattern REGEX = Pattern.compile("(?<=\\()\\d+(?=\\))");
    private static final String BOS_USER = "bos_user";
    private static final String PERSON_SELECT = "person_select";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PERSON, MSGCONTENT, OUTSIDEPERSON});
    }

    public void beforeBindData(EventObject e) {
        Object linkId = this.getView().getFormShowParameter().getCustomParam("link");
        if (linkId != null) {
            DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)linkId, (String)"isc_database_link");
            this.setDefaultValue(link);
            this.getView().setEnable(Boolean.FALSE, new String[]{"dblink"});
        }
    }

    public void setDefaultValue(DynamicObject dblink) {
        this.getView().getModel().setValue("dblink", (Object)dblink);
        this.getView().getModel().setValue("msg_title", (Object)String.format(ResManager.loadKDString((String)"%s\u8fde\u63a5\u5f02\u5e38", (String)"DblinkMessageFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dblink.getString("name")));
    }

    public void click(EventObject evt) {
        String operationKey = ((Control)evt.getSource()).getKey();
        if (MSGCONTENT.equals(operationKey)) {
            this.showBaseForm();
        } else if (OUTSIDEPERSON.equals(operationKey)) {
            this.getView().showForm(MsgUtil.getFormParam(ISC_MSG_PERSONPHONE, false, ShowType.Modal, "value", this.getModel().getValue(OUTSIDEPERSON), new CloseCallBack((IFormPlugin)this, PERSONPHONE_SELECT)));
        } else if (PERSON.equals(operationKey)) {
            this.showPersonForm();
        }
    }

    public void showPersonForm() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BOS_USER, (boolean)true, (int)0);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PERSON_SELECT));
        String person = (String)this.getModel().getValue(PERSON);
        Matcher matcher = REGEX.matcher(person);
        ArrayList<String> pks = new ArrayList<String>();
        while (matcher.find()) {
            pks.add(matcher.group());
        }
        parameter.setSelectedRows(pks.toArray());
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void showBaseForm() {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("entityName", "isc_database_link");
        params.put("value", this.getModel().getValue(MSGCONTENT));
        params.put("properties", this.getPropertiesMap());
        FormOpener.showForm(this, ISC_BASE_NOTICE, ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9", (String)"DblinkMessageFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, MSGCONTENT_SELECT);
    }

    private Object getPropertiesMap() {
        LinkPropertyEnum[] properties = LinkPropertyEnum.values();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (LinkPropertyEnum property : properties) {
            map.put(String.valueOf(property), property.getDesc());
        }
        map.put("error_info", ResManager.loadKDString((String)"\u5b8c\u6574\u9519\u8bef\u5806\u6808", (String)"DblinkMessageFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        map.put("error_message", ResManager.loadKDString((String)"\u9519\u8bef\u6d88\u606f", (String)"DblinkMessageFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        return map;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        Map params;
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if ("enable".equals(operationKey)) {
            String noticeId = D.s((Object)this.getModel().getValue("id"));
            DblinkMessageUtil.enable((String)noticeId);
        } else if ("disable".equals(operationKey)) {
            DblinkMessageUtil.disable((String)D.s((Object)this.getModel().getValue("id")));
        } else if ("modify".equals(operationKey)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("save".equals(operationKey) && evt.getOperationResult().isSuccess() && D.x((params = this.getView().getFormShowParameter().getCustomParams()).get("is_guide_mode"))) {
            this.getView().getParentView().getPageCache().put("message_id", D.s((Object)this.getModel().getValue("id")));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("dblink".equals(property)) {
            Object linkid = this.getModel().getValue("dblink_id");
            if (!CommonUtil.isEmpty((Object)e.getChangeSet()[0].getNewValue())) {
                DynamicObject dblink = BusinessDataServiceHelper.loadSingle((Object)linkid, (String)"isc_database_link");
                this.getView().getModel().setValue("msg_title", (Object)String.format(ResManager.loadKDString((String)"%s\u8fde\u63a5\u5f02\u5e38", (String)"DblinkMessageFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dblink.getString("name")));
            } else {
                this.getView().getModel().setValue("msg_title", null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (MSGCONTENT_SELECT.equalsIgnoreCase(actionId)) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            if (map != null && !map.isEmpty()) {
                String content = (String)map.get("content");
                this.getModel().setValue(MSGCONTENT, (Object)content);
            }
        } else if (PERSONPHONE_SELECT.equalsIgnoreCase(actionId)) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            if (map != null && !map.isEmpty()) {
                String content = (String)map.get("person_phone");
                this.getModel().setValue(OUTSIDEPERSON, (Object)MsgUtil.replaceSymbol(content));
            }
        } else if (PERSON_SELECT.equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            MsgUtil.setEntryFromClosedCallBack(lsrc, BOS_USER, PERSON, this.getModel());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (D.x(params.get("is_guide_mode"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
        }
        boolean empty = StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(OUTSIDEPERSON)));
        this.getView().setVisible(Boolean.valueOf(!empty), new String[]{OUTSIDEPERSON});
        String msg_content = D.s((Object)this.getModel().getValue(MSGCONTENT));
        if (msg_content == null) {
            this.getModel().setValue(MSGCONTENT, (Object)ResManager.loadKDString((String)"\u8fde\u63a5\u540d\u79f0\uff1a#{name} \uff1b\u8fde\u63a5\u7f16\u7801\uff1a#{number}\uff1b\u8fde\u63a5\u72b6\u6001\uff1a#{state}\uff1b\u670d\u52a1\u5668IP\uff1a#{server_ip}\uff0c\u7aef\u53e3\uff1a#{server_port}\uff0c\u8bb8\u53ef\u72b6\u6001\uff1a#{license_info}\uff0c\u9519\u8bef\u6d88\u606f\uff1a#{error_message}\u3002", (String)"DblinkMessageFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter[] qfs;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        long id = D.l((Object)this.getModel().getValue("id"));
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("modify", (IFormPlugin)this);
        if (args.getSource() instanceof Save && id > 0L && "1".equals(this.getModel().getValue("state"))) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8fde\u63a5\u901a\u77e5\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DblinkMessageFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else if ("modify".equals(operationKey) && QueryServiceHelper.exists((String)"isc_link_notification", (QFilter[])(qfs = QFilterUtil.builder().put("id", "=", this.getModel().getValue("id")).put("state", "=", (Object)"1").build()))) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8fde\u63a5\u901a\u77e5\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DblinkMessageFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult() && "modify".equals(evt.getCallBackId())) {
            String id = D.s((Object)this.getModel().getValue("id"));
            DblinkMessageUtil.disable((String)id);
            this.getView().invokeOperation("disable");
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }
}

