/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.msg;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MsgUtil;
import kd.isc.iscb.platform.core.constant.MessageType;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.platform.core.util.SfMessageUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class FlowMessageFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String IERP_PERSON = "recipient";
    private static final String OUTSIDE_PERSON = "recipient_noterp";
    private static final String VAR_PERSON = "recipientvar_erp";
    private static final String VAR_OUTSIDE_PERSON = "recipientvar_noterp";
    private static final String PERSON_SELECT = "person_select";
    private static final String OUTSIDE_PERSON_SELECT = "personphone_select";
    private static final String VAR_PERSON_SELECT = "recipientvar_erp_select";
    private static final String VAR_OUTSIDE_PERSON_SELECT = "recipientvar_noterp";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String TITLE_CALLBACK = "title_callback";
    private static final String CONTENT_CALLBACK = "content_callback";
    private static final String ISC_BASE_NOTICE = "isc_base_notice";
    private static final String DISABLE_CALLBACK = "disable_callback";
    private static final Pattern REGEX = Pattern.compile("(?<=\\()\\d+(?=\\))");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{IERP_PERSON, OUTSIDE_PERSON, VAR_PERSON, "recipientvar_noterp", TITLE, CONTENT});
    }

    public void beforeBindData(EventObject e) {
        int l = MessageType.values().length;
        ComboEdit combo = (ComboEdit)this.getView().getControl("target_system");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(l);
        for (MessageType messageType : MessageType.values()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(((MultiLangEnumBridge)messageType.getName().getB()).loadKDString()));
            item.setValue((String)messageType.getName().getA());
            items.add(item);
        }
        combo.setComboItems(items);
    }

    public void afterBindData(EventObject e) {
        String msg_content;
        super.afterBindData(e);
        String target_system = D.s((Object)this.getModel().getValue("target_system"));
        if (target_system != null) {
            MsgUtil.setNoticeMethod(target_system, this.getView());
        }
        this.getModel().setValue("target_system", (Object)"COSMIC");
        this.getModel().setValue("notice_method", (Object)"system_message");
        boolean recipient_noterp = StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(OUTSIDE_PERSON)));
        boolean recipientvar_noterp = StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("recipientvar_noterp")));
        this.getView().setVisible(Boolean.valueOf(!recipient_noterp), new String[]{OUTSIDE_PERSON});
        this.getView().setVisible(Boolean.valueOf(!recipientvar_noterp), new String[]{"recipientvar_noterp"});
        String msg_title = D.s((Object)this.getModel().getValue(TITLE));
        if (msg_title == null) {
            this.getModel().setValue(TITLE, (Object)ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u201c#{$process.flow.name} \u201d\u901a\u77e5", (String)"FlowMessageFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if ((msg_content = D.s((Object)this.getModel().getValue(CONTENT))) == null) {
            this.getModel().setValue(CONTENT, (Object)ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\uff1a#{$process.flow.name}\uff08\u7f16\u7801\uff1a#{$process.flow.number}\uff09, \u7531 #{$process.creator.name} \u5728 #{$process.created_time} \u542f\u52a8\uff0c\u5f53\u524d\u72b6\u6001 : #{$process.state}\u3002", (String)"FlowMessageFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if ("target_system".equals(prop)) {
            MsgUtil.setNoticeMethod(D.s((Object)this.getModel().getValue("target_system")), this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String operationKey = operate.getOperateKey();
        if (e.getSource() instanceof Save) {
            this.disableBeforeDoOperation(e, ResManager.loadKDString((String)"\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"FlowMessageFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("modify".equals(operationKey)) {
            this.disableBeforeDoOperation(e, ResManager.loadKDString((String)"\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"FlowMessageFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void disableBeforeDoOperation(BeforeDoOperationEventArgs e, String tips) {
        QFilter[] qfs = QFilterUtil.builder().put("id", "=", this.getModel().getValue("id")).put("status", "=", (Object)"1").build();
        if (QueryServiceHelper.exists((String)"isc_flow_notification", (QFilter[])qfs)) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DISABLE_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("modify".equals(key)) {
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (IERP_PERSON.equals(key)) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true, (int)0);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PERSON_SELECT));
            String person = (String)this.getModel().getValue(IERP_PERSON);
            Matcher matcher = REGEX.matcher(person);
            ArrayList<String> pks = new ArrayList<String>();
            while (matcher.find()) {
                pks.add(matcher.group());
            }
            parameter.setSelectedRows(pks.toArray());
            this.getView().showForm((FormShowParameter)parameter);
        } else if (OUTSIDE_PERSON.equals(key)) {
            this.getView().showForm(MsgUtil.getFormParam("isc_msg_phonenumber", false, ShowType.Modal, "value", this.getModel().getValue(OUTSIDE_PERSON), new CloseCallBack((IFormPlugin)this, OUTSIDE_PERSON_SELECT)));
        } else if (VAR_PERSON.equals(key)) {
            if (this.checkFlowNotNull()) {
                return;
            }
            this.selectNoticeVar(VAR_PERSON, VAR_PERSON_SELECT);
        } else if ("recipientvar_noterp".equals(key)) {
            if (this.checkFlowNotNull()) {
                return;
            }
            this.selectNoticeVar("recipientvar_noterp", "recipientvar_noterp");
        } else if (TITLE.equals(key)) {
            this.showBaseForm(TITLE, TITLE_CALLBACK);
        } else if (CONTENT.equals(key)) {
            this.showBaseForm(CONTENT, CONTENT_CALLBACK);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (PERSON_SELECT.equals(actionId)) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            MsgUtil.setEntryFromClosedCallBack(lsrc, "bos_user", IERP_PERSON, this.getModel());
        } else if (OUTSIDE_PERSON_SELECT.equals(actionId)) {
            Map map2 = (Map)returnData;
            if (map2 != null && !map2.isEmpty()) {
                String content = (String)map2.get("person_phone");
                this.getModel().setValue(OUTSIDE_PERSON, (Object)MsgUtil.replaceSymbol(content));
            }
        } else if (VAR_PERSON_SELECT.equals(actionId)) {
            MsgUtil.setNoticeVar(returnData, this.getModel());
        } else if ("recipientvar_noterp".equals(actionId)) {
            MsgUtil.setNoticeVar(returnData, this.getModel());
        } else if (TITLE_CALLBACK.equals(actionId)) {
            Map map3 = (Map)returnData;
            if (map3 != null && !map3.isEmpty()) {
                String content = (String)map3.get(CONTENT);
                this.getModel().setValue(TITLE, (Object)content);
            }
        } else if (CONTENT_CALLBACK.equals(actionId) && (map = (Map)returnData) != null && !map.isEmpty()) {
            String content = (String)map.get(CONTENT);
            this.getModel().setValue(CONTENT, (Object)content);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if (DISABLE_CALLBACK.equals(evt.getCallBackId())) {
            this.getView().invokeOperation("disable");
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    private boolean checkFlowNotNull() {
        if (this.getModel().getValue("flow") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u670d\u52a1\u6d41\u7a0b\u3002", (String)"FlowMessageFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return true;
        }
        return false;
    }

    private void selectNoticeVar(String key, String set_notice_var_noterp) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        long flowId = D.l((Object)this.getModel().getValue("flow_id"));
        param.put("flow_id", flowId);
        param.put("key", key);
        param.put("multi", "1");
        FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"FlowMessageFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, set_notice_var_noterp);
    }

    public void showBaseForm(String content, String callBack) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("entityName", "isc_service_flow");
        params.put("value", this.getModel().getValue(content));
        params.put("properties", this.getPropertiesMap());
        FormOpener.showForm(this, ISC_BASE_NOTICE, ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9", (String)"FlowMessageFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, callBack);
    }

    private Object getPropertiesMap() {
        SfMessageUtil.SfProperty[] properties = SfMessageUtil.SfProperty.values();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (SfMessageUtil.SfProperty property : properties) {
            map.put(property.getPro(), property.getDesc());
        }
        return map;
    }
}

