/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.msg;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.util.MsgUtil;

public class MsgNotificationFormPlugin
extends AbstractFormPlugin {
    private static final String ADDNEW_BTN = "addnew_btn";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String NUMBER_CODE = "number";
    private static final String NAME_CODE = "name";
    private static final String PERSON = "person";
    private static final String WBPERSON = "wbperson";
    private static final String MSGCONTENT = "msgcontent";
    private static final String BOS_USER = "bos_user";
    private static final String ISC_MSG_NOTIFICATION = "isc_msg_notification";
    private static final String ISC_MSG_CONTEXT = "isc_msg_context";
    private static final String ISC_MSG_PERSONCELLINFO = "isc_msg_personcellinfo";
    private static final String MSGCONTENTREGISTER = "msgcontentRegister";
    private static final String MSGPERSONCONTENT = "msgpersoncontent";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
        this.addClickListeners(new String[]{PERSON, MSGCONTENT, WBPERSON});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (ADDNEW_BTN.equals(key)) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 1);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(NUMBER_CODE, (Object)MsgUtil.getMsgNumber());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss");
        this.getModel().setValue(NAME_CODE, (Object)(MsgNotificationFormPlugin.getTipsCode() + format.format(new Date())));
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (PERSON.equals(key)) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BOS_USER, (boolean)true, (int)0);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ISC_MSG_NOTIFICATION));
            String person = (String)this.getModel().getValue(PERSON);
            String[] persons = null;
            ArrayList<String> pks = null;
            if (person != null && !StringUtils.isEmpty((String)person)) {
                persons = person.split(",");
                pks = new ArrayList<String>(persons.length);
                for (String p : persons) {
                    pks.add(p.substring(p.indexOf(40) + 1, p.indexOf(41)));
                }
                parameter.setSelectedRows(pks.toArray(new Object[pks.size()]));
            }
            this.getView().showForm((FormShowParameter)parameter);
        } else if (MSGCONTENT.equals(key)) {
            this.getView().showForm(MsgUtil.getFormParam(ISC_MSG_CONTEXT, false, ShowType.Modal, "value", this.getModel().getValue(MSGCONTENT), new CloseCallBack((IFormPlugin)this, MSGCONTENTREGISTER)));
        } else if (WBPERSON.equals(key)) {
            this.getView().showForm(MsgUtil.getFormParam(ISC_MSG_PERSONCELLINFO, false, ShowType.Modal, "value", this.getModel().getValue(WBPERSON), new CloseCallBack((IFormPlugin)this, MSGPERSONCONTENT)));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        super.closedCallBack(closedCallBackEvent);
        if (ISC_MSG_NOTIFICATION.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (lsrc == null || lsrc.isEmpty()) {
                return;
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)BOS_USER);
            DynamicObject[] dos = null;
            ArrayList<Long> selectedIds = new ArrayList<Long>();
            for (ListSelectedRow row : lsrc) {
                selectedIds.add((Long)row.getPrimaryKeyValue());
            }
            dos = BusinessDataServiceHelper.load((Object[])selectedIds.toArray(), (DynamicObjectType)type);
            if (dos == null || dos.length == 0) {
                return;
            }
            StringBuilder userName = new StringBuilder();
            for (int i = 0; i < dos.length; ++i) {
                if (i == dos.length - 1) {
                    userName.append(dos[i].getString(NAME_CODE)).append('(').append(dos[i].getString("id")).append(')');
                    continue;
                }
                userName.append(dos[i].getString(NAME_CODE)).append('(').append(dos[i].getString("id")).append("),");
            }
            if (StringUtils.isNotEmpty((String)userName.toString())) {
                MsgUtil.setContent(this.getModel(), (EntryGrid)this.getControl(ENTRYENTITY), PERSON, userName.toString());
            }
        } else if (MSGCONTENTREGISTER.equals(closedCallBackEvent.getActionId())) {
            Map map2 = (Map)closedCallBackEvent.getReturnData();
            if (map2 != null && !map2.isEmpty()) {
                String content = (String)map2.get("customSubject");
                MsgUtil.setContent(this.getModel(), (EntryGrid)this.getControl(ENTRYENTITY), MSGCONTENT, content);
            }
        } else if (MSGPERSONCONTENT.equals(closedCallBackEvent.getActionId()) && (map = (Map)closedCallBackEvent.getReturnData()) != null && !map.isEmpty()) {
            String content = (String)map.get(MSGPERSONCONTENT);
            MsgUtil.setContent(this.getModel(), (EntryGrid)this.getControl(ENTRYENTITY), WBPERSON, MsgUtil.replaceSymbol(content));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && (oper = (AbstractOperate)args.getSource()).getOperateKey().equals("save")) {
            if (this.getModel().getValue("sendor") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u6210\u901a\u77e5\u6d88\u606f\u53d1\u9001\u4eba\u4e3a\u7a7a,\u8bf7\u586b\u5199\u3002", (String)"MsgNotificationFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
            if (datas != null && datas.size() > 0) {
                for (DynamicObject dym : datas) {
                    String msgcontent = dym.getString(MSGCONTENT);
                    String person = dym.getString(PERSON);
                    DynamicObjectCollection guides = dym.getDynamicObjectCollection("guide");
                    if (guides == null || guides.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a,\u8bf7\u914d\u7f6e\u3002", (String)"MsgNotificationFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        args.setCancel(true);
                        return;
                    }
                    if (StringUtils.isEmpty((String)msgcontent)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u4eba\u6d88\u606f\u5185\u5bb9\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a,\u8bf7\u914d\u7f6e\u3002", (String)"MsgNotificationFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        args.setCancel(true);
                        return;
                    }
                    if (!StringUtils.isEmpty((String)person)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u4eba\u4eba\u5458\u914d\u7f6e\u4e3a\u7a7a,\u8bf7\u9009\u62e9\u3002", (String)"MsgNotificationFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    args.setCancel(true);
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u4eba\u4fe1\u606f\u914d\u7f6e\u5217\u8868\u4e3a\u7a7a,\u4e0d\u5141\u8bb8\u4fdd\u5b58.", (String)"MsgNotificationFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
        }
    }

    private static String getTipsCode() {
        return ResManager.loadKDString((String)"\u96c6\u6210\u6d88\u606f_", (String)"MsgNotificationFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }
}

