/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.license.IscWhiteListUtil;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.solution.UpdateResourceListJob;
import kd.isc.iscb.platform.core.solution.resources.DeployResourceFromSolution;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.platform.core.util.MultiLangUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.encoding.Hash;
import kd.isc.iscb.util.script.feature.tool.hash.Util;
import kd.isc.iscb.util.script.misc.SystemContext;

public class ResourceCenterFormPlugin
extends AbstractListPlugin
implements PagerClickListener,
HyperLinkClickListener,
TreeNodeClickListener,
CreateListDataProviderListener,
SearchEnterListener {
    private static final String KEY_TREE = "treeviewap";
    private static final String KEY_LIST = "billlistap";
    private static final String KEY_SEARCH = "searchap";
    private static final String UPDATE_RESOURCE_LIST = "update_resource_list";
    private static final String DEPLOY = "deploy";
    private static final String FCONTENT_TAG = "fcontent_tag";
    private static final String READY = "READY";
    private static final String FNAME = "fname";
    private static final String FNUMBER = "fnumber";
    private static final String FRES_PK = "fres_pk";
    private static final String SEARCH_CONDITION = "searchCondition";
    private static final String PAGE_SEARCH_PARAM = "pageSearchParam";
    private static final String NUMBER = "number";
    private static final String RESET_PAGE = "resetPage";
    private static final String FIS_DEPLOYED = "fis_deployed";
    private static final String MODIFYTIME = "modifytime";
    private static final String QUERY_ENTITY_KEY = "query_entity_key";
    private static final String DTS_ENTITYNAME_KEY = "$entityname";
    private static final Log logger = LogFactory.getLog(ResourceCenterFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList list = (BillList)this.getControl(KEY_LIST);
        list.addHyperClickListener((HyperLinkClickListener)this);
        list.addPagerClickListener((PagerClickListener)this);
        list.setSelectedAll(false);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
        this.query();
    }

    public void beforeBindData(EventObject e) {
        String solutionNumber;
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl(KEY_LIST);
        String focusNodeId = this.getFocusNodeId();
        if ("ROOT".equals(focusNodeId)) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getAllEntity());
            billList.setBillFormId("isc_solution_center");
        } else if (StringUtils.isEmpty((CharSequence)billList.getBillFormId())) {
            billList.setBillFormId(focusNodeId);
        }
        if (SystemContext.isProcEnv()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DEPLOY});
        }
        if (!StringUtil.isEmpty((String)(solutionNumber = (String)this.getView().getFormShowParameter().getCustomParam("solution_number")))) {
            this.getPageCache().put(PAGE_SEARCH_PARAM, solutionNumber);
        }
        String whiteListRole = System.getProperty("ISC_WHITE_LIST_ROLE");
        this.getView().setVisible(Boolean.valueOf("admin".equals(whiteListRole)), new String[]{"build_white_list"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getControl(KEY_LIST);
        if (billList.getCurrentListAllRowCollection().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u76f8\u5173\u8d44\u6e90\u5185\u5bb9", (String)"ResourceCenterFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate source = (AbstractOperate)evt.getSource();
        if (UPDATE_RESOURCE_LIST.equals(source.getOperateKey())) {
            BillList billList = (BillList)this.getControl(KEY_LIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() != 1) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"ResourceCenterFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            }
        } else if (DEPLOY.equals(source.getOperateKey())) {
            this.beforeDeploy(evt);
        } else if ("res_diff_comp".equals(source.getOperateKey())) {
            BillList billList = (BillList)this.getControl(KEY_LIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() != 2) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e24\u6761\u6570\u636e\u6bd4\u8f83\u5dee\u5f02", (String)"ResourceCenterFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            }
        } else if ("res_diff_local".equals(source.getOperateKey())) {
            this.resDiffLocalCheck(evt);
        }
    }

    private void resDiffLocalCheck(BeforeDoOperationEventArgs evt) {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 1) {
            long entryId = D.l((Object)selectedRows.get(0).getPrimaryKeyValue());
            String billId = this.loadValueByEntryId(FRES_PK, entryId);
            String entity = this.loadValueByEntryId("ftype", entryId);
            if (!QueryServiceHelper.exists((String)entity, (Object)billId)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8d44\u6e90\u5728\u672c\u5730\u4e0d\u5b58\u5728\uff0c\u8bf7\u90e8\u7f72\u540e\u91cd\u8bd5", (String)"ResourceCenterFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            }
        } else {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"ResourceCenterFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
        }
    }

    private void beforeDeploy(BeforeDoOperationEventArgs evt) {
        if (SystemContext.isProcEnv()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ResourceCenterFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"ResourceCenterFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
        } else if (selectedRows.size() > 20) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e920\u6761\u6570\u636e", (String)"ResourceCenterFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
        }
        if (!evt.isCancel()) {
            try {
                this.checkSolutionVersion(evt);
            }
            catch (Exception e) {
                evt.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u6bd4\u672c\u5730\u8d44\u6e90\u4e0e\u4e91\u7aef\u8d44\u6e90\u7248\u672c\u65f6\u53d1\u751f\u4ee5\u4e0b\u5f02\u5e38\uff0c\u7ee7\u7eed\u90e8\u7f72\u5c06\u4e0d\u518d\u8fdb\u884c\u5bf9\u6bd4\uff0c\u53ef\u80fd\u5bfc\u81f4\u672c\u5730\u8d44\u6e90\u4e0d\u662f\u6700\u65b0\u7684\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"ResourceCenterFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("deployConfirm"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String action = evt.getCallBackId();
        if ("deployConfirm".equals(action) && MessageBoxResult.Yes == evt.getResult()) {
            this.deploy();
        } else if ("offshelfConfirm".equals(action) && MessageBoxResult.Yes == evt.getResult()) {
            this.deploy();
        }
    }

    private void checkSolutionVersion(BeforeDoOperationEventArgs evt) {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<String> numbers = new HashSet<String>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            numbers.add(selectedRow.getNumber());
        }
        QFilter qFilter = new QFilter(NUMBER, "in", numbers);
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"isc_solution_center", (String)"id", (QFilter[])new QFilter[]{qFilter});
        StringBuilder api = new StringBuilder("kapi/v2/kdec/iscb/isc_solution_center/query_solution_by_id?");
        for (int i = 0; i < ids.length; ++i) {
            api.append("id=");
            api.append(ids[i].get("id"));
            if (i == ids.length - 1) continue;
            api.append('&');
        }
        List solutionList = PublicResourceUtil.queryListByGet((String)api.toString(), null);
        this.compareVersion(evt, selectedRows, solutionList);
        this.checkDownshelf(evt, selectedRows, solutionList);
    }

    private void checkDownshelf(BeforeDoOperationEventArgs evt, ListSelectedRowCollection selectedRows, List<Map<String, Object>> solutionList) {
        if (evt.isCancel()) {
            return;
        }
        StringBuilder str = new StringBuilder();
        for (ListSelectedRow selectedRow : selectedRows) {
            Map<String, Object> solution = this.findSolution(selectedRow.getNumber(), solutionList);
            if (!"Z".equals(solution.get("status"))) continue;
            Map<String, Object> res = this.querySolutionEntry(D.l((Object)selectedRow.getPrimaryKeyValue()));
            str.append(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\uff1a\uff08%1$s)%2$s\n", (String)"ResourceCenterFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), res.get(FNUMBER), res.get(FNAME)));
        }
        if (!StringUtil.isEmpty((String)str.toString())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("offshelfConfirm", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5728\u4e91\u7aef\u7ba1\u7406\u5e73\u53f0\u5df2\u4e0b\u67b6\uff0c\u4e14\u4e0d\u518d\u66f4\u65b0\u7ef4\u62a4\uff0c\u5efa\u8bae\u5148\u54a8\u8be2\u65b9\u6848\u5f00\u53d1\u5546\u6216\u96c6\u6210\u4e91\u7ba1\u7406\u5458\u83b7\u53d6\u652f\u6301\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\u90e8\u7f72\uff1f", (String)"ResourceCenterFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), str.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            evt.setCancel(true);
        }
    }

    private void compareVersion(BeforeDoOperationEventArgs evt, ListSelectedRowCollection selectedRows, List<Map<String, Object>> solutionList) {
        StringBuilder str = new StringBuilder();
        int index = 0;
        for (ListSelectedRow selectedRow : selectedRows) {
            Map<String, Object> solution = this.findSolution(selectedRow.getNumber(), solutionList);
            if (solution.isEmpty() || this.isOmitted(solution)) continue;
            Map<String, Object> res = this.querySolutionEntry(D.l((Object)selectedRow.getPrimaryKeyValue()));
            DynamicObject s = this.loadSolution(selectedRow.getNumber());
            str.append(String.format(ResManager.loadKDString((String)"%1$s \u8d44\u6e90\uff1a%2$s    %3$s\n \u8d44\u6e90ID\uff1a%4$s\n \u6240\u5c5e\u65b9\u6848\u5305\uff1a%5$s    %6$s\n \u672c\u5730\u65b9\u6848\u5305\u7248\u672c\uff1a%7$s    \u4e91\u7aef\u65b9\u6848\u5305\u7248\u672c\uff1a%8$s\n\n", (String)"ResourceCenterFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ++index, res.get(FNAME), res.get(FNUMBER), res.get(FRES_PK), selectedRow.getName(), selectedRow.getNumber(), s.getString("version"), solution.get("version")));
        }
        if (!StringUtil.isEmpty((String)str.toString())) {
            FormOpener.showErrorMessage(this.getView(), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b%s\u4e2a\u8d44\u6e90\u7684\u65b9\u6848\u5305\u5df2\u8fc7\u65f6\uff0c\u8bf7\u5148\u5b8c\u6210\u4e91\u66f4\u65b0\u64cd\u4f5c\u540e\u518d\u8fdb\u884c", (String)"ResourceCenterFormPlugin_40", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), index), str.toString());
            evt.setCancel(true);
        }
    }

    private boolean isOmitted(Map<String, Object> solution) {
        long id = D.l((Object)solution.get("id"));
        DynamicObject solutionFormDb = QueryServiceHelper.queryOne((String)"isc_solution_center_m", (String)"version,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (solutionFormDb != null) {
            String importVersion = D.s((Object)solution.get("version"));
            String currentVersion = D.s((Object)solutionFormDb.get("version"));
            if (currentVersion == null) {
                return false;
            }
            int i = importVersion.compareTo(currentVersion);
            return i <= 0;
        }
        return false;
    }

    private DynamicObject loadSolution(String number) {
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"isc_solution_center", (String)"version,status", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
        if (objects.length >= 1) {
            return objects[0];
        }
        return null;
    }

    private Map<String, Object> querySolutionEntry(long entryid) {
        String sql = "select fnumber, fname, fres_pk from t_isc_solution_mr WHERE fentryid = ? union SELECT fnumber, fname, fres_pk from t_isc_solution_rr WHERE fentryid = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            ArrayList<Long> values = new ArrayList<Long>();
            values.add(entryid);
            values.add(entryid);
            ArrayList<Integer> types = new ArrayList<Integer>();
            types.add(-5);
            types.add(-5);
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, values, types);
            if (!dataRows.isEmpty()) {
                Map map = ((DataRow)dataRows.get(0)).toMap();
                return map;
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> findSolution(String number, List<Map<String, Object>> solutionList) {
        for (Map<String, Object> s : solutionList) {
            if (!number.equals(s.get(NUMBER))) continue;
            return s;
        }
        return Collections.emptyMap();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("viewcontent".equals(key)) {
            this.viewcontent();
        } else if (UPDATE_RESOURCE_LIST.equals(key)) {
            this.updateResourceList();
        } else if (DEPLOY.equals(key)) {
            this.deploy();
        } else if ("refresh".equals(key)) {
            this.refresh();
        } else if ("res_diff_comp".equals(key)) {
            this.showDiffComp();
        } else if ("res_diff_local".equals(key)) {
            this.showDiffLocal();
        } else if ("search".equals(key)) {
            FormOpener.showForm((AbstractFormPlugin)this, "isc_res_center_field", "", this.getSearchField(), "search");
        } else if ("reset".equals(key)) {
            this.getPageCache().remove("search_field");
            this.showSearchField();
            this.refresh();
        } else if ("build_white_list".equals(key)) {
            this.buildWhitelist();
        }
    }

    private void buildWhitelist() {
        List<Map<String, Object>> selectData = this.getSelectData();
        if (selectData.isEmpty()) {
            String s = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e", (String)"ResourceCenterFormPlugin_51", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(s);
            return;
        }
        for (Map<String, Object> data : selectData) {
            if (this.canBuildWhitelist(data)) continue;
            return;
        }
        ArrayList list = new ArrayList(selectData.size());
        for (Map map : selectData) {
            String solutionNumber = D.s(this.getValueFromMapIgnoreCase(map, "FSOLUTION_NUMBER"));
            String resPk = D.s(this.getValueFromMapIgnoreCase(map, FRES_PK));
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("solutionNumber", solutionNumber);
            map2.put("resourceId", resPk);
            list.add(map2);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("list", Json.toString(list));
        FormOpener.showForm((AbstractFormPlugin)this, "isc_solution_to_whitelist", params);
    }

    private boolean canBuildWhitelist(Map<String, Object> data) {
        DynamicObject meta;
        String type = D.s((Object)this.getValueFromMapIgnoreCase(data, "ftype"));
        if (!IscWhiteListUtil.isBuildWhitelistType((String)type)) {
            LocaleString displayName = EntityMetadataCache.getDataEntityType((String)type).getDisplayName();
            String tips = String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8d44\u6e90\u7c7b\u578b\uff1a%s \u6784\u5efa\u767d\u540d\u5355", (String)"ResourceCenterFormPlugin_48", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), displayName.toString());
            this.getView().showTipNotification(tips);
            return false;
        }
        if ("isc_metadata_schema".equals(type) && MetaType.SERVICE != MetaType.valueOf((String)(meta = MetaDataSchema.get((long)D.l((Object)data.get(FRES_PK)))).getString("type")) && MetaType.QUERY != MetaType.valueOf((String)meta.getString("type"))) {
            String tips = ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u53ea\u652f\u6301\u52a0\u8f7d\u670d\u52a1\u548c\u67e5\u8be2\u670d\u52a1\u6784\u5efa\u767d\u540d\u5355", (String)"ResourceCenterFormPlugin_50", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> getSelectData() {
        String s = this.getView().getPageCache().get("CURR_PAGE_DATA");
        List list = (List)Json.toObject((String)s);
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Map<String, Object>> select = new ArrayList<Map<String, Object>>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Object rowpk = row.getPrimaryKeyValue();
            for (Map data : list) {
                if (!D.s(this.getValueFromMapIgnoreCase(data, "fentryid")).equals(D.s((Object)rowpk))) continue;
                select.add(data);
            }
        }
        return select;
    }

    private Map<String, Object> getSearchField() {
        String jsonStr = this.getPageCache().get("search_field");
        if (jsonStr == null) {
            HashMap<String, Object> data = new HashMap<String, Object>(1);
            this.getPageCache().put("search_field", Json.toString(data));
            return data;
        }
        return (Map)Json.toObject((String)this.getPageCache().get("search_field"));
    }

    private void showDiffComp() {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        long entryid1 = D.l((Object)selectedRows.get(0).getPrimaryKeyValue());
        long entryid2 = D.l((Object)selectedRows.get(1).getPrimaryKeyValue());
        String contentTag1 = this.loadValueByEntryId(FCONTENT_TAG, entryid1);
        String contentTag2 = this.loadValueByEntryId(FCONTENT_TAG, entryid2);
        Map res1 = (Map)Json.toObject((String)contentTag1);
        Map res2 = (Map)Json.toObject((String)contentTag2);
        if (!D.s(res1.get(DTS_ENTITYNAME_KEY)).equals(D.s(res2.get(DTS_ENTITYNAME_KEY)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u540c\u4e00\u7c7b\u578b\uff0c\u65e0\u6cd5\u6bd4\u8f83", (String)"ResourceCenterFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            String resName1 = MultiLangUtil.getMultiLangValue(res1.get("name"));
            String resName2 = MultiLangUtil.getMultiLangValue(res2.get("name"));
            FormOpener.showDiffComp((AbstractFormPlugin)this, D.s(res1.get(DTS_ENTITYNAME_KEY)), res1, resName1, res2, resName2);
        }
    }

    private void showDiffLocal() {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        long entryid = D.l((Object)selectedRows.get(0).getPrimaryKeyValue());
        String contentTag = this.loadValueByEntryId(FCONTENT_TAG, entryid);
        Map resPackage = (Map)Json.toObject((String)contentTag);
        String pk = D.s(resPackage.get("id"));
        String entity = D.s(resPackage.get(DTS_ENTITYNAME_KEY));
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entity);
        Map resLocal = DynamicObjectUtil.object2Map((DynamicObject)object);
        FormOpener.showDiffComp((AbstractFormPlugin)this, entity, resLocal, String.format(ResManager.loadKDString((String)"%s\uff08\u672c\u5730\uff09", (String)"ResourceCenterFormPlugin_41", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), object.getString("name")), resPackage, String.format(ResManager.loadKDString((String)"%s\uff08\u65b9\u6848\u5305\uff09", (String)"ResourceCenterFormPlugin_42", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), object.getString("name")));
    }

    private void updateResourceList() {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)selectedRows.get(0).getNumber());
        DynamicObject solution = BusinessDataServiceHelper.loadSingle((String)"isc_solution_center", (QFilter[])new QFilter[]{qFilter});
        UpdateResourceListJob updateJob = new UpdateResourceListJob(ResManager.loadKDString((String)"\u66f4\u65b0\u4e91\u7aef\u8d44\u6e90", (String)"ResourceCenterFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), D.s((Object)solution.getPkValue()));
        List jobs = JobEngine.getJobsWithOwnerId((long)updateJob.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob((AbstractFormPlugin)this, (Job)updateJob, UPDATE_RESOURCE_LIST);
        } else {
            FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), updateJob.getTitle(), UPDATE_RESOURCE_LIST);
        }
    }

    private void deploy() {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashMap<String, DeployResourceFromSolution> deploysMap = new HashMap<String, DeployResourceFromSolution>();
        LinkedHashSet deployRefEntryList = new LinkedHashSet();
        ArrayList<DynamicObject> deployMainEntryList = new ArrayList<DynamicObject>();
        for (final ListSelectedRow selectedRow : selectedRows) {
            DeployResourceFromSolution deploys = deploysMap.computeIfAbsent(selectedRow.getNumber(), new Function<String, DeployResourceFromSolution>(){

                @Override
                public DeployResourceFromSolution apply(String s) {
                    return new DeployResourceFromSolution(selectedRow.getNumber());
                }
            });
            List dependentEntry = deploys.loadDependencies(D.l((Object)selectedRow.getPrimaryKeyValue()));
            deployRefEntryList.addAll(dependentEntry);
            deployMainEntryList.add(deploys.loadMain(D.l((Object)selectedRow.getPrimaryKeyValue())));
        }
        DynamicObject[] refArray = new DynamicObject[deployRefEntryList.size()];
        List<DynamicObject> reflist = Arrays.asList(deployRefEntryList.toArray(refArray));
        this.openDeployForm(deployMainEntryList, reflist);
    }

    private void openDeployForm(List<DynamicObject> deployMainEntryList, List<DynamicObject> deployRefEntryList) {
        String resid = this.generateMutexObjId(deployMainEntryList, deployRefEntryList);
        long billId = this.saveHead(resid);
        SolutionUtil.saveMainContents((long)billId, deployMainEntryList, (boolean)true);
        SolutionUtil.saveRefContents((long)billId, deployRefEntryList, (boolean)false);
        BillShowParameter param = new BillShowParameter();
        param.setFormId("isc_dts_solution_deploy");
        param.setPkId((Object)billId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("MUTEX_OBJ_ID", (Object)resid);
        param.setCustomParam("entity", (Object)"isc_solution_center_m");
        param.setStatus(OperationStatus.EDIT);
        param.setCaption(ResManager.loadKDString((String)"\u90e8\u7f72\u8d44\u6e90", (String)"ResourceCenterFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importschema"));
        this.getView().showForm((FormShowParameter)param);
    }

    private String generateMutexObjId(List<DynamicObject> deployMainEntryList, List<DynamicObject> deployRefEntryList) {
        ArrayList<DynamicObject> deployEntryList = new ArrayList<DynamicObject>();
        deployEntryList.addAll(deployMainEntryList);
        deployEntryList.addAll(deployRefEntryList);
        deployEntryList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                if (D.l((Object)o1.getPkValue()) > D.l((Object)o2.getPkValue())) {
                    return 1;
                }
                if (D.l((Object)o1.getPkValue()) == D.l((Object)o2.getPkValue())) {
                    return 0;
                }
                return -1;
            }
        });
        StringBuilder str = new StringBuilder();
        for (DynamicObject o : deployEntryList) {
            str.append(D.s((Object)o.getPkValue()));
        }
        return D.s((Object)Util.hash((Object)str.toString(), (Hash)Hash.SHA));
    }

    private long saveHead(String resid) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"isc_dts_solution_deploy");
        long billId = IDService.get().genLongId();
        object.set("id", (Object)billId);
        object.set("billstatus", (Object)Character.valueOf('A'));
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("billno", (Object)kd.isc.iscb.util.misc.Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()}));
        object.set("resid", (Object)resid);
        object.set("res_type", (Object)FileResourceUtil.getEntityTitle((String)"isc_resouce_center"));
        object.set("progress", (Object)"PARSED");
        object.set("state", (Object)READY);
        object.set(MODIFYTIME, (Object)D.t((Object)System.currentTimeMillis()));
        object.set("modifier", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        return billId;
    }

    private void viewcontent() {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        ListSelectedRow listSelectedRow = billList.getCurrentSelectedRowInfo();
        long id = D.l((Object)listSelectedRow.getPrimaryKeyValue());
        String contentTag = this.loadValueByEntryId(FCONTENT_TAG, id);
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("content", contentTag);
        FormOpener.showStatusForm((AbstractFormPlugin)this, "isc_text_content_dialog", ResManager.loadKDString((String)"\u5185\u5bb9", (String)"ResourceCenterFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, OperationStatus.VIEW, ShowType.Modal);
    }

    private void refresh() {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        String focusNodeId = this.getFocusNodeId();
        if ("ROOT".equals(focusNodeId)) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getAllEntity());
            billList.setBillFormId("isc_solution_center");
        } else if (focusNodeId.startsWith("dir")) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getEntityByCatagory(focusNodeId));
            billList.setBillFormId("isc_solution_center");
        } else if (StringUtils.isEmpty((CharSequence)billList.getBillFormId()) || !billList.getBillFormId().equals(focusNodeId)) {
            billList.setBillFormId(focusNodeId);
        }
        this.query();
        this.getView().updateView(KEY_LIST);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (UPDATE_RESOURCE_LIST.equals(action)) {
            this.getView().invokeOperation("refresh");
        } else if ("search".equals(action)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData == null) {
                return;
            }
            this.getPageCache().put("search_field", Json.toString((Object)returnData));
            this.showSearchField();
            this.refresh();
        }
    }

    private void showSearchField() {
        Map<String, Object> data = this.getSearchField();
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)D.s((Object)data.get("resNumber")))) {
            sb.append(ResManager.loadKDString((String)"\u8d44\u6e90\u7f16\u7801\uff1a", (String)"ResourceCenterFormPlugin_44", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(D.s((Object)data.get("resNumber"))).append("\uff1b ");
        }
        if (!StringUtil.isEmpty((String)D.s((Object)data.get("resName")))) {
            sb.append(ResManager.loadKDString((String)"\u8d44\u6e90\u540d\u79f0\uff1a", (String)"ResourceCenterFormPlugin_45", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(D.s((Object)data.get("resName"))).append("\uff1b ");
        }
        if (!StringUtil.isEmpty((String)D.s((Object)data.get("resPk")))) {
            sb.append(ResManager.loadKDString((String)"\u8d44\u6e90id\uff1a", (String)"ResourceCenterFormPlugin_46", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(D.s((Object)data.get("resPk"))).append("\uff1b ");
        }
        if (!StringUtil.isEmpty((String)D.s((Object)data.get("solutionName")))) {
            sb.append(ResManager.loadKDString((String)"\u65b9\u6848\u5305\u540d\u79f0\uff1a", (String)"ResourceCenterFormPlugin_47", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(D.s((Object)data.get("solutionName"))).append("\uff1b ");
        }
        Label label = (Label)this.getControl("search_field");
        label.setText(sb.toString());
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        TreeNode root = new TreeNode("", "ROOT", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ResourceCenterFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        root.setExpend(true);
        List<TreeNode> nodes = this.getChildrenNodes();
        root.setChildren(nodes);
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand("ROOT");
        treeView.focusNode(root);
    }

    private List<TreeNode> getChildrenNodes() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        TreeNode connection = new TreeNode("ROOT", "dir_connection", ResManager.loadKDString((String)"\u8fde\u63a5\u7ba1\u7406", (String)"ResourceCenterFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        connection.addChild(new TreeNode("dir_connection", "isc_connection_type", ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b", (String)"ResourceCenterFormPlugin_49", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        connection.addChild(new TreeNode("dir_connection", "isc_data_source", ResManager.loadKDString((String)"\u6570\u636e\u6e90", (String)"ResourceCenterFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        connection.addChild(new TreeNode("dir_connection", "isc_user_defined_event", ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u81ea\u5b9a\u4e49\u4e8b\u4ef6", (String)"ResourceCenterFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        nodes.add(connection);
        TreeNode metaCatalog = new TreeNode("ROOT", "dir_meta", ResManager.loadKDString((String)"\u96c6\u6210\u5143\u6570\u636e", (String)"ResourceCenterFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        List<String> list = Arrays.asList("isc_metadata_schema", "isc_apic_for_external_api", "isc_apic_mservice", "isc_custom_function");
        for (String string : list) {
            metaCatalog.addChild(new TreeNode("dir_meta", string, this.getEntityName(string)));
        }
        nodes.add(metaCatalog);
        TreeNode datacopyCatalog = new TreeNode("ROOT", "dir_datacopy", ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210", (String)"ResourceCenterFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        list = Arrays.asList("isc_data_copy", "isc_data_copy_trigger", "isc_value_conver_rule");
        for (String string : list) {
            datacopyCatalog.addChild(new TreeNode("dir_datacopy", string, this.getEntityName(string)));
        }
        nodes.add(datacopyCatalog);
        TreeNode treeNode = new TreeNode("ROOT", "dir_api", ResManager.loadKDString((String)"API\u96c6\u6210", (String)"ResourceCenterFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        list = Arrays.asList("isc_apic_by_meta_schema", "isc_apic_by_dc_schema", "isc_apic_by_dc_trigger", "isc_apic_by_vc", "isc_apic_by_sf", "isc_apic_script", "isc_call_api_by_evt", "isc_call_api_by_timer", "isc_call_api_by_mq", "isc_apic_webapi");
        for (String string : list) {
            treeNode.addChild(new TreeNode("dir_api", string, this.getEntityName(string)));
        }
        nodes.add(treeNode);
        TreeNode treeNode2 = new TreeNode("ROOT", "dir_mq", ResManager.loadKDString((String)"\u6d88\u606f\u96c6\u6210", (String)"ResourceCenterFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        list = Arrays.asList("isc_mq_publisher", "isc_mq_subscriber", "isc_mq_bill_data_pub", "isc_mq_bill_data_sub");
        for (String string : list) {
            treeNode2.addChild(new TreeNode("dir_mq", string, this.getEntityName(string)));
        }
        nodes.add(treeNode2);
        TreeNode treeNode3 = new TreeNode("ROOT", "dir_sf", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u7ba1\u7406", (String)"ResourceCenterFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        list = Collections.singletonList("isc_service_flow");
        for (String string : list) {
            treeNode3.addChild(new TreeNode("dir_sf", string, this.getEntityName(string)));
        }
        nodes.add(treeNode3);
        TreeNode treeNode4 = new TreeNode("ROOT", "dir_transfer", ResManager.loadKDString((String)"\u79bb\u7ebf\u6570\u636e\u96c6\u6210", (String)"ResourceCenterFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        list = Arrays.asList("isc_export_file", "isc_import_file", "isc_export_file_trigger", "isc_import_file_trigger");
        for (String entity : list) {
            treeNode4.addChild(new TreeNode("dir_transfer", entity, this.getEntityName(entity)));
        }
        nodes.add(treeNode4);
        TreeNode treeNode5 = new TreeNode("ROOT", "dir_dataComp", ResManager.loadKDString((String)"\u6570\u636e\u6cbb\u7406", (String)"ResourceCenterFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        treeNode5.addChild(new TreeNode("dir_connection", "isc_data_comp", this.getEntityName("isc_data_comp")));
        nodes.add(treeNode5);
        TreeNode dataFlow = new TreeNode("ROOT", "iscx_resource", this.getEntityName("iscx_resource"));
        nodes.add(dataFlow);
        return nodes;
    }

    private String getEntityName(String entity) {
        return EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
    }

    private String getAllEntity() {
        return "isc_connection_type,isc_data_source,isc_user_defined_event,isc_metadata_schema,isc_apic_for_external_api,isc_apic_mservice,isc_custom_function,isc_data_copy,isc_data_copy_trigger,isc_value_conver_rule,isc_apic_by_meta_schema,isc_apic_by_dc_schema,isc_apic_by_dc_trigger,isc_apic_by_vc,isc_apic_by_sf,isc_apic_script,isc_call_api_by_evt,isc_call_api_by_timer,isc_call_api_by_mq,isc_apic_webapi,isc_mq_publisher,isc_mq_subscriber,isc_mq_bill_data_pub,isc_mq_bill_data_sub,isc_service_flow,isc_export_file,isc_import_file,isc_export_file_trigger,isc_import_file_trigger,isc_data_comp,iscx_resource,iscx_data_flow_trigger";
    }

    private String getEntityByCatagory(String catagory) {
        List leaf = new ArrayList();
        for (TreeNode node : this.getChildrenNodes()) {
            if (!node.getId().equals(catagory)) continue;
            leaf = node.getChildren();
        }
        StringBuilder entity = new StringBuilder();
        for (TreeNode node : leaf) {
            entity.append(node.getId());
            entity.append(',');
        }
        return StringUtil.isEmpty((String)entity.toString()) ? "" : entity.substring(0, entity.length() - 1);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        BillList billList = (BillList)this.getControl(KEY_LIST);
        this.getView().getPageCache().remove(QUERY_ENTITY_KEY);
        if ("ROOT".equals(nodeId)) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getAllEntity());
            billList.setBillFormId("isc_solution_center");
        } else if (nodeId.startsWith("dir")) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getEntityByCatagory(nodeId));
            billList.setBillFormId("isc_solution_center");
        } else {
            billList.setBillFormId(nodeId);
        }
        billList.setPageRow(D.i((Object)this.getPageCache().get("pageRows")));
        this.getPageCache().put(RESET_PAGE, "1");
        this.getPageCache().remove(SEARCH_CONDITION);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.setSearchKey("");
        this.query();
        this.getView().updateView(KEY_LIST);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)evt;
        ListSelectedRow currentRow = billListHyperLinkClickEvent.getCurrentRow();
        long entryId = D.l((Object)currentRow.getPrimaryKeyValue());
        String contentTag = this.loadValueByEntryId(FCONTENT_TAG, entryId);
        Map resMap = (Map)Json.toObject((String)contentTag);
        String billId = D.s(resMap.get("id"));
        String entity = D.s(resMap.get(DTS_ENTITYNAME_KEY));
        if (StringUtils.equals((CharSequence)evt.getFieldName(), (CharSequence)"main_res_number")) {
            boolean exists = QueryServiceHelper.exists((String)entity, (Object)billId);
            if (exists) {
                if ("iscx_resource".equals(entity)) {
                    FormOpener.showView((AbstractFormPlugin)this, "iscx_resource", billId);
                } else {
                    FormOpener.showTabViewIfNotExist((AbstractFormPlugin)this, entity, billId);
                }
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684%s\u8d44\u6e90\uff0c\u8bf7\u90e8\u7f72\u540e\u518d\u67e5\u770b\u3002", (String)"ResourceCenterFormPlugin_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getEntityName(entity)));
            }
        } else if (StringUtils.equals((CharSequence)evt.getFieldName(), (CharSequence)"name")) {
            QFilter filter = new QFilter(NUMBER, "=", (Object)currentRow.getNumber());
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"isc_solution_center", (String)"id", (QFilter[])new QFilter[]{filter});
            if (!objects.isEmpty()) {
                FormOpener.showTabViewIfNotExist((AbstractFormPlugin)this, "isc_solution_center", ((DynamicObject)objects.get(0)).get("id"));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684%s\u8d44\u6e90", (String)"ResourceCenterFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), currentRow.getName()));
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        String text = D.s((Object)evt.getText());
        BillList billList = (BillList)this.getControl(KEY_LIST);
        String focusNodeId = this.getFocusNodeId();
        if ("ROOT".equals(focusNodeId)) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getAllEntity());
            billList.setBillFormId("isc_solution_center");
        } else if (focusNodeId.startsWith("dir")) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getEntityByCatagory(focusNodeId));
            billList.setBillFormId("isc_solution_center");
        } else if (StringUtils.isEmpty((CharSequence)billList.getBillFormId()) || !billList.getBillFormId().equals(focusNodeId)) {
            billList.setBillFormId(focusNodeId);
        }
        if (text != null) {
            this.getPageCache().put(SEARCH_CONDITION, text);
            this.query();
        } else {
            this.getPageCache().remove(SEARCH_CONDITION);
            this.query();
        }
        this.getView().updateView(KEY_LIST);
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        BillList billList = (BillList)pagerClickEvent.getSource();
        String focusNodeId = this.getFocusNodeId();
        if ("ROOT".equals(focusNodeId)) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getAllEntity());
            billList.setBillFormId("isc_solution_center");
        } else if (focusNodeId.startsWith("dir")) {
            this.getView().getPageCache().put(QUERY_ENTITY_KEY, this.getEntityByCatagory(focusNodeId));
            billList.setBillFormId("isc_solution_center");
        } else if (StringUtils.isEmpty((CharSequence)billList.getBillFormId()) || !billList.getBillFormId().equals(focusNodeId)) {
            billList.setBillFormId(focusNodeId);
        }
        billList.setPageRow(pagerClickEvent.getPageRows());
        this.query();
    }

    private void query() {
        BillList list = (BillList)this.getView().getControl(KEY_LIST);
        list.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        ListDataProvider provider = new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                start = ResourceCenterFormPlugin.this.resetPage(start);
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.clear();
                ResourceCenterFormPlugin.this.fillData(rows, this.getQueryResult(), start, limit);
                return rows;
            }
        };
        e.setListDataProvider((IListDataProvider)provider);
    }

    private void fillData(DynamicObjectCollection rows, QueryResult queryResult, int start, int limit) {
        BillList billList = (BillList)this.getControl(KEY_LIST);
        String billFormId = billList.getBillFormId();
        Map<String, Object> result = this.selectByDataSet(billFormId, start, limit);
        int totalSize = D.i((Object)result.get("totalSize"));
        List data = (List)result.get("data");
        int index = 0;
        for (Map item : data) {
            DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
            row.set("id", this.getValueFromMapIgnoreCase(item, "fentryid"));
            row.set("name", this.getValueFromMapIgnoreCase(item, "FSOLUTION_NAME"));
            row.set(NUMBER, this.getValueFromMapIgnoreCase(item, "FSOLUTION_NUMBER"));
            row.set("is_deployed", (Object)Boolean.TRUE.equals(this.getValueFromMapIgnoreCase(item, FIS_DEPLOYED)));
            DynamicObject resType = BusinessDataServiceHelper.newDynamicObject((String)"bos_objecttype");
            String resTypeEntity = D.s(this.getValueFromMapIgnoreCase(item, "ftype"));
            resType.set(NUMBER, (Object)resTypeEntity);
            resType.set("name", (Object)this.getEntityName(resTypeEntity));
            row.set("main_resources.main_res_type", (Object)resType);
            row.set("main_resources.main_res_number", this.getValueFromMapIgnoreCase(item, FNUMBER));
            row.set("main_resources.main_res_name", this.getValueFromMapIgnoreCase(item, FNAME));
            row.set("main_resources.main_res_pk", this.getValueFromMapIgnoreCase(item, FRES_PK));
            row.set(MODIFYTIME, this.getValueFromMapIgnoreCase(item, MODIFYTIME));
            row.set("main_resources.main_res_time", this.getValueFromMapIgnoreCase(item, "fres_time"));
            row.set("main_resources.main_res_size", this.getValueFromMapIgnoreCase(item, "fsize"));
            row.set("main_resources.main_res_remark", this.getValueFromMapIgnoreCase(item, "fremark"));
            rows.add(index, row);
            ++index;
        }
        queryResult.setDataCount(totalSize);
        queryResult.setCollection(rows);
        queryResult.setBillDataCount(0);
        billList.clearSelection();
        this.getView().getPageCache().put("CURR_PAGE_DATA", Json.toString((Object)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> selectByDataSet(String billFormId, int start, int limit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        final String searchCondition = this.getPageCache().get(SEARCH_CONDITION);
        final String pageSearchParam = this.getPageCache().get(PAGE_SEARCH_PARAM);
        String types = this.getView().getPageCache().get(QUERY_ENTITY_KEY);
        StringBuilder typeOfPlaceholder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder otherFilter = new StringBuilder();
        this.setQuerySQLParams(billFormId, types, typeOfPlaceholder, otherFilter, params);
        String sql = "SELECT en.fid, en.fentryid, en.ftype, en.fnumber, en.fname, en.fres_pk, en.fres_time, en.fsize, en.fremark, so.fname as fsolution_name, so.fnumber as fsolution_number FROM t_isc_solution_mr en, t_isc_solution_center so WHERE en.ftype in (" + typeOfPlaceholder + ") and en.fid = so.fid " + otherFilter + " UNION SELECT en.fid, en.fentryid, en.ftype, en.fnumber, en.fname, en.fres_pk, en.fres_time, en.fsize, null, so.fname as fsolution_name, so.fnumber as fsolution_number FROM t_isc_solution_rr en, t_isc_solution_center so WHERE en.ftype in (" + typeOfPlaceholder + ") and en.fid = so.fid " + otherFilter + "ORDER BY ftype ASC, fres_time DESC";
        DataSet dataSet = null;
        DataSet copy = null;
        DataSet resultDataSet = null;
        try {
            dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"iscb"), (String)sql, (Object[])params.toArray());
            if (StringUtils.isNotEmpty((CharSequence)pageSearchParam)) {
                dataSet = dataSet.filter(new FilterFunction(){

                    public boolean test(Row row) {
                        return row.getString("FSOLUTION_NUMBER").contains(pageSearchParam);
                    }
                });
            }
            if (StringUtils.isNotEmpty((CharSequence)searchCondition)) {
                dataSet = dataSet.filter(new FilterFunction(){

                    public boolean test(Row row) {
                        return row.getString(ResourceCenterFormPlugin.FNUMBER).contains(searchCondition) || row.getString(ResourceCenterFormPlugin.FNAME).contains(searchCondition) || row.getString("FSOLUTION_NUMBER").contains(searchCondition) || row.getString("FSOLUTION_NAME").contains(searchCondition);
                    }
                });
            }
            copy = dataSet.copy();
            int totalSize = copy.count("fid", false);
            resultDataSet = copy.range(start, limit);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(32);
            Set<String> fieldSet = ResourceCenterFormPlugin.getDataSetField(resultDataSet);
            while (resultDataSet.hasNext()) {
                Row row = resultDataSet.next();
                HashMap<String, Object> object = new HashMap<String, Object>();
                if (!CollectionUtils.isEmpty(fieldSet)) {
                    for (String selectField : fieldSet) {
                        if (row.get(selectField) != null) {
                            object.put(selectField, row.get(selectField));
                            continue;
                        }
                        object.put(selectField, "");
                    }
                }
                list.add(object);
            }
            logger.info("\u67e5\u8be2\u8d44\u6e90\u660e\u7ec6\u6570\u636e\uff0c\u8be6\u60c5\uff1a" + Json.toString(list));
            this.setDeployed(list);
            result.put("totalSize", totalSize);
            result.put("data", list);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (copy != null) {
                copy.close();
            }
            if (resultDataSet != null) {
                resultDataSet.close();
            }
        }
    }

    private void setQuerySQLParams(String billFormId, String types, StringBuilder placeholder, StringBuilder otherFilter, List<Object> params) {
        if (StringUtil.isEmpty((String)types)) {
            placeholder.append('?');
            params.add(billFormId);
        } else {
            String[] split = types.split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i == split.length - 1) {
                    placeholder.append('?');
                    continue;
                }
                placeholder.append("?,");
            }
            params.addAll(Arrays.asList(split));
        }
        Map<String, Object> searchField = this.getSearchField();
        String resNumber = D.s((Object)searchField.get("resNumber"));
        String resName = D.s((Object)searchField.get("resName"));
        String resPk = D.s((Object)searchField.get("resPk"));
        String solutionName = D.s((Object)searchField.get("solutionName"));
        if (!StringUtil.isEmpty((String)resNumber)) {
            otherFilter.append(" and en.fnumber like ?");
            params.add("%" + resNumber + "%");
        }
        if (!StringUtil.isEmpty((String)resName)) {
            otherFilter.append(" and en.fname like ?");
            params.add("%" + resName + "%");
        }
        if (!StringUtil.isEmpty((String)resPk)) {
            otherFilter.append(" and en.fres_pk = ?");
            params.add(resPk);
        }
        if (!StringUtil.isEmpty((String)solutionName)) {
            otherFilter.append(" and so.fname like ?");
            params.add("%" + solutionName + "%");
        }
        ArrayList<Object> copy = new ArrayList<Object>(params);
        params.addAll(copy);
    }

    private void setDeployed(List<Map<String, Object>> list) {
        if (list.isEmpty()) {
            return;
        }
        Map<String, List<Map<String, Object>>> classify = this.classify(list);
        for (Map.Entry<String, List<Map<String, Object>>> cls : classify.entrySet()) {
            String ftype = cls.getKey();
            List<Map<String, Object>> group = cls.getValue();
            this.setGroupDeployed(ftype, group);
        }
    }

    private void setGroupDeployed(String ftype, List<Map<String, Object>> group) {
        ISimpleProperty pkField = EntityMetadataCache.getDataEntityType((String)ftype).getPrimaryKey();
        Object[] pkArray = new Object[group.size()];
        for (int i = 0; i < group.size(); ++i) {
            Map<String, Object> map = group.get(i);
            map.put(FIS_DEPLOYED, Boolean.FALSE);
            pkArray[i] = pkField instanceof VarcharProp ? D.s((Object)map.get(FRES_PK)) : Long.valueOf(D.l((Object)map.get(FRES_PK)));
        }
        QFilter qFilter = new QFilter("id", "in", (Object)pkArray);
        DynamicObjectCollection dbObjects = QueryServiceHelper.query((String)ftype, (String)"id,modifytime", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject o : dbObjects) {
            for (Map<String, Object> map : group) {
                if (!D.s((Object)o.get("id")).equals(D.s((Object)this.getValueFromMapIgnoreCase(map, FRES_PK)))) continue;
                map.put(FIS_DEPLOYED, Boolean.TRUE);
                map.put(MODIFYTIME, o.get(MODIFYTIME));
            }
        }
    }

    private Map<String, List<Map<String, Object>>> classify(List<Map<String, Object>> list) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        for (Map<String, Object> map : list) {
            String ftype = D.s((Object)this.getValueFromMapIgnoreCase(map, "ftype"));
            List group = result.computeIfAbsent(ftype, k -> new ArrayList());
            group.add(map);
        }
        return result;
    }

    private <T> T getValueFromMapIgnoreCase(Map<String, T> data, String key) {
        T value = data.get(key);
        if (value != null) {
            return value;
        }
        value = data.get(key.toLowerCase());
        if (value != null) {
            return value;
        }
        return data.get(key.toUpperCase());
    }

    public static Set<String> getDataSetField(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>(fields.length);
        for (Field field : fields) {
            String fieldName = field.getName();
            fieldSet.add(fieldName);
        }
        return fieldSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadValueByEntryId(String key, long entryId) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "select %s from t_isc_solution_mr where fentryid = ? union all select %s from t_isc_solution_rr where fentryid = ?";
            sql = String.format(sql, key, key);
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)sql, Arrays.asList(entryId, entryId), Arrays.asList(-5, -5));
            String string = dataRow.getOrDefault((Object)key, (Object)"").toString();
            return string;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private int resetPage(int start) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(RESET_PAGE))) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            AbstractGrid.GridState entryState = proxy.getEntryState(KEY_LIST);
            entryState.setCurrentPageIndex(Integer.valueOf(1));
            this.getPageCache().remove(RESET_PAGE);
            return 0;
        }
        return start;
    }

    private String getFocusNodeId() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        return treeView.getTreeState().getFocusNodeId();
    }
}

