/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.backup;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.resource.backup.Util;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;

public class BackupTaskFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(BackupTaskFormPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate oper = (AbstractOperate)args.getSource();
        String key = oper.getOperateKey();
        if ("save".equals(key)) {
            int size = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
            if (size == 0) {
                String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u6e90", (String)"BackupTaskFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(Boolean.TRUE.booleanValue());
            } else if (size > 100) {
                String tips = ResManager.loadKDString((String)"\u6700\u591a\u6dfb\u52a0100\u4e2a\u8d44\u6e90", (String)"BackupTaskFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        try {
            if ("choose_res".equals(key)) {
                this.showF7();
            } else if ("log".equals(key)) {
                this.showLog();
            }
        }
        catch (Throwable t) {
            logger.error("The operation of " + key + " has an exception", t);
            this.getView().showTipNotification(t.getMessage());
        }
    }

    private void showLog() {
        EntryGrid e = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = e.getSelectRows();
        if (selectRows.length != 1) {
            String tips = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u65e5\u5fd7", (String)"BackupTaskFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        DynamicObject selectRes = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(selectRows[0]);
        Util.showLog(this.getView(), selectRes.getString("res_type.number"), selectRes.getString("res_pk"));
    }

    private void showF7() {
        ListShowParameter p = new ListShowParameter();
        p.setFormId("isc_resource_f7");
        p.getOpenStyle().setShowType(ShowType.Modal);
        p.setF7Style(0);
        p.setMultiSelect(true);
        p.setShowTitle(true);
        p.setHasRight(true);
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("700px");
        p.getOpenStyle().setInlineStyleCss(css);
        p.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_res"));
        p.setShowFilter(false);
        p.setShowQuickFilter(false);
        p.setCustomParam("limit", (Object)100);
        this.getView().showForm((FormShowParameter)p);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("select_res".equals(actionId)) {
            this.addResources((ListSelectedRowCollection)returnData);
        }
    }

    private void addResources(ListSelectedRowCollection collection) {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Map<String, DynamicObject> objectMap = BackupTaskFormPlugin.convertToMap(entries);
        for (ListSelectedRow row : collection) {
            Object resourcesId = row.getPrimaryKeyValue();
            String entity = row.getFormID();
            String key = SolutionUtil.getFullKey((String)entity, (Object)resourcesId);
            DynamicObject existedRes = objectMap.get(key);
            DynamicObject item = existedRes != null ? existedRes : entries.addNew();
            DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)entity);
            item.set("res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)entity, (String)"bos_objecttype"));
            item.set("res_number", (Object)res.getString("number"));
            item.set("res_name", (Object)res.getString("name"));
            item.set("res_pk", res.getPkValue());
            item.set("res_time", res.get(SolutionUtil.getTimeField((String)entity)));
        }
        this.getView().updateView("entryentity");
    }

    private static Map<String, DynamicObject> convertToMap(DynamicObjectCollection entries) {
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>(entries.size());
        for (DynamicObject object : entries) {
            String entity = D.s((Object)((DynamicObject)object.get("res_type")).getPkValue());
            String pk = D.s((Object)object.get("res_pk"));
            map.put(SolutionUtil.getFullKey((String)entity, (Object)pk), object);
        }
        return map;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("name") && !StringUtil.isEmpty((String)(name = D.s((Object)e.getChangeSet()[0].getNewValue())))) {
            this.getModel().setValue("billno", (Object)Hash.mur32((Object[])new Object[]{name}));
        }
    }
}

