/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.backup;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.isc.iscb.platform.core.resource.backup.GitlabNetUtil;
import kd.isc.iscb.platform.core.resource.backup.GitlabParam;
import kd.isc.iscb.platform.core.resource.backup.PushJob;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.SystemContext;

public class BackupTaskListPlugin
extends AbstractListPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (SystemContext.isProcEnv()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pull"});
        }
        DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"isc_res_backup_git_cfg", (QFilter[])new QFilter[0]);
        List iscRoleAdmin = PermissionServiceHelper.getUsersByRoleNum((String)"ISC_Role_002");
        if (iscRoleAdmin.contains(RequestContext.get().getCurrUserId()) && config == null) {
            FormShowParameter p = new FormShowParameter();
            p.setFormId("isc_res_backup_git_cfg");
            p.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(p);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection collection;
        super.beforeDoOperation(args);
        AbstractOperate oper = (AbstractOperate)args.getSource();
        String key = oper.getOperateKey();
        if ("push".equals(key) && (collection = args.getListSelectedData()).size() != 1) {
            String tips = ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u63a8\u9001", (String)"BackupTaskListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("pull".equals(key)) {
            this.pull();
        } else if ("push".equals(key) && args.getOperationResult().isSuccess()) {
            Object pk = args.getOperationResult().getSuccessPkIds().get(0);
            this.openCompare(D.l(pk));
        } else if ("refresh".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"push", "delete"});
        } else if ("git_config".equals(key)) {
            FormShowParameter p = new FormShowParameter();
            p.setFormId("isc_res_backup_git_cfg");
            p.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(p);
        }
    }

    private void openCompare(long taskId) {
        try {
            GitlabParam.get();
            FormShowParameter p = new FormShowParameter();
            p.setFormId("isc_res_backup_compare");
            p.setCustomParam("taskId", (Object)taskId);
            p.getOpenStyle().setShowType(ShowType.Modal);
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "opencompare"));
            this.getView().showForm(p);
        }
        catch (Throwable t) {
            this.getView().showTipNotification(StringUtil.getCascadeMessage((Throwable)t));
        }
    }

    private void pull() {
        try {
            GitlabNetUtil.queryRepositoryTree((String)GitlabNetUtil.createDataCenterCatalogPath(), (int)1, (int)1);
            FormShowParameter p = new FormShowParameter();
            p.setFormId("isc_res_backup_res_cloud");
            p.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(p);
        }
        catch (Throwable t) {
            this.getView().showTipNotification(StringUtil.getCascadeMessage((Throwable)t));
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection selectedRows = evt.getListSelectedRowCollection();
        if (selectedRows.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"push", "delete"});
        } else {
            String billStatus = selectedRows.get(0).getBillStatus();
            if (PushJob.BillStatus.A.name().equals(billStatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"push", "delete"});
            } else if (PushJob.BillStatus.B.name().equals(billStatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"delete"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"push"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"push", "delete"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.getView().invokeOperation("refresh");
    }
}

