/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.backup;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.resource.backup.Branch;
import kd.isc.iscb.platform.core.resource.backup.GitlabNetUtil;
import kd.isc.iscb.platform.core.resource.backup.GitlabParam;
import kd.isc.iscb.platform.core.resource.backup.Project;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class GitConfigFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((String)"isc_res_backup_git_cfg", (QFilter[])new QFilter[0]);
        if (cfg != null) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            this.getView().cacheFormShowParameter();
            DynamicObject object = this.getModel().getDataEntity(true);
            object.set("id", cfg.getPkValue());
            object.set("domain", cfg.get("domain"));
            object.set("project_id", cfg.get("project_id"));
            object.set("project_name", cfg.get("project_name"));
            object.set("private_token", cfg.get("private_token"));
            this.updateBranches();
            object.set("branch", cfg.get("branch"));
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("save2".equals(key) && args.getOperationResult().isSuccess()) {
            String tips = ResManager.loadKDString((String)"\u4fee\u6539git\u914d\u7f6e\u540e\uff0c\u6570\u636e\u5907\u4efd\u5c06\u6309\u7167\u60a8\u914d\u7f6e\u7684\u5730\u5740\u63a8\u9001\u548c\u62c9\u53d6\uff0c\u786e\u8ba4\u8981\u7ee7\u7eed\u4fdd\u5b58\u5417\uff1f", (String)"GitConfigFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("save2", (IFormPlugin)this);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("save2".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            DynamicObject object = this.getModel().getDataEntity(true);
            long id = D.l((Object)this.getModel().getValue("id"));
            if (id == 0L) {
                object.set("id", (Object)IDService.get().genLongId());
                SaveServiceHelper.saveOperate((String)"isc_res_backup_git_cfg", (DynamicObject[])new DynamicObject[]{object});
            } else {
                SaveServiceHelper.update((DynamicObject)object);
            }
            this.createReadmeForDataCenter();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GitConfigFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void createReadmeForDataCenter() {
        String fullpath = GitlabNetUtil.createDataCenterCatalogPath() + "Readme.md";
        RequestContext rc = RequestContext.get();
        Account dataCenter = AccountUtils.getAccountById((String)rc.getAccountId());
        String s = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u5b58\u50a8\u6b64\u6570\u636e\u4e2d\u5fc3\u7684\u96c6\u6210\u4e91\u5907\u4efd\u8d44\u6e90\u3002\u79df\u6237ID\uff1a%1$s\u3002\u6570\u636e\u4e2d\u5fc3ID\uff1a%2$s\u3002\u6570\u636e\u4e2d\u5fc3\u7f16\u7801\uff1a%3$s\u3002", (String)"GitConfigFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), rc.getTenantId(), rc.getAccountId(), dataCenter.getAccountNumber());
        GitlabParam param = new GitlabParam(D.s((Object)this.getModel().getValue("domain")), D.s((Object)this.getModel().getValue("project_id")), D.s((Object)this.getModel().getValue("private_token")), D.s((Object)this.getModel().getValue("branch")));
        GitlabNetUtil.postFile((String)fullpath, (String)s, (GitlabParam)param, (String)"Create Readme File");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("domain".equals(key) || "project_id".equals(key) || "private_token".equals(key)) {
            this.updateBranches();
        }
    }

    private void updateBranches() {
        try {
            this.getBranchesAndFill();
        }
        catch (Exception ex) {
            FormOpener.showErrorMessage(this.getView(), ex);
        }
    }

    private void getBranchesAndFill() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("branch");
        comboEdit.setComboItems(new ArrayList());
        this.getModel().setValue("branch", (Object)"");
        this.getModel().setValue("project_name", (Object)"");
        String domain = D.s((Object)this.getModel().getValue("domain"));
        String projectId = D.s((Object)this.getModel().getValue("project_id"));
        String privateToken = D.s((Object)this.getModel().getValue("private_token"));
        if (!(StringUtil.isEmpty((String)domain) || StringUtil.isEmpty((String)projectId) || StringUtil.isEmpty((String)privateToken))) {
            GitlabParam param = new GitlabParam(domain, projectId, privateToken);
            List branches = GitlabNetUtil.queryProjectBranches((GitlabParam)param);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(branches.size());
            for (Branch b : branches) {
                String name = b.getName();
                if (b.isDefault()) {
                    String defaultTag = ResManager.loadKDString((String)"(\u9ed8\u8ba4)", (String)"GitConfigFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                    name = name + defaultTag;
                    this.getModel().setValue("branch", (Object)b.getName());
                }
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(name));
                item.setValue(b.getName());
                comboItems.add(item);
            }
            comboEdit.setComboItems(comboItems);
            Project project = GitlabNetUtil.querySingleProject((GitlabParam)param);
            this.getModel().setValue("project_name", (Object)project.getName());
        }
    }
}

