/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.packages;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.resource.packages.ExportUtil;
import kd.isc.iscb.platform.core.resource.packages.PackagesExportJob;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class PackagesListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection collection;
        super.beforeDoOperation(args);
        AbstractOperate oper = (AbstractOperate)args.getSource();
        String key = oper.getOperateKey();
        if (("export".equals(key) || "export_record".equals(key)) && (collection = args.getListSelectedData()).size() != 1) {
            String tips = ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u5bfc\u51fa", (String)"PackagesListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("export".equals(key)) {
            Object pk = args.getOperationResult().getSuccessPkIds().get(0);
            this.startExportJob(D.l(pk));
        } else if ("import".equals(key)) {
            this.openImportForm();
        } else if ("export_record".equals(key)) {
            Object pk = args.getOperationResult().getSuccessPkIds().get(0);
            QFilter qFilter = new QFilter("packages", "=", pk);
            FormOpener.openBillList((AbstractFormPlugin)this, "isc_res_packages_export", Collections.singletonList(qFilter));
        } else if ("import_record".equals(key)) {
            QFilter qFilter = new QFilter("res_type", "=", (Object)FileResourceUtil.getEntityTitle((String)"isc_res_packages"));
            FormOpener.openBillList((AbstractFormPlugin)this, "isc_dts_imp", Collections.singletonList(qFilter));
        }
    }

    private void openImportForm() {
        BillShowParameter param = new BillShowParameter();
        param.setFormId("isc_dts_imp_packages");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("entity", (Object)"isc_res_packages");
        param.setStatus(OperationStatus.ADDNEW);
        param.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u96c6\u6210\u8d44\u6e90\u5305", (String)"PackagesListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)param);
    }

    private void startExportJob(long packagesId) {
        List jobs = JobEngine.getJobsWithOwnerId((long)packagesId);
        if (jobs.isEmpty()) {
            this.startNewJob(packagesId);
        } else {
            this.openRunningJob(packagesId, jobs);
        }
    }

    private void openRunningJob(long packagesId, List<JobInfo> jobs) {
        JobInfo jobInfo = jobs.get(0);
        String exportNumber = jobInfo.getTitle().split(":")[1];
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("number", exportNumber);
        param.put("packagesId", packagesId);
        FormOpener.reopenJob((AbstractFormPlugin)this, jobInfo.getId(), jobInfo.getTitle(), "started", param);
    }

    private void startNewJob(long packagesId) {
        long billId = IDService.get().genLongId();
        String number = Hash.mur32((Object[])new Object[]{billId});
        String title = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8d44\u6e90\u5305\u5e76\u5bfc\u51fa\uff0c\u6279\u53f7:%s", (String)"PackagesListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number);
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("billId", billId);
        param.put("number", number);
        param.put("packagesId", packagesId);
        PackagesExportJob job = new PackagesExportJob(title, Json.toString(param));
        FormOpener.startJob((AbstractFormPlugin)this, (Job)job, "started", param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("started".equals(action)) {
            boolean jobComplete;
            Map returnData = (Map)evt.getReturnData();
            boolean bl = jobComplete = !JobEngine.existsRunningJobWithOwnerId((long)D.l(returnData.get("packagesId")));
            if (jobComplete) {
                this.downloadZip(returnData);
            }
        }
    }

    private void downloadZip(Map<String, Object> returnData) {
        String exportNumber = D.s((Object)returnData.get("number"));
        QFilter filter = new QFilter("number", "=", (Object)exportNumber);
        DynamicObject query = QueryServiceHelper.queryOne((String)"isc_res_packages_export", (String)"id", (QFilter[])new QFilter[]{filter});
        if (query != null) {
            try {
                ExportUtil.export((long)D.l((Object)query.get("id")), (IFormView)this.getView());
            }
            catch (Throwable t) {
                FormOpener.showErrorMessage(this.getView(), t);
            }
        }
    }
}

