/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.robot;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.isc.iscb.formplugin.robot.SmartRobotUtil;
import kd.isc.iscb.formplugin.robot.SmartScriptTypeEnum;
import kd.isc.iscb.platform.core.mapping.bean.PropertyModel;
import kd.isc.iscb.platform.core.mapping.util.PropertyUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class SmartRobotChatFormPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(SmartRobotChatFormPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initChat();
        long source_schema = D.l((Object)this.getView().getFormShowParameter().getCustomParam("source_schema"));
        long target_schema = D.l((Object)this.getView().getFormShowParameter().getCustomParam("target_schema"));
        String srcMetaDesc = SmartRobotChatFormPlugin.buildMetaSmartDesc(source_schema);
        String tarMetaDesc = SmartRobotChatFormPlugin.buildMetaSmartDesc(target_schema);
        this.getPageCache().put("srcMetaDesc", srcMetaDesc);
        this.getPageCache().put("tarMetaDesc", tarMetaDesc);
        long gaiPromptId = SmartScriptTypeEnum.DataCopyTransScriptEX.getGaiPromptId();
        this.getPageCache().put("gaiPromptId", D.s((Object)gaiPromptId));
        LOG.warn(ResManager.loadKDString((String)"\u7f13\u5b58\u7684\u63d0\u793a\u8bcdID\u662f\uff1a", (String)"SmartRobotChatFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + gaiPromptId);
        this.getPageCache().put("chatSessionId", UUID.randomUUID().toString());
    }

    public void initChat() {
        this.getModel().setValue("chat", null);
    }

    private String getScene() {
        return ResManager.loadKDString((String)"\u4f60\u662f\u4e00\u4e2aDSL\u751f\u6210\u5de5\u5177\uff0c\u4e0d\u8981\u4f7f\u7528JavaScript\u8bed\u6cd5\uff0c\u8bf7\u4e25\u683c\u6839\u636e\u4ee5\u4e0b\u63d0\u4f9b\u7684\u8bed\u6cd5\u751f\u6210\u811a\u672c\uff0c\u53ea\u9700\u8981\u8fd4\u56de\u751f\u6210\u7684\u811a\u672c\u548c\u811a\u672c\u91cc\u7684\u6ce8\u91ca\uff0c\u5982\u679c\u65e0\u6cd5\u751f\u6210\u8bf7\u8bf4\u660e\u539f\u56e0", (String)"SmartRobotChatFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("ok".equals(operateKey)) {
            String inputText = this.getInputText();
            String chatSessionId = this.getPageCache().get("chatSessionId");
            if (inputText == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u63cf\u8ff0\u60a8\u7684\u9700\u6c42", (String)"SmartRobotChatFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<String, String> promptInputMap = this.getPromptInputMap();
            LOG.warn("AI\u8c03\u7528\u7684\u8f93\u5165\u662f\uff0cchatSessionId\uff1a" + chatSessionId + "\n" + Json.toString(promptInputMap, (boolean)true));
            Map resp = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCallUseHistoryMsg", (Object[])new Object[]{chatSessionId, D.l((Object)this.getPageCache().get("gaiPromptId")), inputText, promptInputMap});
            LOG.warn("AI\u8fd4\u56de\u7684\u7ed3\u679c\u662f\uff1a" + Json.toString((Object)resp, (boolean)true));
            this.afterInvokeGpt(resp);
        } else if ("clear".equals(operateKey)) {
            this.getPageCache().remove("requestId");
            this.getModel().setValue("message", null);
            this.initChat();
        }
    }

    public void afterInvokeGpt(Map<String, Object> resp) {
        String text = this.buildRespMessage(resp);
        this.getModel().setValue("message", (Object)text);
        this.initChat();
    }

    public String buildRespMessage(Map<String, Object> resp) {
        String message = this.getPageCache().get("message");
        String inputText = "P\uff1a" + this.getInputText() + "\n";
        String data = "AI\uff1a" + SmartRobotUtil.formatAiResp(resp) + "\n";
        String result = message != null ? message + "\n" + inputText + data : inputText + data;
        this.getPageCache().put("message", result);
        return result;
    }

    public Map<String, String> getPromptInputMap() {
        HashMap<String, String> promptInput = new HashMap<String, String>();
        promptInput.put("src", this.getPageCache().get("srcMetaDesc"));
        promptInput.put("tar", this.getPageCache().get("tarMetaDesc"));
        promptInput.put("scene", this.getScene());
        return promptInput;
    }

    public String getInputText() {
        return this.getModel().getDataEntity().getString("chat");
    }

    public static String buildMetaSmartDesc(long id) {
        if (id > 0L) {
            Map propModels = PropertyUtil.initPropertyMap((long)id, (String)"", (String)"");
            Collection values = propModels.values();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(values.size());
            for (PropertyModel tarProp : values) {
                SmartRobotChatFormPlugin.buildOneProp(map, tarProp);
            }
            return JSON.toJSONString(map);
        }
        return "";
    }

    public static void buildOneProp(Map<String, Object> map, PropertyModel prop) {
        Map childProps = prop.getChildProps();
        if (!childProps.isEmpty()) {
            LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>();
            for (PropertyModel value : childProps.values()) {
                SmartRobotChatFormPlugin.buildOneProp(subMap, value);
            }
            map.put(prop.getName(), subMap);
        } else {
            map.put(prop.getName(), prop.getDetailedDesc());
        }
    }
}

