/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.robot;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.util.dt.D;

public class SmartRobotListPlugin
extends AbstractListPlugin {
    private static final String GAI_PROMPT = "gai_prompt";
    private static final Log LOG = LogFactory.getLog(SmartRobotListPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String op = args.getOperateKey();
        try {
            if ("enable".equals(op)) {
                List successPkIds = args.getOperationResult().getSuccessPkIds();
                if (successPkIds.size() > 0) {
                    for (Object pkId : successPkIds) {
                        SmartRobotListPlugin.enableGaiPrompt(D.l(pkId));
                    }
                }
            } else if ("set_server".equals(op)) {
                this.showServer();
            } else if ("update_cloud".equals(op)) {
                List data = PublicResourceUtil.queryListByGet((String)"kapi/v2/kdec/kdec_eip_resource/kdec_smart_robot_cloud/KD_ISC_GET_CLOUD", Collections.emptyMap());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("data", data);
                FormOpener.showForm((AbstractFormPlugin)this, "isc_smart_cloudrobot_list", "", params, "update_cloud");
            } else if ("disable".equals(op)) {
                List successPkIds = args.getOperationResult().getSuccessPkIds();
                OperationServiceHelper.executeOperate((String)"delete", (String)GAI_PROMPT, (Object[])successPkIds.toArray(), (OperateOption)OperateOption.create());
            }
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void showServer() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        FormOpener.showF7((AbstractFormPlugin)this, "aicc_instance", filters.toArray(new QFilter[0]), "aicc_instance", false);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returns = evt.getReturnData();
        if ("aicc_instance".equals(evt.getActionId()) && returns instanceof ListSelectedRowCollection) {
            DynamicObject[] objects;
            ListSelectedRowCollection c = (ListSelectedRowCollection)returns;
            Object selectID = c.get(0).getPrimaryKeyValue();
            DynamicObject aicc = BusinessDataServiceHelper.loadSingle((Object)selectID, (String)"aicc_instance", (String)"service.number");
            ListSelectedRowCollection selectedSchemaRows = this.getSelectedRows();
            Object[] primaryKeyValues = selectedSchemaRows.getPrimaryKeyValues();
            for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"isc_smart_robot", (String)"language_model", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)})) {
                object.set("language_model", aicc.get("service.number"));
            }
            OperationResult result = ConnectorUtil.doBatchAction((DynamicObject[])objects, (String)"save");
            LOG.warn(ResManager.loadKDString((String)"\u8bbe\u7f6e\u670d\u52a1\u5668\u5b9e\u4f8b\u7ed3\u679c", (String)"SmartRobotListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Object)result);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5b9e\u4f8b\u8bbe\u7f6e\u6210\u529f\u3002", (String)"SmartRobotListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if ("update_cloud".equals(evt.getActionId()) && returns instanceof String) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e91\u66f4\u65b0\u6210\u529f\u3002", (String)"SmartRobotListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public static void enableGaiPrompt(long id) {
        DynamicObject iscSmartRobot = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_smart_robot");
        DynamicObject gai = SmartRobotListPlugin.createOneGaiPrompt(id);
        gai.set("number", iscSmartRobot.get("number"));
        gai.set("name", iscSmartRobot.get("name"));
        gai.set("ispreset", (Object)"0");
        gai.set("desc", iscSmartRobot.get("desc"));
        gai.set("org_id", (Object)100000L);
        gai.set("createorg_id", (Object)100000L);
        gai.set("useorg_id", (Object)100000L);
        gai.set("srccreateorg_id", (Object)100000L);
        gai.set("enable", (Object)"1");
        gai.set("status", (Object)"C");
        gai.set("ctrlstrategy", (Object)5);
        gai.set("blgids", (Object)"41");
        String language_model = iscSmartRobot.getString("language_model");
        gai.set("language_model", (Object)language_model);
        gai.set("model_style", iscSmartRobot.get("model_style"));
        gai.set("prompt", iscSmartRobot.get("prompt"));
        gai.set("prompt_tag", iscSmartRobot.get("prompt_tag"));
        gai.set("remembercount", iscSmartRobot.get("remembercount"));
        DynamicObjectCollection collection = gai.getDynamicObjectCollection("var_configs");
        collection.clear();
        for (DynamicObject object : iscSmartRobot.getDynamicObjectCollection("var_configs")) {
            DynamicObject row = collection.addNew();
            row.set("var", object.get("var"));
            row.set("var_name", object.get("var_name"));
            row.set("var_type", object.get("var_type"));
        }
        DynamicObjectCollection output = gai.getDynamicObjectCollection("out_var_configs");
        output.clear();
        DynamicObject out = output.addNew();
        out.set("out_var", (Object)"prompt_output");
        out.set("out_var_name", (Object)"GPT_outputs");
        out.set("out_var_type", (Object)"String");
        out.set("out_json_analysis", (Object)"0");
        ConnectorUtil.save((DynamicObject)gai);
    }

    private static DynamicObject createOneGaiPrompt(long id) {
        QFilter q = new QFilter("id", "=", (Object)id);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)GAI_PROMPT, (String)"id", (QFilter[])new QFilter[]{q});
        if (object == null) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)GAI_PROMPT);
            obj.set("creator", (Object)RequestContext.get().getCurrUserId());
            obj.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            obj.set("id", (Object)id);
            obj.set("masterid", (Object)id);
            obj.set("sourcedata", (Object)id);
            return obj;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)GAI_PROMPT);
    }
}

