/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.robot;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.isc.iscb.formplugin.robot.SmartRobotChatFormPlugin;
import kd.isc.iscb.formplugin.robot.SmartRobotUtil;
import kd.isc.iscb.formplugin.robot.SmartScriptTypeEnum;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class SmartRobotParseFormPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(SmartRobotParseFormPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String script = (String)this.getView().getFormShowParameter().getCustomParam("script");
        this.getModel().setValue("script", (Object)script);
        this.getModel().setValue("textareafield", (Object)ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u6211\u4eec\u63d0\u4f9b\u7684AI\u811a\u672c\u5206\u6790\u548c\u4fee\u6b63\u5efa\u8bae\u670d\u52a1\u4ec5\u4f9b\u53c2\u8003\u3002\u867d\u7136\u6211\u4eec\u81f4\u529b\u4e8e\u786e\u4fdd\u5efa\u8bae\u7684\u51c6\u786e\u6027\u548c\u76f8\u5173\u6027\uff0c\u4f46\u4e0d\u80fd\u4fdd\u8bc1\u8fd9\u4e9b\u5efa\u8bae\u5728\u6240\u6709\u60c5\u51b5 \u4e0b\u90fd\u662f\u5b8c\u5168\u6b63\u786e\u6216\u9002\u7528\u7684\u3002", (String)"SmartRobotChatFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        long source_schema = D.l((Object)this.getView().getFormShowParameter().getCustomParam("source_schema"));
        long target_schema = D.l((Object)this.getView().getFormShowParameter().getCustomParam("target_schema"));
        String srcMetaDesc = SmartRobotChatFormPlugin.buildMetaSmartDesc(source_schema);
        String tarMetaDesc = SmartRobotChatFormPlugin.buildMetaSmartDesc(target_schema);
        this.getPageCache().put("srcMetaDesc", srcMetaDesc);
        this.getPageCache().put("tarMetaDesc", tarMetaDesc);
        long gaiPromptId = SmartScriptTypeEnum.DataCopyTransScriptEX.getGaiPromptId();
        this.getPageCache().put("gaiPromptId", D.s((Object)gaiPromptId));
    }

    public Map<String, String> getPromptInputMap() {
        HashMap<String, String> promptInput = new HashMap<String, String>();
        promptInput.put("src", this.getPageCache().get("srcMetaDesc"));
        promptInput.put("tar", this.getPageCache().get("tarMetaDesc"));
        promptInput.put("scene", this.getScene());
        return promptInput;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.invokeParseService();
    }

    public void invokeParseService() {
        String script = this.getModel().getDataEntity().getString("script");
        if (StringUtil.isEmpty((String)script)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u811a\u672c", (String)"SmartRobotChatFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> promptInputMap = this.getPromptInputMap();
        LOG.warn("AI\u89e3\u6790\u8c03\u7528\u7684\u8f93\u5165\u662f\uff1a" + Json.toString(promptInputMap, (boolean)true));
        Map resp = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])new Object[]{D.l((Object)this.getPageCache().get("gaiPromptId")), script, promptInputMap});
        LOG.warn("AI\u89e3\u6790\u8fd4\u56de\u7684\u7ed3\u679c\u662f\uff1a" + Json.toString((Object)resp, (boolean)true));
        String aiResp = SmartRobotUtil.formatAiResp(resp);
        this.getModel().setValue("report", (Object)aiResp);
        this.getView().updateView("report");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("ok".equals(operateKey)) {
            this.getView().returnDataToParent(this.getModel().getValue("script"));
            this.getView().close();
        } else if ("resend".equals(operateKey)) {
            this.invokeParseService();
        }
    }

    private String getScene() {
        return ResManager.loadKDString((String)"\u4f60\u662f\u4e00\u4e2aDSL\u68c0\u67e5\u5de5\u5177\uff0c\u6839\u636e\u4ee5\u4e0b\u8bed\u6cd5\u68c0\u67e5\u7528\u6237\u7684\u811a\u672c\u662f\u5426\u5b58\u5728\u95ee\u9898\uff0c\u5e76\u7ed9\u51fa\u4fee\u6539\u610f\u89c1\uff1a", (String)"SmartRobotChatFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }
}

