/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.api.ApiResourceType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class ApiFunctionEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String PARAM_INPUT_NAME = "param_input_name";
    private static final String PARAM_INPUT_TITLE = "param_input_title";
    private static final String PARAM_INPUT_TYPE = "param_input_type";
    private static final String PARAM_INPUT_VALUE = "param_input_value";
    private static final String PARAM_INPUT_VAR = "param_input_var";
    private static final String PARAM_OUTPUT_NAME = "param_output_name";
    private static final String PARAM_OUTPUT_TITLE = "param_output_title";
    private static final String PARAM_OUTPUT_TYPE = "param_output_type";
    private static final String PARAM_OUTPUT_VAR = "param_output_var";
    private static final String ENTRYENTITY_INPUT = "entryentity_input";
    private static final String ENTRYENTITY_OUTPUT = "entryentity_output";
    private static final String FUNC = "func";
    private static final String FUNC_TYPE = "func_type";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String FIXED_VALUE = "fixed_value";
    private static final String VAR_VALUE = "var_value";
    private static final String VIEW = "view";
    public static final String OPEN_API_VIEW = "openApiView";
    public static final String CALLER = "caller";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("title", params.get("title"));
        String alias = D.s(params.get(FUNC));
        this.getModel().setValue(FUNC, (Object)alias);
        String caller = D.s(params.get(CALLER));
        this.getModel().setValue(CALLER, (Object)caller);
        this.getModel().setValue("save_state_on_success", (Object)D.x(params.get("save_state_on_success")));
        this.getModel().setValue("wait_for_on_failed", (Object)D.s(params.get("wait_for_on_failed")));
        this.getModel().setValue("wait_for_premise", (Object)D.s(params.get("wait_for_premise")));
        if (this.getModel().getValue("title") == null) {
            this.getModel().setValue("title", (Object)ResManager.loadKDString((String)"\u51fd\u6570", (String)"ApiFunctionEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        this.setEntries(params, alias);
    }

    private void setEntries(Map<String, Object> params, String alias) {
        if (this.isEditable() && !StringUtil.isEmpty((String)alias)) {
            this.setEntriesByAlias(alias);
        } else if (!this.isEditable()) {
            this.getModel().setValue(FUNC_TYPE, params.get(FUNC_TYPE));
            EditorUtil.setInstCombo(this, FUNC, "description");
            this.setInstInputEntry(params);
            this.setInstOutputEntry(params);
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private boolean isEditable() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
    }

    private void setEntriesByAlias(String alias) {
        String type = EditorUtil.getTypeByalias(this, alias);
        this.getModel().setValue(FUNC_TYPE, (Object)type);
        this.setCombo(type);
        DynamicObject obj = EditorUtil.getObjByAlias(this, type, alias);
        List<Map<String, String>> inputs = this.getInputList(type, obj);
        this.setEditableInputEntry(inputs);
        List<Map<String, String>> outputs = this.getOutputList(type, obj);
        this.setEditableOutputEntry(outputs);
    }

    private void setInstOutputEntry(Map<String, Object> params) {
        Map outputs = (Map)params.get(OUTPUT);
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_OUTPUT);
        param_entryentity.clear();
        for (Map.Entry output : outputs.entrySet()) {
            DynamicObject item = param_entryentity.addNew();
            item.set(PARAM_OUTPUT_NAME, output.getKey());
            item.set(PARAM_OUTPUT_TYPE, ((Map)output.getValue()).get("type"));
            item.set(PARAM_OUTPUT_TITLE, ((Map)output.getValue()).get("description"));
            item.set(PARAM_OUTPUT_VAR, ((Map)output.getValue()).get(VAR_VALUE));
        }
    }

    private void setInstInputEntry(Map<String, Object> params) {
        Map inputs = (Map)params.get(INPUT);
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_INPUT);
        param_entryentity.clear();
        for (Map.Entry input : inputs.entrySet()) {
            DynamicObject item = param_entryentity.addNew();
            item.set(PARAM_INPUT_NAME, input.getKey());
            item.set(PARAM_INPUT_TYPE, ((Map)input.getValue()).get("type"));
            item.set(PARAM_INPUT_TITLE, ((Map)input.getValue()).get("description"));
            item.set(PARAM_INPUT_VALUE, ((Map)input.getValue()).get(FIXED_VALUE));
            item.set(PARAM_INPUT_VAR, ((Map)input.getValue()).get(VAR_VALUE));
        }
    }

    private void setCombo(String entityType) {
        List<ComboItem> items = EditorUtil.getComboItems(this, entityType);
        ComboEdit combo = (ComboEdit)this.getView().getControl(FUNC);
        combo.setComboItems(items);
    }

    private List<Map<String, String>> getOutputList(String entityName, DynamicObject api) {
        List outputs = null;
        for (ApiResourceType value : ApiResourceType.values()) {
            if (!String.valueOf(value).equals(entityName)) continue;
            outputs = value.getOutput(api);
        }
        return outputs;
    }

    private List<Map<String, String>> getInputList(String entityType, DynamicObject obj) {
        List inputs = null;
        for (ApiResourceType value : ApiResourceType.values()) {
            if (!String.valueOf(value).equals(entityType)) continue;
            inputs = value.getInput(obj);
        }
        return inputs;
    }

    private void setEditableOutputEntry(List<Map<String, String>> outputs) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_OUTPUT);
        param_entryentity.clear();
        for (Map<String, String> output : outputs) {
            Map out;
            DynamicObject item = param_entryentity.addNew();
            item.set(PARAM_OUTPUT_NAME, (Object)output.get(PARAM_OUTPUT_NAME));
            item.set(PARAM_OUTPUT_TYPE, (Object)output.get(PARAM_OUTPUT_TYPE));
            item.set(PARAM_OUTPUT_TITLE, (Object)StringUtil.trim((String)output.get(PARAM_OUTPUT_TITLE), (int)250));
            Map outputMap = (Map)this.getView().getFormShowParameter().getCustomParam(OUTPUT);
            if (outputMap == null || (out = (Map)outputMap.get(output.get(PARAM_OUTPUT_NAME))) == null) continue;
            item.set(PARAM_OUTPUT_VAR, out.get(VAR_VALUE));
        }
        this.getView().updateView(ENTRYENTITY_OUTPUT);
    }

    private void setEditableInputEntry(List<Map<String, String>> inputs) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_INPUT);
        param_entryentity.clear();
        for (Map<String, String> input : inputs) {
            Map in;
            DynamicObject item = param_entryentity.addNew();
            item.set(PARAM_INPUT_NAME, (Object)input.get(PARAM_INPUT_NAME));
            item.set(PARAM_INPUT_TYPE, (Object)input.get(PARAM_INPUT_TYPE));
            item.set(PARAM_INPUT_TITLE, (Object)StringUtil.trim((String)input.get(PARAM_INPUT_TITLE), (int)250));
            Map inputMap = (Map)this.getView().getFormShowParameter().getCustomParam(INPUT);
            if (inputMap == null || (in = (Map)inputMap.get(input.get(PARAM_INPUT_NAME))) == null) continue;
            item.set(PARAM_INPUT_VALUE, in.get(FIXED_VALUE));
            item.set(PARAM_INPUT_VAR, in.get(VAR_VALUE));
        }
        this.getView().updateView(ENTRYENTITY_INPUT);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (FUNC_TYPE.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            String entityName = D.s((Object)changeSet[0].getNewValue());
            this.setCombo(entityName);
        } else if (FUNC.equals(name)) {
            String entityName = D.s((Object)this.getModel().getValue(FUNC_TYPE));
            ChangeData[] changeSet = e.getChangeSet();
            String newValue = D.s((Object)changeSet[0].getNewValue());
            DynamicObject obj = EditorUtil.getObjByAlias(this, entityName, newValue);
            List<Map<String, String>> inputs = this.getInputList(entityName, obj);
            this.setEditableInputEntry(inputs);
            List<Map<String, String>> outputs = this.getOutputList(entityName, obj);
            this.setEditableOutputEntry(outputs);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARAM_INPUT_VAR, PARAM_OUTPUT_VAR, VIEW, "wait_for_premise", "wait_for_on_failed"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        try {
            if (VIEW.equals(key)) {
                this.openObjForm();
            } else if (Arrays.asList(PARAM_INPUT_VAR, PARAM_OUTPUT_VAR).contains(key)) {
                EditorUtil.selectVariableProperty(this, key);
            } else if ("wait_for_premise".equals(key) || "wait_for_on_failed".equals(key)) {
                ScriptTextUtil.openRetryScriptForm(this.getModel().getValue(key), this, key, key);
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            if (!this.isEditable()) {
                this.getView().close();
                return;
            }
            if ("returndata".equals(evt.getOperateKey()) && evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
                this.checkTypeAndApi();
                this.setReturnData();
                this.getView().close();
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void checkTypeAndApi() {
        String type = D.s((Object)this.getModel().getValue(FUNC_TYPE));
        String alias = D.s((Object)this.getModel().getValue(FUNC));
        if (type != null && !type.equals(EditorUtil.getTypeByAlias(this, alias))) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u51fd\u6570&API\u9009\u62e9\u4e00\u4e2a%s,\u5982\u679c\u4e0b\u62c9\u5217\u8868\u4e3a\u7a7a\uff0c\u9700\u8981\u5728\u6d41\u7a0b\u5c5e\u6027\u4e2d\u5f15\u5165\u5bf9\u5e94\u7684\u8d44\u6e90\u3002", (String)"ApiFunctionEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)type).getDisplayName().getLocaleValue()));
        }
    }

    private void openObjForm() {
        String alias = D.s((Object)this.getModel().getValue(FUNC));
        if (StringUtil.isEmpty((String)alias)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2aapi\u6216\u51fd\u6570\u3002", (String)"ApiFunctionEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        String entityName = D.s((Object)this.getModel().getValue(FUNC_TYPE));
        long id = EditorUtil.getIdByAlias(this, alias);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPEN_API_VIEW);
        this.checkTypeAndApi();
        EditorUtil.showView(this, entityName, id, closeCallBack);
    }

    private void setReturnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        String alias = D.s((Object)this.getModel().getValue(FUNC));
        params.put(FUNC, alias);
        String funType = D.s((Object)this.getModel().getValue(FUNC_TYPE));
        params.put(FUNC_TYPE, funType);
        params.put(CALLER, D.s((Object)this.getModel().getValue(CALLER)));
        params.put("description", EditorUtil.getDescByAlias(this, alias));
        params.put("save_state_on_success", this.getModel().getValue("save_state_on_success"));
        params.put("wait_for_on_failed", this.getModel().getValue("wait_for_on_failed"));
        params.put("wait_for_premise", this.getModel().getValue("wait_for_premise"));
        this.setInputParamsReturnData(params);
        this.setOutputParamsReturnData(params);
        this.getView().returnDataToParent((Object)params);
    }

    private void setInputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_INPUT);
        LinkedHashMap input = new LinkedHashMap(param_entryentity.size());
        for (DynamicObject entry : param_entryentity) {
            HashMap<String, String> line = new HashMap<String, String>(4);
            line.put("type", entry.getString(PARAM_INPUT_TYPE));
            line.put("description", StringUtil.trim((String)entry.getString(PARAM_INPUT_TITLE), (int)250));
            line.put(FIXED_VALUE, entry.getString(PARAM_INPUT_VALUE));
            line.put(VAR_VALUE, entry.getString(PARAM_INPUT_VAR));
            input.put(entry.getString(PARAM_INPUT_NAME), line);
        }
        params.put(INPUT, input);
    }

    private void setOutputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_OUTPUT);
        LinkedHashMap output = new LinkedHashMap(param_entryentity.size());
        for (DynamicObject entry : param_entryentity) {
            HashMap<String, String> line = new HashMap<String, String>(3);
            line.put("type", entry.getString(PARAM_OUTPUT_TYPE));
            line.put("description", StringUtil.trim((String)entry.getString(PARAM_OUTPUT_TITLE), (int)250));
            line.put(VAR_VALUE, entry.getString(PARAM_OUTPUT_VAR));
            output.put(entry.getString(PARAM_OUTPUT_NAME), line);
        }
        params.put(OUTPUT, output);
    }

    private void clearEntry(String entryEntityInput) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(entryEntityInput);
        param_entryentity.clear();
        this.getView().updateView(entryEntityInput);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("get_property".equals(action)) {
            EditorUtil.setReturnDataAfterChosedVar(this.getModel(), evt);
        } else if (OPEN_API_VIEW.equals(action) && this.isEditable()) {
            String alias = D.s((Object)this.getModel().getValue(FUNC));
            this.setEntriesByAlias(alias);
        } else if ("wait_for_premise".equals(action) || "wait_for_on_failed".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        }
    }
}

