/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.sf.select.TreeModel;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class BillSplittingEditorFormPlugin
extends AbstractFormPlugin
implements Const,
CellClickListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("source", params.get("source"));
        this.getModel().setValue("target", params.get("target"));
        List entryentity = (List)params.get("entryentity");
        if (entryentity != null) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            collection.clear();
            for (Map map : entryentity) {
                DynamicObject obj = collection.addNew();
                obj.set("field", map.get("field"));
                obj.set("desc", map.get("desc"));
            }
        }
        if (this.isEditable()) {
            List<ComboItem> vars = this.getVarComboItems(false, 0L);
            ComboEdit combo = (ComboEdit)this.getView().getControl("source");
            combo.setComboItems(vars);
            if (params.get("source") != null) {
                this.initTarCombo(D.s(params.get("source")));
            }
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
            EditorUtil.setInstCombo(this, "source", "source_desc");
            EditorUtil.setInstCombo(this, "target", "target_desc");
        }
        if (this.getModel().getValue("title") == null) {
            this.getModel().setValue("title", (Object)ResManager.loadKDString((String)"\u5206\u5355", (String)"BillSplittingEditorFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        this.refreshClickButton(this.getModel().getDataEntity().getString("source"), "src");
        this.refreshClickButton(this.getModel().getDataEntity().getString("target"), "tar");
    }

    public void refreshClickButton(String alias, String buttonKey) {
        if (StringUtil.isEmpty((String)alias)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{buttonKey});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{buttonKey});
        }
    }

    public List<ComboItem> getVarComboItems(boolean needMuli, long metaID) {
        ArrayList<ComboItem> vars = new ArrayList<ComboItem>();
        DynamicObject flow = EditorUtil.getFlow(this);
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        for (DynamicObject variable : variables) {
            if ("isc_type_simple_value".equals(variable.get("var_category"))) continue;
            ComboItem item = new ComboItem();
            String varName = D.s((Object)variable.get("var_name"));
            item.setValue(varName);
            String varDesc = D.s((Object)variable.get("var_desc"));
            item.setCaption(new LocaleString(Util.getVarOrResName(varDesc, varName)));
            if (needMuli && D.x((Object)variable.get("is_array")) && metaID > 0L) {
                long var_type_id = variable.getLong("var_type_id");
                QFilter q = new QFilter("id", "=", (Object)var_type_id);
                String fullname = BusinessDataServiceHelper.loadSingle((Object)metaID, (String)"isc_metadata_schema", (String)"full_name").getString("full_name");
                q.and(new QFilter("full_name", "=", (Object)fullname));
                if (!QueryServiceHelper.exists((String)"isc_metadata_schema", (QFilter[])new QFilter[]{q})) continue;
                vars.add(item);
                continue;
            }
            if (needMuli) continue;
            vars.add(item);
        }
        return vars;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        String alias = D.s((Object)e.getChangeSet()[0].getNewValue());
        if ("source".equals(name)) {
            this.refreshClickButton(alias, "src");
            this.initTarCombo(alias);
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            collection.clear();
            this.getView().updateView("entryentity");
        } else if ("target".equals(name)) {
            this.refreshClickButton(alias, "tar");
        }
    }

    public void initTarCombo(String alias) {
        DynamicObject var = EditorUtil.getVar(this, alias);
        long metaId = var.getLong("var_type_id");
        List<ComboItem> vars = this.getVarComboItems(true, metaId);
        ComboEdit combo = (ComboEdit)this.getView().getControl("target");
        combo.setComboItems(vars);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if ("src".equals(key)) {
            DynamicObject source = EditorUtil.getVar(this, this.getModel().getDataEntity().getString("source"));
            long metaId = source.getLong("var_type_id");
            FormOpener.showView(this, "isc_metadata_schema", metaId);
        } else if ("tar".equals(key)) {
            DynamicObject source = EditorUtil.getVar(this, this.getModel().getDataEntity().getString("target"));
            long metaId = source.getLong("var_type_id");
            FormOpener.showView(this, "isc_metadata_schema", metaId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("field".equals(action) && returnData instanceof Map) {
            Map params = (Map)returnData;
            List nodes = (List)Json.toObject((String)D.s(params.get("currNodeId")));
            DynamicObjectCollection fields = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            int index = D.i(params.get("$row"));
            if (nodes.size() == 1) {
                Map map = (Map)nodes.get(0);
                String field = D.s(map.get("id"));
                if (!BillSplittingEditorFormPlugin.hasField(fields, field, "field")) {
                    DynamicObject entry = (DynamicObject)fields.get(index);
                    entry.set("field", (Object)field);
                    entry.set("desc", map.get("text"));
                }
            } else {
                DynamicObject sentry = this.getModel().getEntryRowEntity("entryentity", index);
                if (StringUtil.isEmpty((String)sentry.getString("field"))) {
                    fields.remove(index);
                }
                for (Map map : nodes) {
                    String field = D.s(map.get("id"));
                    if (BillSplittingEditorFormPlugin.hasField(fields, field, "field")) continue;
                    DynamicObject entry = fields.addNew();
                    entry.set("field", (Object)field);
                    entry.set("desc", map.get("text"));
                }
            }
            this.getView().updateView("entryentity");
        }
    }

    private static boolean hasField(DynamicObjectCollection entries, String field, String fieldColumn) {
        for (DynamicObject item : entries) {
            if (!field.equals(item.getString(fieldColumn))) continue;
            return true;
        }
        return false;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid retrieverEntries = (EntryGrid)this.getView().getControl("entryentity");
        retrieverEntries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"src", "tar"});
    }

    private boolean isEditable() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            if (!this.isEditable()) {
                this.getView().close();
                return;
            }
            if ("returndata".equals(evt.getOperateKey()) && evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
                EditorUtil.checkTitle(this.getModel());
                if (StringUtil.isEmpty((String)this.getModel().getDataEntity().getString("source"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6e90\u5bf9\u8c61\u53d8\u91cf\u3002", (String)"BillSplittingEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                if (StringUtil.isEmpty((String)this.getModel().getDataEntity().getString("target"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u76ee\u6807\u5bf9\u8c61\u53d8\u91cf\u3002", (String)"BillSplittingEditorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                if (this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5355\u5b57\u6bb5\u3002", (String)"BillSplittingEditorFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                this.setReturnData();
                this.getView().close();
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void setReturnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        params.put("source", this.getModel().getValue("source"));
        params.put("target", this.getModel().getValue("target"));
        params.put("source_desc", this.getModel().getValue("source"));
        params.put("target_desc", this.getModel().getValue("target"));
        ArrayList entryentity = new ArrayList();
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<String> fields = new ArrayList<String>();
        for (DynamicObject object : collection) {
            HashMap<String, String> entry = new HashMap<String, String>();
            String field = object.getString("field");
            entry.put("field", field);
            fields.add(field);
            entry.put("desc", object.getString("desc"));
            entryentity.add(entry);
        }
        params.put("entryentity", entryentity);
        params.put("entryKey", this.getEntryKey(fields));
        this.getView().returnDataToParent((Object)params);
    }

    public String getEntryKey(List<String> keys) {
        String commonPrefix = null;
        for (String key : keys) {
            String[] parts = key.split("\\.");
            if (parts.length != 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u5206\u5355\u5b57\u6bb5\u53ea\u80fd\u662f\u5206\u5f55\u5b57\u6bb5\uff0c\u4e14\u53ea\u652f\u6301\u5206\u5f55\u6807\u8bc6.\u5b57\u6bb5\u683c\u5f0f\u3002", (String)"BillSplittingEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            String prefix = parts[0];
            if (commonPrefix == null) {
                commonPrefix = prefix;
                continue;
            }
            if (commonPrefix.equals(prefix)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u5206\u5355\u5b57\u6bb5\u53ea\u80fd\u6765\u81ea\u540c\u4e00\u4e2a\u5206\u5f55\u3002", (String)"BillSplittingEditorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return commonPrefix;
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        try {
            if (!this.isEditable()) {
                return;
            }
            String src = this.getModel().getDataEntity().getString("source");
            if (StringUtil.isEmpty((String)src)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5bf9\u8c61\u53d8\u91cf", (String)"BillSplittingEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject var = EditorUtil.getVar(this, src);
            long metaId = var.getLong("var_type_id");
            String fieldKey = evt.getFieldKey();
            if ("field".equals(fieldKey)) {
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                StringBuilder sb = new StringBuilder();
                for (DynamicObject object : collection) {
                    String field = object.getString("field");
                    int index = field.lastIndexOf(".");
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    if (index <= -1) continue;
                    sb.append(field.substring(index + 1));
                }
                HashMap<String, Object> param = new HashMap<String, Object>(3);
                String json = this.buildMesaJson(src, metaId);
                param.put("treenodes", json);
                param.put("ismulti", "1");
                param.put("$row", evt.getRow());
                param.put("nodeids", sb.toString());
                FormOpener.showForm(this, "isc_sf_selectfield", ResManager.loadKDString((String)"\u9009\u62e9\u5206\u5f55\u5b57\u6bb5", (String)"BillSplittingEditorFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "field");
            }
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private String buildMesaJson(String name, long metaId) {
        TreeModel treeModel = new TreeModel(name, metaId, "", 0);
        return JSON.toJSONString((Object)treeModel);
    }
}

