/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class BlockEditFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String BTNCANCEL = "btncancel";
    private static final String VIEW_BLOCK = "viewBlock";
    public static final String SUB_NODE = "subNode";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map<String, Object> define = this.loadDefine();
        boolean editable = this.isEditable();
        Util.setEditorData(this, define, editable);
        Util.saveDefineToCache(this, define);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", BTNCANCEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button) {
            this.buttonClick((Button)src);
        }
    }

    private void buttonClick(Button src) {
        if ("btnok".equals(src.getKey())) {
            this.saveBlockDefine();
        } else if (BTNCANCEL.equals(src.getKey())) {
            if (this.isEditable() && !Json.toString(this.loadDefine()).equals(Util.getDefineStringFromCache(this))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("cancel", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8282\u70b9\u5757\u5185\u6d41\u7a0b\u56fe\u5df2\u66f4\u6539\uff0c\u662f\u5426\u653e\u5f03\uff1f", (String)"BlockEditFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            } else {
                this.getView().close();
            }
        }
    }

    private void saveBlockDefine() {
        if (this.isEditable()) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            Map<String, Object> subNode = this.getSubNode();
            params.put(SUB_NODE, subNode);
            this.getView().returnDataToParent((Object)params);
        }
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if ("cancel".equals(evt.getCallBackId())) {
            this.getView().close();
        }
    }

    private Map<String, Object> getSubNode() {
        Map subNode = (Map)Json.toObject((String)Util.getDefineStringFromCache(this));
        Map nodes = (Map)subNode.get("nodes");
        Map links = (Map)subNode.get("links");
        Map<String, Object> rLinks = this.replaceId(links, true);
        Map<String, Object> rNodes = this.replaceId(nodes, false);
        subNode.put("nodes", rNodes);
        subNode.put("links", rLinks);
        return subNode;
    }

    private Map<String, Object> replaceId(Map<String, Object> map, boolean isLink) {
        if (map == null) {
            return Collections.emptyMap();
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String pri = D.s(params.get("id")) + '_';
        LinkedHashMap<String, Object> lh = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(pri)) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)entry.getValue();
                lh.put(this.getStringName(entry.getKey()), entry.getValue());
                this.getValueMap(isLink, linkedHashMap);
                continue;
            }
            lh.put(entry.getKey(), entry.getValue());
        }
        return lh;
    }

    private void getValueMap(boolean isLink, Map<String, Object> linkedHashMap) {
        linkedHashMap.put("id", this.getStringName(linkedHashMap.get("id")));
        if (isLink) {
            linkedHashMap.put("source", this.getStringName(linkedHashMap.get("source")));
            linkedHashMap.put("target", this.getStringName(linkedHashMap.get("target")));
        }
    }

    private String getStringName(Object name) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String pri = D.s(params.get("id")) + '_';
        if (!D.s((Object)name).startsWith(pri)) {
            return pri + name;
        }
        return D.s((Object)name);
    }

    protected boolean isEditable() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
    }

    private Map<String, Object> loadDefine() {
        String define = D.s((Object)this.getView().getFormShowParameter().getCustomParam(SUB_NODE));
        if (define == null) {
            return (Map)Json.toObject((String)BlockEditFormPlugin.getDefaultDiagram());
        }
        return (Map)Json.toObject((String)define);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String event = e.getEventName();
        if ("open_editor".equals(event)) {
            Util.openEditor(this, event, (Map)Json.toObject((String)e.getEventArgs()), this.isEditable());
        } else if (VIEW_BLOCK.equals(event)) {
            Util.openBlock(this, (Map)Json.toObject((String)e.getEventArgs()), event, this.isEditable());
        } else if ("Ctrl+S".equals(event)) {
            this.saveBlockDefine();
        } else {
            this.updateDiagram(event, e.getEventArgs());
        }
    }

    protected void updateDiagram(String event, String args) {
        try (DLock lock = DLock.create((String)("/isc/sf/" + this.getView().getPageId())).fastMode();){
            lock.tryLock(300000L);
            Map<String, Object> define = Util.getDefineFromCache(this);
            this.updateDefine(define, event, args);
            Util.saveDefineToCache(this, define);
        }
    }

    private void updateDefine(Map<String, Object> define, String event, String args) {
        if ("move_node".equals(event) || "node_resize".equals(event)) {
            this.updateNode(define, args);
        } else if ("path_change".equals(event) || "link_change".equals(event)) {
            this.updateLink(args, define);
        } else if ("add_node".equals(event)) {
            this.addNode(args, define);
        } else if ("drop_node".equals(event)) {
            this.dropNode(args, define);
        } else if ("add_link".equals(event)) {
            this.addLink(args, define);
        } else if ("drop_link".equals(event)) {
            this.dropLink(args, define);
        } else {
            throw new IllegalArgumentException("TODO - " + event);
        }
    }

    private void dropLink(String args, Map<String, Object> define) {
        Map links = (Map)define.get("links");
        links.remove(args);
    }

    private void addLink(String args, Map<String, Object> define) {
        Map data;
        String id;
        Map links = (Map)define.get("links");
        if (links.putIfAbsent(id = (String)(data = (Map)Json.toObject((String)args)).get("id"), data) != null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\uff08%s\uff09\u5df2\u5b58\u5728\uff01", (String)"BlockEditFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
        }
        define.put("count", id);
    }

    private void dropNode(String args, Map<String, Object> define) {
        Map nodes = (Map)define.get("nodes");
        nodes.remove(args);
    }

    private void addNode(String args, Map<String, Object> define) {
        Map data;
        String id;
        Map nodes = (Map)define.get("nodes");
        if (nodes.putIfAbsent(id = (String)(data = (Map)Json.toObject((String)args)).get("id"), data) != null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u5df2\u5b58\u5728\uff01", (String)"BlockEditFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
        }
        define.put("count", id);
    }

    private void updateLink(String args, Map<String, Object> define) {
        Map data = (Map)Json.toObject((String)args);
        Object id = data.remove("id");
        Map<String, Object> link = Util.findLink(define, id);
        this.mergeElementDefine(link, data);
    }

    private void updateNode(Map<String, Object> define, String args) {
        Map data = (Map)Json.toObject((String)args);
        Object id = data.remove("id");
        Map<String, Object> node = Util.findNode(define, id);
        this.mergeElementDefine(node, data);
    }

    protected void updateFlowDefine(Map<String, Object> define, Map<String, Object> data, Object id) {
        Map<String, Object> node = Util.findNode(define, id);
        if (node != null) {
            this.mergeElementDefine(node, data);
        } else {
            Map<String, Object> link = Util.findLink(define, id);
            if (link != null) {
                this.mergeElementDefine(link, data);
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5143\u7d20(%s)\u4e0d\u5b58\u5728\uff01", (String)"BlockEditFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
            }
        }
    }

    private void mergeElementDefine(Map<String, Object> element, Map<String, Object> data) {
        for (Map.Entry<String, Object> e : data.entrySet()) {
            element.put(e.getKey(), e.getValue());
        }
    }

    private void updateClientView(Map<String, Object> params, Object id) {
        HashMap<String, Object> cmd = new HashMap<String, Object>();
        cmd.put("id", id);
        cmd.put("title", params.get("title"));
        ((CustomControl)this.getControl("editor")).setData(cmd);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (!this.isEditable()) {
            return;
        }
        Map data = (Map)e.getReturnData();
        if (data != null) {
            data.remove("flow");
            data.remove("editable");
            data.remove("released_id");
            Object id = data.remove("id");
            Map<String, Object> define = Util.getDefineFromCache(this);
            this.updateFlowDefine(define, data, id);
            Util.saveDefineToCache(this, define);
            this.updateClientView(data, id);
        }
    }

    private static String getDefaultDiagram() {
        return String.format("({\"count\":\"2\",\"nodes\":{\"1\":{\"id\":\"1\",\"title\":\"%1$s\",\"type\":\"SubFlowStarter\",\"coordinate\":{\"x\":120 ,\"y\":130 ,\"height\":45 ,\"width\":200 }},\"2\":{\"id\":\"2\",\"title\":\"%2$s\",\"type\":\"End\",\"coordinate\":{\"x\":120 ,\"y\":440 ,\"height\":45 ,\"width\":200 }}},\"links\":{}})", ResManager.loadKDString((String)"\u5f00\u59cb", (String)"BlockEditFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u675f", (String)"BlockEditFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }
}

