/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompEditorFormPlugin
extends AbstractFormPlugin
implements Const,
CellClickListener {
    public static final String SRC_DATA_VAR = "src_data_var";
    private static final String VIEW = "view";
    private static final String GET_PROPERTY = "get_property";
    private static final String SCHEMA = "schema";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String INPUT = "input";
    public static final String PARAM_NAME = "param_name";
    public static final String PARAM_TITLE = "param_title";
    public static final String PARAM_TYPE = "param_type";
    public static final String PARAM_VAR_FIXED = "param_var_fixed";
    public static final String PARAM_VAR = "param_var";
    private static final Set<String> CTL = new HashSet<String>(Arrays.asList("src_data_var", "state_var"));

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (this.isEditable()) {
            this.initEditableView(params);
        } else {
            this.initInstView(params);
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void initEditableView(Map<String, Object> params) {
        this.getModel().setValue("title", params.get("title"));
        this.setCombo();
        String alias = D.s((Object)params.get(SCHEMA));
        this.getModel().setValue(SCHEMA, (Object)alias);
        if (!StringUtil.isEmpty((String)alias)) {
            this.setInputEntrytity(alias);
            this.setPropertyValue(params);
        }
    }

    private void initInstView(Map<String, Object> params) {
        this.getModel().setValue("title", params.get("title"));
        EditorUtil.setInstCombo(this, SCHEMA, "description");
        String alias = D.s((Object)params.get(SCHEMA));
        this.getModel().setValue(SCHEMA, (Object)alias);
        this.setInstInputEntry(params);
        this.setPropertyValue(params);
    }

    private void setInstInputEntry(Map<String, Object> params) {
        Map inputs = (Map)params.get(INPUT);
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        param_entryentity.clear();
        for (Map.Entry input : inputs.entrySet()) {
            DynamicObject item = param_entryentity.addNew();
            item.set(PARAM_NAME, input.getKey());
            item.set(PARAM_TYPE, ((Map)input.getValue()).get(PARAM_TYPE));
            item.set(PARAM_TITLE, ((Map)input.getValue()).get(PARAM_TITLE));
            item.set(PARAM_VAR_FIXED, ((Map)input.getValue()).get(PARAM_VAR_FIXED));
            item.set(PARAM_VAR, ((Map)input.getValue()).get(PARAM_VAR));
        }
    }

    private void setInputEntrytity(String alias) {
        this.getModel().getDataEntity(true);
        DynamicObject schema = EditorUtil.getObjByAlias(this, "isc_data_comp", alias);
        DynamicObjectCollection paramsEntryentity = schema.getDynamicObjectCollection("params_entryentity");
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(ENTRY_ENTITY);
        inputs.clear();
        for (DynamicObject obj : paramsEntryentity) {
            DynamicObject item = inputs.addNew();
            item.set(PARAM_NAME, obj.get(PARAM_NAME));
            item.set(PARAM_TITLE, obj.get(PARAM_TITLE));
            item.set(PARAM_TYPE, obj.get(PARAM_TYPE));
            this.setFixedAndVar(obj, item);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setFixedAndVar(DynamicObject obj, DynamicObject item) {
        Map in;
        Map inputMap = (Map)this.getView().getFormShowParameter().getCustomParam(INPUT);
        if (inputMap != null && (in = (Map)inputMap.get(obj.getString(PARAM_NAME))) != null) {
            item.set(PARAM_VAR_FIXED, in.get(PARAM_VAR_FIXED));
            item.set(PARAM_VAR, in.get(PARAM_VAR));
        }
    }

    private void setPropertyValue(Map<String, Object> params) {
        this.getModel().setValue(SRC_DATA_VAR, params.get(SRC_DATA_VAR));
        this.getModel().setValue("state_var", params.get("state_var"));
        this.getModel().setValue("save_state_on_success", params.get("save_state_on_success"));
        this.getModel().setValue("wait_for_premise", params.get("wait_for_premise"));
        this.getModel().setValue("wait_for_on_failed", params.get("wait_for_on_failed"));
    }

    void setCombo() {
        List<ComboItem> items = EditorUtil.getComboItems(this, "isc_data_comp");
        ComboEdit combo = (ComboEdit)this.getView().getControl(SCHEMA);
        combo.setComboItems(items);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"wait_for_premise", "wait_for_on_failed", VIEW});
        this.addClickListeners(CTL.toArray(new String[0]));
        EntryGrid entries = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{PARAM_VAR});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        try {
            super.afterDoOperation(args);
            String operateKey = args.getOperateKey();
            if ("btnok".equals(operateKey)) {
                if (this.isEditable()) {
                    EditorUtil.checkTitle(this.getModel());
                    this.checkParams();
                    this.checkInputParams();
                    this.setReturnData();
                }
                this.getView().close();
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void checkInputParams() {
        DynamicObjectCollection paramEntries = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject entry : paramEntries) {
            if (!StringUtil.isEmpty((String)entry.getString(PARAM_VAR_FIXED)) || !StringUtil.isEmpty((String)entry.getString(PARAM_VAR))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53d8\u91cf %s\u7684\u53c2\u6570\u8d4b\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataCompEditorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entry.getString(PARAM_NAME)));
        }
    }

    private void checkParams() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (collection.isEmpty()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataCompEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void setReturnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        String alias = D.s((Object)this.getModel().getValue(SCHEMA));
        params.put(SCHEMA, alias);
        params.put("description", EditorUtil.getDescByAlias(this, alias));
        this.setInputParamsReturnData(params);
        params.put(SRC_DATA_VAR, this.getModel().getValue(SRC_DATA_VAR));
        params.put("state_var", this.getModel().getValue("state_var"));
        params.put("save_state_on_success", this.getModel().getValue("save_state_on_success"));
        params.put("wait_for_on_failed", this.getModel().getValue("wait_for_on_failed"));
        params.put("wait_for_premise", this.getModel().getValue("wait_for_premise"));
        this.getView().returnDataToParent((Object)params);
    }

    private void setInputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        LinkedHashMap input = new LinkedHashMap(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            HashMap<String, String> line = new HashMap<String, String>(5);
            line.put(PARAM_NAME, entry.getString(PARAM_NAME));
            line.put(PARAM_TITLE, entry.getString(PARAM_TITLE));
            line.put(PARAM_TYPE, entry.getString(PARAM_TYPE));
            line.put(PARAM_VAR_FIXED, entry.getString(PARAM_VAR_FIXED));
            line.put(PARAM_VAR, entry.getString(PARAM_VAR));
            input.put(entry.getString(PARAM_NAME), line);
        }
        params.put(INPUT, input);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (CTL.contains(key)) {
            EditorUtil.selectVariableProperty(this, key);
        } else if (VIEW.equals(key)) {
            this.openView();
        } else if ("wait_for_premise".equals(key) || "wait_for_on_failed".equals(key)) {
            ScriptTextUtil.openRetryScriptForm(this.getModel().getValue(key), this, key, key);
        }
    }

    private void openView() {
        String alias = D.s((Object)this.getModel().getValue(SCHEMA));
        if (StringUtil.isEmpty((String)alias)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u3002", (String)"DataCompEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = EditorUtil.getIdByAlias(this, alias);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, VIEW);
        EditorUtil.showView(this, "isc_data_comp", id, closeCallBack);
    }

    private boolean isEditable() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (SCHEMA.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            String newValue = D.s((Object)changeSet[0].getNewValue());
            this.setInputEntrytity(newValue);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent event) {
        String fieldKey = event.getFieldKey();
        if (PARAM_VAR.equals(fieldKey)) {
            EditorUtil.selectVariableProperty(this, fieldKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (GET_PROPERTY.equals(action)) {
            EditorUtil.setReturnDataAfterChosedVar(this.getModel(), evt);
        } else if ("wait_for_premise".equals(action) || "wait_for_on_failed".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        } else if (VIEW.equals(action) && this.isEditable()) {
            String alias = D.s((Object)this.getModel().getValue(SCHEMA));
            this.setInputEntrytity(alias);
        }
    }
}

