/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;

public class DataConversionNodeEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String RES_REF_ID = "res_ref_id";
    private static final String DATA_COPY2 = "data_copy";
    private static final String ISC_DATA_COPY2 = "isc_data_copy";
    private static final String VECTORAP_3 = "vectorap3";
    private static final String VECTORAP_2 = "vectorap2";
    private static final String VECTORAP_1 = "vectorap1";
    private static final String VAR_DESC = "var_desc";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean editable = D.x(params.get("editable"));
        if (editable) {
            long workFlowId = D.l(params.get("flow"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)workFlowId, (String)"isc_service_flow");
            this.loadDataCopy(params, flow);
            this.loadVariables(params, flow);
            this.isShowInfoButton();
        } else {
            this.viewType(params);
        }
        this.getModel().setValue("title", params.get("title"));
    }

    private void viewType(Map<String, Object> params) {
        if (params.size() < 1) {
            return;
        }
        this.getView().setStatus(OperationStatus.VIEW);
        Object srcName = params.get("src_var");
        Object tarName = params.get("tar_var");
        Object dataCopy = params.get(DATA_COPY2);
        Map variableMap = (Map)params.get("variableMap");
        Map resourceMap = (Map)params.get("resourceMap");
        Map dataCopyInfo = (Map)resourceMap.get(dataCopy);
        Object dataCopyName = ObjectUtils.isEmpty((Object)dataCopyInfo) ? null : dataCopyInfo.get("res_ref_name");
        Map srcInfo = (Map)variableMap.get(srcName);
        Object srcDesc = ObjectUtils.isEmpty((Object)srcInfo) ? null : srcInfo.get(VAR_DESC);
        Map tarInfo = (Map)variableMap.get(tarName);
        Object tarDesc = ObjectUtils.isEmpty((Object)tarInfo) ? null : tarInfo.get(VAR_DESC);
        this.setComboEdit(srcName, srcDesc, "src_var");
        this.setComboEdit(tarName, tarDesc, "tar_var");
        this.setComboEdit(dataCopy, dataCopyName, DATA_COPY2);
        this.getModel().setValue(DATA_COPY2, dataCopy);
        this.getModel().setValue("src_var", srcName);
        this.getModel().setValue("tar_var", tarName);
        this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAP_1});
        this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAP_2});
        this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAP_3});
    }

    private void setComboEdit(Object varName, Object varDesc, String srcVar) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(srcVar);
        ComboItem comboItem = new ComboItem();
        ArrayList<ComboItem> variableList = new ArrayList<ComboItem>(1);
        comboItem.setCaption(new LocaleString(varName + (ObjectUtils.isEmpty((Object)varDesc) ? "" : "(" + varDesc + ")")));
        comboItem.setValue(D.s((Object)varName));
        variableList.add(comboItem);
        comboEdit.setComboItems(variableList);
    }

    private void loadDataCopy(Map<String, Object> params, DynamicObject flow) {
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        Object dataCopy = params.get(DATA_COPY2);
        String existedName = null;
        int size = resources.size();
        ArrayList<ComboItem> field = new ArrayList<ComboItem>(size);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(DATA_COPY2);
        for (DynamicObject resource : resources) {
            if (!ISC_DATA_COPY2.equals(D.s((Object)resource.get("res_category")))) continue;
            String resAlias = D.s((Object)resource.get("res_alias"));
            String name = D.s((Object)resource.get("res_ref.name.zh_CN"));
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString((name == null ? "" : name + ':') + resAlias));
            comboItem.setValue(resAlias);
            field.add(comboItem);
            if (resAlias == null || !resAlias.equals(dataCopy)) continue;
            existedName = resAlias;
        }
        this.getModel().setValue(DATA_COPY2, existedName);
        comboEdit.setComboItems(field);
    }

    private void loadVariables(Map<String, Object> params, DynamicObject flow) {
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        ArrayList<ComboItem> variableList = new ArrayList<ComboItem>(variables.size());
        ComboEdit srcComboEdit = (ComboEdit)this.getView().getControl("src_var");
        ComboEdit tarComboEdit = (ComboEdit)this.getView().getControl("tar_var");
        Object srcOldName = params.get("src_var");
        Object tarOldName = params.get("tar_var");
        Object existedSrcId = null;
        Object existedTarId = null;
        for (DynamicObject variable : variables) {
            String varName = variable.getString("var_name");
            String varDesc = variable.getString(VAR_DESC);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(varDesc + "(" + varName + ")"));
            comboItem.setValue(varName);
            variableList.add(comboItem);
            if (varName.equals(srcOldName)) {
                existedSrcId = srcOldName;
            }
            if (!varName.equals(tarOldName)) continue;
            existedTarId = tarOldName;
        }
        this.getModel().setValue("src_var", existedSrcId);
        this.getModel().setValue("tar_var", existedTarId);
        srcComboEdit.setComboItems(variableList);
        tarComboEdit.setComboItems(variableList);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addItemClickListeners(new String[]{DATA_COPY2});
        this.addClickListeners(new String[]{VECTORAP_1, VECTORAP_2, VECTORAP_3});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (VECTORAP_1.equals(key)) {
            Object dataCopyValue = this.getModel().getValue(DATA_COPY2);
            if (ObjectUtils.isEmpty((Object)dataCopyValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u96c6\u6210\u65b9\u6848\uff01", (String)"DataConversionNodeEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            Map dataCopyinfo = (Map)this.getResourceInfo().get(dataCopyValue);
            FormOpener.showView(this, ISC_DATA_COPY2, ObjectUtils.isEmpty((Object)dataCopyinfo) ? Integer.valueOf(0) : dataCopyinfo.get(RES_REF_ID));
        } else if (VECTORAP_2.equals(key)) {
            Object srcVarValue = this.getModel().getValue("src_var");
            if (ObjectUtils.isEmpty((Object)srcVarValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u6570\u636e\uff01", (String)"DataConversionNodeEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showMetaDataSchema(srcVarValue);
        } else if (VECTORAP_3.equals(key)) {
            Object trcVarValue = this.getModel().getValue("tar_var");
            if (ObjectUtils.isEmpty((Object)trcVarValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u6570\u636e\uff01", (String)"DataConversionNodeEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showMetaDataSchema(trcVarValue);
        }
    }

    private void showMetaDataSchema(Object srcVarValue) {
        Map variableMapValue = (Map)this.getVariableInfo().get(srcVarValue);
        FormOpener.showView(this, "isc_metadata_schema", ObjectUtils.isEmpty((Object)variableMapValue) ? Integer.valueOf(0) : variableMapValue.get("var_type_id"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("btn_ok")) {
            if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
                this.getView().close();
                return;
            }
            Map params = this.getView().getFormShowParameter().getCustomParams();
            params.put("title", this.getModel().getValue("title"));
            params.put("src_var", this.getModel().getValue("src_var"));
            params.put("tar_var", this.getModel().getValue("tar_var"));
            params.put(DATA_COPY2, this.getModel().getValue(DATA_COPY2));
            params.put("variableMap", this.getVariableInfo());
            params.put("resourceMap", this.getResourceInfo());
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }

    private Map<String, Object> getResourceInfo() {
        Object workFlowId = this.getView().getFormShowParameter().getCustomParams().get("flow");
        String dataCopyName = D.s((Object)this.getModel().getValue(DATA_COPY2));
        DynamicObject flow = BusinessDataServiceHelper.loadSingle(workFlowId, (String)"isc_service_flow");
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        HashMap<String, Object> schemaInfo = new HashMap<String, Object>(1);
        for (DynamicObject res : resources) {
            if (!res.getString("res_alias").equals(dataCopyName)) continue;
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(RES_REF_ID, res.getString("res_ref.id"));
            map.put("res_ref_name", res.getString("res_ref.name.zh_CN"));
            schemaInfo.put(dataCopyName, map);
            if (schemaInfo.size() <= 1) continue;
            break;
        }
        return schemaInfo;
    }

    private Map<String, Object> getVariableInfo() {
        Object workFlowId = this.getView().getFormShowParameter().getCustomParams().get("flow");
        DynamicObject flow = BusinessDataServiceHelper.loadSingle(workFlowId, (String)"isc_service_flow");
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        HashMap<String, Object> variableInfoMap = new HashMap<String, Object>(variables.size());
        for (DynamicObject dy : variables) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("var_category", dy.get("var_category"));
            map.put(VAR_DESC, dy.getString(VAR_DESC));
            map.put("var_type_id", dy.get("var_type.id"));
            map.put("is_array", dy.getBoolean("is_array"));
            variableInfoMap.put(dy.getString("var_name"), map);
        }
        return variableInfoMap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (DATA_COPY2.equals(propName)) {
            String dataCopyAliasName = D.s((Object)this.getModel().getValue(DATA_COPY2));
            IDataModel dataModel = this.getModel();
            AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
            model.beginInit();
            if (dataCopyAliasName == null) {
                this.getModel().setValue("src_var", null);
                this.getModel().setValue("tar_var", null);
            } else {
                this.dataCopyAliasNameIsNotNull(dataCopyAliasName);
            }
        }
        this.isShowInfoButton();
    }

    private void dataCopyAliasNameIsNotNull(String dataCopyAliasName) {
        Map dataCopyInfo = (Map)this.getResourceInfo().get(dataCopyAliasName);
        DynamicObject schema = BusinessDataServiceHelper.loadSingle(dataCopyInfo.get(RES_REF_ID), (String)ISC_DATA_COPY2);
        long sourceSchema = schema.getLong("source_schema.id");
        long targetSchema = schema.getLong("target_schema.id");
        Object srcVarName = this.getVariableName(sourceSchema);
        Object tarVarName = this.getVariableName(targetSchema);
        Map<String, Object> variableMap = this.getVariableInfo();
        this.setVariableValue(variableMap, srcVarName, "src_var");
        this.setVariableValue(variableMap, tarVarName, "tar_var");
    }

    private void setVariableValue(Map<String, Object> variableMap, Object varName, String var) {
        if (variableMap.containsKey(varName)) {
            this.getModel().setValue(var, varName);
        } else {
            this.getModel().setValue(var, null);
        }
        this.getView().updateView(var);
    }

    private Object getVariableName(long schemaId) {
        Object workFlowId = this.getView().getFormShowParameter().getCustomParams().get("flow");
        QFilter qFilter1 = new QFilter("id", "in", workFlowId);
        QFilter qFilter2 = new QFilter("variables.var_type", "=", (Object)schemaId);
        DynamicObjectCollection flow = QueryServiceHelper.query((String)"isc_service_flow", (String)"variables.var_name", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        return flow.size() < 1 ? flow : ((DynamicObject)flow.get(0)).get("variables.var_name");
    }

    private void isShowInfoButton() {
        Object dc = this.getModel().getValue(DATA_COPY2);
        Object sv = this.getModel().getValue("src_var");
        Object tv = this.getModel().getValue("tar_var");
        if (ObjectUtils.isEmpty((Object)dc)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAP_1});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAP_1});
        }
        if (ObjectUtils.isEmpty((Object)sv)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAP_2});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAP_2});
        }
        if (ObjectUtils.isEmpty((Object)tv)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAP_3});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAP_3});
        }
    }
}

