/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.util.EntryFilterUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;

public class DataCopyEditorFormPlugin
extends AbstractFormPlugin
implements Const,
CellClickListener {
    private static final String GET_PROPERTY = "get_property";
    private static final String PARAMS_DATA_TYPE = "params_data_type";
    private static final String PARAMS_LABEL = "params_label";
    private static final String PARAMS_VAR_FIXED = "params_var_fixed";
    private static final String PARAMS_VAR = "params_var";
    private static final String PARAMS_NAME = "params_name";
    private static final String PARAM_ENTRIES = "param_entries";
    private static final String SCHEMA = "schema";
    private static final String FILTERS = "filters";
    private static final String SCHEMA_TYPE = "schema_type";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FILTER_ENTRY = "filter_entries";
    private static final Set<String> CTL = new HashSet<String>(Arrays.asList("src_var", "tar_var", "execution_var", "state_var"));

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean editable = D.x(params.get("editable"));
        if (editable) {
            String flowId = D.s(params.get("flow"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
            String schemaType = D.s(params.get(SCHEMA_TYPE));
            if (schemaType == null) {
                schemaType = "isc_data_copy_trigger";
            }
            this.loadSchema(flow, schemaType, params);
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
            this.viewSchema(params);
        }
        this.setControlValue(params);
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        if (this.getModel().getValue("title") == null) {
            this.getModel().setValue("title", (Object)ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210", (String)"DataCopyEditorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void setControlValue(Map<String, Object> params) {
        String filterType = D.s((Object)params.get("filter_type"));
        if (filterType == null) {
            List param_entries = params.getOrDefault(PARAM_ENTRIES, Collections.emptyList());
            List filter_entries = params.getOrDefault(FILTER_ENTRY, Collections.emptyList());
            filterType = filter_entries.isEmpty() && !param_entries.isEmpty() ? "params" : FILTERS;
        }
        this.getModel().setValue("filter_type", (Object)filterType);
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("src_var", params.get("src_var"));
        this.getModel().setValue("tar_var", params.get("tar_var"));
        this.getModel().setValue("execution_var", params.get("execution_var"));
        this.getModel().setValue("state_var", params.get("state_var"));
        this.getModel().setValue("save_state_on_success", (Object)D.x((Object)params.get("save_state_on_success")));
        this.getModel().setValue("wait_for_on_failed", (Object)D.s((Object)params.get("wait_for_on_failed")));
        this.getModel().setValue("wait_for_premise", (Object)D.s((Object)params.get("wait_for_premise")));
        this.loadFilters((List)params.get(FILTER_ENTRY));
    }

    private void loadFilters(List<Map<String, Object>> filters) {
        if (!CollectionUtils.isEmpty(filters)) {
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(FILTER_ENTRY);
            collection.clear();
            DynamicObjectType type = collection.getDynamicObjectType();
            for (Map<String, Object> map : filters) {
                DynamicObject item = collection.addNew();
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String key = entry.getKey();
                    if (type.getProperty(key) == null) continue;
                    item.set(key, entry.getValue());
                }
            }
            this.getView().updateView("filter_type");
        }
    }

    private void viewSchema(Map<String, Object> params) {
        Map schema = (Map)params.get(SCHEMA);
        if (schema == null) {
            return;
        }
        String schemaType = D.s((Object)params.get(SCHEMA_TYPE));
        Flow releasedFLow = ServiceFlowParser.getFlow((long)D.l((Object)params.get("released_id")));
        Map resources = (Map)releasedFLow.getAttribute("resources");
        HashMap<String, String> existedSchema = null;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(resources.size());
        HashSet<Resource> checkRepeatSet = new HashSet<Resource>();
        for (Map.Entry entry : resources.entrySet()) {
            Resource r;
            if (!(entry.getValue() instanceof Resource) || !(r = (Resource)entry.getValue()).getCategory().getEntityType().equals(schemaType) || !checkRepeatSet.add(r)) continue;
            String resAlias = r.name();
            ComboItem item = new ComboItem();
            String desc = D.s((Object)r.getTitle());
            item.setCaption(new LocaleString(Util.getVarOrResName(desc, resAlias)));
            item.setValue(resAlias);
            items.add(item);
            if (!resAlias.equals(schema.get("var")) || r.getId() != D.l(schema.get("id"))) continue;
            existedSchema = new HashMap<String, String>();
            existedSchema.put("var", resAlias);
            existedSchema.put("id", D.s((Object)r.getId()));
            break;
        }
        this.getView().getFormShowParameter().setCustomParam(SCHEMA, existedSchema);
        this.getView().cacheFormShowParameter();
        this.getModel().setValue(SCHEMA, existedSchema != null ? D.s(existedSchema.get("var")) : null);
        this.getModel().setValue(SCHEMA_TYPE, (Object)schemaType);
        ((ComboEdit)this.getView().getControl(SCHEMA)).setComboItems(items);
        this.loadParams((List)params.get(PARAM_ENTRIES));
    }

    private void loadParams(List<Map<String, Object>> array) {
        if (!CollectionUtils.isEmpty(array)) {
            DynamicObjectCollection collection = this.getEntryCollection();
            collection.clear();
            for (Map<String, Object> map : array) {
                DynamicObject object = collection.addNew();
                object.set(PARAMS_NAME, map.get(PARAMS_NAME));
                object.set(PARAMS_LABEL, map.get(PARAMS_LABEL));
                object.set(PARAMS_DATA_TYPE, map.get(PARAMS_DATA_TYPE));
                object.set(PARAMS_VAR, map.get(PARAMS_VAR));
                object.set(PARAMS_VAR_FIXED, map.get(PARAMS_VAR_FIXED));
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    private void loadSchema(DynamicObject flow, String schemaType, Map<String, Object> params) {
        if (schemaType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (String)"DataCopyEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Map schema = (Map)params.get(SCHEMA);
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        HashMap<String, String> existedSchema = null;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(resources.size());
        for (DynamicObject resource : resources) {
            if (!D.s((Object)resource.get("res_category")).equals(schemaType)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String resAlias = D.s((Object)resource.get("res_alias"));
            ComboItem item = new ComboItem();
            String desc = D.s((Object)resource.get("res_ref.name.zh_CN"));
            item.setCaption(new LocaleString(Util.getVarOrResName(desc, resAlias)));
            item.setValue(resAlias);
            items.add(item);
            map.put("var", resAlias);
            map.put("id", D.s((Object)resource.get("res_ref.id")));
            if (schema == null || !resAlias.equals(schema.get("var"))) continue;
            existedSchema = map;
        }
        this.getModel().setValue(SCHEMA_TYPE, (Object)schemaType);
        this.getModel().setValue(SCHEMA, existedSchema != null ? D.s(existedSchema.get("var")) : null);
        ((ComboEdit)this.getView().getControl(SCHEMA)).setComboItems(items);
        if (existedSchema != null) {
            List p = (List)params.get(PARAM_ENTRIES);
            List existedParamList = p == null ? Collections.emptyList() : p;
            List<Map<String, Object>> paramsList = this.getParamsList(D.l(existedSchema.get("id")), schemaType);
            this.refreshParams(existedParamList, paramsList);
        }
    }

    private void refreshParams(List<Map<String, Object>> existedParamList, List<Map<String, Object>> schemaParamsList) {
        HashMap<String, Map<String, Object>> existed = new HashMap<String, Map<String, Object>>(existedParamList.size());
        for (Map<String, Object> map : existedParamList) {
            existed.put(D.s((Object)map.get(PARAMS_NAME)), map);
        }
        for (Map<String, Object> map : schemaParamsList) {
            String name = D.s((Object)map.get(PARAMS_NAME));
            Map original = (Map)existed.get(name);
            if (original == null) continue;
            map.put(PARAMS_VAR, original.get(PARAMS_VAR));
            map.put(PARAMS_VAR_FIXED, original.get(PARAMS_VAR_FIXED));
        }
        this.loadParams(schemaParamsList);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String schema = null;
        boolean editable = D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
        if (CTL.contains(key)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("flow_id", this.getView().getFormShowParameter().getCustomParam("flow"));
            param.put("key", key);
            FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"DataCopyEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, GET_PROPERTY);
        } else if ("vectorap".equals(key) && (schema = D.s((Object)this.getModel().getValue(SCHEMA))) != null) {
            String type = D.s((Object)this.getModel().getValue(SCHEMA_TYPE));
            Map<String, Object> map = this.getSelectedSchema(type, schema);
            FormOpener.showView(this, type, map.get("id"));
        } else if (editable && ("wait_for_premise".equals(key) || "wait_for_on_failed".equals(key))) {
            ScriptTextUtil.openRetryScriptForm(this.getModel().getValue(key), this, key, key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (GET_PROPERTY.equals(action)) {
            Object returnData = evt.getReturnData();
            if (returnData instanceof Map) {
                String key = D.s(((Map)returnData).get("key"));
                String value = D.s(((Map)returnData).get("full_number"));
                this.getModel().setValue(key, (Object)value);
            }
        } else if ("get_filter_column".equals(action)) {
            Object returnData = evt.getReturnData();
            this.setSelectedFilterColumn(returnData);
        } else if ("wait_for_premise".equals(action) || "wait_for_on_failed".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        }
    }

    private void setSelectedFilterColumn(Object returnData) {
        if (returnData instanceof Map) {
            Map map = (Map)returnData;
            this.getModel().setValue("filter_column", EntryFilterUtil.getFilterColumn(map));
            this.getModel().setValue("filter_label", map.get("name"));
            this.getView().updateView(FILTER_ENTRY);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if (SCHEMA_TYPE.equals(prop)) {
            String flow = D.s((Object)this.getView().getFormShowParameter().getCustomParam("flow"));
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)flow, (String)"isc_service_flow");
            this.loadSchema(object, D.s((Object)this.getModel().getValue(SCHEMA_TYPE)), this.getView().getFormShowParameter().getCustomParams());
        } else if (SCHEMA.equals(prop)) {
            String schemaType = D.s((Object)this.getModel().getValue(SCHEMA_TYPE));
            String schema = D.s((Object)this.getModel().getValue(SCHEMA));
            if (schema == null || schemaType == null) {
                this.getEntryCollection().clear();
                this.getView().updateView(ENTRY_ENTITY);
                return;
            }
            Map<String, Object> map = this.getSelectedSchema(schemaType, schema);
            List<Map<String, Object>> params = this.getParamsList(map.get("id"), schemaType);
            if (!FILTERS.equals(this.getModel().getValue("filter_type")) && params.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u6ca1\u6709\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e!", (String)"DataCopyEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getEntryCollection().clear();
                this.getView().updateView(ENTRY_ENTITY);
            }
            this.loadParams(params);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
            this.getView().close();
            return;
        }
        String filterType = D.s((Object)this.getModel().getValue("filter_type"));
        if (!FILTERS.equals(filterType) && this.getEntryCollection().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u6ca1\u6709\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e!", (String)"DataCopyEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (FILTERS.equals(filterType) && this.getEntryCollection(FILTER_ENTRY).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6!", (String)"DataCopyEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("returndata")) {
            this.returnData();
        }
    }

    private void returnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        params.put("src_var", this.getModel().getValue("src_var"));
        params.put("tar_var", this.getModel().getValue("tar_var"));
        params.put("execution_var", this.getModel().getValue("execution_var"));
        params.put("state_var", this.getModel().getValue("state_var"));
        String filterType = D.s((Object)this.getModel().getValue("filter_type"));
        params.put("filter_type", filterType);
        String schemaType = D.s((Object)this.getModel().getValue(SCHEMA_TYPE));
        params.put(SCHEMA_TYPE, schemaType);
        String schema = D.s((Object)this.getModel().getValue(SCHEMA));
        params.put(SCHEMA, this.getSelectedSchema(schemaType, schema));
        if (FILTERS.equals(filterType)) {
            DynamicObjectCollection filterEntry = this.getEntryCollection(FILTER_ENTRY);
            params.put(FILTER_ENTRY, DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)filterEntry));
        } else {
            DynamicObjectCollection entryEntity = this.getEntryCollection();
            params.put(PARAM_ENTRIES, DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)entryEntity));
        }
        params.put("save_state_on_success", this.getModel().getValue("save_state_on_success"));
        params.put("wait_for_on_failed", this.getModel().getValue("wait_for_on_failed"));
        params.put("wait_for_premise", this.getModel().getValue("wait_for_premise"));
        this.getView().returnDataToParent((Object)params);
        this.getView().close();
    }

    private Map<String, Object> getSelectedSchema(String schemaType, String var) {
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
            return (Map)this.getView().getFormShowParameter().getCustomParam(SCHEMA);
        }
        long flowId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("flow"));
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        for (DynamicObject res : resources) {
            if (!var.equals(D.s((Object)res.get("res_alias")))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("id", res.get("res_ref.id"));
            map.put("name", res.get("res_ref.name.zh_CN"));
            map.put("var", var);
            map.put(SCHEMA_TYPE, schemaType);
            return map;
        }
        return Collections.emptyMap();
    }

    private List<Map<String, Object>> getParamsList(Object id, String schemaType) {
        if (D.l((Object)id) == 0L || schemaType == null) {
            return Collections.emptyList();
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)schemaType);
        DynamicObjectCollection paramEntries = obj.getDynamicObjectCollection(schemaType.equals("isc_data_copy") ? PARAM_ENTRIES : "params_entryentity");
        return DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)paramEntries);
    }

    private DynamicObjectCollection getEntryCollection() {
        return this.getEntryCollection(ENTRY_ENTITY);
    }

    private DynamicObjectCollection getEntryCollection(String entryEntity) {
        return this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntity);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid mappingEntries = (EntryGrid)this.getView().getControl(FILTER_ENTRY);
        mappingEntries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"btnok", "wait_for_premise", "wait_for_on_failed"});
        this.addClickListeners(CTL.toArray(new String[0]));
        this.addItemClickListeners(new String[]{SCHEMA_TYPE, SCHEMA});
        this.addClickListeners(new String[]{"vectorap"});
        EntryGrid entries = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{PARAMS_VAR});
    }

    public void cellClick(CellClickEvent event) {
    }

    public void cellDoubleClick(CellClickEvent event) {
        String fieldKey = event.getFieldKey();
        if ("filter_column".equals(fieldKey)) {
            this.selectFilterColumn(event);
        } else if (PARAMS_VAR.equals(fieldKey) || "filter_value_var".equals(fieldKey)) {
            this.selectVariableProperty(fieldKey);
        }
    }

    private void selectVariableProperty(String fieldKey) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("flow_id", this.getView().getFormShowParameter().getCustomParam("flow"));
        param.put("key", fieldKey);
        FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"DataCopyEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, GET_PROPERTY);
    }

    private void selectFilterColumn(CellClickEvent event) {
        String schema = D.s((Object)this.getModel().getValue(SCHEMA));
        String type = D.s((Object)this.getModel().getValue(SCHEMA_TYPE));
        if (schema == null || type == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65b9\u6848\u7c7b\u578b\u6216\u8005\u65b9\u6848!", (String)"DataCopyEditorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> map = this.getSelectedSchema(type, schema);
        HashMap<String, Object> param = new HashMap<String, Object>();
        long srcId = D.l((Object)this.getSrcMetaIdBySchema(type, map.get("id")));
        param.put("id", srcId);
        param.put("notExpandMultiLangNode", true);
        EntryFilterUtil.showFormByConnType(this, srcId, param, "get_filter_column");
    }

    private Object getSrcMetaIdBySchema(String type, Object id) {
        Assert.isTrue((D.l((Object)id) != 0L ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u65b9\u6848ID\u4e3a\u7a7a!", (String)"DataCopyEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        if ("isc_data_copy_trigger".equals(type)) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)type, (String)"data_copy.id");
            return this.getSrcMetaIdByDataCopy(object.get("data_copy.id"));
        }
        return this.getSrcMetaIdByDataCopy(id);
    }

    private Object getSrcMetaIdByDataCopy(Object id) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_data_copy", (String)"source_schema.id");
        return object.get("source_schema.id");
    }
}

