/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;

public class DataCopyTriggerEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String VARIABLES_VALUE2 = "variables_value";
    private static final String PARAMS_NAME = "params_name";
    private static final String PARAM_ENTRIES = "param_entries";
    private static final String DC_TRIGGER = "dc_trigger";
    private static final String ENTRY_ENTITY = "param_entry";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean editable = D.x(params.get("editable"));
        if (editable) {
            String flowId = D.s(params.get("flow"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
            this.loadTrigger(flow, params);
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
            this.viewTrigger(params);
        }
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("execution_var", params.get("execution_var"));
        this.getModel().setValue("state_var", params.get("state_var"));
    }

    private void viewTrigger(Map<String, Object> params) {
        Map trigger = (Map)params.get(DC_TRIGGER);
        if (trigger == null) {
            return;
        }
        String var = D.s(trigger.get("var"));
        ComboEdit combo = (ComboEdit)this.getView().getControl(DC_TRIGGER);
        ComboItem item = new ComboItem();
        item.setCaption(new LocaleString(var + " - " + D.s(trigger.get("name"))));
        item.setValue(var);
        combo.setComboItems(Collections.singletonList(item));
        this.getModel().setValue(DC_TRIGGER, (Object)var);
        this.loadParams((List)params.get(PARAM_ENTRIES));
    }

    private void loadTrigger(DynamicObject flow, Map<String, Object> params) {
        Map trigger = (Map)params.get(DC_TRIGGER);
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        HashMap<String, String> existedTrigger = null;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(resources.size());
        ComboEdit combo = (ComboEdit)this.getView().getControl(DC_TRIGGER);
        for (DynamicObject resource : resources) {
            if (!"isc_data_copy_trigger".equals(D.s((Object)resource.get("res_category")))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String resAlias = D.s((Object)resource.get("res_alias"));
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(resAlias + "-" + D.s((Object)resource.get("res_ref.name"))));
            item.setValue(resAlias);
            items.add(item);
            map.put("var", resAlias);
            map.put("id", D.s((Object)resource.get("res_ref.id")));
            if (trigger == null || !resAlias.equals(trigger.get("var"))) continue;
            existedTrigger = map;
        }
        this.getModel().setValue(DC_TRIGGER, existedTrigger != null ? D.s(existedTrigger.get("var")) : null);
        combo.setComboItems(items);
        if (existedTrigger != null) {
            List p = (List)params.get(PARAM_ENTRIES);
            List existedParamList = p == null ? Collections.emptyList() : p;
            List<Map<String, Object>> dcParamsList = this.getDcTriggersList(D.l(existedTrigger.get("id")));
            this.refreshParams(existedParamList, dcParamsList);
        }
    }

    private void refreshParams(List<Map<String, Object>> existedParamList, List<Map<String, Object>> dcTriggersList) {
        HashMap<String, Map<String, Object>> existed = new HashMap<String, Map<String, Object>>(existedParamList.size());
        for (Map<String, Object> map : existedParamList) {
            existed.put(D.s((Object)map.get(PARAMS_NAME)), map);
        }
        for (Map<String, Object> map : dcTriggersList) {
            String name = D.s((Object)map.get(PARAMS_NAME));
            Map original = (Map)existed.get(name);
            if (original == null) continue;
            map.put(VARIABLES_VALUE2, original.get(VARIABLES_VALUE2));
        }
        this.loadParams(dcTriggersList);
    }

    private void loadParams(List<Map<String, Object>> array) {
        if (!CollectionUtils.isEmpty(array)) {
            DynamicObjectCollection collection = this.getEntryCollection();
            collection.clear();
            for (Map<String, Object> map : array) {
                DynamicObject object = collection.addNew();
                object.set(PARAMS_NAME, map.get(PARAMS_NAME));
                object.set("params_label", map.get("params_label"));
                object.set("params_data_type", map.get("params_data_type"));
                object.set(VARIABLES_VALUE2, map.get(VARIABLES_VALUE2));
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "execution_var", "state_var"});
        this.addItemClickListeners(new String[]{DC_TRIGGER});
        this.addClickListeners(new String[]{"vectorap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String dcTrigger = null;
        if ("execution_var".equals(key) || "state_var".equals(key)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("flow_id", this.getView().getFormShowParameter().getCustomParam("flow"));
            param.put("key", key);
            FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"DataCopyTriggerEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_property");
        } else if ("vectorap".equals(key) && (dcTrigger = D.s((Object)this.getModel().getValue(DC_TRIGGER))) != null) {
            Map<String, Object> schema = this.getSelectedTrigger(dcTrigger);
            FormOpener.showView(this, "isc_data_copy_trigger", schema.get("id"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
            this.getView().close();
            return;
        }
        if (this.getEntryCollection().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u542f\u52a8\u65b9\u6848\u6ca1\u6709\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e!", (String)"DataCopyTriggerEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("returndata")) {
            this.returnData();
        }
    }

    private void returnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        params.put("execution_var", this.getModel().getValue("execution_var"));
        params.put("state_var", this.getModel().getValue("state_var"));
        String trigger = D.s((Object)this.getModel().getValue(DC_TRIGGER));
        params.put(DC_TRIGGER, this.getSelectedTrigger(trigger));
        DynamicObjectCollection param_entry = this.getEntryCollection();
        params.put(PARAM_ENTRIES, DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)param_entry));
        this.getView().returnDataToParent((Object)params);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (action.equals("get_property") && (returnData = evt.getReturnData()) instanceof Map) {
            String key = D.s(((Map)returnData).get("key"));
            String value = D.s(((Map)returnData).get("full_number"));
            this.getModel().setValue(key, (Object)value);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if (DC_TRIGGER.equals(prop)) {
            String dC_Trigger = D.s((Object)this.getModel().getValue(DC_TRIGGER));
            if (dC_Trigger == null) {
                this.getEntryCollection().clear();
                this.getView().updateView(ENTRY_ENTITY);
                return;
            }
            Map<String, Object> schema = this.getSelectedTrigger(dC_Trigger);
            List<Map<String, Object>> dcTriggersList = this.getDcTriggersList(schema.get("id"));
            if (dcTriggersList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u542f\u52a8\u65b9\u6848\u6ca1\u6709\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e!", (String)"DataCopyTriggerEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getEntryCollection().clear();
                this.getView().updateView(ENTRY_ENTITY);
            }
            this.loadParams(dcTriggersList);
        }
    }

    private Map<String, Object> getSelectedTrigger(String var) {
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
            return (Map)this.getView().getFormShowParameter().getCustomParam(DC_TRIGGER);
        }
        long flowId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("flow"));
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        for (DynamicObject res : resources) {
            if (var == null || !var.equals(D.s((Object)res.get("res_alias")))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("id", res.get("res_ref.id"));
            map.put("name", res.get("res_ref.name.zh_CN"));
            map.put("var", var);
            return map;
        }
        return Collections.emptyMap();
    }

    private List<Map<String, Object>> getDcTriggersList(Object dataCopyId) {
        if (D.l((Object)dataCopyId) == 0L) {
            return Collections.emptyList();
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)dataCopyId, (String)"isc_data_copy_trigger");
        DynamicObjectCollection paramEntries = obj.getDynamicObjectCollection("params_entryentity");
        return DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)paramEntries);
    }

    private DynamicObjectCollection getEntryCollection() {
        return this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
    }
}

