/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.connector.self.triggerhandler.DataFlowHandler;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.n.DataFlowInvokeParser;
import kd.isc.iscb.platform.core.sf.runtime.n.DataFlowInvokeApplication;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.misc.StringUtil;

public class DataFlowInvokeFormPlugin
extends AbstractFormPlugin
implements Const,
ClickListener {
    private static Log logger = LogFactory.getLog(DataFlowInvokeFormPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        try {
            this.innerBeforeBindData(e);
        }
        catch (Throwable t) {
            logger.error("\u670d\u52a1\u6d41\u7a0b\u4e2d\u6570\u636e\u6d41\u8c03\u7528\u8282\u70b9\u63d2\u4ef6\u5728beforeBindData\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u539f\u56e0\uff1a", t);
            this.getView().showErrorNotification(StringUtil.getCascadeMessage((Throwable)t));
        }
    }

    private void innerBeforeBindData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.setTitle(params);
        IDataModel m = this.getModel();
        m.setValue("save_state_on_success", (Object)D.x(params.get("save_state_on_success")));
        m.setValue("wait_for_on_failed", (Object)D.s(params.get("wait_for_on_failed")));
        m.setValue("wait_for_premise", (Object)D.s(params.get("wait_for_premise")));
        if (!D.x(params.get("editable"))) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.prepareComboList("state_var", D.s(params.get("state_var")));
            this.prepareComboList("data_flow", D.s(params.get("data_flow")));
            long released_id = D.l(params.get("released_id"));
            DynamicObject release = BusinessDataServiceHelper.loadSingle((Object)released_id, (String)"isc_service_flow_r", (String)"flow");
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)release.getLong("flow"), (String)"isc_service_flow");
            this.prepareStateVarList(flow);
            Map<String, Long> triggers = this.prepareDataFlowComboList(flow);
            this.prepareDataFlowParamEntries(triggers, params);
        } else {
            long flowId = D.l(params.get("flow"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
            this.prepareStateVarList(flow);
            Map<String, Long> triggers = this.prepareDataFlowComboList(flow);
            this.prepareDataFlowParamEntries(triggers, params);
        }
        m.setValue("data_flow", params.get("data_flow"));
        m.setValue("state_var", params.get("state_var"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        try {
            this.innerPropertyChanged(e);
        }
        catch (Throwable t) {
            logger.error("\u670d\u52a1\u6d41\u7a0b\u4e2d\u6570\u636e\u6d41\u8c03\u7528\u8282\u70b9\u63d2\u4ef6\u5728propertyChanged\u53d1\u751f\u4e86\u5f02\u5e38\u3002" + e.getProperty().getName() + "\u3002\u539f\u56e0\uff1a", t);
            this.getView().showErrorNotification(StringUtil.getCascadeMessage((Throwable)t));
        }
    }

    private void innerPropertyChanged(PropertyChangedArgs e) {
        if ("data_flow".equals(e.getProperty().getName())) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            long flowId = D.l(params.get("flow"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
            Map<String, Long> triggers = this.prepareDataFlowComboList(flow);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("data_flow", this.getModel().getValue("data_flow"));
            this.prepareDataFlowParamEntries(triggers, map);
        }
    }

    private void prepareDataFlowParamEntries(Map<String, Long> triggers, Map<String, Object> params) {
        String alias = DataFlowInvokeParser.getDataFlowAlias(params);
        Long dataFlowTriggerId = triggers.get(alias);
        if (dataFlowTriggerId != null) {
            HashMap<String, Map> paramMap = new HashMap<String, Map>();
            List list = (List)params.get("params");
            if (list != null) {
                for (Map e : list) {
                    paramMap.put((String)e.get("param_name"), e);
                }
            }
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("params");
            entries.clear();
            for (IscApiParam.Field f : DataFlowHandler.getDataFlowParam((long)dataFlowTriggerId)) {
                DynamicObject entry = entries.addNew();
                entry.set("param_name", (Object)f.getName());
                entry.set("param_type", (Object)f.getDataType());
                entry.set("param_title", (Object)f.getTitle());
                Map item = (Map)paramMap.get(f.getName());
                if (item == null) continue;
                entry.set("param_value", item.get("param_value"));
                entry.set("param_expr", item.get("param_expr"));
            }
            this.getView().updateView("params");
        }
    }

    private void prepareComboList(String field, String value) {
        if (value != null) {
            String varDesc = DataFlowInvokeParser.getDesc((String)value);
            String varName = DataFlowInvokeParser.getAlias((String)value);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(Util.getVarOrResName(varDesc, varName)));
            comboItem.setValue(value);
            List list = D.asList((Object[])new ComboItem[]{comboItem});
            ((ComboEdit)this.getView().getControl(field)).setComboItems(list);
        }
    }

    private Map<String, Long> prepareDataFlowComboList(DynamicObject flow) {
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        ArrayList<ComboItem> resList = new ArrayList<ComboItem>(resources.size());
        HashMap<String, Long> triggers = new HashMap<String, Long>(resources.size());
        for (DynamicObject res : resources) {
            if (!"iscx_data_flow_trigger".equals(res.get("res_category"))) continue;
            this.appendComboItemList(resList, res, "res_alias", "res_ref.name");
            triggers.put(res.getString("res_alias"), res.getLong("res_ref.id"));
        }
        ((ComboEdit)this.getView().getControl("data_flow")).setComboItems(resList);
        return triggers;
    }

    private void prepareStateVarList(DynamicObject flow) {
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        ArrayList<ComboItem> varList = new ArrayList<ComboItem>(variables.size());
        for (DynamicObject var : variables) {
            if (!"variant".equals(var.get("var_type.number")) || D.x((Object)var.get("is_array"))) continue;
            this.appendComboItemList(varList, var, "var_name", "var_desc");
        }
        ((ComboEdit)this.getView().getControl("state_var")).setComboItems(varList);
    }

    private String appendComboItemList(List<ComboItem> list, DynamicObject entry, String nameField, String descField) {
        String varDesc = entry.getString(descField);
        String varName = entry.getString(nameField);
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(Util.getVarOrResName(varDesc, varName)));
        comboItem.setValue(DataFlowInvokeParser.concatComboValue((String)varName, (String)varDesc));
        list.add(comboItem);
        return varName;
    }

    private void setTitle(Map<String, Object> params) {
        String title = D.s((Object)params.get("title"));
        if (title != null) {
            this.getModel().setValue("title", (Object)title);
        } else {
            this.getModel().setValue("title", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6d41\u8c03\u7528", (String)"DataFlowInvokeFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"wait_for_premise", "wait_for_on_failed"});
        this.addClickListeners(new String[]{"param_expr"});
        this.addClickListeners(new String[]{"view_data_flow"});
    }

    private void collectTitle(Map<String, Object> params) {
        String title = D.s((Object)this.getModel().getValue("title"));
        if (title != null) {
            params.put("title", title);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("get_property".equals(action)) {
            EditorUtil.setReturnDataAfterChosedVar(this.getModel(), evt);
        }
        if ("wait_for_premise".equals(action) || "wait_for_on_failed".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("btnok".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            this.collectTitle(params);
            IDataModel m = this.getModel();
            params.put("state_var", m.getValue("state_var"));
            params.put("data_flow", m.getValue("data_flow"));
            params.put("save_state_on_success", m.getValue("save_state_on_success"));
            params.put("wait_for_on_failed", m.getValue("wait_for_on_failed"));
            params.put("wait_for_premise", m.getValue("wait_for_premise"));
            DynamicObjectCollection entries = m.getEntryEntity("params");
            ArrayList list = new ArrayList(entries.size());
            for (DynamicObject item : entries) {
                HashMap<String, String> map = new HashMap<String, String>();
                String param_name = D.s((Object)item.getString("param_name"));
                map.put("id", param_name);
                map.put("param_name", param_name);
                map.put("param_type", D.s((Object)item.getString("param_type")));
                map.put("param_title", D.s((Object)item.getString("param_title")));
                map.put("param_value", D.s((Object)item.getString("param_value")));
                map.put("param_expr", D.s((Object)item.getString("param_expr")));
                list.add(map);
            }
            params.put("params", list);
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        String value;
        super.click(evt);
        Object src = evt.getSource();
        boolean editable = D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
        if (src instanceof TextEdit) {
            String key = ((TextEdit)src).getKey();
            if (editable) {
                if ("wait_for_premise".equals(key) || "wait_for_on_failed".equals(key)) {
                    ScriptTextUtil.openRetryScriptForm(this.getModel().getValue(key), this, key, key);
                }
                if ("param_expr".equals(key)) {
                    EditorUtil.selectVariableProperty(this, key);
                }
            }
        }
        if (src instanceof Vector && "view_data_flow".equals(((Vector)src).getKey()) && (value = D.s((Object)this.getModel().getValue("data_flow"))) != null) {
            String alias = DataFlowInvokeParser.getAlias((String)value);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (editable) {
                long flowId = D.l(params.get("flow"));
                DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
                DynamicObjectCollection c = flow.getDynamicObjectCollection("resources");
                long triggerId = 0L;
                for (DynamicObject o : c) {
                    if (!alias.equals(o.get("res_alias"))) continue;
                    triggerId = o.getLong("res_ref.id");
                }
                if (triggerId != 0L) {
                    FormOpener.showView(this, "iscx_data_flow_trigger", triggerId);
                } else {
                    String message = ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u672a\u5f15\u7528\u522b\u540d\u4e3a\uff08%s\uff09\u7684\u6570\u636e\u6d41\u8d44\u6e90\u3002", (String)"DataFlowInvokeFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(String.format(message, alias));
                }
            } else {
                long proc_inst_id = D.l(params.get("proc_inst_id"));
                DynamicObject proc = BusinessDataServiceHelper.loadSingle((Object)proc_inst_id, (String)"isc_sf_proc_inst", (String)"flow_id");
                Flow flow = ServiceFlowParser.getFlow((long)proc.getLong("flow_id"));
                DataFlowInvokeApplication app = (DataFlowInvokeApplication)flow.getNode(D.s(params.get("id"))).getApplication();
                FormOpener.showView(this, "iscx_data_flow_trigger", app.getDataFlowTriggerId());
            }
        }
    }
}

