/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.log.SchemaEncryptDataUtil;
import kd.isc.iscb.formplugin.sf.VariableType;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.connector.s.QueryList;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.DataArea;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class FlowVariableListPlugin
extends AbstractListPlugin
implements Const {
    public static final String ENTRY_ENTITY = "entryentity";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.getVarInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getVarInfo();
    }

    private void getVarInfo() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object procInstId = params.get("proc_inst_id");
        if (procInstId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e3a\u7a7a", (String)"FlowVariableListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isOutAllowSize(D.l(procInstId))) {
            return;
        }
        try {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity(ENTRY_ENTITY);
            entryList.clear();
            FlowRuntime flowRuntime = ProcessRuntime.loadRuntime((long)D.l(procInstId));
            DataArea rootMemory = flowRuntime.getRootMemory();
            this.showVarsList(entryList, rootMemory);
            if (entryList.size() == flowRuntime.getFlow().getVariables().size()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flow"});
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
        catch (OutOfMemoryError e) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u53d8\u91cf\u6570\u636e\u8fc7\u5927\uff0c\u65e0\u6cd5\u663e\u793a\uff0c\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u670d\u52a1\u6d41\u7a0b\u8bbe\u8ba1\uff0c\u51cf\u5c11\u6d41\u7a0b\u53d8\u91cf\u4e2d\u5b58\u653e\u7684\u5185\u5bb9\u3002", (String)"FlowVariableListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e));
        }
    }

    private void showVarsList(DynamicObjectCollection entryList, DataArea memory) {
        Flow flow = memory.getFlow();
        Map vmap = flow.getVariables();
        for (Map.Entry entry : vmap.entrySet()) {
            Variable variable = (Variable)entry.getValue();
            this.showVar(entryList.addNew(), memory, variable, flow.getId());
        }
        List children = memory.getChildren();
        for (DataArea child : children) {
            this.showVarsList(entryList, child);
        }
    }

    public boolean isOutAllowSize(long procInstId) {
        int maxSize;
        DynamicObject inst = BusinessDataServiceHelper.loadSingle((String)"isc_sf_proc_inst", (String)"context_length", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)procInstId)});
        if (inst == null) {
            return false;
        }
        int count = D.i((Object)inst.get("context_length"));
        if (count > (maxSize = QueryList.getResultSetMaxSize())) {
            FormOpener.showErrorMessage(this.getView(), String.format(ResManager.loadKDString((String)"\u53d8\u91cf\u6570\u636e\u8d85\u8fc7\u53ef\u663e\u793a\u7684\u6700\u5927\u503c%s\u4e2a\u5b57\u8282\uff0c\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u670d\u52a1\u6d41\u7a0b\u8bbe\u8ba1\uff0c\u51cf\u5c11\u6d41\u7a0b\u53d8\u91cf\u4e2d\u5b58\u653e\u7684\u5185\u5bb9\uff1b\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_QUERY_MAX_SIZE \u589e\u52a0\u4e0a\u9650\u3002", (String)"FlowVariableListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), maxSize), null);
            return true;
        }
        return false;
    }

    private void showVar(DynamicObject row, DataArea rootMemory, Variable variable, String release_id) {
        Map varDefine = (Map)variable.getAttribute("define");
        String varCategory = D.s(varDefine.get("category"));
        String varType = D.s(varDefine.get("type"));
        Object varValue = rootMemory.getAt(variable);
        DynamicObject meta = null;
        String encryptData = null;
        if (VariableType.isc_metadata_schema.name().equalsIgnoreCase(varCategory)) {
            meta = BusinessDataServiceHelper.loadSingle((Object)varType, (String)"isc_metadata_schema");
            encryptData = D.s((Object)SchemaEncryptDataUtil.getEncryptData(D.l((Object)meta.getPkValue()), varValue));
        } else if (VariableType.isc_type_simple_value.name().equalsIgnoreCase(varCategory)) {
            meta = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_type_simple_value", (QFilter[])QFilterUtil.builder().put("number", "=", (Object)varType.toLowerCase()).build());
        }
        String value = encryptData == null ? Json.toString((Object)varValue, (boolean)true) : encryptData;
        row.set("var_name", (Object)variable.getName());
        row.set("var_desc", (Object)variable.getTitle());
        row.set("var_category", (Object)varCategory.toLowerCase());
        row.set("var_type", (Object)meta);
        row.set("is_array", varDefine.get("is_array"));
        row.set("var_value", (Object)StringUtil.trim((String)value, (int)20));
        row.set("var_value_tag", (Object)this.subStr(SchemaEncryptDataUtil.getVarTag(value), 16384));
        row.set("is_input", varDefine.get("is_input"));
        row.set("is_output", varDefine.get("is_output"));
        long serviceFlowId = ServiceFlowParser.getServiceFlowId((Flow)ServiceFlowParser.getFlow((long)D.l((Object)release_id)));
        row.set("flow", (Object)ServiceFlow.get((long)serviceFlowId));
    }

    public String subStr(Object obj, int maxLength) {
        if (obj == null) {
            return null;
        }
        String str = D.s((Object)obj);
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength) + "\n...";
    }
}

