/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.sf.VariableType;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class FlowVariableSelectorFormPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
Const,
TreeNodeQueryListener {
    private static final String CACHE_KEY = "key";
    private static final String DESC2 = "desc";
    private static final String FULL_NUMBER2 = "full_number";
    private static final String NUMBER2 = "number";
    private static final String DATA_SCHEMA2 = "data_schema";
    private static final String DATA_TYPE2 = "data_type";
    private static final String PROP_LABEL = "prop_label";
    private static final String PROP_NAME = "prop_name";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String KEY_TREE = "treeviewap";
    private static final Set<String> EXPANDED_TYPES = new HashSet<String>(Arrays.asList("REF", "STRUCT", "ENTRIES"));
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ONLY_SIMPLE_VALUE = "only_simple_value";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(KEY_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String flowId = D.s(params.get("flow_id"));
        boolean onlySimpleValue = D.x(params.get(ONLY_SIMPLE_VALUE));
        this.getPageCache().put(ONLY_SIMPLE_VALUE, D.s((Object)onlySimpleValue));
        this.saveParamsToPageCache(params);
        if (flowId == null || "0".equals(flowId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0bID\u4e3a\u7a7a", (String)"FlowVariableSelectorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("flow_id", flowId);
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
            this.initTree(flow, onlySimpleValue);
        }
    }

    private void saveParamsToPageCache(Map<String, Object> params) {
        HashMap<String, String> cache = new HashMap<String, String>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value = entry.getValue();
            if (value != null && !(value instanceof String) && !(value instanceof Number)) continue;
            cache.put(entry.getKey(), D.s((Object)value));
        }
        this.getPageCache().put(cache);
    }

    private void initTree(DynamicObject flow, boolean onlySimpleValue) {
        TreeNode root = this.prepareRoot();
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(variables.size());
        for (DynamicObject var : variables) {
            String var_name = var.getString("var_name");
            String var_desc = var.getString("var_desc");
            String var_category = D.s((Object)var.getString("var_category"));
            long var_type = D.l((Object)var.get("var_type_id"));
            Assert.notNull((Object)var_category, (String)String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u53d8\u91cf%s\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FlowVariableSelectorFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), var_category));
            Assert.isTrue((var_type != 0L ? 1 : 0) != 0, (String)String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u53d8\u91cf%s\u7684\u53d8\u91cf\u5f15\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FlowVariableSelectorFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), var_name));
            VariableType variableType = VariableType.valueOf(var_category);
            if (this.isFilterBySimpleValue(variableType, onlySimpleValue)) continue;
            String s = StringUtil.isEmpty((String)var_desc) ? "" : " - " + var_desc;
            TreeNode node = new TreeNode("ROOT", var_name + "@" + variableType.name() + "@" + var_type, var_name + s);
            node.setType(variableType.name());
            if (VariableType.isc_dataset_schema == variableType || VariableType.isc_metadata_schema == variableType) {
                node.setChildren(new ArrayList());
                node.setData((Object)var_type);
            } else {
                node.setData((Object)var_name);
            }
            nodeList.add(node);
        }
        root.addChildren(nodeList);
        this.initRootEntry(variables, onlySimpleValue);
    }

    private boolean isFilterBySimpleValue(VariableType variableType, boolean onlySimpleValue) {
        return onlySimpleValue && VariableType.isc_type_simple_value != variableType;
    }

    private void initRootEntry(DynamicObjectCollection variables, boolean onlySimpleValue) {
        String flowId = this.getPageCache().get("flow_id");
        if (flowId == null) {
            return;
        }
        for (DynamicObject var : variables) {
            String var_name = var.getString("var_name");
            String var_desc = var.getString("var_desc");
            String var_category = D.s((Object)var.getString("var_category"));
            VariableType variableType = VariableType.valueOf(var_category);
            if (this.isFilterBySimpleValue(variableType, onlySimpleValue)) continue;
            this.showSimpleValueDetails(var_name, var_name, var_desc, VariableType.valueOf(var_category).getDescription(), var_category);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private TreeNode prepareRoot() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        TreeNode root = new TreeNode("", "ROOT", ResManager.loadKDString((String)"\u6d41\u7a0b\u53d8\u91cf", (String)"FlowVariableSelectorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        root.setExpend(true);
        root.setChildren(new ArrayList());
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.focusNode(root);
        treeView.expand("ROOT");
        return root;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        String nodeId = D.s((Object)evt.getNodeId());
        if (nodeId == null || nodeId.indexOf(64) < 0) {
            return;
        }
        String[] split = nodeId.split("@");
        this.expandChildNodes(nodeId, (TreeView)this.getView().getControl(KEY_TREE), split[1]);
    }

    private void expandChildNodes(String nodeId, TreeView treeView, String type) {
        VariableType variableType = VariableType.valueOf(type);
        if (variableType == VariableType.isc_metadata_schema) {
            this.appendMetaPropertyNodes(treeView, nodeId);
        } else if (variableType == VariableType.isc_dataset_schema) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"TODO-\u6682\u672a\u652f\u6301\u6570\u636e\u96c6\u7684\u8282\u70b9\u9009\u62e9\u3002", (String)"FlowVariableSelectorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u5c55\u5f00\uff1a%s", (String)"FlowVariableSelectorFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type));
        }
    }

    private void appendMetaPropertyNodes(TreeView treeView, String nodeId) {
        DynamicObject root = this.findRootMeta(nodeId);
        DynamicObject meta = this.innerFindParent(root, nodeId);
        if (D.l((Object)meta.getPkValue()) != 0L) {
            this.innerAppendMetaNodes(treeView, nodeId, meta);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u7684\u5143\u6570\u636e\u6a21\u578b\u672a\u540c\u6b65\u3002", (String)"FlowVariableSelectorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getParentMeta(String nodeId) {
        int index = nodeId.lastIndexOf(46);
        DynamicObject root = this.findRootMeta(nodeId);
        if (index < 0) {
            return root;
        }
        String fullName = nodeId.substring(0, index);
        return this.innerFindParent(root, fullName);
    }

    private DynamicObject innerFindParent(DynamicObject meta, String fullName) {
        int index = fullName.indexOf(46);
        if (index < 0) {
            return this.getChildMeta(meta, fullName);
        }
        String property = fullName.substring(0, index);
        meta = this.getChildMeta(meta, property);
        return this.innerFindParent(meta, fullName.substring(index + 1));
    }

    private DynamicObject findRootMeta(String nodeId) {
        String rootId = null;
        int p1 = nodeId.lastIndexOf(64);
        int p2 = nodeId.indexOf(46);
        rootId = p2 > 0 ? nodeId.substring(p1 + 1, p2) : nodeId.substring(p1 + 1);
        return BusinessDataServiceHelper.loadSingle((Object)rootId, (String)"isc_metadata_schema");
    }

    private void innerAppendMetaNodes(TreeView treeView, String parentId, DynamicObject meta) {
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(properties.size());
        for (DynamicObject p : properties) {
            String propName = p.getString(PROP_NAME);
            String propLabel = p.getString(PROP_LABEL);
            String dataType = p.getString(DATA_TYPE2);
            TreeNode node = new TreeNode(parentId, parentId + "." + propName, propLabel);
            if (EXPANDED_TYPES.contains(dataType)) {
                node.setChildren(new ArrayList());
            }
            children.add(node);
        }
        treeView.addNodes(children);
    }

    private DynamicObject getChildMeta(DynamicObject meta, String property) {
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject p : properties) {
            if (!property.equals(p.getString(PROP_NAME))) continue;
            meta = JsonSampleUtil.findMetaByDataSchema((DynamicObject)meta, (String)p.getString(DATA_SCHEMA2));
            break;
        }
        return meta;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = D.s((Object)evt.getNodeId());
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        String flowId = this.getPageCache().get("flow_id");
        if (!StringUtil.isEmpty((String)flowId)) {
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
            if ("ROOT".equals(nodeId)) {
                this.initRootEntry(flow.getDynamicObjectCollection("variables"), D.x((Object)this.getPageCache().get(ONLY_SIMPLE_VALUE)));
            } else {
                this.initChildrenEntry(nodeId);
            }
        }
    }

    private void initChildrenEntry(String nodeId) {
        String dataType = nodeId.split("@")[1];
        String var = nodeId.split("@")[0];
        if (!nodeId.contains(".")) {
            this.initFlowVariableEntry(nodeId, dataType, var);
        } else {
            this.initFlowVariableChildrenEntry(nodeId, dataType, var);
        }
    }

    private void initFlowVariableEntry(String nodeId, String dataType, String var) {
        VariableType variableType = VariableType.valueOf(dataType);
        if (variableType == VariableType.isc_type_simple_value) {
            this.showSimpleValueDetails(var, var, var, dataType, var);
        } else if (variableType == VariableType.isc_metadata_schema) {
            String id = nodeId.substring(nodeId.lastIndexOf(64) + 1);
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_metadata_schema");
            this.setEntries(var, meta);
        } else if (variableType == VariableType.isc_dataset_schema) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6570\u636e\u96c6\u7684\u5c5e\u6027\u9009\u62e9.", (String)"FlowVariableSelectorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void initFlowVariableChildrenEntry(String nodeId, String dataType, String var) {
        VariableType variableType = VariableType.valueOf(dataType);
        if (variableType == VariableType.isc_type_simple_value) {
            this.showSimpleValueDetails(var, var, var, dataType, var);
        } else if (variableType == VariableType.isc_metadata_schema) {
            this.showMetaDetails(nodeId);
        } else if (variableType == VariableType.isc_dataset_schema) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6570\u636e\u96c6\u7684\u5c5e\u6027\u9009\u62e9.", (String)"FlowVariableSelectorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void showSimpleValueDetails(String number, String full_number, String desc, String dataType, String dataSchema) {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject row = entry.addNew();
        row.set(NUMBER2, (Object)number);
        row.set(FULL_NUMBER2, (Object)full_number);
        row.set(DESC2, (Object)desc);
        row.set(DATA_TYPE2, (Object)dataType);
        row.set(DATA_SCHEMA2, (Object)dataSchema);
    }

    private void showMetaDetails(String nodeId) {
        String fullNumber = nodeId.split("@")[0] + "." + nodeId.substring(nodeId.indexOf(46) + 1);
        String name = nodeId.substring(nodeId.lastIndexOf(46) + 1);
        DynamicObject parentMeta = this.getParentMeta(nodeId);
        DynamicObjectCollection properties = parentMeta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject property : properties) {
            String propName = property.getString(PROP_NAME);
            if (!propName.equals(name)) continue;
            if (EXPANDED_TYPES.contains(property.getString(DATA_TYPE2))) {
                this.setEntries(fullNumber, parentMeta, property.getString(DATA_SCHEMA2));
                break;
            }
            this.showSimpleValueDetails(name, fullNumber, name, name, name);
            break;
        }
    }

    private void setEntries(String fullNumber, DynamicObject parentMeta, String dataSchema) {
        DynamicObject meta = JsonSampleUtil.findMetaByDataSchema((DynamicObject)parentMeta, (String)dataSchema);
        if (D.l((Object)meta.getPkValue()) == 0L) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u540c\u6b65\u7f16\u7801\u4e3a\uff08%s\uff09\u7684\u96c6\u6210\u5bf9\u8c61", (String)"FlowVariableSelectorFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataSchema));
            return;
        }
        this.setEntries(fullNumber, meta);
    }

    private void setEntries(String parentNumber, DynamicObject meta) {
        DynamicObjectCollection collection = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (DynamicObject o : collection) {
            DynamicObject row = entry.addNew();
            String propName = o.getString(PROP_NAME);
            String fullNumber = D.s((Object)parentNumber) != null ? parentNumber + "." + propName : propName;
            row.set(NUMBER2, (Object)propName);
            row.set(FULL_NUMBER2, (Object)fullNumber);
            row.set(DESC2, (Object)o.getString(PROP_LABEL));
            row.set(DATA_TYPE2, (Object)o.getString(DATA_TYPE2));
            row.set(DATA_SCHEMA2, (Object)o.getString(DATA_SCHEMA2));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object multi = params.get("multi");
        if ("btnok".equals(key)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] rows = entry.getSelectRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u3002", (String)"FlowVariableSelectorFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            } else if (rows.length > 1) {
                if (multi == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"FlowVariableSelectorFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                } else if ("1".equals(multi)) {
                    ArrayList<Map> list = new ArrayList<Map>(rows.length);
                    for (int r : rows) {
                        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, r);
                        Map map = DynamicObjectUtil.object2Map((DynamicObject)rowEntity);
                        map.put(CACHE_KEY, this.getPageCache().get(CACHE_KEY));
                        map.putAll(this.getPageCache().getAll());
                        list.add(map);
                    }
                    this.getView().returnDataToParent(list);
                    this.getView().close();
                }
            } else {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rows[0]);
                Map map = DynamicObjectUtil.object2Map((DynamicObject)rowEntity);
                map.put(CACHE_KEY, this.getPageCache().get(CACHE_KEY));
                map.putAll(this.getPageCache().getAll());
                this.getView().returnDataToParent((Object)map);
                this.getView().close();
            }
        }
    }

    private static void removeExpandTypes() {
        EXPANDED_TYPES.clear();
    }
}

