/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;

public class LoopBlockEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String LOOP_VAR = "loop_var";
    private static final String INNER_SPLIT_VAR = "inner_split_var";
    private static final String OUTPUT = "output";
    private static final String INPUT = "input";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("title", params.get("title"));
        String loop_var = D.s(params.get(LOOP_VAR));
        this.getModel().setValue(LOOP_VAR, (Object)loop_var);
        String loop_alias = D.s(params.get(INNER_SPLIT_VAR));
        this.getModel().setValue(INNER_SPLIT_VAR, (Object)loop_alias);
        this.buildCombos();
        this.getModel().setValue(INPUT, params.get(INPUT));
        this.getModel().setValue(OUTPUT, params.get(OUTPUT));
        if (this.getModel().getValue("title") == null) {
            this.getModel().setValue("title", (Object)ResManager.loadKDString((String)"\u51fd\u6570", (String)"LoopBlockEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void buildCombos() {
        if (this.isEditable()) {
            List<ComboItem> items = this.getEditorComboItems(true);
            ComboEdit loop_combo = (ComboEdit)this.getView().getControl(LOOP_VAR);
            loop_combo.setComboItems(items);
            ComboEdit out_combo = (ComboEdit)this.getView().getControl(OUTPUT);
            out_combo.setComboItems(items);
            items = this.getEditorComboItems(false);
            ComboEdit in_combo = (ComboEdit)this.getView().getControl(INPUT);
            in_combo.setComboItems(items);
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
            EditorUtil.setInstCombo(this, LOOP_VAR, LOOP_VAR);
            this.setCombos(INPUT);
            this.setCombos(OUTPUT);
        }
    }

    private void setCombos(String fieldName) {
        String ins = (String)this.getView().getFormShowParameter().getCustomParam(fieldName);
        if (ins != null) {
            String[] in_array;
            ArrayList<ComboItem> in_items = new ArrayList<ComboItem>(ins.length());
            for (String resAlias : in_array = ins.split(",")) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(resAlias));
                item.setValue(resAlias);
                in_items.add(item);
            }
            ComboEdit in_combo = (ComboEdit)this.getView().getControl(fieldName);
            in_combo.setComboItems(in_items);
        }
    }

    private List<ComboItem> getEditorComboItems(boolean isArray) {
        DynamicObject flow = EditorUtil.getFlow(this);
        DynamicObjectCollection vars = flow.getDynamicObjectCollection("variables");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(vars.size());
        for (DynamicObject var : vars) {
            if (isArray && D.x((Object)var.get("is_array"))) {
                this.getItems(items, var);
                continue;
            }
            if (isArray || D.x((Object)var.get("is_array"))) continue;
            this.getItems(items, var);
        }
        return items;
    }

    private void getItems(List<ComboItem> items, DynamicObject var) {
        String resAlias = D.s((Object)var.get("var_name"));
        String resName = D.s((Object)var.get("var_desc"));
        ComboItem item = new ComboItem();
        item.setCaption(new LocaleString(Util.getVarOrResName(resName, resAlias)));
        item.setValue(resAlias);
        items.add(item);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (this.isEditable() && "returndata".equals(evt.getOperateKey())) {
            this.setReturnData();
        }
    }

    private void setReturnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        params.put(LOOP_VAR, this.getModel().getValue(LOOP_VAR));
        params.put(INNER_SPLIT_VAR, this.getModel().getValue(INNER_SPLIT_VAR));
        params.put(INPUT, this.getModel().getValue(INPUT));
        params.put(OUTPUT, this.getModel().getValue(OUTPUT));
        this.getView().returnDataToParent((Object)params);
    }

    private boolean isEditable() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
    }
}

