/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.dc.e.v.ExprEvaluator;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class ManualStarterParamsFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String FIELD_VALUE = "value";
    private static final String EXPRESS_VALUE = "express_value";
    private static final String ENTRY_ENTITY = "entryentity";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String flowId = D.s(params.get("flow_id"));
        if (flowId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0bID\u4e3a\u7a7a!", (String)"ManualStarterParamsFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            List variables = (List)params.get("params");
            this.showParams(variables);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        String name = e.getProperty().getName();
        Object[] changeSet = e.getChangeSet();
        if (ObjectUtils.isEmpty((Object[])changeSet)) {
            return;
        }
        DynamicObject dataEntity = changeSet[0].getDataEntity();
        if (FIELD_VALUE.equals(name)) {
            Object express_value = dataEntity.get(EXPRESS_VALUE);
            if (D.s((Object)dataEntity.get("type")).contains("List")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570 %s \u4e3a\u591a\u503c\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528\u8868\u8fbe\u5f0f\u8d4b\u503c!", (String)"ManualStarterParamsFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataEntity.get("name")));
                dataEntity.set(FIELD_VALUE, null);
            } else if (!StringUtil.isEmpty((String)D.s((Object)express_value))) {
                dataEntity.set(EXPRESS_VALUE, null);
            }
        } else if (EXPRESS_VALUE.equals(name) && !StringUtil.isEmpty((String)D.s((Object)(value = dataEntity.get(FIELD_VALUE))))) {
            dataEntity.set(FIELD_VALUE, null);
        }
        this.getView().updateView();
    }

    private void showParams(List<Map<String, Object>> variables) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRY_ENTITY);
        entries.clear();
        for (Map<String, Object> var : variables) {
            DynamicObject item = entries.addNew();
            item.set("name", var.get("name"));
            item.set("class_type", var.get("class_type"));
            item.set("var_desc", var.get("var_desc"));
            String category = D.s((Object)var.get("category"));
            String type = D.s((Object)var.get("type"));
            item.set("type", (Object)EditorUtil.getDynamicType(category, type));
            item.set("is_array", (Object)D.x((Object)var.get("is_array")));
            item.set("init_value", var.get("init_value"));
            item.set(FIELD_VALUE, var.get("init_value"));
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing && "returndata".equals(((Donothing)source).getOperateKey())) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            int i = 1;
            for (DynamicObject o : collection) {
                String value = o.getString(FIELD_VALUE);
                String express_value = o.getString(EXPRESS_VALUE);
                if (StringUtil.isEmpty((String)value) && StringUtil.isEmpty((String)express_value)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a!", (String)"ManualStarterParamsFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), i));
                    args.setCancel(true);
                    break;
                }
                ++i;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("returndata")) {
            try {
                this.returnData();
                this.getView().close();
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private void returnData() {
        List<Object> values = this.getValues();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, List<Object>> data = new HashMap<String, List<Object>>(params);
        data.put("values", values);
        this.getView().returnDataToParent(data);
    }

    private List<Object> getValues() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<Object> values = new ArrayList<Object>(collection.size());
        for (DynamicObject o : collection) {
            String value = o.getString(FIELD_VALUE);
            String express_value = o.getString(EXPRESS_VALUE);
            if (StringUtil.isEmpty((String)value)) {
                values.add(this.evalValue(express_value));
                continue;
            }
            values.add(value);
        }
        return values;
    }

    private Object evalValue(String express_value) {
        if (express_value == null) {
            return null;
        }
        if (express_value.startsWith("#{") && express_value.endsWith("}")) {
            return ExprEvaluator.calc((Object)express_value, null, null, null);
        }
        if (express_value.startsWith("<%") && express_value.endsWith("%>")) {
            String s = express_value.substring(2, express_value.length() - 2);
            Script script = Script.compileSimpleScript((String)s);
            return script.eval();
        }
        Script script = Script.compileSimpleScript((String)express_value);
        return script.eval();
    }

    static {
        Functions.init();
    }
}

