/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.tools.AbstractScriptEditorFormPlugin;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class ScriptNodeEditorFormPlugin
extends AbstractScriptEditorFormPlugin
implements Const {
    private static final String EDITOR = "editor";

    @Override
    public void beforeBindData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("env", "sf_script_node");
        if (D.x(params.get("editable"))) {
            if (D.x(params.get("is_loop_block"))) {
                this.buildLoopBlockScriptTips(params);
            } else {
                Pair<List<String>, List<Map<String, Object>>> innervarPair = this.getInnerVars(D.l(params.get("flow")));
                params.put("context_variables", innervarPair.getA());
                params.put("dynamic_tips", innervarPair.getB());
            }
        }
        super.beforeBindData(e);
        boolean editable = D.x(params.get("editable"));
        if (!editable) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("save_state_on_success", (Object)D.x(params.get("save_state_on_success")));
        this.getModel().setValue("wait_for_on_failed", (Object)D.s(params.get("wait_for_on_failed")));
        this.getModel().setValue("wait_for_premise", (Object)D.s(params.get("wait_for_premise")));
        this.getView().setEnable(Boolean.valueOf(editable), new String[]{EDITOR});
    }

    public void buildLoopBlockScriptTips(Map<String, Object> params) {
        ArrayList<String> innerVars = new ArrayList<String>();
        ArrayList<Map<String, Object>> tips = new ArrayList<Map<String, Object>>();
        String pageId = this.getView().getParentView().getParentView().getPageId();
        String stringFromCache = Util.getDefineStringFromCache(pageId);
        if (!StringUtil.isEmpty((String)stringFromCache)) {
            Map map = (Map)Json.toObject((String)stringFromCache);
            Object id = params.get("loop_block_id");
            Map<String, Object> node = Util.findNode(map, id);
            this.buildLoopInputTips(innerVars, tips, node);
            this.buildLoopOutputTips(innerVars, tips, node);
            this.buildLoopVarTips(innerVars, tips, node);
        }
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)params.get("flow"), (String)"isc_service_flow");
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        Pair<List<String>, List<Map<String, Object>>> resourcesPair = ScriptNodeEditorFormPlugin.buildResourcesTips(resources);
        innerVars.addAll((Collection)resourcesPair.getA());
        tips.addAll((Collection)resourcesPair.getB());
        params.put("context_variables", innerVars);
        params.put("dynamic_tips", tips);
    }

    public void buildLoopVarTips(List<String> innerVars, List<Map<String, Object>> tips, Map<String, Object> node) {
        String inner_split_var = D.s((Object)node.get("inner_split_var"));
        if (!StringUtil.isEmpty((String)inner_split_var)) {
            innerVars.add(inner_split_var);
            HashMap<String, String> tip = new HashMap<String, String>();
            tip.put("title", inner_split_var + ResManager.loadKDString((String)"// \u5faa\u73af\u5757\u6620\u5c04\u53d8\u91cf", (String)"ScriptNodeEditorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            tip.put("text", inner_split_var);
            tips.add(tip);
        } else {
            String loop_var = D.s((Object)node.get("loop_var"));
            if (!StringUtil.isEmpty((String)loop_var)) {
                innerVars.add(loop_var);
                HashMap<String, String> tip = new HashMap<String, String>();
                tip.put("title", loop_var + ResManager.loadKDString((String)"// \u5faa\u73af\u5757\u53d8\u91cf", (String)"ScriptNodeEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                tip.put("text", loop_var);
                tips.add(tip);
            }
        }
    }

    public void buildLoopOutputTips(List<String> innerVars, List<Map<String, Object>> tips, Map<String, Object> node) {
        String loop_block_output = D.s((Object)node.get("output"));
        if (!StringUtil.isEmpty((String)loop_block_output)) {
            for (String s : loop_block_output.split(",")) {
                if (StringUtil.isEmpty((String)s)) continue;
                innerVars.add(s);
                HashMap<String, String> tip = new HashMap<String, String>();
                tip.put("title", s + ResManager.loadKDString((String)"// \u5faa\u73af\u5757\u8f93\u51fa\u53d8\u91cf", (String)"ScriptNodeEditorFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                tip.put("text", s);
                tips.add(tip);
            }
        }
    }

    public void buildLoopInputTips(List<String> innerVars, List<Map<String, Object>> tips, Map<String, Object> node) {
        String loop_block_input = D.s((Object)node.get("input"));
        if (!StringUtil.isEmpty((String)loop_block_input)) {
            for (String s : loop_block_input.split(",")) {
                if (StringUtil.isEmpty((String)s)) continue;
                innerVars.add(s);
                HashMap<String, String> tip = new HashMap<String, String>();
                tip.put("title", s + ResManager.loadKDString((String)"// \u5faa\u73af\u5757\u8f93\u5165\u53d8\u91cf", (String)"ScriptNodeEditorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                tip.put("text", s);
                tips.add(tip);
            }
        }
    }

    private Pair<List<String>, List<Map<String, Object>>> getInnerVars(long flowid) {
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowid, (String)"isc_service_flow");
        if (flow == null) {
            return new Pair(Collections.emptyList(), Collections.emptyList());
        }
        Pair<List<String>, List<Map<String, Object>>> inputs = this.buildVarTips(flow);
        ArrayList innerVars = new ArrayList((Collection)inputs.getA());
        ArrayList tips = new ArrayList((Collection)inputs.getB());
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        Pair<List<String>, List<Map<String, Object>>> resourcesPair = ScriptNodeEditorFormPlugin.buildResourcesTips(resources);
        innerVars.addAll((Collection)resourcesPair.getA());
        tips.addAll((Collection)resourcesPair.getB());
        return new Pair(innerVars, tips);
    }

    private Pair<List<String>, List<Map<String, Object>>> buildVarTips(DynamicObject flow) {
        DynamicObjectCollection entries = flow.getDynamicObjectCollection("variables");
        ArrayList<String> innerVars = new ArrayList<String>(entries.size());
        ArrayList<Map<String, Object>> tips = new ArrayList<Map<String, Object>>(entries.size());
        for (DynamicObject entry : entries) {
            String field = entry.getString("var_name");
            String fieldDesc = entry.getString("var_desc");
            innerVars.add(field);
            String descMark = ResManager.loadKDString((String)"\u6d41\u7a0b\u53d8\u91cf - ", (String)"ScriptNodeEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            String titleDesc = field + " // " + descMark + fieldDesc;
            if (entry.getString("var_category").equals("isc_metadata_schema")) {
                this.buildMetaProp(tips, entry, field, titleDesc);
                continue;
            }
            HashMap<String, String> tip = new HashMap<String, String>();
            tip.put("title", titleDesc);
            tip.put("text", field);
            tips.add(tip);
        }
        return new Pair(innerVars, tips);
    }

    public static Pair<List<String>, List<Map<String, Object>>> buildResourcesTips(DynamicObjectCollection resources) {
        ArrayList<String> innerVars = new ArrayList<String>(resources.size());
        ArrayList<Map<String, Object>> tips = new ArrayList<Map<String, Object>>(resources.size());
        for (DynamicObject entry : resources) {
            String field = entry.getString("res_alias");
            innerVars.add(field);
            DynamicObject basedata = entry.getDynamicObject("res_ref");
            if (basedata == null) continue;
            String fieldDesc = basedata.getString("name") + "\uff08" + basedata.getString("number") + "\uff09";
            String descMark = ResManager.loadKDString((String)"\u4f9d\u8d56\u8d44\u6e90 - ", (String)"ScriptNodeEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            String res_category = entry.getString("res_category");
            ScriptNodeEditorFormPlugin.buildTipsByResource(tips, field, basedata, fieldDesc, descMark, res_category);
        }
        return new Pair(innerVars, tips);
    }

    private static void buildTipsByResource(List<Map<String, Object>> tips, String field, DynamicObject basedata, String fieldDesc, String descMark, String res_category) {
        if (Arrays.asList("isc_custom_function", "isc_apic_script", "isc_apic_mservice", "isc_service_flow", "isc_apic_for_external_api").contains(res_category)) {
            Map<String, Object> tip = ScriptNodeEditorFormPlugin.buildResourceWithInput(res_category, basedata.getLong("id"), field, descMark + fieldDesc);
            tips.add(tip);
        } else if ("isc_apic_webapi".equalsIgnoreCase(res_category)) {
            ScriptNodeEditorFormPlugin.buildWebapiTips(tips, field, basedata, fieldDesc, descMark, res_category);
        } else {
            HashMap<String, String> tip = new HashMap<String, String>();
            tip.put("title", field + " // " + descMark + fieldDesc);
            tip.put("text", field);
            tips.add(tip);
        }
    }

    private static void buildWebapiTips(List<Map<String, Object>> tips, String field, DynamicObject basedata, String fieldDesc, String descMark, String res_category) {
        DynamicObject webapi = BusinessDataServiceHelper.loadSingle((Object)basedata.getLong("id"), (String)res_category);
        String bodyDesc = ScriptNodeEditorFormPlugin.buildWebapiBodyDesc(webapi);
        HashMap<String, String> tip = new HashMap<String, String>();
        String fun1 = field + "(body); // (\u53ea\u9700\u4f20\u5165\u672a\u8bbe\u7f6e\u53c2\u6570\u503c\u7684\u53c2\u6570) - body\u8bf7\u6c42\u4f53 - " + bodyDesc + " - " + descMark + fieldDesc;
        tip.put("title", fun1);
        tip.put("text", fun1);
        tips.add(tip);
        HashMap<String, String> tip1 = new HashMap<String, String>();
        String queryStringDesc = ScriptNodeEditorFormPlugin.buildQueryStringDesc(webapi);
        String headDesc = ScriptNodeEditorFormPlugin.buildHeadDesc(webapi);
        String fun2 = String.format(ResManager.loadKDString((String)"%1$s(body,head,queryParam); // (\u53ea\u9700\u4f20\u5165\u672a\u8bbe\u7f6e\u53c2\u6570\u503c\u7684\u53c2\u6570) - body\u8bf7\u6c42\u4f53 -%2$s  head\u8bf7\u6c42\u5934 -%3$s url\u53c2\u6570 -  %4$s - %5$s %6$s", (String)"ScriptNodeEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), field, bodyDesc, headDesc, queryStringDesc, descMark, fieldDesc);
        tip1.put("title", fun2);
        tip1.put("text", fun2);
        tips.add(tip1);
    }

    private static String buildHeadDesc(DynamicObject webapi) {
        DynamicObjectCollection web_req_body = webapi.getDynamicObjectCollection("web_req_header");
        HashMap<String, String> desc = new HashMap<String, String>();
        for (DynamicObject object : web_req_body) {
            if (!StringUtil.isEmpty((String)object.getString("req_h_param_value"))) continue;
            desc.put(object.getString("req_h_param_name"), object.getString("req_h_param_desc"));
        }
        return Json.toString(desc, (boolean)true);
    }

    private static String buildQueryStringDesc(DynamicObject webapi) {
        DynamicObjectCollection web_req_body = webapi.getDynamicObjectCollection("web_url_params");
        HashMap<String, String> desc = new HashMap<String, String>();
        for (DynamicObject object : web_req_body) {
            if (!StringUtil.isEmpty((String)object.getString("url_param_value"))) continue;
            desc.put(object.getString("url_param_name"), object.getString("url_param_desc"));
        }
        return Json.toString(desc, (boolean)true);
    }

    private static String buildWebapiBodyDesc(DynamicObject webapi) {
        DynamicObjectCollection web_req_body = webapi.getDynamicObjectCollection("web_req_body");
        HashMap<String, String> desc = new HashMap<String, String>();
        for (DynamicObject object : web_req_body) {
            if (!StringUtil.isEmpty((String)object.getString("req_b_param_value")) || object.getLong("pid") != 0L) continue;
            desc.put(object.getString("req_b_param_name"), object.getString("req_b_param_desc"));
        }
        return Json.toString(desc, (boolean)true);
    }

    private static Map<String, Object> buildResourceWithInput(String res_category, long id, String field, String titleDesc) {
        DynamicObject object;
        StringBuilder sb = new StringBuilder();
        sb.append(field).append('(');
        if (Arrays.asList("isc_apic_script", "isc_apic_mservice", "isc_apic_for_external_api").contains(res_category)) {
            object = BusinessDataServiceHelper.loadSingle((Object)id, (String)res_category);
            DynamicObjectCollection collection = object.getDynamicObjectCollection("inputs");
            int j = 0;
            for (int i = 0; i < collection.size(); ++i) {
                String input_field = ((DynamicObject)collection.get(i)).getString("input_field");
                if (input_field.contains(".")) continue;
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(input_field);
                ++j;
            }
        } else if (res_category.equalsIgnoreCase("isc_custom_function")) {
            object = BusinessDataServiceHelper.loadSingle((Object)id, (String)res_category);
            DynamicObjectCollection collection = object.getDynamicObjectCollection("function_entries");
            for (int i = 0; i < collection.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(((DynamicObject)collection.get(i)).getString("function_name"));
            }
        }
        sb.append("); // ").append(titleDesc);
        HashMap<String, Object> tip = new HashMap<String, Object>();
        tip.put("title", sb.toString());
        tip.put("text", sb.toString());
        return tip;
    }

    private void buildMetaProp(List<Map<String, Object>> tips, DynamicObject entry, String field, String titleDesc) {
        HashMap<String, Object> childTip = new HashMap<String, Object>();
        childTip.put("title", titleDesc);
        childTip.put("group", field + '.');
        ArrayList<Map<String, Object>> childList = new ArrayList<Map<String, Object>>();
        childTip.put("children", childList);
        long id = entry.getLong("var_type_id");
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_metadata_schema");
        DynamicObjectCollection collection = meta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject object : collection) {
            String propName = object.getString("prop_name");
            String data_schema = object.getString("data_schema");
            String data_type = object.getString("data_type");
            if ("$FILE_LIST".equalsIgnoreCase(propName) || "bd_attachment".equals(data_schema) || "bos_attachment".equals(data_schema) || "ENTRIES".equals(data_type)) continue;
            this.buildProp(childList, object, propName);
        }
        tips.add(childTip);
    }

    private void buildProp(List<Map<String, Object>> childList, DynamicObject object, String propName) {
        HashMap<String, String> each = new HashMap<String, String>();
        String prop_label = propName + " // " + object.getString("prop_label") + '-' + object.getString("data_type");
        each.put("title", prop_label);
        each.put("text", propName);
        childList.add(each);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"wait_for_premise", "wait_for_on_failed"});
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("wait_for_premise".equals(action) || "wait_for_on_failed".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        boolean editable = D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
        if (editable && ("wait_for_premise".equals(key) || "wait_for_on_failed".equals(key))) {
            ScriptTextUtil.openRetryScriptForm(this.getModel().getValue(key), this, key, key);
        }
    }

    @Override
    protected int getHeight() {
        return 400;
    }

    @Override
    protected int getWidth() {
        return 1050;
    }

    @Override
    protected void handleScript(String script) {
        if (D.s((Object)this.getModel().getValue("title")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6807\u9898\u3002", (String)"ScriptNodeEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        params.put("save_state_on_success", this.getModel().getValue("save_state_on_success"));
        params.put("wait_for_on_failed", this.getModel().getValue("wait_for_on_failed"));
        params.put("wait_for_premise", this.getModel().getValue("wait_for_premise"));
        params.put("script", script);
        this.getView().returnDataToParent((Object)params);
        this.getView().close();
    }
}

